/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSchema;

public abstract class LDAPSchemaElement
implements Serializable {
    static final long serialVersionUID = -3972153461950418863L;
    public static final int unknown = 0;
    public static final int cis = 1;
    public static final int binary = 2;
    public static final int telephone = 3;
    public static final int ces = 4;
    public static final int dn = 5;
    public static final int integer = 6;
    protected static final String cisString = "1.3.6.1.4.1.1466.115.121.1.15";
    protected static final String binaryString = "1.3.6.1.4.1.1466.115.121.1.5";
    protected static final String telephoneString = "1.3.6.1.4.1.1466.115.121.1.50";
    protected static final String cesString = "1.3.6.1.4.1.1466.115.121.1.26";
    protected static final String intString = "1.3.6.1.4.1.1466.115.121.1.27";
    protected static final String dnString = "1.3.6.1.4.1.1466.115.121.1.12";
    public static final String OBSOLETE = "OBSOLETE";
    public static final String SUPERIOR = "SUP";
    public static final String SYNTAX = "SYNTAX";
    protected String oid = null;
    protected String name = "";
    protected String description = "";
    protected String attrName = null;
    protected String rawValue = null;
    protected String[] aliases = null;
    protected Hashtable properties = null;
    protected static Hashtable novalsTable = new Hashtable();

    protected LDAPSchemaElement() {
    }

    protected LDAPSchemaElement(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    protected LDAPSchemaElement(String string, String string2, String string3, String[] stringArray) {
        if (string2 == null) {
            throw new IllegalArgumentException("OID required");
        }
        this.name = string;
        this.oid = string2;
        this.description = string3;
        if (stringArray != null && stringArray.length > 0) {
            this.aliases = stringArray;
        }
    }

    public void add(LDAPConnection lDAPConnection) throws LDAPException {
        this.add(lDAPConnection, "");
    }

    public void add(LDAPConnection lDAPConnection, String string) throws LDAPException {
        this.update(lDAPConnection, 0, this.attrName, string);
    }

    String getAliasString() {
        if (this.aliases != null) {
            String string = "; aliases:";
            int n = 0;
            while (n < this.aliases.length) {
                string = String.valueOf(string) + ' ' + this.aliases[n];
                ++n;
            }
            return string;
        }
        return "";
    }

    public String[] getAliases() {
        return this.aliases;
    }

    protected String getCustomValues() {
        String string = "";
        Enumeration enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("X-")) continue;
            string = String.valueOf(string) + this.getValue(string2, true, false) + ' ';
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == ' ') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.oid;
    }

    public String getName() {
        return this.name;
    }

    public String getOID() {
        return this.getID();
    }

    protected String getOptionalValues(String[] stringArray) {
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = this.getQualifier(stringArray[n]);
            if (stringArray2 != null && stringArray2.length > 0) {
                string = String.valueOf(string) + stringArray[n] + ' ' + stringArray2[0];
            }
            ++n;
        }
        return string;
    }

    public String[] getQualifier(String string) {
        if (this.properties == null) {
            return null;
        }
        Object v = this.properties.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof Vector) {
            Vector vector = (Vector)v;
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        String string2 = (String)v;
        if (string2.length() < 1) {
            return new String[0];
        }
        return new String[]{string2};
    }

    public Enumeration getQualifierNames() {
        return this.properties.keys();
    }

    String getQualifierString(String[] stringArray) {
        Hashtable<String, String> hashtable = null;
        if (stringArray != null) {
            hashtable = new Hashtable<String, String>();
            int n = 0;
            while (n < stringArray.length) {
                hashtable.put(stringArray[n], stringArray[n]);
                ++n;
            }
        }
        String string = "";
        Enumeration enumeration = this.getQualifierNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (hashtable != null && hashtable.containsKey(string2)) continue;
            string = String.valueOf(string) + "; " + string2;
            String[] stringArray2 = this.getQualifier(string2);
            if (stringArray2 == null) {
                string = String.valueOf(string) + ' ';
                continue;
            }
            string = String.valueOf(string) + ": ";
            int n = 0;
            while (n < stringArray2.length) {
                string = String.valueOf(string) + stringArray2[n] + ' ';
                ++n;
            }
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == ' ') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getValue() {
        return this.getValue(false);
    }

    String getValue(String string, boolean bl) {
        return this.getValue(string, bl, true);
    }

    String getValue(String string, boolean bl, boolean bl2) {
        String string2 = "";
        Object v = this.properties.get(string);
        if (v == null) {
            return string2;
        }
        if (v instanceof String) {
            if (((String)v).length() > 0) {
                string2 = String.valueOf(string2) + string + ' ';
                if (bl) {
                    string2 = String.valueOf(string2) + '\'';
                }
                string2 = String.valueOf(string2) + (String)v;
                if (bl) {
                    string2 = String.valueOf(string2) + '\'';
                }
            }
        } else {
            string2 = String.valueOf(string2) + string + " ( ";
            Vector vector = (Vector)v;
            int n = 0;
            while (n < vector.size()) {
                if (bl) {
                    string2 = String.valueOf(string2) + '\'';
                }
                string2 = String.valueOf(string2) + (String)vector.elementAt(n);
                if (bl) {
                    string2 = String.valueOf(string2) + '\'';
                }
                string2 = String.valueOf(string2) + ' ';
                if (bl2 && n < vector.size() - 1) {
                    string2 = String.valueOf(string2) + "$ ";
                }
                ++n;
            }
            string2 = String.valueOf(string2) + ')';
        }
        return string2;
    }

    String getValue(boolean bl) {
        return null;
    }

    String getValuePrefix() {
        String string = "( " + this.oid + ' ';
        if (this.name != null && this.name.length() > 0) {
            string = String.valueOf(string) + "NAME ";
            if (this.aliases != null) {
                string = String.valueOf(string) + "( '" + this.name + "' ";
                int n = 0;
                while (n < this.aliases.length) {
                    string = String.valueOf(string) + '\'' + this.aliases[n] + "' ";
                    ++n;
                }
                string = String.valueOf(string) + ") ";
            } else {
                string = String.valueOf(string) + '\'' + this.name + "' ";
            }
        }
        if (this.description != null) {
            string = String.valueOf(string) + "DESC '" + this.description + "' ";
        }
        if (this.isObsolete()) {
            string = String.valueOf(string) + "OBSOLETE ";
        }
        return string;
    }

    public boolean isObsolete() {
        return this.properties == null ? false : this.properties.containsKey(OBSOLETE);
    }

    public void modify(LDAPConnection lDAPConnection, LDAPSchemaElement lDAPSchemaElement) throws LDAPException {
        this.modify(lDAPConnection, lDAPSchemaElement, "");
    }

    public void modify(LDAPConnection lDAPConnection, LDAPSchemaElement lDAPSchemaElement, String string) throws LDAPException {
        boolean bl = LDAPSchema.isAttributeSyntaxStandardsCompliant(lDAPConnection) ^ true;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        lDAPModificationSet.add(1, new LDAPAttribute(this.attrName, this.getValue(bl)));
        lDAPModificationSet.add(0, new LDAPAttribute(this.attrName, lDAPSchemaElement.getValue(bl)));
        String string2 = LDAPSchema.getSchemaDN(lDAPConnection, string);
        lDAPConnection.modify(string2, lDAPModificationSet);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected void parseValue(String var1_1) {
        if (this.properties == null) {
            this.properties = new Hashtable<K, V>();
        }
        var2_2 = var1_1.length();
        var3_3 = new char[var2_2];
        var1_1.getChars(0, var2_2, var3_3, 0);
        --var2_2;
        while (var3_3[var2_2] == ' ') {
            --var2_2;
        }
        var4_4 = 0;
        while (var3_3[var4_4] == ' ') {
            ++var4_4;
        }
        var5_5 = (var4_4 += 2) + 1;
        while (var3_3[var5_5] != ' ') {
            ++var5_5;
        }
        this.oid = new String(var3_3, var4_4, var5_5 - var4_4);
        ++var5_5;
        ** GOTO lbl95
        {
            ++var5_5;
            do {
                block24: {
                    block25: {
                        block23: {
                            block22: {
                                block21: {
                                    if (var3_3[var5_5] == ' ') continue block3;
                                    var8_8 = var5_5 + 1;
                                    while (var8_8 < var2_2 && var3_3[var8_8] != ' ') {
                                        ++var8_8;
                                    }
                                    if (var8_8 >= var2_2) break block21;
                                    var6_6 = new String(var3_3, var5_5, var8_8 - var5_5);
                                    var5_5 = var8_8;
                                    if (LDAPSchemaElement.novalsTable.containsKey(var6_6)) {
                                        this.properties.put(var6_6, "");
                                        continue;
                                    }
                                    ** GOTO lbl41
                                }
                                var6_6 = "";
                                var5_5 = var2_2;
                                break block3;
lbl-1000:
                                // 1 sources

                                {
                                    ++var5_5;
lbl41:
                                    // 2 sources

                                    ** while (var5_5 < var2_2 && var3_3[var5_5] == ' ')
                                }
lbl42:
                                // 1 sources

                                var8_8 = var5_5 + 1;
                                if (var5_5 >= var2_2) break block3;
                                var9_10 = false;
                                var10_11 = false;
                                if (var3_3[var5_5] != '\'') break block22;
                                var9_10 = true;
                                ++var5_5;
                                if (true) ** GOTO lbl57
                            }
                            if (var3_3[var5_5] != '(') ** GOTO lbl64
                            var10_11 = true;
                            ++var5_5;
                            if (true) ** GOTO lbl61
                            do {
                                ++var8_8;
lbl57:
                                // 2 sources

                            } while (var8_8 < var2_2 && var3_3[var8_8] != '\'');
                            break block23;
                            do {
                                ++var8_8;
lbl61:
                                // 2 sources

                            } while (var8_8 < var2_2 && var3_3[var8_8] != ')');
                            break block23;
lbl-1000:
                            // 1 sources

                            {
                                ++var8_8;
lbl64:
                                // 2 sources

                                ** while (var8_8 < var2_2 && var3_3[var8_8] != ' ')
                            }
                        }
                        if (var5_5 >= var8_8 || var8_8 > var2_2) break block24;
                        if (!var10_11) break block25;
                        var11_12 = new Vector<String>();
                        if (var3_3[var5_5] == ' ') {
                            ++var5_5;
                        }
                        var12_13 = (var7_7 = new String(var3_3, var5_5, var8_8 - var5_5 - 1)).indexOf(39) >= 0 ? "'" : " ";
                        var13_14 = new StringTokenizer(var7_7, var12_13);
                        if (true) ** GOTO lbl90
                    }
                    var7_7 = new String(var3_3, var5_5, var8_8 - var5_5);
                    if (var6_6.equals("NAME")) {
                        this.name = var7_7;
                    } else if (var6_6.equals("DESC")) {
                        this.description = var7_7;
                    } else {
                        this.properties.put(var6_6, var7_7);
                    }
                    if (var9_10) {
                        ++var8_8;
                    }
                    break block24;
                    do {
                        if ((var14_15 = var13_14.nextToken().trim()).length() <= 0 || var14_15.equals("$")) continue;
                        var11_12.addElement(var14_15);
lbl90:
                        // 3 sources

                    } while (var13_14.hasMoreTokens());
                    this.properties.put(var6_6, var11_12);
                }
                var5_5 = var8_8 + 1;
lbl95:
                // 3 sources

            } while (var5_5 < var2_2);
        }
        var8_9 = this.getQualifier("NAME");
        if (var8_9 != null && var8_9.length > 0) {
            this.name = var8_9[0];
            if (var8_9.length > 1) {
                this.aliases = new String[var8_9.length - 1];
                System.arraycopy(var8_9, 1, this.aliases, 0, this.aliases.length);
            }
        }
    }

    public void remove(LDAPConnection lDAPConnection) throws LDAPException {
        this.remove(lDAPConnection, "");
    }

    public void remove(LDAPConnection lDAPConnection, String string) throws LDAPException {
        this.update(lDAPConnection, 1, this.attrName, string);
    }

    public void setQualifier(String string, String string2) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        if (string2 != null) {
            this.properties.put(string, string2);
        } else {
            this.properties.remove(string);
        }
    }

    public void setQualifier(String string, String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        this.properties.put(string, vector);
    }

    protected void update(LDAPConnection lDAPConnection, int n, String string, String string2) throws LDAPException {
        boolean bl = LDAPSchema.isAttributeSyntaxStandardsCompliant(lDAPConnection) ^ true;
        LDAPAttribute lDAPAttribute = new LDAPAttribute(string, this.getValue(bl));
        this.update(lDAPConnection, n, lDAPAttribute, string2);
    }

    protected void update(LDAPConnection lDAPConnection, int n, LDAPAttribute lDAPAttribute, String string) throws LDAPException {
        LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[]{lDAPAttribute};
        this.update(lDAPConnection, n, lDAPAttributeArray, string);
    }

    protected void update(LDAPConnection lDAPConnection, int n, LDAPAttribute[] lDAPAttributeArray, String string) throws LDAPException {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        int n2 = 0;
        while (n2 < lDAPAttributeArray.length) {
            lDAPModificationSet.add(n, lDAPAttributeArray[n2]);
            ++n2;
        }
        String string2 = LDAPSchema.getSchemaDN(lDAPConnection, string);
        lDAPConnection.modify(string2, lDAPModificationSet);
    }
}

