/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;

public class LDAPAttributeSet
implements Cloneable,
Serializable {
    static final long serialVersionUID = 5018474561697778100L;
    Hashtable attrHash = null;
    LDAPAttribute[] attrs = new LDAPAttribute[0];
    static final int ATTR_COUNT_REQUIRES_HASH = 5;

    public LDAPAttributeSet() {
    }

    public LDAPAttributeSet(LDAPAttribute[] lDAPAttributeArray) {
        this.attrs = lDAPAttributeArray;
    }

    public synchronized void add(LDAPAttribute lDAPAttribute) {
        if (lDAPAttribute != null) {
            LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[this.attrs.length + 1];
            int n = 0;
            while (n < this.attrs.length) {
                lDAPAttributeArray[n] = this.attrs[n];
                ++n;
            }
            lDAPAttributeArray[this.attrs.length] = lDAPAttribute;
            this.attrs = lDAPAttributeArray;
            if (this.attrHash != null) {
                this.attrHash.put(lDAPAttribute.getName().toLowerCase(), lDAPAttribute);
            }
        }
    }

    public synchronized Object clone() {
        try {
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.attrs = new LDAPAttribute[this.attrs.length];
            int n = 0;
            while (n < this.attrs.length) {
                lDAPAttributeSet.attrs[n] = new LDAPAttribute(this.attrs[n]);
                ++n;
            }
            return lDAPAttributeSet;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public LDAPAttribute elementAt(int n) {
        return this.attrs[n];
    }

    public LDAPAttribute getAttribute(String string) {
        this.prepareHashtable();
        if (this.attrHash != null) {
            return (LDAPAttribute)this.attrHash.get(string.toLowerCase());
        }
        int n = 0;
        while (n < this.attrs.length) {
            if (string.equalsIgnoreCase(this.attrs[n].getName())) {
                return this.attrs[n];
            }
            ++n;
        }
        return null;
    }

    public LDAPAttribute getAttribute(String string, String string2) {
        if (string2 == null || string2.length() < 1) {
            return this.getAttribute(string);
        }
        String string3 = string2.toLowerCase();
        if (string3.length() < 5 || !string3.substring(0, 5).equals("lang-")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "-");
        stringTokenizer.nextToken();
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        String string4 = LDAPAttribute.getBaseName(string);
        String[] stringArray2 = LDAPAttribute.getSubtypes(string);
        LDAPAttribute lDAPAttribute = null;
        int n2 = 0;
        n = 0;
        while (n < this.attrs.length) {
            boolean bl = false;
            LDAPAttribute lDAPAttribute2 = this.attrs[n];
            if (lDAPAttribute2.getBaseName().equalsIgnoreCase(string4)) {
                if (stringArray2 == null || stringArray2.length < 1) {
                    bl = true;
                } else if (lDAPAttribute2.hasSubtypes(stringArray2)) {
                    bl = true;
                }
            }
            String string5 = null;
            if (bl) {
                string5 = lDAPAttribute2.getLangSubtype();
                if (string5 == null) {
                    lDAPAttribute = lDAPAttribute2;
                } else {
                    stringTokenizer = new StringTokenizer(string5.toLowerCase(), "-");
                    stringTokenizer.nextToken();
                    if (stringTokenizer.countTokens() <= stringArray.length) {
                        int n3 = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            if (!stringArray[n3].equals(stringTokenizer.nextToken())) {
                                n3 = 0;
                                break;
                            }
                            ++n3;
                        }
                        if (n3 > n2) {
                            lDAPAttribute = lDAPAttribute2;
                            n2 = n3;
                        }
                    }
                }
            }
            ++n;
        }
        return lDAPAttribute;
    }

    public Enumeration getAttributes() {
        Vector<LDAPAttribute> vector = new Vector<LDAPAttribute>();
        LDAPAttributeSet lDAPAttributeSet = this;
        synchronized (lDAPAttributeSet) {
            int n = 0;
            while (n < this.attrs.length) {
                vector.addElement(this.attrs[n]);
                ++n;
            }
        }
        return vector.elements();
    }

    public LDAPAttributeSet getSubset(String string) {
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        if (string == null) {
            return lDAPAttributeSet;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.countTokens() < 1) {
            return lDAPAttributeSet;
        }
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = (String)stringTokenizer.nextElement();
            ++n;
        }
        Enumeration enumeration = this.getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            if (!lDAPAttribute.hasSubtypes(stringArray)) continue;
            lDAPAttributeSet.add(new LDAPAttribute(lDAPAttribute));
        }
        return lDAPAttributeSet;
    }

    private void prepareHashtable() {
        if (this.attrHash == null && this.attrs.length >= 5) {
            this.attrHash = new Hashtable();
            int n = 0;
            while (n < this.attrs.length) {
                this.attrHash.put(this.attrs[n].getName().toLowerCase(), this.attrs[n]);
                ++n;
            }
        }
    }

    public synchronized void remove(String string) {
        int n = 0;
        while (n < this.attrs.length) {
            if (string.equalsIgnoreCase(this.attrs[n].getName())) {
                this.removeElementAt(n);
                break;
            }
            ++n;
        }
    }

    public void removeElementAt(int n) {
        if (n >= 0 && n < this.attrs.length) {
            LDAPAttributeSet lDAPAttributeSet = this;
            synchronized (lDAPAttributeSet) {
                LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[this.attrs.length - 1];
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.attrs.length) {
                    if (n3 != n) {
                        lDAPAttributeArray[n2++] = this.attrs[n3];
                    }
                    ++n3;
                }
                if (this.attrHash != null) {
                    this.attrHash.remove(this.attrs[n].getName().toLowerCase());
                }
                this.attrs = lDAPAttributeArray;
            }
        }
    }

    public int size() {
        return this.attrs.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LDAPAttributeSet: ");
        int n = 0;
        while (n < this.attrs.length) {
            if (n != 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.attrs[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }
}

