/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.client;

import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.comm.client.Debug;

public class CLIValidOptions {
    static final String sccs_id = "%W% %G% SMI";
    private Vector name = null;
    private Vector takesArg = null;
    private Vector defaultValue = null;
    private Vector required = null;
    private Vector echo = null;
    private Vector description = null;
    private Vector secOption = null;
    private Vector argPrefix = null;
    private static final String _bracesReg = "\\{[^\\}]+\\}";
    private static final String _braceListReg = "\\{([^\\}]+)\\}(,\\{[^\\}]+\\})*";
    private static final Pattern _bPat = Pattern.compile("\\{([^\\}]+)\\}(,\\{[^\\}]+\\})*");

    public String getClassVersion() {
        return sccs_id;
    }

    public CLIValidOptions(String[] nameArray, Boolean[] takesArgArray, String[] defaultValueArray, Boolean[] requiredArray, Boolean[] echoArray, String[] descriptionArray, String[] argPrefixArray) {
        this.setNames(nameArray);
        this.setTakesArgs(takesArgArray);
        this.setDefaultValues(defaultValueArray);
        this.setRequireds(requiredArray);
        this.setEchos(echoArray);
        this.setDescriptions(descriptionArray);
        this.setArgPrefixes(argPrefixArray);
    }

    public CLIValidOptions(String[][] optionsArray) {
        this.setValidOptionsArray(optionsArray);
    }

    public CLIValidOptions() {
        this.setNames(null);
        this.setTakesArgs(null);
        this.setDefaultValues(null);
        this.setRequireds(null);
        this.setEchos(null);
        this.setDescriptions(null);
        this.setArgPrefixes(null);
        this.setSecOptions(null);
    }

    public String[][] getValidOptionsArray() {
        String[][] validOptions = new String[this.name.size()][8];
        int i = 0;
        while (i < this.name.size()) {
            validOptions[i][0] = (String)this.name.elementAt(i);
            validOptions[i][1] = ((Boolean)this.takesArg.elementAt(i)).toString();
            validOptions[i][2] = (String)this.defaultValue.elementAt(i);
            validOptions[i][3] = ((Boolean)this.required.elementAt(i)).toString();
            validOptions[i][4] = ((Boolean)this.echo.elementAt(i)).toString();
            validOptions[i][5] = (String)this.description.elementAt(i);
            validOptions[i][6] = (String)this.argPrefix.elementAt(i);
            validOptions[i][7] = this.getSecOptionsAsString(i);
            ++i;
        }
        return validOptions;
    }

    public String replaceNullbyHash(String s) {
        if (s.equals("")) {
            return "#";
        }
        return s;
    }

    private String getSecOptionsAsString(int index) {
        HashMap secOptMap = this.getSecOption(index);
        if (secOptMap == null) {
            return "";
        }
        Set optValSet = secOptMap.keySet();
        String[] optValArr = new String[optValSet.size()];
        optValArr = optValSet.toArray(optValArr);
        String accValOptPair = "";
        int i = 0;
        while (i < optValArr.length) {
            String val = optValArr[i];
            CLIValidOptions cv = (CLIValidOptions)secOptMap.get(val);
            String accSecOpts = "";
            int j = 0;
            while (j < cv.size()) {
                String optProps = (String)cv.name.elementAt(j);
                optProps = optProps + ";" + ((Boolean)cv.takesArg.elementAt(j)).toString();
                optProps = optProps + ";" + this.replaceNullbyHash((String)cv.defaultValue.elementAt(j));
                optProps = optProps + ";" + ((Boolean)cv.required.elementAt(j)).toString();
                optProps = optProps + ";" + ((Boolean)cv.echo.elementAt(j)).toString();
                optProps = optProps + ";" + (String)cv.description.elementAt(j);
                optProps = optProps + ";" + this.replaceNullbyHash((String)cv.argPrefix.elementAt(j));
                optProps = optProps + ";#";
                String optPropsWBraces = "{" + optProps + "}";
                accSecOpts = accSecOpts + (j == 0 ? optPropsWBraces : "," + optPropsWBraces);
                ++j;
            }
            String valOptPair = val + "=" + accSecOpts;
            accValOptPair = accValOptPair + (i == 0 ? valOptPair : "::" + valOptPair);
            ++i;
        }
        return accValOptPair;
    }

    public void setValidOptionsArray(String[][] optionsArray) {
        this.name = new Vector();
        this.takesArg = new Vector();
        this.defaultValue = new Vector();
        this.required = new Vector();
        this.echo = new Vector();
        this.description = new Vector();
        this.argPrefix = new Vector();
        this.secOption = new Vector();
        this.addValidOptions(optionsArray);
    }

    public void addValidOptions(String[][] optionsArray) {
        if (optionsArray != null) {
            int i = 0;
            while (i < optionsArray.length) {
                this.addValidOption(optionsArray[i]);
                ++i;
            }
        }
    }

    private String[] _retrieveOptList(String valOpt) {
        if (valOpt == null || valOpt.length() == 0) {
            return null;
        }
        String text = valOpt;
        String[] arr = null;
        Matcher m = _bPat.matcher(text);
        if (m.find()) {
            String first = m.group(1);
            String remText = text.substring(m.end(1) + 1);
            String[] tmp = this._retrieveOptList(remText);
            if (tmp != null) {
                arr = new String[tmp.length + 1];
                System.arraycopy(tmp, 0, arr, 1, tmp.length);
            } else {
                arr = new String[]{first};
            }
        } else {
            Debug.println("retrieveOptList:Internal Error:No match: text=" + text);
            return null;
        }
        return arr;
    }

    public void addValidOption(String[] optionArray) {
        if (optionArray != null && !this.name.contains(optionArray[0])) {
            this.name.addElement(optionArray[0]);
            this.takesArg.addElement(new Boolean(optionArray[1]));
            this.defaultValue.addElement(optionArray[2]);
            this.required.addElement(new Boolean(optionArray[3]));
            this.echo.addElement(new Boolean(optionArray[4]));
            this.description.addElement(optionArray[5]);
            this.argPrefix.addElement(optionArray[6]);
            if (optionArray.length >= 8 && optionArray[7].length() > 0) {
                HashMap<String, CLIValidOptions> optMap = new HashMap<String, CLIValidOptions>();
                String[] valOptPair = optionArray[7].split("::");
                int i = 0;
                while (i < valOptPair.length) {
                    String[] eachValOpt = valOptPair[i].split("=");
                    String eachVal = eachValOpt[0];
                    String[] optList = this._retrieveOptList(eachValOpt[1]);
                    int optlistlen = optList.length;
                    String[][] valOptArr = new String[optlistlen][];
                    int j = 0;
                    while (j < optlistlen) {
                        String curOpt = optList[j];
                        String[] optArr = curOpt.split(";");
                        int z = 0;
                        while (z < optArr.length) {
                            if (optArr[z].equals("#")) {
                                optArr[z] = "";
                            }
                            ++z;
                        }
                        valOptArr[j] = optArr;
                        ++j;
                    }
                    CLIValidOptions sec = new CLIValidOptions(valOptArr);
                    optMap.put(eachVal, sec);
                    ++i;
                }
                this.secOption.addElement(optMap);
            } else {
                this.secOption.addElement(null);
            }
        }
    }

    public void addValidOptions(CLIValidOptions valOpts) {
        if (valOpts != null) {
            String[][] valOptsArr = valOpts.getValidOptionsArray();
            this.addValidOptions(valOptsArr);
        }
    }

    public void removeValidOptions(String[] nameArray) {
        if (nameArray != null) {
            int i = 0;
            while (i < nameArray.length) {
                this.removeValidOption(nameArray[i]);
                ++i;
            }
        }
    }

    public void removeValidOption(String optionName) {
        int index;
        if (optionName != null && (index = this.name.indexOf(optionName)) >= 0) {
            this.name.removeElementAt(index);
            this.takesArg.removeElementAt(index);
            this.defaultValue.removeElementAt(index);
            this.required.removeElementAt(index);
            this.echo.removeElementAt(index);
            this.description.removeElementAt(index);
            this.argPrefix.removeElementAt(index);
            this.secOption.removeElementAt(index);
        }
    }

    public String[] getNames(boolean indicateArg) {
        Vector<String> nameVector = new Vector<String>();
        String currentName = null;
        Object[] nameArray = new String[this.name.size()];
        int i = 0;
        while (i < this.name.size()) {
            currentName = new String((String)this.name.elementAt(i));
            if (indicateArg && this.getTakesArg(i)) {
                currentName = currentName + ":";
            }
            nameVector.addElement(currentName);
            ++i;
        }
        nameVector.copyInto(nameArray);
        return nameArray;
    }

    public String[] getNames() {
        return this.getNames(false);
    }

    public String getName(int index) {
        return (String)this.name.elementAt(index);
    }

    public void setNames(String[] nameArray) {
        this.name = new Vector();
        if (nameArray != null) {
            int i = 0;
            while (i < nameArray.length) {
                this.name.addElement(nameArray[i]);
                ++i;
            }
        }
    }

    public Boolean[] getTakesArgs() {
        Object[] takesArgArray = new Boolean[this.takesArg.size()];
        this.takesArg.copyInto(takesArgArray);
        return takesArgArray;
    }

    public boolean getTakesArg(int index) {
        return (Boolean)this.takesArg.elementAt(index);
    }

    public void setTakesArgs(Boolean[] takesArgArray) {
        this.takesArg = new Vector();
        if (takesArgArray != null) {
            int i = 0;
            while (i < takesArgArray.length) {
                this.takesArg.addElement(takesArgArray[i]);
                ++i;
            }
        }
    }

    public String[] getDefaultValues() {
        Object[] defaultValueArray = new String[this.defaultValue.size()];
        this.defaultValue.copyInto(defaultValueArray);
        return defaultValueArray;
    }

    public String getDefaultValue(int index) {
        return (String)this.defaultValue.elementAt(index);
    }

    public void setDefaultValues(String[] defaultValueArray) {
        this.defaultValue = new Vector();
        if (defaultValueArray != null) {
            int i = 0;
            while (i < defaultValueArray.length) {
                this.defaultValue.addElement(defaultValueArray[i]);
                ++i;
            }
        }
    }

    public void setDefaultValue(String defval, int index) {
        if (defval != null) {
            this.defaultValue.insertElementAt(defval, index);
            this.defaultValue.removeElementAt(index + 1);
        }
    }

    public Boolean[] getRequireds() {
        Object[] requiredArray = new Boolean[this.required.size()];
        this.required.copyInto(requiredArray);
        return requiredArray;
    }

    public boolean getRequired(int index) {
        return (Boolean)this.required.elementAt(index);
    }

    public void setRequireds(Boolean[] requiredArray) {
        this.required = new Vector();
        if (requiredArray != null) {
            int i = 0;
            while (i < requiredArray.length) {
                this.required.addElement(requiredArray[i]);
                ++i;
            }
        }
    }

    public void setRequired(boolean requiredBoolean, int index) {
        this.required.insertElementAt(new Boolean(requiredBoolean), index);
        this.required.removeElementAt(index + 1);
    }

    public Boolean[] getEchos() {
        Object[] echoArray = new Boolean[this.echo.size()];
        this.echo.copyInto(echoArray);
        return echoArray;
    }

    public boolean getEcho(int index) {
        return (Boolean)this.echo.elementAt(index);
    }

    public void setEchos(Boolean[] echoArray) {
        this.echo = new Vector();
        if (echoArray != null) {
            int i = 0;
            while (i < echoArray.length) {
                this.echo.addElement(echoArray[i]);
                ++i;
            }
        }
    }

    public void setEcho(boolean echoBoolean, int index) {
        this.echo.insertElementAt(new Boolean(echoBoolean), index);
        this.echo.removeElementAt(index + 1);
    }

    public String[] getDescriptions() {
        Object[] descriptionArray = new String[this.description.size()];
        this.description.copyInto(descriptionArray);
        return descriptionArray;
    }

    public String getDescription(int index) {
        return (String)this.description.elementAt(index);
    }

    public String getDescription(String opt) {
        int index = this.name.indexOf(opt);
        return (String)this.description.elementAt(index);
    }

    public void setDescriptions(String[] descriptionArray) {
        this.description = new Vector();
        if (descriptionArray != null) {
            int i = 0;
            while (i < descriptionArray.length) {
                this.description.addElement(descriptionArray[i]);
                ++i;
            }
        }
    }

    public void setDescription(String descriptionString, int index) {
        if (descriptionString != null) {
            this.description.insertElementAt(descriptionString, index);
            this.description.removeElementAt(index + 1);
        }
    }

    public String[] getArgPrefixes() {
        Object[] argPrefixesArray = new String[this.argPrefix.size()];
        this.argPrefix.copyInto(argPrefixesArray);
        return argPrefixesArray;
    }

    public String getArgPrefix(int index) {
        return (String)this.argPrefix.elementAt(index);
    }

    public void setArgPrefixes(String[] argPrefixArray) {
        this.argPrefix = new Vector();
        if (argPrefixArray != null) {
            int i = 0;
            while (i < argPrefixArray.length) {
                this.argPrefix.addElement(argPrefixArray[i]);
                ++i;
            }
        }
    }

    public void setArgPrefix(String argPrefixString, int index) {
        if (argPrefixString != null) {
            this.argPrefix.insertElementAt(argPrefixString, index);
            this.argPrefix.removeElementAt(index + 1);
        }
    }

    public HashMap getSecOption(int index) {
        if (this.secOption == null) {
            return null;
        }
        if (index >= this.secOption.size()) {
            return null;
        }
        Object obj = this.secOption.elementAt(index);
        return obj == null ? null : (HashMap)obj;
    }

    public void setSecOptions(HashMap[] secOptsArray) {
        this.secOption = new Vector();
        if (secOptsArray != null) {
            int i = 0;
            while (i < secOptsArray.length) {
                this.secOption.addElement(secOptsArray[i]);
                ++i;
            }
        }
    }

    public int indexOf(String optName) {
        return this.name.indexOf(optName);
    }

    public int size() {
        return this.name.size();
    }

    public void sort() {
        String[][] valArr = this.getValidOptionsArray();
        Vector<String[]> store = new Vector<String[]>();
        store.addElement(valArr[0]);
        String[] newVal = null;
        int i = 1;
        while (i < valArr.length) {
            int j = 0;
            while (j < store.size()) {
                newVal = (String[])store.elementAt(j);
                if (valArr[i][0].toLowerCase().compareTo(newVal[0].toLowerCase()) < 0) {
                    store.insertElementAt(valArr[i], j);
                    break;
                }
                ++j;
            }
            if (j > 0 && j == store.size()) {
                store.addElement(valArr[i]);
            }
            ++i;
        }
        String[][] newValArr = new String[valArr.length][];
        int i2 = 0;
        while (i2 < valArr.length) {
            newValArr[i2] = (String[])store.elementAt(i2);
            ++i2;
        }
        this.setValidOptionsArray(newValArr);
    }

    public CLIValidOptions getCopy() {
        String[][] valOptsArr = this.getValidOptionsArray();
        CLIValidOptions temp = new CLIValidOptions(valOptsArr);
        return temp;
    }

    public void debug() {
        int i = 0;
        while (i < this.name.size()) {
            System.out.print(this.name.elementAt(i) + " ");
            ++i;
        }
        System.out.println("");
    }
}

