/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.comm.client.BadLoginException;
import sun.comm.client.CLIInteractive;
import sun.comm.client.CLIObject;
import sun.comm.client.CLIValidOptions;
import sun.comm.client.CommAdmin;
import sun.comm.client.Debug;
import sun.comm.client.InvalidOptionException;
import sun.comm.client.MissingOptionException;
import sun.comm.client.NoMoreOptionsException;
import sun.comm.client.ServletInfo;

public class CLITask
extends CLIObject {
    static final String sccs_id = "%W% %G% SMI";
    private String[][] validConnOptionsArray = new String[][]{{"D", "true", "", "true", "true", "ObjectOptDesc_binddn", ""}, {"n", "true", "", "true", "true", "ObjectOptDesc_domain", ""}, {"p", "true", "", "true", "true", "ObjectOptDesc_ldapport", ""}, {"w", "true", "", "true", "false", "ObjectOptDesc_bindpw", ""}, {"X", "true", "", "true", "true", "ObjectOptDesc_ldaphost", ""}};
    private CLIValidOptions connValidOptions = null;
    private ServletInfo[] servInfo = null;
    private static final String APPKEY = "appName";
    private static final String DEFAULTAPPNAME = "commcli";
    private static final String ARGSEPARATOR = "+";
    private static final String CLIMODIFYARG = "CLIModifyArg";
    private String usageObject = null;
    private String usageTask = null;
    private String bindUser;
    private String bindPw;
    private String bindDomain;

    public String getClassVersion() {
        return sccs_id;
    }

    public CLITask() {
    }

    public CLITask(boolean secure) {
        super(secure);
    }

    public String getUsageObject() {
        return this.usageObject;
    }

    public String getUsageTask() {
        return this.usageTask;
    }

    public int doStuff(String[] argv) throws InvalidOptionException, MissingOptionException {
        String[] taskObjArgsArray = null;
        String[] allArgs = null;
        Hashtable optionArgs = new Hashtable();
        int iterationNum = 0;
        if (argv == null || argv.length < 2) {
            Debug.println("Not Implemented connxn yet !");
            return -1;
        }
        String object = argv[0];
        String task = argv[1];
        Debug.println("DBG:Object = " + object + " ; " + "task = " + task);
        taskObjArgsArray = new String[argv.length - 2];
        int i = 0;
        while (i < argv.length - 2) {
            taskObjArgsArray[i] = argv[i + 2];
            ++i;
        }
        this.connValidOptions = new CLIValidOptions(this.validConnOptionsArray);
        this.setDefaultProperties(this.connValidOptions);
        this.parseOptionValues(optionArgs, this.connValidOptions, taskObjArgsArray);
        allArgs = taskObjArgsArray;
        int returnCode = 6;
        iterationNum = 0;
        while (true) {
            block32: {
                block33: {
                    block31: {
                        block30: {
                            if (iterationNum == 0) {
                                this.allValidOptions = this.connValidOptions.getCopy();
                            }
                            try {
                                this.promptMissingValues(optionArgs, this.allValidOptions);
                            }
                            catch (MissingOptionException e) {
                                if (!CommAdmin.getNonInteractive()) {
                                    throw e;
                                }
                                if (iterationNum <= 0) break block30;
                                CLIInteractive.printMissing(e.getMessage());
                            }
                        }
                        this.bindUser = this.getOptionArg(optionArgs, "D");
                        this.bindPw = this.getOptionArg(optionArgs, "w");
                        this.bindDomain = this.getOptionArg(optionArgs, "n");
                        String ndaHost = this.getOptionArg(optionArgs, "X");
                        int ndaPort = 0;
                        try {
                            ndaPort = Integer.valueOf(this.getOptionArg(optionArgs, "p"));
                        }
                        catch (NumberFormatException e) {
                            this.invalidValue(optionArgs, this.allValidOptions, "p");
                        }
                        this.setCurrentHostPort(ndaHost, ndaPort);
                        int status = 0;
                        try {
                            this.authenticate(this.bindUser, this.bindPw, this.bindDomain);
                        }
                        catch (MalformedURLException e) {
                            CLIInteractive.printError(e.getMessage());
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            CLIInteractive.printError(e.getMessage());
                            e.printStackTrace();
                            this.invalidValue(optionArgs, this.allValidOptions, "X");
                            this.invalidValue(optionArgs, this.allValidOptions, "p");
                            status = 3;
                            if (CommAdmin.getNonInteractive()) break block31;
                            break block32;
                        }
                        catch (BadLoginException e) {
                            this.invalidValue(optionArgs, this.allValidOptions, "D");
                            this.invalidValue(optionArgs, this.allValidOptions, "w");
                            this.invalidValue(optionArgs, this.allValidOptions, "n");
                            if (!CommAdmin.getNonInteractive()) break block32;
                        }
                    }
                    Debug.println("DBG: before getobjtaskargs");
                    try {
                        if (this.servInfo == null) {
                            this.servInfo = this.getObjTaskArgs(object, task);
                            Debug.println("DBG: getObjTaskArgs done");
                        }
                    }
                    catch (BadLoginException e) {
                    }
                    catch (Exception e) {
                        Debug.println("doStuff, Excptn: " + e.getMessage());
                        Debug.stackTrace(e);
                        CLIInteractive.printError(e.getMessage());
                    }
                    CLIValidOptions validObjTaskOptions = null;
                    int i2 = 0;
                    while (this.servInfo != null && i2 < this.servInfo.length) {
                        validObjTaskOptions = this.servInfo[i2].getValidOptions();
                        this.allValidOptions.addValidOptions(validObjTaskOptions);
                        ++i2;
                    }
                    if (this.servInfo != null) {
                        this.usageObject = object;
                        this.usageTask = task;
                    } else {
                        Debug.println("servinfo == null");
                    }
                    if (CommAdmin.getPrintUsage() || CommAdmin.getPrintVersion()) break;
                    try {
                        String[] argsLeft = this.parseOptionValues(optionArgs, this.allValidOptions, allArgs, true);
                        if (argsLeft != null && argsLeft.length > 0) {
                            throw new InvalidOptionException("Unknown options/additional data entered.");
                        }
                        returnCode = this.doOne(object, task, optionArgs);
                        Debug.println("DBG: doOne returned code=" + returnCode);
                    }
                    catch (InvalidOptionException e) {
                        returnCode = 2;
                        CLIInteractive.printUnknown(e.getMessage());
                        if (!CommAdmin.getNonInteractive()) {
                            CommAdmin.setPrintUsage(true);
                        }
                    }
                    catch (MissingOptionException e) {
                        returnCode = 3;
                        if (iterationNum <= 0) break block33;
                        CLIInteractive.printMissing(e.getMessage());
                    }
                }
                try {
                    ++iterationNum;
                    allArgs = this.parseNextOptionValues(optionArgs, this.allValidOptions);
                }
                catch (NoMoreOptionsException e) {
                    break;
                }
                catch (InvalidOptionException e) {
                    CLIInteractive.printError(this.res.getString("InvalidOption") + ": " + e.getMessage());
                    returnCode = 2;
                }
            }
            ++iterationNum;
        }
        try {
            this.logout();
        }
        catch (Exception e) {
            Debug.println("logout exception: " + e.getMessage());
        }
        this.dsMesg = null;
        this.successMesg = null;
        return returnCode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int doOne(String object, String task, Hashtable args) throws MissingOptionException {
        CLIValidOptions validObjTaskOptions = null;
        String[] ObjTaskoptionMultiValues = null;
        Vector resp = null;
        if (this.servInfo == null) {
            return 0;
        }
        Debug.println("servInfo len = " + this.servInfo.length);
        int servNum = 0;
        while (servNum < this.servInfo.length) {
            boolean promptAll = false;
            boolean missingRequired = true;
            while (missingRequired) {
                missingRequired = false;
                validObjTaskOptions = this.servInfo[servNum].getValidOptions();
                String appName = this.cliRes.getString(APPKEY);
                if (appName == null || appName.length() == 0) {
                    appName = DEFAULTAPPNAME;
                }
                String servlet = "/" + appName + "/" + this.servInfo[servNum].getName();
                String[] servArg = this.servInfo[servNum].getservletArgs();
                this.promptMissingValues(args, this.allValidOptions, promptAll);
                String servCommand = null;
                int argNum = 0;
                while (argNum < servArg.length) {
                    servCommand = servCommand == null ? servArg[argNum] : servCommand + "&" + servArg[argNum];
                    ++argNum;
                }
                int optNum = 0;
                while (!missingRequired && optNum < this.allValidOptions.size()) {
                    String currentOption = this.allValidOptions.getName(optNum);
                    String servArgDesc = this.allValidOptions.getArgPrefix(optNum);
                    ObjTaskoptionMultiValues = this.getOptionArgs(args, currentOption);
                    int j = 0;
                    while (ObjTaskoptionMultiValues != null && !missingRequired && j < ObjTaskoptionMultiValues.length) {
                        block51: {
                            String argVal = ObjTaskoptionMultiValues[j];
                            StringTokenizer st = new StringTokenizer(servArgDesc, ARGSEPARATOR);
                            if (argVal == null || argVal.equals("")) break block51;
                            if (argVal.startsWith("\\")) {
                                argVal = argVal.substring(1);
                            }
                            while (st.hasMoreTokens()) {
                                block53: {
                                    String prefix;
                                    block56: {
                                        block54: {
                                            block49: {
                                                block55: {
                                                    block52: {
                                                        prefix = st.nextToken();
                                                        if (this.allValidOptions.getTakesArg(optNum)) break block52;
                                                        servCommand = servCommand + "&" + prefix;
                                                        break block53;
                                                    }
                                                    if (!object.equalsIgnoreCase("group") || !currentOption.equals("m") && !currentOption.equals("M") && !currentOption.equals("f")) break block54;
                                                    if (!task.equalsIgnoreCase("modify")) break block55;
                                                    if (argVal.startsWith(ARGSEPARATOR)) {
                                                        prefix = "add_";
                                                        argVal = argVal.substring(1);
                                                        break block49;
                                                    } else if (argVal.startsWith("-")) {
                                                        prefix = "delete_";
                                                        argVal = argVal.substring(1);
                                                        break block49;
                                                    } else {
                                                        this.invalidValue(args, this.allValidOptions, currentOption, this.res.getString("MissingAction"));
                                                        missingRequired = true;
                                                        break;
                                                    }
                                                }
                                                if (task.equalsIgnoreCase("create")) {
                                                    if (argVal.startsWith(ARGSEPARATOR)) {
                                                        prefix = "add_";
                                                        argVal = argVal.substring(1);
                                                    } else {
                                                        if (argVal.startsWith("-")) {
                                                            this.invalidValue(args, this.allValidOptions, currentOption, this.res.getString("ActionNotAllowed"));
                                                            missingRequired = true;
                                                            break;
                                                        }
                                                        prefix = "add_";
                                                    }
                                                }
                                            }
                                            String attrName = currentOption.equals("m") ? "uniquemember" : (currentOption.equals("M") ? "mgrprfc822mailmember" : "memberurl");
                                            servCommand = servCommand + "&" + prefix + attrName + "=" + this.MyURLEncoder(argVal);
                                            break block53;
                                        }
                                        if (!currentOption.equals("R")) break block56;
                                        if (prefix.equalsIgnoreCase(CLIMODIFYARG)) {
                                            Debug.println("With 'R' received for modify command: " + prefix);
                                            if (argVal.startsWith(ARGSEPARATOR)) {
                                                prefix = "add_";
                                                argVal = argVal.substring(1);
                                            } else if (argVal.startsWith("-")) {
                                                prefix = "delete_";
                                                argVal = argVal.substring(1);
                                            } else {
                                                prefix = "replace_";
                                            }
                                            String attrName = "icsallowrights";
                                            servCommand = servCommand + "&" + prefix + attrName + "=" + this.MyURLEncoder(argVal);
                                            break block53;
                                        } else if (task.equalsIgnoreCase("create")) {
                                            if (argVal.startsWith(ARGSEPARATOR)) {
                                                prefix = "add_";
                                                argVal = argVal.substring(1);
                                            } else {
                                                if (argVal.startsWith("-")) {
                                                    this.invalidValue(args, this.allValidOptions, currentOption, this.res.getString("ActionNotAllowed"));
                                                    missingRequired = true;
                                                    break;
                                                }
                                                prefix = "add_";
                                            }
                                            String attrName = "icsallowrights";
                                            servCommand = servCommand + "&" + prefix + attrName + "=" + this.MyURLEncoder(argVal);
                                        }
                                        break block53;
                                    }
                                    if (currentOption.equals("A")) {
                                        if (task.equalsIgnoreCase("create")) {
                                            Debug.println("Option 'A' recvd for create command: " + prefix);
                                            if (argVal.startsWith(ARGSEPARATOR)) {
                                                argVal = argVal.substring(1);
                                            } else if (argVal.startsWith("-")) {
                                                this.invalidValue(args, this.allValidOptions, currentOption, this.res.getString("ActionNotAllowed"));
                                                missingRequired = true;
                                                break;
                                            }
                                        } else if (prefix.equalsIgnoreCase(CLIMODIFYARG)) {
                                            Debug.println("With 'A' recvd for modify command: " + prefix);
                                            if (argVal.startsWith(ARGSEPARATOR)) {
                                                prefix = "add_";
                                                argVal = argVal.substring(1);
                                            } else if (argVal.startsWith("-")) {
                                                prefix = "delete_";
                                                argVal = argVal.substring(1);
                                            } else {
                                                prefix = "replace_";
                                            }
                                        }
                                        int index = argVal.indexOf(":");
                                        if (index <= 0) {
                                            this.invalidMultiValue(args, this.allValidOptions, "A", j + 1);
                                            missingRequired = true;
                                            break;
                                        }
                                        Debug.println("argVal.substring(index+1) =" + argVal.substring(index + 1));
                                        servCommand = servCommand + "&" + prefix + argVal.substring(0, index).toLowerCase() + "=" + this.MyURLEncoder(argVal.substring(index + 1));
                                    } else {
                                        Debug.println("argVal =" + argVal);
                                        servCommand = servCommand + "&" + prefix + "=" + this.MyURLEncoder(argVal);
                                    }
                                }
                                Debug.println("servCommand =" + servCommand);
                            }
                        }
                        ++j;
                    }
                    ++optNum;
                }
                if (servCommand != null && servCommand.startsWith("&")) {
                    servCommand = servCommand.substring(1);
                }
                if (missingRequired) continue;
                try {
                    if (missingRequired) continue;
                    resp = this.sendservCommand(servlet, servCommand);
                }
                catch (IOException e) {
                    CLIInteractive.printError(e.getMessage());
                    return 4;
                }
                catch (InvalidOptionException e) {
                    missingRequired = true;
                    promptAll = true;
                }
                catch (BadLoginException e) {
                    try {
                        this.authenticate(this.bindUser, this.bindPw, this.bindDomain);
                    }
                    catch (Exception e1) {
                        CLIInteractive.printError(e1.getMessage());
                    }
                }
            }
            if (resp != null) {
                this.rcStat = (String)resp.elementAt(0);
                Debug.println("CLITask: status returned =" + this.rcStat);
                if (this.rcStat.equals("FAIL")) {
                    return this.printStatus(resp);
                }
            }
            ++servNum;
        }
        return this.printStatus(resp);
    }

    public String MyURLEncoder(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (Exception e) {
            Debug.println("exception =" + e.toString());
            return data;
        }
    }
}

