/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.factory;

import com.netscape.jss.CryptoManager;
import com.netscape.jss.crypto.AlreadyInitializedException;
import com.netscape.jss.crypto.X509Certificate;
import com.netscape.jss.ssl.SSLCertificateApprovalCallback;
import com.netscape.jss.ssl.SSLSocket;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;

public class JSSSocketFactory
implements Serializable,
LDAPSocketFactory,
SSLCertificateApprovalCallback {
    static final long serialVersionUID = -6926469178017736902L;
    public static final String defaultModDB = "secmod.db";
    public static final String defaultKeyDB = "key3.db";
    public static final String defaultCertDB = "cert7.db";
    private static String moddb;
    private static String keydb;
    private static String certdb;
    private static boolean initialized;

    static {
        initialized = false;
    }

    public JSSSocketFactory() throws LDAPException {
        if (!initialized) {
            JSSSocketFactory.initialize(defaultModDB, defaultKeyDB, defaultCertDB);
        }
    }

    public boolean approve(X509Certificate x509Certificate, SSLCertificateApprovalCallback.ValidityStatus validityStatus) {
        return true;
    }

    public static String getCertDB() {
        return certdb;
    }

    public static String getKeyDB() {
        return keydb;
    }

    public static String getModDB() {
        return moddb;
    }

    public static void initialize(String string) throws LDAPException {
        String string2 = String.valueOf(string) + File.separator + defaultModDB;
        String string3 = String.valueOf(string) + File.separator + defaultKeyDB;
        String string4 = String.valueOf(string) + File.separator + defaultCertDB;
        JSSSocketFactory.initialize(string2, string3, string4);
    }

    public static void initialize(String string, String string2, String string3) throws LDAPException {
        if (initialized) {
            throw new LDAPException("JSSSocketFactory is already initialized", 80);
        }
        try {
            moddb = string;
            keydb = string2;
            certdb = string3;
            initialized = true;
            CryptoManager.initialize((String)string, (String)string2, (String)string3);
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
        }
        catch (Exception exception) {
            throw new LDAPException("Failed to initialize JSSSocketFactory: " + exception.getMessage(), 80);
        }
    }

    public Socket makeSocket(String string, int n) throws LDAPException {
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = new SSLSocket(InetAddress.getByName(string), n, null, 0, true, (SSLCertificateApprovalCallback)this, null);
            sSLSocket.forceHandshake();
        }
        catch (Exception exception) {
            throw new LDAPException("SSL connection to " + string + ":" + n + ", " + exception.getMessage(), 91);
        }
        return sSLSocket;
    }
}

