/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.dirmig;

import java.util.Iterator;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;
import sun.comm.dirmig.commEntry;
import sun.comm.dirmig.commFactoryInterface;
import sun.comm.dirmig.commSearchResults;

class commSearchResultsAsyncIterator
implements Iterator {
    LDAPSearchListener sListener = null;
    commFactoryInterface sFactory = null;
    LDAPMessage sLdapMessage = null;
    commEntry sCommEntry = null;
    commSearchResults sCommSearchResults = null;

    public commSearchResultsAsyncIterator(commSearchResults theCommSearchResults) {
        this.sListener = theCommSearchResults.getListener();
        this.sFactory = theCommSearchResults.getClassFactory();
        this.sCommSearchResults = theCommSearchResults;
    }

    public boolean hasNext() {
        LDAPResponse aResponse = null;
        LDAPEntry aLdapEntry = null;
        int aStatus = 0;
        boolean aReturn = true;
        String aErrorString = null;
        try {
            aReturn = true;
            this.sCommEntry = null;
            while (aReturn && this.sCommEntry == null) {
                this.sLdapMessage = this.sListener.getResponse();
                if (this.sLdapMessage == null) {
                    aReturn = false;
                    continue;
                }
                if (this.sLdapMessage instanceof LDAPSearchResultReference) {
                    ((LDAPSearchResultReference)this.sLdapMessage).getUrls();
                    aReturn = false;
                    continue;
                }
                if (this.sLdapMessage instanceof LDAPSearchResult) {
                    aLdapEntry = ((LDAPSearchResult)this.sLdapMessage).getEntry();
                    this.sCommEntry = this.sFactory.createObject(aLdapEntry);
                    if (this.sCommEntry != null) continue;
                    continue;
                }
                aResponse = (LDAPResponse)this.sLdapMessage;
                aStatus = aResponse.getResultCode();
                if (aStatus == 0) continue;
                aErrorString = LDAPException.errorCodeToString((int)aStatus);
                this.sCommSearchResults.setLdapException(new LDAPException(aErrorString, aStatus, aResponse.getErrorMessage(), aResponse.getMatchedDN()));
                aReturn = false;
            }
        }
        catch (LDAPException aLdapException) {
            this.sCommSearchResults.setLdapException(aLdapException);
            aReturn = false;
        }
        return aReturn;
    }

    public Object next() {
        return this.sCommEntry;
    }

    public void remove() {
    }
}

