/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.dirmig;

import java.util.Map;
import netscape.ldap.LDAPEntry;
import sun.comm.dirmig.commConfig;
import sun.comm.dirmig.commDomainEntry;
import sun.comm.dirmig.commUtil;

public class commSearchConstraints {
    int sBaseDnType = 3;
    int sSearchType = 1000;
    int sObjectType = 4;
    String sObjectString = "User";
    String sFilterTypeString = "All";
    String sBaseDn = null;
    String sFilter = null;
    Map sValueMap = null;
    commDomainEntry sDomainEntry = null;
    LDAPEntry sLdapEntry = null;

    public commSearchConstraints() {
    }

    public commSearchConstraints(String theObjectString, commDomainEntry theDomainEntry) throws Exception {
        this.sDomainEntry = theDomainEntry;
        this.sObjectString = theObjectString;
        this.sObjectType = commUtil.getObjectId(this.sObjectString);
        this.setBaseDn();
        this.setFilter();
    }

    public commSearchConstraints(String theObjectString, String theSearchFilterType, commDomainEntry theDomainEntry, LDAPEntry theLdapEntry, Map theValueMap, int theBaseDnType, int theSearchOpType) throws Exception {
        this.sBaseDnType = theBaseDnType;
        this.sSearchType = theSearchOpType;
        this.sObjectString = theObjectString;
        this.sObjectType = commUtil.getObjectId(theObjectString);
        this.sFilterTypeString = theSearchFilterType;
        this.sValueMap = theValueMap;
        this.sDomainEntry = theDomainEntry;
        this.sLdapEntry = theLdapEntry;
        this.setBaseDn();
        this.setFilter();
    }

    public void setBaseDnType(int theBaseDnType) {
        this.sBaseDnType = theBaseDnType;
    }

    public void setObjectId(int theObjectId) {
        this.sObjectType = theObjectId;
        this.sObjectString = commUtil.getObjectString(theObjectId);
    }

    public void setObjectString(String theObjectString) {
        this.sObjectString = theObjectString;
        this.sObjectType = commUtil.getObjectId(theObjectString);
    }

    public void setFilterType(String theFilterType) {
        this.sFilterTypeString = theFilterType;
    }

    public void setValueMap(Map theValueMap) {
        this.sValueMap = theValueMap;
    }

    public void setSynchronousSearch() {
        this.sSearchType = 1000;
    }

    public void setAsyncSearch() {
        this.sSearchType = 1001;
    }

    public void setBaseDn() throws Exception {
        if (this.sBaseDnType == 1) {
            this.sBaseDn = commConfig.getMacroValue("%DC_ROOT%");
        } else if (this.sBaseDnType == 2) {
            this.sBaseDn = commConfig.getMacroValue("%OSI_ROOT%");
        } else if (this.sBaseDnType == 3 && this.sDomainEntry != null) {
            this.sBaseDn = this.sDomainEntry.getUgBaseDn();
        }
        if (this.sBaseDn == null && this.sValueMap != null) {
            this.sBaseDn = (String)this.sValueMap.get("%SEARCH_BASEDN%");
        }
    }

    public void setBaseDn(String theBaseDn) throws Exception {
        this.sBaseDn = theBaseDn;
    }

    public void setFilter() throws Exception {
        this.sFilter = commConfig.getSearchFilter(this.sObjectString, this.sFilterTypeString, this.sDomainEntry, this.sLdapEntry, this.sValueMap);
    }

    public void setFilter(String theFilter) throws Exception {
        this.sFilter = theFilter;
    }

    public String getBaseDn() {
        return this.sBaseDn;
    }

    public String getFilter() {
        return this.sFilter;
    }

    public int getSearchType() {
        return this.sSearchType;
    }

    public String getObjectString() {
        return this.sObjectString;
    }

    public int getObjectId() {
        return this.sObjectType;
    }
}

