/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.dirmig;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.comm.dirmig.InvalidOptionException;
import sun.comm.dirmig.NullObject;

public class GetOpts {
    static final String sccs_id = "%W% %G% SMI";
    public static final String DEF_OPT_PREFIX = "-";
    private static final String ARG_INDICATOR = ":";
    private static final byte notOptType = -1;
    private static final byte argType = 0;
    private static final byte noArgType = 1;
    private static final byte illegalOptType = 2;
    private static final byte separateType = 3;
    private boolean ignoreUnknownOpts;
    private String optPrefix;
    private Hashtable optTable;
    private Vector pushBack;
    private String[] optList;
    private String[] split;

    public String getClassVersion() {
        return sccs_id;
    }

    public GetOpts(String[] opts, boolean ignore) {
        this.ignoreUnknownOpts = ignore;
        this.optList = opts;
        this.optPrefix = DEF_OPT_PREFIX;
        this.optTable = new Hashtable();
        this.pushBack = new Vector();
        this.split = new String[2];
    }

    public GetOpts(String[] opts) {
        this(opts, false);
    }

    public String[] parseOpts(String[] argv) throws InvalidOptionException {
        int sz;
        int lopt = -1;
        boolean argOk = false;
        if (argv != null) {
            block6: for (int i = 0; i < argv.length; ++i) {
                switch (this.getType(argv[i])) {
                    case 3: {
                        String[] nargs = new String[argv.length - i + 1];
                        nargs[0] = this.split[0];
                        nargs[1] = this.split[1];
                        int k = 2;
                        for (int j = i + 1; j < argv.length; ++j) {
                            nargs[k++] = argv[j];
                        }
                        return this.parseOpts(nargs);
                    }
                    case 0: {
                        lopt = i;
                        argOk = true;
                        this.setSwitch(this.stripPrefix(argv[i]));
                        continue block6;
                    }
                    case 1: {
                        this.setSwitch(this.stripPrefix(argv[i]));
                        if (!argOk) continue block6;
                        argOk = false;
                        continue block6;
                    }
                    case 2: {
                        if (this.ignoreUnknownOpts) {
                            this.pushBack.addElement(argv[i]);
                            continue block6;
                        }
                        throw new InvalidOptionException(argv[i]);
                    }
                    default: {
                        if (argOk) {
                            this.setOpt(this.stripPrefix(argv[lopt]), argv[i]);
                            argOk = false;
                            continue block6;
                        }
                        this.pushBack.addElement(argv[i]);
                    }
                }
            }
        }
        if ((sz = this.pushBack.size()) > 0) {
            Object[] rejects = new String[sz];
            this.pushBack.copyInto(rejects);
            return rejects;
        }
        return null;
    }

    public String getArg(String opt) {
        Object o = this.optTable.get(opt);
        if (o != null && !(o instanceof NullObject)) {
            Vector valVector = (Vector)o;
            return (String)valVector.elementAt(valVector.size() - 1);
        }
        return null;
    }

    public Enumeration getAllOptions() {
        return this.optTable.keys();
    }

    public Vector getMultiArgs(String opt) {
        Object o = this.optTable.get(opt);
        if (o != null && !(o instanceof NullObject)) {
            return (Vector)o;
        }
        return null;
    }

    public boolean isOpt(String opt) {
        return this.optTable.containsKey(opt);
    }

    public void setOpt(String opt, String val) {
        Vector valVector = null;
        if (val != null) {
            val = val.trim();
        }
        if (this.isOpt(opt)) {
            Object o = this.optTable.get(opt);
            valVector = o != null && !(o instanceof NullObject) ? (Vector)o : new Vector();
            valVector.addElement(val);
            this.setMultiOpt(opt, valVector);
        } else {
            valVector = new Vector();
            valVector.addElement(val);
            this.optTable.put(opt, valVector);
        }
    }

    public void replaceMultiArgsOpt(String opt, Vector val) {
        if (val == null) {
            return;
        }
        if (this.isOpt(opt)) {
            this.setMultiOpt(opt, val);
        } else {
            this.optTable.put(opt, val);
        }
    }

    public void replaceOpt(String opt, String val) {
        Vector<String> valVector = null;
        if (val != null) {
            val = val.trim();
        }
        if (this.isOpt(opt)) {
            valVector = new Vector<String>();
            valVector.addElement(val);
            this.setMultiOpt(opt, valVector);
        } else {
            valVector = new Vector();
            valVector.addElement(val);
            this.optTable.put(opt, valVector);
        }
    }

    public void setSwitch(String opt) {
        Object o = this.optTable.get(opt);
        if (o == null) {
            this.optTable.put(opt, new NullObject());
        }
    }

    public void setMultiOpt(String opt, Vector vals) {
        this.optTable.put(opt, vals);
    }

    public String getOptPrefix() {
        return this.optPrefix;
    }

    public void setOptPrefix(String pre) {
        this.optPrefix = pre;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.optList.length; ++i) {
            String oName = this.getOptName(this.optList[i]);
            buf.append(oName);
            buf.append(": ");
            if (this.isOpt(oName)) {
                Vector args = this.getMultiArgs(oName);
                if (args == null) {
                    buf.append("<true>");
                } else {
                    buf.append((String)args.elementAt(0));
                    for (int j = 1; j < args.size(); ++j) {
                        buf.append(", ");
                        buf.append((String)args.elementAt(j));
                    }
                }
            } else {
                buf.append("<false>");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    private boolean takesArg(String optListEntry) {
        return optListEntry.endsWith(ARG_INDICATOR);
    }

    private String getOptName(String optListEntry) {
        if (this.takesArg(optListEntry)) {
            return optListEntry.substring(0, optListEntry.indexOf(ARG_INDICATOR));
        }
        return optListEntry;
    }

    private String stripPrefix(String opt) {
        return opt.substring(this.optPrefix.length());
    }

    private byte getType(String opt) {
        if (opt.startsWith(this.optPrefix)) {
            String oName = this.stripPrefix(opt);
            if (oName.equals("")) {
                return -1;
            }
            for (int i = this.optList.length - 1; i >= 0; --i) {
                String optName = this.getOptName(this.optList[i]);
                if (optName.equals(oName)) {
                    if (this.takesArg(this.optList[i])) {
                        return 0;
                    }
                    return 1;
                }
                if (!oName.startsWith(optName)) continue;
                if (this.takesArg(this.optList[i])) {
                    this.split[0] = this.optPrefix + optName;
                    this.split[1] = oName.substring(optName.length());
                    return 3;
                }
                this.split[0] = this.optPrefix + oName.charAt(0);
                this.split[1] = this.optPrefix + oName.substring(1);
                return 3;
            }
            return 2;
        }
        return -1;
    }
}

