/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.comm.client.BadLoginException;
import sun.comm.client.CLIInfileParser;
import sun.comm.client.CLIInteractive;
import sun.comm.client.CLIProperties;
import sun.comm.client.CLIValidOptions;
import sun.comm.client.CommAdmin;
import sun.comm.client.Connection;
import sun.comm.client.Debug;
import sun.comm.client.GetOpts;
import sun.comm.client.InvalidOptionException;
import sun.comm.client.MissingOptionException;
import sun.comm.client.NoMoreOptionsException;
import sun.comm.client.ServletInfo;

public class CLIObject {
    static final String sccs_id = "%W% %G% SMI";
    public static final int MAXRETRIES = 3;
    private String[][] validAddOptionsArray = new String[0][];
    private String[][] validDeleteOptionsArray = new String[0][];
    private String[][] validModifyOptionsArray = new String[0][];
    private String[][] validSearchOptionsArray = new String[0][];
    protected String rcStat = "INIT";
    protected String dsMesg = null;
    protected ResourceBundle dsRes = null;
    protected CLIInfileParser infileParser = null;
    protected String msMesg = null;
    protected ResourceBundle res = ResourceBundle.getBundle("sun.comm.client.CLIResourceBundle", Locale.getDefault());
    protected int retries = 0;
    protected String successMesg = null;
    private String[] currCookies = null;
    private String currNDAHost = null;
    private int currNDAPort = 80;
    protected CLIValidOptions allValidOptions = null;
    protected CLIProperties cliRes = null;
    private Hashtable authSessions = null;
    protected String protocol = null;
    protected boolean secure = false;
    private static final String DEFAULTDOMAIN = "DefaultDomain";
    private static final String ISHOST = "IdentityServerHost";
    private static final String ISPORT = "IdentityServerPort";
    private static final String ISSSLPORT = "IdentityServerSSLPort";
    private static final String AUTHSERVLET = "auth";
    private static final String MAPSERVLET = "climap";
    private static final String LOGOUTSERVLET = "logout";
    private static final String EQUALS = "=";
    private static final String AMPERSAND = "&";
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final String DOMAIN = "domain";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String ENCODING = "charsetenc";
    private static final String SERVLET_AUTH = "/commcli/auth";
    private static final String SERVLET_CLIMAP = "/commcli/climap";
    private static final String SERVLET_LOGOUT = "/commcli/logout";
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String COOKIE = "Cookie";
    private static final String COOKIE_SEPARATOR = ";";
    public static final String STATUSOK = "OK";
    public static final String STATUSFAIL = "FAIL";
    private static final String HTML_TITLE = "<title>";

    public String getClassVersion() {
        return sccs_id;
    }

    public CLIObject() {
        this(null, 0, false);
    }

    public CLIObject(boolean secure) {
        this(null, 0, secure);
    }

    public CLIObject(String host, int port) {
        this(host, port, false);
    }

    public CLIObject(String host, int port, boolean secure) {
        if (CommAdmin.getInputFile() != null) {
            this.infileParser = new CLIInfileParser(CommAdmin.getInputFile());
        }
        this.currNDAHost = host;
        this.currNDAPort = port;
        this.cliRes = new CLIProperties();
        this.secure = secure;
        this.protocol = secure ? HTTPS : HTTP;
        this.authSessions = new Hashtable();
    }

    public CLIValidOptions getValidOptions() {
        return this.allValidOptions;
    }

    protected String[] parseOptionValues(Hashtable ht, CLIValidOptions vo, String[] av) throws InvalidOptionException {
        return this.parseOptionValues(ht, vo, av, true);
    }

    private Vector flattenArgsList(Vector src) {
        Vector<String> res = new Vector<String>();
        int count = 0;
        int i = 0;
        while (i < src.size()) {
            String elem = (String)src.elementAt(i);
            String[] sublist = elem.split(",");
            if (sublist.length > 0) {
                int j = 0;
                while (j < sublist.length) {
                    res.addElement(sublist[j].toLowerCase());
                    ++j;
                    ++count;
                }
            } else {
                res.addElement(elem);
                ++count;
            }
            ++i;
        }
        return res;
    }

    protected String[] parseOptionValues(Hashtable optiontable, CLIValidOptions validOptions, String[] argv, boolean ignoreUnknownOpts) throws InvalidOptionException {
        GetOpts opts = new GetOpts(validOptions.getNames(true), ignoreUnknownOpts);
        String[] argvLeft = null;
        if (argv == null) {
            return null;
        }
        try {
            argvLeft = opts.parseOpts(argv);
        }
        catch (InvalidOptionException e) {
            e.setValidOptions(validOptions);
            throw e;
        }
        int i = 0;
        while (i < validOptions.size()) {
            block16: {
                Hashtable sectable;
                Vector<String> temp;
                String currentOption;
                block15: {
                    String defaultValue;
                    block14: {
                        currentOption = validOptions.getName(i);
                        defaultValue = validOptions.getDefaultValue(i);
                        temp = null;
                        sectable = null;
                        if (!opts.isOpt(currentOption)) break block14;
                        temp = opts.getMultiArgs(currentOption);
                        if (currentOption.equals("S")) {
                            temp = this.flattenArgsList(temp);
                        }
                        if (temp != null) {
                            CLIValidOptions validSecOptions;
                            HashMap secOptMap = validOptions.getSecOption(i);
                            if (secOptMap != null && (validSecOptions = this.getValidSecOptions(secOptMap, temp)) != null) {
                                sectable = new Hashtable();
                                argvLeft = this.parseOptionValues(sectable, validSecOptions, argvLeft, true);
                                validOptions.addValidOptions(validSecOptions);
                            }
                            temp.insertElementAt("true", 0);
                        } else {
                            temp = new Vector<String>();
                            temp.addElement("true");
                            if (!validOptions.getTakesArg(i)) {
                                temp.addElement(validOptions.getArgPrefix(i));
                            } else {
                                temp.addElement("");
                                optiontable.put(currentOption, temp);
                                this.invalidValue(optiontable, validOptions, currentOption);
                            }
                        }
                        break block15;
                    }
                    Vector maybe = (Vector)optiontable.get(currentOption);
                    if (maybe != null && ((String)maybe.elementAt(0)).equals("true")) break block16;
                    temp = new Vector<String>();
                    temp.addElement("false");
                    temp.addElement(defaultValue);
                }
                optiontable.put(currentOption, temp);
                if (sectable != null) {
                    optiontable.putAll(sectable);
                }
            }
            ++i;
        }
        return argvLeft;
    }

    private CLIValidOptions getValidSecOptions(Map secOptMap, Vector temp) {
        String val = "";
        CLIValidOptions validSecOptions = null;
        int k = 0;
        while (k < temp.size()) {
            val = (String)temp.elementAt(k);
            if (val.equals("all")) {
                Iterator opts = secOptMap.values().iterator();
                while (opts.hasNext()) {
                    CLIValidOptions cv = (CLIValidOptions)opts.next();
                    if (cv == null) continue;
                    if (validSecOptions != null) {
                        validSecOptions.addValidOptions(cv);
                        continue;
                    }
                    validSecOptions = cv;
                }
                break;
            }
            CLIValidOptions cv = (CLIValidOptions)secOptMap.get(val);
            if (cv != null) {
                if (validSecOptions != null) {
                    validSecOptions.addValidOptions(cv);
                } else {
                    validSecOptions = cv;
                }
            }
            ++k;
        }
        return validSecOptions;
    }

    protected String[] parseNextOptionValues(Hashtable optiontable, CLIValidOptions validOptions) throws NoMoreOptionsException, InvalidOptionException {
        if (this.infileParser == null) {
            throw new NoMoreOptionsException();
        }
        String[] argv = null;
        try {
            argv = this.infileParser.parseNextOptionSet();
        }
        catch (IOException e) {
            throw new NoMoreOptionsException();
        }
        if (argv == null) {
            throw new NoMoreOptionsException();
        }
        this.parseOptionValues(optiontable, validOptions, argv);
        return argv;
    }

    protected void invalidValue(Hashtable optiontable, CLIValidOptions validOptions, String opt) {
        this.invalidMultiValue(optiontable, validOptions, opt, 1);
    }

    protected void invalidValue(Hashtable optiontable, CLIValidOptions validOptions, String opt, String reason) {
        CLIInteractive.printError(reason);
        this.invalidValue(optiontable, validOptions, opt);
    }

    protected void invalidMultiValue(Hashtable optiontable, CLIValidOptions validOptions, String opt, int multiIndex) {
        Vector optionMultiValues = (Vector)optiontable.get(opt);
        int index = validOptions.indexOf(opt);
        String resp = validOptions.getDescription(index);
        String element = "";
        if (optionMultiValues != null && optionMultiValues.size() > 1) {
            element = (String)optionMultiValues.elementAt(multiIndex);
        }
        try {
            resp = this.res.getString(resp);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        CLIInteractive.printInvalid(resp, element, validOptions.getEcho(index));
        optionMultiValues.setElementAt("InvalidValue", 0);
        validOptions.setRequired(true, index);
    }

    protected void promptMissingValues(Hashtable optiontable, CLIValidOptions validOptions) throws MissingOptionException {
        this.promptMissingValues(optiontable, validOptions, false);
    }

    protected String[] getOptionArgs(Hashtable ht, String opt) {
        Vector temp = (Vector)ht.get(opt);
        Vector<String> newTemp = null;
        Object[] argArr = null;
        if (temp != null) {
            newTemp = new Vector<String>();
            int i = 1;
            while (i < temp.size()) {
                newTemp.addElement((String)temp.elementAt(i));
                ++i;
            }
            argArr = new String[newTemp.size()];
            newTemp.copyInto(argArr);
        }
        return argArr;
    }

    protected String getOptionArg(Hashtable ht, String opt) {
        String arg = "";
        String[] temp = this.getOptionArgs(ht, opt);
        if (temp != null) {
            arg = temp[0];
        }
        return arg;
    }

    protected boolean isOptionValid(Hashtable optiontable, String name) {
        String state;
        boolean valid = false;
        Vector temp = (Vector)optiontable.get(name);
        if (temp != null && !(state = (String)temp.elementAt(0)).equalsIgnoreCase("InvalidValue")) {
            valid = true;
        }
        return valid;
    }

    protected void promptMissingValues(Hashtable optiontable, CLIValidOptions validOptions, boolean promptAll) throws MissingOptionException {
        int i = 0;
        while (i < validOptions.size()) {
            String opt = validOptions.getName(i);
            Vector optionMultiValues = (Vector)optiontable.get(opt);
            boolean optionValid = this.isOptionValid(optiontable, opt);
            String optArg = this.getOptionArg(optiontable, opt);
            if (promptAll || validOptions.getRequired(i) && optArg.equals("") || !optionValid) {
                int j = 1;
                while (j < optionMultiValues.size()) {
                    if (CommAdmin.getNonInteractive()) {
                        throw new MissingOptionException(validOptions.getName(i));
                    }
                    if (this.retries >= 3) {
                        throw new MissingOptionException(validOptions.getName(i));
                    }
                    String resp = validOptions.getDescription(i);
                    try {
                        resp = this.res.getString(resp);
                    }
                    catch (MissingResourceException e) {
                        // empty catch block
                    }
                    String retStr = CLIInteractive.promptUser(resp, validOptions.getEcho(i), (String)optionMultiValues.elementAt(j));
                    if (retStr == null) {
                        throw new MissingOptionException(validOptions.getName(i));
                    }
                    if (retStr.equals("")) {
                        optionMultiValues.setElementAt("true", 0);
                    } else {
                        optionMultiValues.setElementAt("true", 0);
                        optionMultiValues.removeElementAt(j);
                        optionMultiValues.insertElementAt(retStr.trim(), j);
                    }
                    ++j;
                }
                optiontable.put(opt, optionMultiValues);
            }
            ++i;
        }
    }

    protected int printStatus(Vector resp) {
        int rc = 0;
        if (resp != null) {
            int i = 0;
            while (i < resp.size()) {
                CLIInteractive.printResult((String)resp.elementAt(i));
                ++i;
            }
        }
        if (this.rcStat.equals(STATUSOK)) {
            if (this.successMesg != null) {
                CLIInteractive.printResult(this.successMesg);
                CLIInteractive.printResult("");
            }
        } else {
            if (this.dsMesg != null) {
                CLIInteractive.printError(this.dsMesg);
            }
            if (this.msMesg != null) {
                CLIInteractive.printError(this.msMesg);
            }
            CLIInteractive.printError("");
            rc = 6;
        }
        return rc;
    }

    /*
     * Loose catch block
     */
    protected boolean promptBoolean(String optionalPreHeader, String promptMsg, String[] trueInputs, String[] falseInputs) {
        String inputString = null;
        int f = 0;
        int t = 0;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        block6: while (true) {
            if (optionalPreHeader != null) {
                System.out.print(optionalPreHeader + this.res.getString("SeparatorLogSeverity") + promptMsg);
            } else {
                System.out.print(promptMsg);
            }
            try {
                inputString = in.readLine();
            }
            catch (IOException e) {
                System.err.println(this.res.getString("Error") + this.res.getString("SeparatorLogSeverity") + this.res.getString("IOExceptionreadLine") + e.getLocalizedMessage());
                return false;
            }
            try {
                t = 0;
                while (t < trueInputs.length) {
                    if (inputString.equalsIgnoreCase(trueInputs[t])) {
                        return true;
                    }
                    ++t;
                }
            }
            catch (Exception e) {
                System.err.println(this.res.getString("Error") + this.res.getString("SeparatorLogSeverity") + e.getLocalizedMessage());
                return false;
            }
            f = 0;
            while (true) {
                if (f >= falseInputs.length) continue block6;
                if (inputString.equalsIgnoreCase(falseInputs[f])) {
                    return false;
                }
                ++f;
            }
            break;
        }
        catch (Exception e) {
            System.err.println(this.res.getString("Error") + this.res.getString("SeparatorLogSeverity") + e.getLocalizedMessage());
            return false;
        }
    }

    protected void setCookie(String[] cookiesToset) {
        this.currCookies = cookiesToset;
    }

    protected String[] getCookies() {
        return this.currCookies;
    }

    protected boolean isCookieValid() {
        String[] ndaCookie = this.getCookies();
        return ndaCookie != null;
    }

    private String makeURL(String prot, String host, int port, String serv) {
        String url = null;
        if (host != null && port != 0) {
            url = prot + host + ":" + port + serv;
        }
        return url;
    }

    private Connection getConnection(String protocol, String servlet) throws MalformedURLException, IOException {
        return this.getConnection(protocol, this.currNDAHost, this.currNDAPort, servlet);
    }

    private Connection getConnection(String protocol, String host, int port, String servlet) throws MalformedURLException, IOException {
        String url = this.makeURL(protocol, this.currNDAHost, this.currNDAPort, servlet);
        if (url == null) {
            throw new MalformedURLException();
        }
        Debug.println("Contacting : " + url);
        Connection connxn = new Connection(url);
        HttpURLConnection urlConnxn = connxn.openConnection();
        return connxn;
    }

    private String makeKey(String host, int port, String user, String domain) {
        String key = null;
        if (host != null && port != 0) {
            key = host + ":" + port + "/" + user + "@" + domain;
        }
        return key;
    }

    private AuthContainer getUserSession(String user, String domain) {
        AuthContainer cont = null;
        String key = this.makeKey(this.currNDAHost, this.currNDAPort, user, domain);
        if (key != null) {
            cont = (AuthContainer)this.authSessions.get(key);
        }
        return cont;
    }

    private void saveUserSession(String user, String domain, String[] cookies) {
        String key = null;
        key = CommAdmin.getUniqLogin() ? cookies[0] : this.makeKey(this.currNDAHost, this.currNDAPort, user, domain);
        if (key != null) {
            AuthContainer cont = new AuthContainer();
            cont.cookies = cookies;
            cont.host = this.currNDAHost;
            cont.port = this.currNDAPort;
            this.authSessions.put(key, cont);
        }
    }

    protected int authenticate(String user, String passwd, String domain) throws MissingOptionException, MalformedURLException, IOException, BadLoginException {
        AuthContainer ac = null;
        if (user == null || user.length() == 0 || domain == null || domain.length() == 0) {
            return 3;
        }
        String servlet = SERVLET_AUTH;
        String auth_serv = null;
        if (this.cliRes != null && (auth_serv = this.cliRes.getString(AUTHSERVLET)) != null) {
            servlet = auth_serv;
        }
        if ((ac = this.getUserSession(user, domain)) != null && ac.cookies != null) {
            this.setCookie(ac.cookies);
            Debug.println("OPTIMIZED login for: " + user + "@" + domain);
            return 0;
        }
        Connection connxn = this.getConnection(this.protocol, servlet);
        HttpURLConnection urlConnxn = connxn.getURLConnxn();
        String arg = "domain=" + domain + AMPERSAND + USERNAME + EQUALS + user + AMPERSAND + PASSWORD + EQUALS + passwd + AMPERSAND + ENCODING + EQUALS + "UTF-8";
        urlConnxn.setRequestMethod(POST);
        Debug.println("To servlet: " + arg);
        connxn.send(arg);
        try {
            if (urlConnxn.getResponseCode() != 200) {
                String msg = urlConnxn.getResponseMessage();
                Debug.println("Http Error recvd: " + msg);
                throw new MalformedURLException(msg);
            }
        }
        catch (IOException e) {
            String msg = urlConnxn.getResponseMessage();
            throw new IOException(e.getMessage() + ": " + urlConnxn.getResponseMessage());
        }
        String[] hdrCookie = this.retrvCookies(urlConnxn);
        this.setCookie(hdrCookie);
        if (hdrCookie == null) {
            Vector msg = connxn.recv();
            this.printHTMLTitle(msg);
            throw new BadLoginException(msg.elementAt(0).toString());
        }
        this.saveUserSession(user, domain, hdrCookie);
        connxn.close();
        return 0;
    }

    protected ServletInfo[] getObjTaskArgs(String object, String task) throws BadLoginException, MalformedURLException, IOException {
        Object servInfo = null;
        Debug.println("In getObjTaskArgs for: " + object + "; " + task);
        if (!this.isCookieValid()) {
            throw new BadLoginException("InvalidLogin");
        }
        String[] ndaCookie = this.getCookies();
        String servlet = SERVLET_CLIMAP;
        String map_serv = null;
        if (this.cliRes != null && (map_serv = this.cliRes.getString(MAPSERVLET)) != null) {
            servlet = map_serv;
        }
        Connection connxn = this.getConnection(this.protocol, servlet);
        HttpURLConnection urlConnxn = connxn.getURLConnxn();
        urlConnxn.setRequestMethod(POST);
        this.setCookieInHeader(urlConnxn, ndaCookie);
        String arg = "task=" + task + AMPERSAND + "object=" + object;
        Debug.println("Sending to servlet: " + arg);
        connxn.send(arg);
        try {
            if (urlConnxn.getResponseCode() != 200) {
                String msg = urlConnxn.getResponseMessage();
                throw new IOException(msg);
            }
        }
        catch (IOException e) {
            String msg = urlConnxn.getResponseMessage();
            throw new IOException(e.getMessage() + ": " + urlConnxn.getResponseMessage());
        }
        InputStream in = urlConnxn.getInputStream();
        ObjectInputStream deser = null;
        int status = -1;
        try {
            deser = new ObjectInputStream(in);
            status = deser.readInt();
        }
        catch (Exception e) {
            Debug.println("getObjTaskArgs, Excptn: " + e.getMessage());
            Debug.stackTrace(e);
            CLIInteractive.printError(this.res.getString("CLIMapInvalid") + ": " + e.getMessage());
            return null;
        }
        ServletInfo[] servInf = null;
        Debug.println("getObjTaskArgs Status: " + status);
        if (status == 0) {
            try {
                servInf = this.readServletInfo(deser);
            }
            catch (ClassCastException e) {
                Debug.println("getObjTaskArgs, ClassCastException: " + e.getMessage());
            }
            if (servInf == null) {
                CLIInteractive.printError(this.res.getString("CLIMapInvalid"));
            }
        } else {
            CommAdmin.setPrintUsage(true);
            if (status == 1) {
                CLIInteractive.printError(this.res.getString("InvalidObject"));
                CLIInteractive.printError(this.res.getString("ValidObjectsR"));
            } else if (status == 2) {
                CLIInteractive.printError(this.res.getString("InvalidTask"));
                CLIInteractive.printError(this.res.getString("ValidTasksR"));
            }
            String[] list = null;
            try {
                list = this.readObjTasklist(deser);
            }
            catch (ClassCastException e) {
                Debug.println("getObjTaskArgs, ClassCastException: " + e.getMessage());
            }
            if (list == null || list.length == 0) {
                CLIInteractive.printError(this.res.getString("CLIMapInvalid"));
            } else {
                int i = 0;
                while (i < list.length) {
                    CLIInteractive.printError("  " + list[i]);
                    ++i;
                }
            }
        }
        deser.close();
        in.close();
        connxn.close();
        return servInf;
    }

    private String[] readObjTasklist(ObjectInputStream deser) {
        String[] objTask = null;
        try {
            objTask = (String[])deser.readObject();
        }
        catch (Exception e) {
            Debug.println("readObjTasklist:" + e.getMessage());
            return null;
        }
        return objTask;
    }

    private ServletInfo[] readServletInfo(ObjectInputStream deser) {
        Object[] servObj = null;
        ServletInfo[] serinf = null;
        try {
            servObj = (Object[])deser.readObject();
        }
        catch (Exception e) {
            Debug.println("Excptn, readServletInfo: " + e.getMessage());
            return null;
        }
        serinf = new ServletInfo[servObj.length];
        Debug.println("Number of servlets: " + servObj.length);
        int i = 0;
        while (i < servObj.length) {
            Object[] oneServ = (Object[])servObj[i];
            String servName = (String)oneServ[0];
            Debug.println("Servlet Name: " + servName);
            String[] servArgs = (String[])oneServ[1];
            int j = 0;
            while (j < servArgs.length) {
                Debug.println("Servlet args: " + servArgs[j]);
                ++j;
            }
            Object[] optObjArr = (Object[])oneServ[2];
            String[][] valOptArr = new String[optObjArr.length][];
            int j2 = 0;
            while (j2 < optObjArr.length) {
                valOptArr[j2] = (String[])optObjArr[j2];
                ++j2;
            }
            Debug.println("Valid Options Array: " + valOptArr.length);
            int row = 0;
            while (row < valOptArr.length) {
                int col = 0;
                while (col < valOptArr[row].length) {
                    Debug.print(valOptArr[row][col] + ", ");
                    ++col;
                }
                Debug.print("\n");
                ++row;
            }
            serinf[i] = new ServletInfo(servName, servArgs, valOptArr);
            ++i;
        }
        return serinf;
    }

    protected Vector sendservCommand(String servlet, String arg) throws MalformedURLException, IOException, BadLoginException, InvalidOptionException {
        if (!this.isCookieValid()) {
            throw new BadLoginException("InvalidLogin");
        }
        String[] ndaCookie = this.getCookies();
        Connection connxn = this.getConnection(this.protocol, servlet);
        HttpURLConnection urlConnxn = connxn.getURLConnxn();
        urlConnxn.setRequestMethod(POST);
        this.setCookieInHeader(urlConnxn, ndaCookie);
        Debug.println("To servlet: " + arg);
        connxn.send(arg);
        try {
            int urlstat = urlConnxn.getResponseCode();
            if (urlstat != 200) {
                return null;
            }
        }
        catch (IOException e) {
            String msg = urlConnxn.getResponseMessage();
            throw new IOException(e.getMessage() + ": " + msg);
        }
        Vector resp = connxn.recv();
        if (resp == null) {
            throw new InvalidOptionException("InvalidOption");
        }
        return resp;
    }

    protected void setDefaultProperties(CLIValidOptions val) {
        String host;
        if (val == null || this.cliRes == null) {
            return;
        }
        String defDomain = this.cliRes.getString(DEFAULTDOMAIN);
        if (defDomain != null) {
            Debug.println("default domain from Properties: " + defDomain);
            val.setDefaultValue(defDomain, val.indexOf("n"));
        }
        if ((host = this.cliRes.getString(ISHOST)) != null) {
            Debug.println("IShost from Properties: " + host);
            val.setDefaultValue(host, val.indexOf("X"));
        }
        if (this.secure) {
            String port = this.cliRes.getString(ISSSLPORT);
            if (port != null) {
                Debug.println("ISSSLPort from Properties: " + port);
                val.setDefaultValue(port, val.indexOf("p"));
            }
        } else {
            String port = this.cliRes.getString(ISPORT);
            if (port != null) {
                Debug.println("ISPort from Properties: " + port);
                val.setDefaultValue(port, val.indexOf("p"));
            }
        }
    }

    protected int logout() throws MalformedURLException, IOException, BadLoginException {
        if (CommAdmin.getDontLogout()) {
            return 0;
        }
        String servlet = SERVLET_LOGOUT;
        String name = null;
        String[] ndaCookie = null;
        AuthContainer cont = null;
        if (this.authSessions == null) {
            return 0;
        }
        String logout_serv = null;
        if (this.cliRes != null && (logout_serv = this.cliRes.getString(LOGOUTSERVLET)) != null) {
            servlet = logout_serv;
        }
        Enumeration keys = this.authSessions.keys();
        while (keys.hasMoreElements()) {
            name = (String)keys.nextElement();
            cont = (AuthContainer)this.authSessions.get(name);
            if (cont == null) continue;
            ndaCookie = cont.cookies;
            if (cont.cookies == null) continue;
            Connection connxn = this.getConnection(this.protocol, cont.host, cont.port, servlet);
            HttpURLConnection urlConnxn = connxn.getURLConnxn();
            urlConnxn.setRequestMethod(POST);
            this.setCookieInHeader(urlConnxn, ndaCookie);
            Debug.println("Logout ... ");
            Vector resp = connxn.recv();
            connxn.close();
        }
        return 0;
    }

    protected String getFromHTML(Vector msg, String tag) {
        int index = -1;
        String buf = null;
        int i = 0;
        while (i < msg.size()) {
            String line = (String)msg.elementAt(i);
            index = line.toLowerCase().indexOf(tag);
            if (index >= 0) {
                String temp = line.substring(index + tag.length());
                if ((index = temp.indexOf("<")) >= 0) {
                    buf = temp.substring(0, index);
                    break;
                }
                buf = temp;
                break;
            }
            ++i;
        }
        return buf;
    }

    protected void printHTMLTitle(Vector msg) {
        String header = this.getFromHTML(msg, HTML_TITLE);
        if (header != null) {
            CLIInteractive.printError(header);
        }
    }

    protected String[] retrvCookies(HttpURLConnection uConn) {
        String header = null;
        Vector<String> temp = new Vector<String>();
        Object[] hdrCookies = null;
        int i = 1;
        while ((header = uConn.getHeaderFieldKey(i)) != null) {
            if (header.equalsIgnoreCase(SET_COOKIE)) {
                String cookie = uConn.getHeaderField(i);
                int separator = cookie.indexOf(COOKIE_SEPARATOR);
                if (separator == -1) {
                    temp.addElement(cookie);
                } else {
                    temp.addElement(cookie.substring(0, separator));
                }
                Debug.println("cookie => " + cookie);
            }
            ++i;
        }
        if (temp.size() > 0) {
            hdrCookies = new String[temp.size()];
            temp.copyInto(hdrCookies);
        }
        return hdrCookies;
    }

    protected void setCookieInHeader(HttpURLConnection urlConnxn, String[] ndaCookie) {
        String header = "";
        if (ndaCookie != null) {
            int i = 0;
            while (i < ndaCookie.length) {
                header = header + ndaCookie[i] + "; ";
                ++i;
            }
            urlConnxn.setRequestProperty(COOKIE, header);
        }
    }

    protected void setCurrentHostPort(String host, int port) {
        this.currNDAHost = host;
        this.currNDAPort = port;
    }

    private class AuthContainer {
        String host;
        int port;
        String[] cookies;

        private AuthContainer() {
        }
    }
}

