/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Locale;
import java.util.ResourceBundle;

public class CLIInteractive {
    static final String sccs_id = "%W% %G% SMI";
    public static ResourceBundle res = null;
    public static String enter = null;
    public static String invalidValue = null;
    public static String unknownOption = null;
    public static String missingOption = null;
    public static PrintStream error = System.err;
    public static PrintStream output = System.out;
    public static InputStream input = System.in;

    public String getClassVersion() {
        return sccs_id;
    }

    public static String promptUser(String description, boolean echo, String oldValue) {
        BufferedReader inputBR = new BufferedReader(new InputStreamReader(input));
        String inputString = new String();
        if (oldValue != null && !oldValue.equals("")) {
            if (!echo) {
                oldValue = "*";
            }
            oldValue = "[" + oldValue + "]";
        }
        output.print(enter + description + oldValue + ": ");
        try {
            inputString = inputBR.readLine();
        }
        catch (IOException e) {
            return "";
        }
        return inputString;
    }

    public static String promptUser(String description) {
        return CLIInteractive.promptUser(description, true, "");
    }

    public static String promptUser(String description, boolean echo) {
        return CLIInteractive.promptUser(description, echo, "");
    }

    public static void printError(String mesg) {
        error.println(mesg);
    }

    public static void printUnknown(String option) {
        error.println(unknownOption + ": " + option);
    }

    public static void printInvalid(String description, String value, boolean echo) {
        if (echo) {
            error.println(invalidValue + description + ": " + value);
        } else {
            error.println(invalidValue + description);
        }
    }

    public static void printMissing(String description) {
        error.println(missingOption + ": " + description);
    }

    public static void printResult(String mesg) {
        output.println(mesg);
    }

    public static void printError(InputStream in) throws IOException {
        String errorBuf = null;
        if (in == null) {
            return;
        }
        BufferedReader errorBR = new BufferedReader(new InputStreamReader(in));
        while ((errorBuf = errorBR.readLine()) != null) {
            output.println(errorBuf);
        }
    }

    static {
        res = ResourceBundle.getBundle("sun.comm.client.CLIResourceBundle", Locale.getDefault());
        enter = res.getString("Enter");
        invalidValue = res.getString("InvalidValue");
        unknownOption = res.getString("UnknownOption");
        missingOption = res.getString("MissingOption");
    }
}

