/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.page;

import com.netscape.page.AbstractEditor;
import com.netscape.page.AttrValue;
import com.netscape.page.Layout;
import com.netscape.page.PageUI;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JSlider;

public class SLIDEReditor
extends AbstractEditor {
    private static final String ATTR_ORIENTATION = "orientation";
    private static final String ATTR_MIN = "min";
    private static final String ATTR_MAX = "max";
    private static final String ATTR_INTERVAL = "interval";
    private static final String ATTR_TICKS = "ticks";
    private static final String ATTR_SNAP = "snap";
    private static final String ATTR_MAJOR = "major";
    private static final String ATTR_MINOR = "minor";
    private static final String VAL_HORIZONTAL = "x";
    private static final String VAL_VERTICAL = "y";
    private static final Integer DEF_MIN = new Integer(0);
    private static final int DEF_RANGE = 10;
    private static final String DEF_TICKS = "true";
    private static final String DEF_SNAP = "false";
    private JSlider _slider;
    private int _orientation;
    private int _min;
    private int _max;
    private int _val;
    private int _interval;
    private int _major;
    private int _minor;
    private boolean _snap;
    private boolean _ticks;
    private boolean _invert;
    private Hashtable _labels;
    private AttrValue _valAttr;

    public Component getEditor(PageUI pageUI, Layout layout) {
        super.getEditor(pageUI, layout);
        this.updateSlider();
        this.addWriter(this._valAttr);
        return this._slider;
    }

    public Component getFocusComponent() {
        return this._slider;
    }

    protected void getAttributes() {
        String string;
        this._valAttr = this.layout.getStringTag("val");
        AttrValue attrValue = this.layout.getStringTag(ATTR_ORIENTATION);
        if (attrValue != null && (string = (String)attrValue.getValue()) != null) {
            this._orientation = VAL_VERTICAL.equals(string) ? 1 : 0;
        }
        this._min = (Integer)this.layout.getIntTag(ATTR_MIN, DEF_MIN).getValue();
        this._max = (Integer)this.layout.getIntTag(ATTR_MAX, new Integer(this._min + 10)).getValue();
        if (this._min > this._max) {
            int n = this._min;
            this._min = this._max;
            this._max = n;
            this._invert = true;
        }
        this._val = (Integer)this.layout.getIntTag("val", new Integer(this._min + (this._max - this._min) / 2)).getValue();
        this._interval = (Integer)this.layout.getIntTag(ATTR_INTERVAL, new Integer((this._max - this._min) / 10)).getValue();
        this._major = (Integer)this.layout.getIntTag(ATTR_MAJOR, new Integer(this._interval)).getValue();
        this._minor = (Integer)this.layout.getIntTag(ATTR_MINOR, new Integer(this._major / 2)).getValue();
        this._ticks = new Boolean((String)this.layout.getStringTag(ATTR_TICKS, DEF_TICKS).getValue());
        this._snap = new Boolean((String)this.layout.getStringTag(ATTR_SNAP, DEF_SNAP).getValue());
        Object[] objectArray = null;
        attrValue = this.layout.getObjectArrayTag("labels");
        if (attrValue != null) {
            objectArray = (Object[])attrValue.getValue();
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Vector)) continue;
                Vector vector = (Vector)objectArray[i];
                if (this._labels == null) {
                    this._labels = new Hashtable();
                }
                if (vector.size() != 2) continue;
                Integer n = new Integer((String)vector.elementAt(0));
                JLabel jLabel = new JLabel((String)vector.elementAt(1), 0);
                this._labels.put(n, jLabel);
            }
        }
        this.layout.setTip(this._slider);
        if (this._val < this._min || this._val > this._max) {
            // empty if block
        }
        if (this._interval > this._max - this._min) {
            // empty if block
        }
        if (this._major > this._max - this._min || this._minor > this._major) {
            // empty if block
        }
    }

    protected void updateSlider() {
        if (this._slider == null) {
            this._slider = new JSlider();
        }
        this._slider.setInverted(this._invert);
        this._slider.setMajorTickSpacing(this._major);
        this._slider.setMinorTickSpacing(this._minor);
        this._slider.setPaintLabels(true);
        this._slider.setPaintTicks(this._ticks);
        this._slider.setSnapToTicks(this._snap);
        this._slider.setOrientation(this._orientation);
        this._slider.setMinimum(this._min);
        this._slider.setMaximum(this._max);
        this._slider.setValue(this._val);
        if (this._labels == null) {
            this._labels = this._slider.createStandardLabels(this._interval);
        }
        this._slider.setLabelTable(this._labels);
    }

    protected boolean setValueHandler(Object object) {
        this._slider.setValue((Integer)object);
        return true;
    }

    public Object getValue() {
        return new Integer(this._slider.getValue());
    }

    protected void setEnabledFlag(boolean bl) {
        this._slider.setEnabled(bl);
    }
}

