/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.msgserv;

import com.netscape.management.client.IFramework;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.msgserv.MsgResourceModel;
import com.netscape.management.msgserv.NodeCache;
import com.netscape.management.msgserv.util.ConfigPage;
import com.netscape.management.msgserv.util.Debug;
import com.netscape.management.msgserv.util.MsgUtil;
import com.netscape.management.msgserv.util.PropSheet;
import com.netscape.management.msgserv.util.ServerErrorException;
import com.netscape.page.PageUI;
import com.netscape.page.PageUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class MsgResource
implements IResourceObject,
IMenuInfo {
    String _serverRoot;
    String _name;
    String _displayName;
    String _type;
    String _cgi;
    PageUI _pUI;
    Hashtable _instanceTable = new Hashtable();
    int _nodeCount = 0;
    NodeCache _nodeCache = null;
    boolean _isLeaf = false;
    Object[] _tabs;
    Object[] _nodePath;
    Icon _icon = null;
    Container _customPanel;
    Component _configUI = null;
    Vector _pages;
    MsgResourceModel _dataModel;
    ConsoleInfo _info;

    public MsgResource() {
    }

    public MsgResource(MsgResourceModel msgResourceModel, Hashtable hashtable, ConsoleInfo consoleInfo) {
        this(null, msgResourceModel, hashtable, consoleInfo);
    }

    public MsgResource(Object[] objectArray, MsgResourceModel msgResourceModel, Hashtable hashtable, ConsoleInfo consoleInfo) {
        this();
        this._dataModel = msgResourceModel;
        this._info = consoleInfo;
        this._serverRoot = this._info.getAdminURL();
        String string = this._info.getCurrentDN();
        this._serverRoot = this._serverRoot + (String)this._info.get((Object)"SIE");
        this._serverRoot = this._serverRoot + "/tasks/operation/";
        this._name = (String)hashtable.get("name");
        if (hashtable.containsKey("title")) {
            this._displayName = (String)hashtable.get("title");
        } else {
            int n = this._name.lastIndexOf(124);
            this._displayName = this._name.length() > n + 1 ? this._name.substring(n + 1) : this._name;
        }
        this._cgi = (String)hashtable.get("cgi");
        if (hashtable.containsKey("isleaf")) {
            String string2 = (String)hashtable.get("isleaf");
            this._isLeaf = new Boolean(string2);
        } else {
            this._isLeaf = new Boolean(false);
        }
        if (hashtable.containsKey("icon")) {
            String string3 = (String)hashtable.get("icon");
            this._icon = new RemoteImage(string3);
        }
        this._tabs = (Object[])hashtable.get("tabs");
        this._pages = new Vector();
        if (objectArray == null) {
            this._nodePath = new Object[]{this};
        } else {
            this._nodePath = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, this._nodePath, 0, objectArray.length);
            this._nodePath[objectArray.length] = this;
        }
        if (!this._isLeaf) {
            if (hashtable.containsKey("nodes")) {
                this._nodeCache = new NodeCache(this, (Object[])hashtable.get("nodes"));
            }
            this._dataModel.registerNonLeaf(this._nodePath);
        }
    }

    Object[] getNodePath() {
        return this._nodePath;
    }

    String getBrowseQuery() {
        return this._serverRoot + this._cgi + "?cmd=getchild&object=" + this._name;
    }

    public final String getConfigURL() {
        return this._serverRoot + this._cgi;
    }

    public final ConsoleInfo getConsoleInfo() {
        return this._info;
    }

    String getActionURL() {
        return this._serverRoot + this._cgi;
    }

    String getQuery(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("?cmd=");
        stringBuffer.append(string2);
        stringBuffer.append("&object=");
        stringBuffer.append(this._name);
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    public TreeNode getParent() {
        if (this._nodePath == null || this._nodePath.length == 1) {
            return null;
        }
        return (TreeNode)this._nodePath[this._nodePath.length - 2];
    }

    public TreeNode getChildAt(int n) {
        if (n < this._nodeCount && this._nodeCache != null) {
            return (TreeNode)this._nodeCache.elementAt(n);
        }
        return null;
    }

    public int getIndex(TreeNode treeNode) {
        return 0;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public Enumeration children() {
        return null;
    }

    public int getChildCount() {
        if (this._isLeaf) {
            return 0;
        }
        this._nodeCount = this._nodeCache.size();
        return this._nodeCount;
    }

    public final boolean isLeaf() {
        return this._isLeaf;
    }

    public final String getFullName() {
        return this._name;
    }

    public final String getName() {
        return this._displayName;
    }

    public final void setName(String string) {
        this._displayName = string;
    }

    public final MsgResourceModel getResourceModel() {
        return this._dataModel;
    }

    public Object[] getTabs() {
        return this._tabs;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public Icon getLargeIcon() {
        return this._icon;
    }

    public boolean canRunSelection(IResourceObject[] iResourceObjectArray) {
        return false;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    public Component getCustomPanel() {
        return null;
    }

    public void setFlag(String string) {
        this._dataModel.setFlag(string);
    }

    public Component getCustomPanel(IPage iPage) {
        PropSheet propSheet;
        IFramework iFramework = iPage.getFramework();
        if (this._instanceTable.containsKey(iPage)) {
            InstanceData instanceData = (InstanceData)this._instanceTable.get(iPage);
            propSheet = instanceData.propSheet;
        } else if (this.getTabs() == null) {
            propSheet = null;
        } else {
            PropSheet propSheet2 = new PropSheet(this, iPage);
            InstanceData instanceData = new InstanceData();
            instanceData.propSheet = propSheet2;
            this._instanceTable.put(iPage, instanceData);
            PageUI pageUI = this.getTabComponent(iPage, 0);
            if (pageUI != null) {
                propSheet2.setComponentAt(0, pageUI);
            }
            propSheet = propSheet2;
        }
        this.updateConfig(iPage, null);
        return propSheet;
    }

    public void updateConfig(IPage iPage, Hashtable[] hashtableArray) {
        new Thread(new GetConfigAttrs(iPage, hashtableArray, this.getActionURL(), "getattr")).start();
    }

    public PageUI getTabComponent(IPage iPage, int n) {
        if (this._cgi == null) {
            return null;
        }
        PageUI pageUI = null;
        InstanceData instanceData = (InstanceData)this._instanceTable.get(iPage);
        PropSheet propSheet = instanceData.propSheet;
        if (propSheet == null) {
            return null;
        }
        IFramework iFramework = iPage.getFramework();
        String string = (String)((Object[])this._tabs[n])[0];
        if (instanceData.uiTable != null) {
            pageUI = (PageUI)instanceData.uiTable.get(string);
            Debug.println("return from getTabComponent(1) for: " + instanceData);
        }
        if (pageUI == null) {
            iFramework.setCursor(new Cursor(3));
            iFramework.changeStatusItemState("StatusItemText", (Object)MsgUtil.getReadDataString());
            try {
                String string2 = this.getQuery(this.getActionURL(), "getlayout", "&tab=" + string);
                Hashtable hashtable = MsgUtil.sendQuery(string2);
                Hashtable hashtable2 = (Hashtable)hashtable.get("layoutattrs");
                Object[] objectArray = (Object[])hashtable.get("layout");
                Hashtable hashtable3 = PageUtil.createUITable(objectArray);
                if (instanceData.uiTable != null) {
                    PageUtil.addHashEntries(hashtable3, instanceData.uiTable);
                } else {
                    instanceData.uiTable = hashtable3;
                }
                Debug.println("got uiTable for: " + instanceData);
                pageUI = (PageUI)instanceData.uiTable.get(string);
            }
            catch (ServerErrorException serverErrorException) {
                Debug.println("MsgResource::getTabComponent(): " + serverErrorException);
            }
            iFramework.changeStatusItemState("StatusItemText", (Object)"");
            iFramework.setCursor(new Cursor(0));
            Debug.println("return from getTabComponent(2) for: " + instanceData);
        }
        return pageUI;
    }

    public void unselect(IPage iPage) {
        InstanceData instanceData = (InstanceData)this._instanceTable.get(iPage);
        if (instanceData != null && instanceData.propSheet != null) {
            if (instanceData.propSheet.hasUnsavedChanges()) {
                this.getResourceModel().addUnsavedChanges(this.getFullName(), iPage);
            } else {
                this.getResourceModel().removeUnsavedChanges(this.getFullName(), iPage);
            }
        }
    }

    public void select(IPage iPage) {
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        return true;
    }

    public String[] getMenuCategoryIDs() {
        return new String[]{"VIEW"};
    }

    public IMenuItem[] getMenuItems(String string) {
        return new IMenuItem[]{new MenuItemText("refresh", "Refresh", "TODO:description")};
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if ("refresh".equals(iMenuItem.getID())) {
            this.updateConfig(iPage, null);
        }
    }

    private final void getConfigAttrs(Object object, String string, String string2) {
        InstanceData instanceData = (InstanceData)this._instanceTable.get(object);
        if (instanceData != null) {
            try {
                String string3 = this.getQuery(string, string2, "&attr=t");
                Hashtable hashtable = MsgUtil.sendQuery(string3);
                Hashtable hashtable2 = (Hashtable)hashtable.get("attrs");
                ConfigPage configPage = new ConfigPage(hashtable2, this);
                configPage.setUITable(instanceData.uiTable);
            }
            catch (ServerErrorException serverErrorException) {
                Debug.println(serverErrorException.getMessage());
            }
        }
    }

    class InstanceData {
        PropSheet propSheet;
        Hashtable uiTable;

        InstanceData() {
        }
    }

    class GetConfigAttrs
    implements Runnable {
        private String _url;
        private String _cmd;
        private InstanceData _iData;
        private Hashtable[] _tableList;
        private IPage viewInstance;
        private IFramework framework = null;

        public GetConfigAttrs(IPage iPage, Hashtable[] hashtableArray, String string, String string2) {
            this.viewInstance = iPage;
            if (iPage != null) {
                this._iData = (InstanceData)MsgResource.this._instanceTable.get(iPage);
                this.framework = iPage.getFramework();
            } else {
                this._iData = null;
            }
            this._tableList = hashtableArray;
            this._url = string;
            this._cmd = string2;
        }

        public void run() {
            if (this.framework != null) {
                this.framework.setCursor(new Cursor(3));
                this.framework.changeStatusItemState("StatusItemText", (Object)MsgUtil.getReadDataString());
            }
            try {
                ConfigPage configPage;
                String string = MsgResource.this.getQuery(this._url, this._cmd, "&attr=t");
                Hashtable hashtable = MsgUtil.sendQuery(string);
                Hashtable hashtable2 = (Hashtable)hashtable.get("attrs");
                if (this._tableList != null) {
                    for (int i = 0; i < this._tableList.length; ++i) {
                        configPage = new ConfigPage(hashtable2, MsgResource.this);
                        configPage.setUITable(this._tableList[i]);
                    }
                }
                if (this._iData != null) {
                    configPage = new ConfigPage(hashtable2, MsgResource.this);
                    while (this._iData.uiTable == null) {
                        try {
                            Thread.sleep(500L);
                            Debug.println("waiting for _iData");
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    configPage.setUITable(this._iData.uiTable);
                    this._iData.propSheet.validate();
                    this._iData.propSheet.repaint();
                } else {
                    Enumeration enumeration = MsgResource.this._instanceTable.elements();
                    while (enumeration.hasMoreElements()) {
                        InstanceData instanceData = (InstanceData)enumeration.nextElement();
                        configPage = new ConfigPage(hashtable2, MsgResource.this);
                        while (instanceData.uiTable == null) {
                            try {
                                Thread.sleep(500L);
                                Debug.println("waiting for iData: " + instanceData);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        configPage.setUITable(instanceData.uiTable);
                        instanceData.propSheet.validate();
                        instanceData.propSheet.repaint();
                    }
                }
            }
            catch (ServerErrorException serverErrorException) {
                Debug.println("GetConfigAttrs::run(): " + serverErrorException);
            }
            if (this.framework != null) {
                this.framework.setCursor(new Cursor(0));
                this.framework.changeStatusItemState("StatusItemText", (Object)"");
            }
        }
    }
}

