#!/bin/ksh

#############################################################################
##
## iMS monitoring and alarm script
##
## This script is part an example framework of what can be done.
## There are MANY ways that you can take this from here.
##
## File: $RCSfile: plugin4nagios.sh,v $
##       A script to generate daily usage reports
##
## While this package is provided AS-IS and unsupported, we would appreciate
## your comments, feedback and bug-reports at:
##
##      mailtools-feedback @Sign sun.com
##
#############################################################################
##
## Nagios ext plugin for monitoring iPlanet Messaging Server.
##
## Installation:
##      1) Make sure that your monitoring packages are running fine
##	2) append this to your checkcommands.cfg file
##	
##	3) USE SSH over RSH when possible. 
## 	   Create a .rhosts file in the home directory of the 'mailsrv'
##	   user which allows rsh actions by the 'nagios' user connecting
##	   from 127.0.0.1 and localhost. 
##
#############################################################################

. PATH_TO_SCRIPTS-Change-me/etc/alarms.cfg

rshoption="rsh localhost -l <local.serveruid>"	# One could use ssh intead

# This is left as an exercise to the reader.


#
# 'check_queues' command definition
define command{
        command_name    check_queues
        command_line    $rshoption "Path-to-scripts/change-me/healthmon/check_queues -S nagios -w $ARG1$ -c $ARG2$ -H $ARG3$ -p $ARG4$"
        }

define command{
        command_name    check_files
        command_line    $rshoption "Path-to-scripts/change-me/healthmon/check_files -S nagios"
        }

define command{
        command_name    check_mconn
        command_line    $rshoption "Path-to-scripts/change-me/healthmon/check_mconn -S nagios"
        }

define command{
        command_name    check_procs
        command_line    $rshoption "Path-to-scripts/change-me/healthmon/check_procs -S nagios"
        }

define command{
        command_name    check_sys
        command_line    $rshoption "Path-to-scripts/change-me/healthmon/check_sys -S nagios"
        }

define command{
        command_name    runmonitor
        command_line    $rshoption "Path-to-scripts/change-me/healthmon/runmoitor -S nagios"
        }

## end of script
