/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.page;

import com.netscape.page.AttrNotFoundException;
import com.netscape.page.AttrValue;
import com.netscape.page.Debug;
import com.netscape.page.Deserializer;
import com.netscape.page.PageModel;
import com.netscape.page.PageUI;
import com.netscape.page.PageUtil;
import com.netscape.page.Serializer;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class Layout {
    public static final String EMPTY_STRING = "";
    public static final String INDIRECT = "$";
    public static final String ATTR_ALIGNH = "alignh";
    public static final String ATTR_LABELS = "labels";
    public static final String ATTR_ITEMS = "items";
    public static final String ATTR_FONT = "font";
    public static final String ATTR_EDITOR = "editor";
    public static final String ATTR_TEXT = "text";
    public static final String ATTR_BOOLEAN = "boolean";
    public static final String ATTR_COMBO = "combo";
    public static final String ATTR_VAL = "val";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_COLUMNS = "columns";
    public static final String ATTR_SHOWADD = "showadd";
    public static final String ATTR_SHOWEDIT = "showedit";
    public static final String ATTR_SHOWDELETE = "showdelete";
    public static final String ATTR_ADDTEXT = "addtext";
    public static final String ATTR_EDITTEXT = "edittext";
    public static final String ATTR_DELTEXT = "deltext";
    public static final String ATTR_ADDUI = "addui";
    public static final String ATTR_EDITUI = "editui";
    public static final String ATTR_ALIGNX = "alignx";
    public static final String ATTR_ALIGNY = "aligny";
    public static final String ATTR_BOUNDS = "bounds";
    public static final String ATTR_BUTTONSAT = "buttonsat";
    public static final String ATTR_DELIMITER = "delimiter";
    public static final String ATTR_VISIBLEROWS = "visiblerows";
    public static final String ATTR_SWITCH = "switch";
    public static final String ATTR_CONTENT = "content";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_DIALOG = "dialog";
    public static final String ATTR_CONSTRAINT = "constraint";
    public static final String ATTR_ANCHOR = "anchor";
    public static final String ATTR_FILL = "fill";
    public static final String ATTR_GRIDHEIGHT = "gridheight";
    public static final String ATTR_GRIDWIDTH = "gridwidth";
    public static final String ATTR_GRIDX = "gridx";
    public static final String ATTR_GRIDY = "gridy";
    public static final String ATTR_INSETS = "insets";
    public static final String ATTR_IPADX = "ipadx";
    public static final String ATTR_IPADY = "ipady";
    public static final String ATTR_WEIGHTX = "weightx";
    public static final String ATTR_WEIGHTY = "weighty";
    public static final String ATTRVAL_CENTER = "center";
    public static final String ATTRVAL_LEFT = "left";
    public static final String ATTRVAL_RIGHT = "right";
    public static final String ATTRVAL_HORIZONTAL = "h";
    public static final String ATTRVAL_VERTICAL = "v";
    public static final String ATTRVAL_TRUE = "true";
    public static final String ATTRVAL_FALSE = "false";
    public static final String ATTRVAL_NORTH = "north";
    public static final String ATTRVAL_NORTHEAST = "northeast";
    public static final String ATTRVAL_EAST = "east";
    public static final String ATTRVAL_SOUTHEAST = "southeast";
    public static final String ATTRVAL_SOUTH = "south";
    public static final String ATTRVAL_SOUTHWEST = "southwest";
    public static final String ATTRVAL_WEST = "west";
    public static final String ATTRVAL_NORTHWEST = "northwest";
    public static final String ATTRVAL_NONE = "none";
    public static final String ATTRVAL_BOTH = "both";
    public static final String ATTRVAL_RELATIVE = "relative";
    public static final String ATTRVAL_REMAINDER = "remainder";
    public static final int COMP_SPACE = 6;
    public static final int DIFF_COMP_SPACE = 9;
    public static final int SEP_COMP_SPACE = 12;
    PageUI owner;
    Hashtable table;

    public Layout(Hashtable hashtable) {
        this(null, hashtable);
    }

    public Layout(PageUI pageUI, Hashtable hashtable) {
        this.owner = pageUI;
        this.table = hashtable;
    }

    public Hashtable getTable() {
        return this.table;
    }

    public static boolean isIndirect(Object object) {
        return object instanceof String && ((String)object).startsWith(INDIRECT);
    }

    public static String stripIndirect(String string) {
        return string.substring(1);
    }

    protected Object getValueOf(String string) {
        boolean bl = false;
        String string2 = string;
        Object object = null;
        PageModel pageModel = this.owner.getPageModel();
        if (pageModel != null) {
            try {
                object = pageModel.getAttribute(string2);
                bl = true;
            }
            catch (AttrNotFoundException attrNotFoundException) {
                // empty catch block
            }
        }
        if (!bl) {
            Hashtable hashtable = this.owner.getLayoutAttrs();
            if (hashtable != null && hashtable.containsKey(string2)) {
                object = hashtable.get(string2);
                bl = true;
            } else {
                hashtable = PageUI.getGlobalAttrs();
                if (hashtable != null && hashtable.containsKey(string2)) {
                    object = hashtable.get(string2);
                    bl = true;
                }
            }
        }
        return object;
    }

    public Object getIndirectAttr(String string, Object object) {
        boolean bl = false;
        Object object2 = null;
        if (this.owner != null) {
            PageModel pageModel = this.owner.getPageModel();
            if (pageModel != null) {
                try {
                    object2 = pageModel.getAttribute(string);
                    bl = true;
                }
                catch (AttrNotFoundException attrNotFoundException) {
                    // empty catch block
                }
            }
            if (!bl) {
                Hashtable hashtable = this.owner.getLayoutAttrs();
                if (hashtable != null && hashtable.containsKey(string)) {
                    object2 = hashtable.get(string);
                    bl = true;
                } else {
                    hashtable = PageUI.getGlobalAttrs();
                    if (hashtable != null && hashtable.containsKey(string)) {
                        object2 = hashtable.get(string);
                        bl = true;
                    }
                }
            }
        }
        if (!bl) {
            return object;
        }
        return object2;
    }

    private AttrValue getAttr(String string, Object object) {
        String string2 = null;
        if (PageUtil.emptyString(string)) {
            return new AttrValue(null, object);
        }
        Object object2 = this.table.get(string);
        if (object2 != null && Layout.isIndirect(object2)) {
            string2 = Layout.stripIndirect((String)object2);
            boolean bl = false;
            object2 = this.getIndirectAttr(string2, object);
        }
        AttrValue attrValue = new AttrValue(string2, object2);
        return attrValue;
    }

    public AttrValue getObjectArrayTag(String string) {
        AttrValue attrValue = this.getAttr(string, null);
        Object object = attrValue.getValue();
        if (object != null && !(object instanceof Object[])) {
            if (object instanceof String) {
                Object object2 = Deserializer.deserializeObject((String)object);
                if (object2 instanceof Object[]) {
                    attrValue.setValue(object2);
                } else {
                    attrValue.setValue(null);
                }
            } else {
                attrValue.setValue(null);
            }
        }
        return attrValue;
    }

    public AttrValue getHashtableTag(String string) {
        AttrValue attrValue = this.getAttr(string, null);
        Object object = attrValue.getValue();
        if (object != null && !(object instanceof Hashtable)) {
            if (object instanceof String) {
                Object object2 = Deserializer.deserializeObject((String)object);
                if (object2 instanceof Hashtable) {
                    attrValue.setValue(object2);
                } else {
                    attrValue.setValue(null);
                }
            } else {
                attrValue.setValue(null);
            }
        }
        return attrValue;
    }

    public AttrValue getVectorTag(String string) {
        AttrValue attrValue = this.getAttr(string, null);
        Object object = attrValue.getValue();
        if (object != null && !(object instanceof Vector)) {
            if (object instanceof String) {
                Object object2 = Deserializer.deserializeObject((String)object);
                if (object2 instanceof Vector) {
                    attrValue.setValue(object2);
                } else {
                    attrValue.setValue(null);
                }
            } else {
                attrValue.setValue(null);
            }
        }
        return attrValue;
    }

    public AttrValue getRectangleTag(String string, Rectangle rectangle) {
        AttrValue attrValue = this.getAttr(string, rectangle);
        Object object = attrValue.getValue();
        if (object != null && !(object instanceof Rectangle)) {
            object = object instanceof Object[] ? this.getBounds((Object[])object) : rectangle;
        }
        attrValue.setValue(null == object ? rectangle : object);
        return attrValue;
    }

    public AttrValue getDimensionTag(String string, Dimension dimension) {
        AttrValue attrValue = this.getAttr(string, dimension);
        Object object = attrValue.getValue();
        if (object != null && !(object instanceof Dimension)) {
            object = object instanceof Object[] ? this.getDimension((Object[])object) : dimension;
        }
        attrValue.setValue(null == object ? dimension : object);
        return attrValue;
    }

    public AttrValue getStringTag(String string) {
        return this.getStringTag(string, EMPTY_STRING);
    }

    public AttrValue getStringTag(String string, String string2) {
        AttrValue attrValue = this.getAttr(string, string2);
        Object object = attrValue.getValue();
        if (object != null && !(object instanceof String)) {
            object = Serializer.serializeObject(object);
        }
        attrValue.setValue(null == object ? string2 : object);
        return attrValue;
    }

    public AttrValue getIntTag(String string) {
        return this.getIntTag(string, PageUtil.INTEGER_0);
    }

    public AttrValue getIntTag(String string, Integer n) {
        AttrValue attrValue = this.getAttr(string, n);
        Object object = attrValue.getValue();
        if (object != null && !(object instanceof Integer)) {
            if (object instanceof String) {
                try {
                    object = new Integer((String)object);
                }
                catch (Exception exception) {
                    Debug.println("Failed to parse int parameter");
                    object = null;
                }
            } else {
                object = null;
            }
        }
        attrValue.setValue(null == object ? n : object);
        return attrValue;
    }

    public AttrValue getFloatTag(String string) {
        return this.getFloatTag(string, PageUtil.FLOAT_0);
    }

    public AttrValue getFloatTag(String string, Float f) {
        AttrValue attrValue = this.getAttr(string, f);
        Object object = attrValue.getValue();
        if (object != null && !(object instanceof Float)) {
            if (object instanceof String) {
                try {
                    object = new Float((String)object);
                }
                catch (Exception exception) {
                    Debug.println("Failed to parse float parameter");
                    object = null;
                }
            } else {
                object = null;
            }
        }
        attrValue.setValue(null == object ? f : object);
        return attrValue;
    }

    public AttrValue getBooleanTag(String string) {
        return this.getBooleanTag(string, PageUtil.BOOLEAN_TRUE);
    }

    public AttrValue getBooleanTag(String string, Boolean bl) {
        Object object;
        AttrValue attrValue;
        block7: {
            attrValue = this.getAttr(string, bl);
            object = attrValue.getValue();
            if (object != null && !(object instanceof Boolean)) {
                if (object instanceof String) {
                    try {
                        String string2 = (String)object;
                        string2 = string2.toLowerCase();
                        if (string2.indexOf(49) == 0 || string2.indexOf(121) == 0 || string2.indexOf(116) == 0 || string2.indexOf("on") == 0) {
                            object = new Boolean(true);
                            break block7;
                        }
                        if (string2.indexOf(48) == 0 || string2.indexOf(110) == 0 || string2.indexOf(102) == 0 || string2.indexOf("of") == 0) {
                            object = new Boolean(false);
                            break block7;
                        }
                        object = new Boolean((String)object);
                    }
                    catch (Exception exception) {
                        Debug.println("Failed to parse boolean parameter");
                        object = null;
                    }
                } else {
                    object = null;
                }
            }
        }
        attrValue.setValue(null == object ? bl : object);
        return attrValue;
    }

    public Dimension getDimension(Object[] objectArray) {
        int[] nArray = new int[2];
        Dimension dimension = null;
        if (objectArray != null && objectArray.length == 2) {
            try {
                for (int i = 0; i < 2; ++i) {
                    nArray[i] = Integer.parseInt((String)objectArray[i]);
                }
                dimension = new Dimension(nArray[0], nArray[1]);
            }
            catch (Exception exception) {
                Debug.println("Failed to parse dimension");
                return dimension;
            }
        }
        return dimension;
    }

    public Rectangle getBounds(Object[] objectArray) {
        int[] nArray = new int[4];
        Rectangle rectangle = null;
        nArray[3] = 0;
        nArray[2] = 0;
        nArray[1] = 0;
        nArray[0] = 0;
        if (objectArray != null && objectArray.length == 4) {
            try {
                for (int i = 0; i < 4; ++i) {
                    nArray[i] = Integer.parseInt((String)objectArray[i]);
                }
                rectangle = new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
            }
            catch (Exception exception) {
                Debug.println("Failed to parse bound");
            }
        }
        return rectangle;
    }

    public Insets getInsets(Object object) {
        Object[] objectArray = new Object[]{"0", "0", "0", "0"};
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
        } else if (object instanceof String && Layout.isIndirect((String)object)) {
            objectArray = (Object[])this.getIndirectAttr(Layout.stripIndirect((String)object), objectArray);
        }
        int[] nArray = new int[4];
        Insets insets = null;
        nArray[3] = 0;
        nArray[2] = 0;
        nArray[1] = 0;
        nArray[0] = 0;
        if (objectArray != null && objectArray.length == 4) {
            for (int i = 0; i < 4; ++i) {
                try {
                    nArray[i] = Integer.parseInt((String)objectArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    if (!Layout.isIndirect(objectArray[i])) continue;
                    String string = Layout.stripIndirect((String)objectArray[i]);
                    objectArray[i] = (String)this.getIndirectAttr(string, "0");
                    --i;
                }
            }
            insets = new Insets(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        return insets;
    }

    public static void setAlignment(JComponent jComponent, AttrValue attrValue, AttrValue attrValue2) {
        float f = ((Float)attrValue.getValue()).floatValue();
        float f2 = ((Float)attrValue2.getValue()).floatValue();
        jComponent.setAlignmentX(f);
        jComponent.setAlignmentY(f2);
    }

    public void setBounds(JComponent jComponent, Rectangle rectangle) {
        if (rectangle != null) {
            jComponent.setBounds(rectangle);
            Dimension dimension = new Dimension(rectangle.width, rectangle.height);
            jComponent.setMinimumSize(dimension);
            jComponent.setPreferredSize(dimension);
            jComponent.setMaximumSize(dimension);
        }
    }

    public void setTip(JComponent jComponent) {
        AttrValue attrValue = this.getStringTag("tip");
        String string = (String)attrValue.getValue();
        if (!PageUtil.emptyString(string)) {
            jComponent.setToolTipText(string);
        }
    }

    public static void setFont(JComponent jComponent, AttrValue attrValue) {
        Object[] objectArray = (Object[])attrValue.getValue();
        if (objectArray == null) {
            return;
        }
        String string = (String)objectArray[0];
        String string2 = (String)objectArray[1];
        String string3 = (String)objectArray[2];
        Font font = jComponent.getFont();
        String string4 = "Dialog";
        int n = 0;
        int n2 = 12;
        if (font != null) {
            string = font.getName();
            n = font.getStyle();
            n2 = font.getSize();
        }
        if (string != null && !EMPTY_STRING.equals(string)) {
            string4 = string;
        }
        n = "plain".equals(string2) ? 0 : ("bold".equals(string2) ? 1 : ("italic".equals(string2) ? 2 : ("bitalic".equals(string2) ? 3 : 0)));
        if (!EMPTY_STRING.equals(string3)) {
            try {
                if (string3.startsWith("+")) {
                    int n3 = Integer.parseInt(string3.substring(1));
                    n2 += n3;
                } else if (string3.startsWith("-")) {
                    int n4 = Integer.parseInt(string3);
                    n2 += n4;
                } else {
                    n2 = Integer.parseInt(string3);
                }
            }
            catch (Exception exception) {
                Debug.println("Failed to parse bound");
                return;
            }
            Font font2 = new Font(string4, n, n2);
            jComponent.setFont(font2);
        }
    }

    public static void setLayoutManager(Container container, Object[] objectArray) {
        if (null == objectArray) {
            container.setLayout(new BoxLayout(container, 1));
        } else {
            String string = (String)objectArray[0];
            if ("gridbag".equals(string)) {
                container.setLayout(new GridBagLayout());
            } else if ("ybox".equals(string)) {
                container.setLayout(new BoxLayout(container, 1));
            } else if ("xbox".equals(string)) {
                container.setLayout(new BoxLayout(container, 0));
            } else if ("absolute".equals(string)) {
                container.setLayout(null);
            } else if ("border".equals(string)) {
                container.setLayout(new BorderLayout());
            } else if ("grid".equals(string)) {
                String string2 = (String)objectArray[1];
                int n = 1;
                n = Integer.parseInt(string2);
                String string3 = (String)objectArray[2];
                int n2 = 1;
                n2 = Integer.parseInt(string3);
                container.setLayout(new GridLayout(n, n2));
            }
        }
    }
}

