/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.msgserv.util;

import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.CommRecord;
import com.netscape.management.client.comm.HttpManager;
import com.netscape.management.client.util.URLByteEncoder;
import com.netscape.management.msgserv.util.AsyncListener;
import com.netscape.management.msgserv.util.Debug;
import com.netscape.management.msgserv.util.MsgUtil;
import com.netscape.page.Deserializer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class ExploreTask
implements CommClient {
    private String _userID;
    private String _userPasswd;
    private URL _adminURL;
    private String _argList = null;
    private int _iError;
    private boolean _finished = false;
    private HttpManager _hManager;
    private Hashtable _rspVariables;
    protected Vector _results = new Vector(8);
    protected boolean _sync = true;
    protected BufferedReader _br;
    protected Vector _listeners = new Vector(8);

    public static Vector explore(String string) {
        ExploreTask exploreTask = null;
        Vector vector = null;
        try {
            exploreTask = new ExploreTask(new URL(string), MsgUtil.getAuthID(), MsgUtil.getAuthPasswd());
            if (exploreTask != null) {
                exploreTask.exec();
                vector = exploreTask.getResults();
                if (vector != null && vector.size() <= 0) {
                    vector = null;
                }
            }
        }
        catch (Exception exception) {
            Debug.println("ExploreTask::explore(): Failed to exec CGI query> " + string);
        }
        return vector;
    }

    public static Vector explore(String string, String[] stringArray, String[] stringArray2) {
        ExploreTask exploreTask = null;
        Vector vector = null;
        if (stringArray.length != stringArray2.length) {
            return vector;
        }
        try {
            exploreTask = new ExploreTask(new URL(string), MsgUtil.getAuthID(), MsgUtil.getAuthPasswd());
            if (exploreTask != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    exploreTask.addArgument(stringArray[i], stringArray2[i]);
                }
                exploreTask.exec();
                vector = exploreTask.getResults();
                if (vector != null && vector.size() <= 0) {
                    vector = null;
                }
            }
        }
        catch (Exception exception) {
            Debug.println("ExploreTask::explore(): Failed to exec CGI query> " + string);
        }
        return vector;
    }

    public ExploreTask(URL uRL, String string, String string2) {
        this._userID = string;
        this._userPasswd = string2;
        this._adminURL = uRL;
    }

    public String username(Object object, CommRecord commRecord) {
        return this._userID;
    }

    public String password(Object object, CommRecord commRecord) {
        return this._userPasswd;
    }

    public int addArgument(String string, String string2) {
        this._argList = this._argList == null ? "" : this._argList + "&";
        this._argList = this._argList + URLByteEncoder.encodeUTF8((String)string) + "=" + URLByteEncoder.encodeUTF8((String)string2);
        return 0;
    }

    public int exec() {
        if (this._hManager == null) {
            this._hManager = new HttpManager();
        }
        this._rspVariables = new Hashtable();
        ByteArrayInputStream byteArrayInputStream = null;
        int n = this._hManager.getResponseTimeout();
        this._hManager.setResponseTimeout(0);
        try {
            if (this._argList != null) {
                byteArrayInputStream = new ByteArrayInputStream(this._argList.getBytes());
            }
            Debug.println("+++++ " + this._adminURL);
            if (byteArrayInputStream == null) {
                this._hManager.post(this._adminURL, (CommClient)this, null, null, 0, 3);
            } else {
                this._hManager.post(this._adminURL, (CommClient)this, null, (InputStream)byteArrayInputStream, byteArrayInputStream.available(), 3);
            }
            this.waitForFinish();
            return 0;
        }
        catch (Exception exception) {
            Debug.println("ExploreTask::exec(): " + exception);
            return -1;
        }
    }

    private final synchronized void waitForFinish() {
        while (!this._finished) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
    }

    public final synchronized void finish() {
        this._finished = true;
        this.notifyAll();
    }

    public void errorHandler(Exception exception, CommRecord commRecord) {
        Debug.println("ExploreTask::errorHandler() >\n" + exception);
        this._iError = -1;
        this.finish();
    }

    public void replyHandler(InputStream inputStream, CommRecord commRecord) {
        this._br = new BufferedReader(new InputStreamReader(inputStream));
        if (this._sync) {
            try {
                Object object = Deserializer.readObject(inputStream);
                this._results.addElement(object);
            }
            catch (Exception exception) {
                Debug.println("ExploreTask::replyHandler(): deserializer failed. " + exception);
            }
            this.finish();
        } else {
            new Thread(new AsyncReader(inputStream, this._listeners)).start();
            this.finish();
        }
    }

    public void setSync(boolean bl) {
        this._sync = bl;
    }

    public void addAsyncListener(AsyncListener asyncListener) {
    }

    public void removeAsyncListener(AsyncListener asyncListener) {
    }

    public Vector getResults() {
        return this._results;
    }

    class AsyncReader
    implements Runnable {
        Vector _listeners;
        InputStream _is;

        public AsyncReader(InputStream inputStream, Vector vector) {
            this._listeners = vector;
            this._is = inputStream;
        }

        public void run() {
            try {
                Object object = Deserializer.readObject(this._is);
                ExploreTask.this._results.addElement(object);
            }
            catch (Exception exception) {
                Debug.println("AsyncReader failed. " + exception);
            }
            this.notifyAll();
        }

        private void notifyAll(Object object) {
        }
    }
}

