/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.msgserv;

import com.netscape.management.client.Framework;
import com.netscape.management.client.StatusItemProgress;
import com.netscape.management.msgserv.MsgPageControl;
import com.netscape.management.msgserv.MsgResource;
import com.netscape.management.msgserv.util.BusyDialog;
import com.netscape.management.msgserv.util.ExploreTask;
import com.netscape.management.msgserv.util.MsgUtil;
import com.netscape.page.AttrNotFoundException;
import com.netscape.page.CtrlModifiedEvent;
import com.netscape.page.IPageUIListener;
import com.netscape.page.ModelModifiedEvent;
import com.netscape.page.PANEeditor;
import com.netscape.page.PageModel;
import com.netscape.page.PageUI;
import com.netscape.page.PageUtil;
import com.netscape.page.TABLEeditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class ServiceGeneralControl
extends MsgPageControl {
    public static final String[] PROCESS_NAMES = new String[]{"IMAP", "POP", "MTA", "HTTP"};
    private static final int IMAP = 0;
    private static final int POP = 1;
    private static final int SMTP = 2;
    private static final int HTTP = 3;
    private static final int NNTP = 4;
    private static final String START_CMD = ".service.start";
    private static final String STOP_CMD = ".service.stop";
    private static final String STARTALL_CMD = ".service.startall";
    private static final String STOPALL_CMD = ".service.stopall";
    private static final String UPDATE_CMD = ".service.update";
    PageModel _pModel;
    String _onS = MsgUtil.getString("info", "serveron");
    String _offS = MsgUtil.getString("info", "serveroff");
    JButton _startB;
    JButton _stopB;
    PANEeditor _paneCtrl;
    JPanel _statPane;
    TABLEeditor _tableCtrl;
    JTable _table;
    TableModel _tableModel;
    String[] _processState;
    boolean[] _started;
    PageUI[] _statUI;
    int _currentSelection;
    PageUI _imapStat;
    PageUI _popStat;
    PageUI _smtpStat;
    PageUI _httpStat;
    Framework _framework;
    Thread _svcActionThread;
    static String[] _columnNames = new String[]{"Service", "On/Off state"};

    public final void init(PageUI pageUI) {
        super.init(pageUI);
        this._paneCtrl = (PANEeditor)pageUI.getCtrlByName("statcontainer");
        this._statPane = (JPanel)this._paneCtrl.getComponents()[0];
        this._statPane.setLayout(new BorderLayout());
        this._tableCtrl = (TABLEeditor)pageUI.getCtrlByName("processtable");
        this._processState = new String[PROCESS_NAMES.length];
        this._started = new boolean[PROCESS_NAMES.length];
        this._statUI = new PageUI[PROCESS_NAMES.length];
        for (int i = 0; i < PROCESS_NAMES.length; ++i) {
            this._processState[i] = this._offS;
        }
        this._tableModel = new ProcessModel();
        this._tableCtrl.setModel(this._tableModel);
        Object[] objectArray = this._tableCtrl.getComponents();
        Component component = (Component)objectArray[0];
        this._table = (JTable)component;
        ListSelectionModel listSelectionModel = this._table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new SelectListener());
        JButton[] jButtonArray = (JButton[])objectArray[6];
        this._startB = jButtonArray[0];
        this._stopB = jButtonArray[1];
    }

    public final void modelModified(ModelModifiedEvent modelModifiedEvent) {
        if (this._framework == null) {
            this._framework = MsgUtil.getFramework(this.getPageUI());
        }
        this._pModel = modelModifiedEvent.getModel();
        if (this._pModel != null) {
            Hashtable hashtable = this._pModel.getUITable();
            this._statUI[0] = (PageUI)hashtable.get("imapstat");
            this._statUI[0].setPageModel(this._pModel);
            this._statUI[1] = (PageUI)hashtable.get("popstat");
            this._statUI[1].setPageModel(this._pModel);
            this._statUI[2] = (PageUI)hashtable.get("smtpstat");
            this._statUI[2].setPageModel(this._pModel);
            this._statUI[3] = (PageUI)hashtable.get("httpstat");
            this._statUI[3].setPageModel(this._pModel);
        }
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (".page.init".equals(string)) {
            String string2;
            try {
                string2 = (String)this._pModel.getAttribute("sys.imapstart.value");
                this._processState[0] = this._onS + " [" + PageUtil.internalToLocale(string2) + "]";
                this._started[0] = true;
            }
            catch (AttrNotFoundException attrNotFoundException) {
                this._processState[0] = this._offS;
                this._started[0] = false;
            }
            try {
                string2 = (String)this._pModel.getAttribute("sys.popstart.value");
                this._processState[1] = this._onS + " [" + PageUtil.internalToLocale(string2) + "]";
                this._started[1] = true;
            }
            catch (AttrNotFoundException attrNotFoundException) {
                this._processState[1] = this._offS;
                this._started[1] = false;
            }
            try {
                string2 = (String)this._pModel.getAttribute("sys.smtpstart.value");
                this._processState[2] = this._onS + " [" + PageUtil.internalToLocale(string2) + "]";
                this._started[2] = true;
            }
            catch (AttrNotFoundException attrNotFoundException) {
                this._processState[2] = this._offS;
                this._started[2] = false;
            }
            try {
                string2 = (String)this._pModel.getAttribute("sys.httpstart.value");
                this._processState[3] = this._onS + " [" + PageUtil.internalToLocale(string2) + "]";
                this._started[3] = true;
            }
            catch (AttrNotFoundException attrNotFoundException) {
                this._processState[3] = this._offS;
                this._started[3] = false;
            }
            this.updateStatPane();
        } else if (START_CMD.equals(string)) {
            switch (this._currentSelection) {
                case 0: {
                    this._svcActionThread = new Thread(new DoActionHelper(this.getPageUI(), "start", "imap"));
                    break;
                }
                case 1: {
                    this._svcActionThread = new Thread(new DoActionHelper(this.getPageUI(), "start", "pop"));
                    break;
                }
                case 2: {
                    this._svcActionThread = new Thread(new DoActionHelper(this.getPageUI(), "start", "smtp"));
                    break;
                }
                case 3: {
                    this._svcActionThread = new Thread(new DoActionHelper(this.getPageUI(), "start", "http"));
                }
            }
            if (this._svcActionThread != null) {
                this._svcActionThread.start();
            }
        } else if (STOP_CMD.equals(string)) {
            switch (this._currentSelection) {
                case 0: {
                    this._svcActionThread = new Thread(new DoActionHelper(this.getPageUI(), "stop", "imap"));
                    break;
                }
                case 1: {
                    this._svcActionThread = new Thread(new DoActionHelper(this.getPageUI(), "stop", "pop"));
                    break;
                }
                case 2: {
                    this._svcActionThread = new Thread(new DoActionHelper(this.getPageUI(), "stop", "smtp"));
                    break;
                }
                case 3: {
                    this._svcActionThread = new Thread(new DoActionHelper(this.getPageUI(), "stop", "http"));
                }
            }
            if (this._svcActionThread != null) {
                this._svcActionThread.start();
            }
        } else if (STARTALL_CMD.equals(string)) {
            new Thread(new DoActionHelper(this.getPageUI(), "start", "")).start();
        } else if (STOPALL_CMD.equals(string)) {
            new Thread(new DoActionHelper(this.getPageUI(), "stop", "")).start();
        } else if (UPDATE_CMD.equals(string)) {
            this.updateConfig();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    void updateConfig() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MsgResource msgResource = (MsgResource)this._pModel.getClientData();
        if (msgResource != null) {
            msgResource.updateConfig(null, new Hashtable[]{this._pModel.getUITable()});
        }
    }

    void updateStatPane() {
        if (this._statUI[this._currentSelection] == null) {
            return;
        }
        this._statPane.removeAll();
        if (this._currentSelection < PROCESS_NAMES.length) {
            this._startB.setEnabled(!this._started[this._currentSelection]);
            this._stopB.setEnabled(this._started[this._currentSelection]);
            if (this._started[this._currentSelection]) {
                this._statPane.add(this._statUI[this._currentSelection]);
            }
            this._statUI[this._currentSelection].invalidate();
            Container container = this.getPageUI().getParent();
            container.validate();
            container.repaint();
        }
    }

    final void setBusy(boolean bl, String string) {
        if (bl) {
            if (this._framework != null) {
                this._framework.setCursor(new Cursor(3));
                this._framework.changeStatusItemState("StatusItemText", (Object)MsgUtil.getString("status", string));
                this._framework.changeStatusItemState("StatusItemProgress", (Object)StatusItemProgress.STATE_BUSY);
            }
        } else if (this._framework != null) {
            this._framework.changeStatusItemState("StatusItemText", (Object)"");
            this._framework.setCursor(new Cursor(0));
            this._framework.changeStatusItemState("StatusItemProgress", (Object)new Integer(0));
        }
    }

    class DoActionHelper
    implements Runnable,
    IPageUIListener {
        String _cmd;
        String _service;
        PageUI _pUI;
        BusyDialog _busyDialog;

        public DoActionHelper(PageUI pageUI, String string, String string2) {
            this._cmd = string;
            this._service = string2;
            this._pUI = pageUI;
        }

        public void run() {
            this._busyDialog = new BusyDialog(PageUtil.getRootFrame(this._pUI), MsgUtil.getString("status", "title"), this);
            this._busyDialog.setText(MsgUtil.getString("status", this._cmd));
            this._busyDialog.pack();
            PageUtil.placeWindow(this._pUI, this._busyDialog);
            this._busyDialog.show();
            ServiceGeneralControl.this.setBusy(true, this._cmd);
            String string = MsgUtil.getServerRoot() + "/tasks/operation/cgi_service?cmd=" + this._cmd + "&object=|service|" + this._service;
            Vector vector = ExploreTask.explore(string);
            String string2 = MsgUtil.replyStatus(vector);
            if (null != string2 && string2.startsWith("OK")) {
                String string3 = "Command executed";
                String string4 = "." + this._cmd + ".ok";
                string3 = (String)this._pUI.getLayoutAttr(string4);
                JOptionPane.showMessageDialog(PageUtil.getRootFrame(this._pUI), string3, MsgUtil.getString("status", "title"), 1);
            } else if (string2.startsWith("HA")) {
                String string5 = "Command failed";
                String string6 = "." + this._cmd + ".ha";
                string5 = (String)this._pUI.getLayoutAttr(string6);
                JOptionPane.showMessageDialog(PageUtil.getRootFrame(this._pUI), string5, MsgUtil.getString("error", "title"), 0);
            } else {
                String string7 = "Command failed";
                String string8 = "." + this._cmd + ".error";
                string7 = (String)this._pUI.getLayoutAttr(string8);
                JOptionPane.showMessageDialog(PageUtil.getRootFrame(this._pUI), string7, MsgUtil.getString("error", "title"), 0);
            }
            if (this._busyDialog != null) {
                this._busyDialog.done();
            }
            this._busyDialog = null;
            ServiceGeneralControl.this.setBusy(false, null);
            ServiceGeneralControl.this.updateConfig();
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("cancel".equals(string)) {
                if (ServiceGeneralControl.this._svcActionThread != null) {
                    ServiceGeneralControl.this._svcActionThread.stop();
                }
                ServiceGeneralControl.this._svcActionThread = null;
                ServiceGeneralControl.this.setBusy(false, null);
                if (this._busyDialog != null) {
                    this._busyDialog.done();
                }
                ServiceGeneralControl.this.updateConfig();
            }
        }

        public void modelModified(ModelModifiedEvent modelModifiedEvent) {
        }

        public void ctrlModified(CtrlModifiedEvent ctrlModifiedEvent) {
        }
    }

    class SelectListener
    implements ListSelectionListener {
        SelectListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                ServiceGeneralControl.this._currentSelection = ServiceGeneralControl.this._table.getSelectedRow();
                if (ServiceGeneralControl.this._currentSelection < 0) {
                    return;
                }
                ServiceGeneralControl.this.updateStatPane();
            }
        }
    }

    class ProcessModel
    extends AbstractTableModel {
        ProcessModel() {
        }

        public int getRowCount() {
            return PROCESS_NAMES.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return _columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return PROCESS_NAMES[n];
            }
            if (n2 == 1) {
                return ServiceGeneralControl.this._processState[n];
            }
            return null;
        }
    }
}

