#!../../../../install/perl
#
# helper of edit-mailautoreply.html
# Return list of languages msg server supports
#

$SERVERROOT=$ENV{"NETSITE_ROOT"};
$CONFIGUTIL="$SERVERROOT/bin/msg/admin/bin/configutil";
$DSGWCONF="$SERVERROOT/admin-serv/config/dsgw.conf";

# get default language
$defaultlang = `$CONFIGUTIL -o gen.sitelanguage`;
chop($defaultlang);
if ($defaultlang eq "") {
    $defaultlang = "en";
}

# get list of supported languages
$_ = `$CONFIGUTIL -o local.supportedlanguages`;
($_) = /\[(.*)\]/;
@langs = split(/,/);

# compile mapping from langtag to language name
# result in %langmap
&getlangmap();

# print HTML SELECT list
print<<EOF;
<SELECT NAME="preferredLanguage" ONCHANGE="reloadNewLang()">
EOF

for ($x = 0; $x <= $#langs; $x++) {
    printf("<OPTION %sVALUE=\"%s\">%s\n",
	   ($langs[$x] eq $defaultlang) ? "SELECTED ":"",
	   $langs[$x], $langmap{$langs[$x]});
}

print<<EOF;
</SELECT>
EOF

sub getlangmap
{
    local($tag, $name);

    if (open(IN, "<$DSGWCONF")) {
	while (<IN>) {
	    if (/^language/) {
		($tag, $name) = /^language\s+(\S+)\s+(\S+)\s+/;
		$langmap{$tag} = $name;
	    }
	}
    }
}
