/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.page;

import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.UITools;
import com.netscape.management.nmclf.SuiConstants;
import com.netscape.page.DottedBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class DayPicker
extends JPanel
implements SuiConstants {
    Calendar calendar;
    DayLabel[][] dayLabelArray;
    FocusListener dayFocusListener = new DayFocusListener();
    MouseListener dayMouseListener = new DayMouseListener();
    Border emptyBorder = BorderFactory.createEmptyBorder(1, 6, 1, 6);
    DayLabel selectedDay;
    DayKeyListener dayKeyListener = new DayKeyListener();

    public DayPicker(Calendar calendar) {
        int n;
        this.calendar = calendar;
        String[] stringArray = new String[]{"S", "M", "T", "W", "T", "F", "S"};
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.setBorder(UITools.createLoweredBorder());
        for (n = 0; n < stringArray.length; ++n) {
            JLabel jLabel = new JLabel(stringArray[n]);
            jLabel.setBackground(Color.darkGray);
            jLabel.setForeground(Color.white);
            jLabel.setBorder(this.emptyBorder);
            jLabel.setOpaque(true);
            GridBagUtil.constrain((Container)this, (Component)jLabel, (int)n, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)2, (int)0, (int)0, (int)6, (int)0);
        }
        n = calendar.getMaximum(4);
        int n2 = calendar.getMaximum(7);
        this.dayLabelArray = new DayLabel[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                DayLabel dayLabel = new DayLabel();
                dayLabel.addKeyListener(this.dayKeyListener);
                this.dayLabelArray[i][j] = dayLabel;
                GridBagUtil.constrain((Container)this, (Component)dayLabel, (int)j, (int)(i + 1), (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)0, (int)0, (int)0, (int)6, (int)0);
            }
        }
        this.updatePicker();
    }

    public JComponent getFocusComponent() {
        return this.selectedDay;
    }

    public int getDay() {
        return this.calendar.get(5);
    }

    int getIntFromString(String string) {
        Integer n = new Integer(string);
        return n;
    }

    public void updatePicker() {
        if (this.selectedDay != null) {
            this.selectedDay.setSelected(false);
        }
        boolean bl = false;
        int n = this.calendar.getMaximum(4);
        int n2 = this.calendar.getMaximum(7);
        int n3 = this.calendar.get(5);
        this.calendar.set(5, 1);
        for (int i = 0; i < n; ++i) {
            int n4 = this.calendar.getMaximum(5);
            for (int j = 0; j < n2; ++j) {
                if (this.calendar.get(7) == j + 1 && !bl) {
                    int n5 = this.calendar.get(5);
                    DayLabel dayLabel = this.dayLabelArray[i][j];
                    if (n5 == n3) {
                        dayLabel.setSelected(true);
                        this.selectedDay = dayLabel;
                    }
                    dayLabel.setText(String.valueOf(n5));
                    this.calendar.roll(5, true);
                    int n6 = this.calendar.get(5);
                    if (n6 >= n5) continue;
                    bl = true;
                    continue;
                }
                this.dayLabelArray[i][j].setText(" ");
            }
        }
        this.calendar.set(5, n3);
        this.refreshUI();
    }

    void refreshUI() {
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            ((Component)container).validate();
        }
    }

    class DayMouseListener
    extends MouseAdapter {
        DayMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            jLabel.requestFocus();
        }
    }

    class DayKeyListener
    extends KeyAdapter {
        DayKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 38) {
                int n2 = DayPicker.this.calendar.getMinimum(5);
                int n3 = DayPicker.this.calendar.getMaximum(5);
                int n4 = DayPicker.this.calendar.getMaximum(7);
                int n5 = DayPicker.this.calendar.get(5);
                if (n5 - n4 >= n2) {
                    DayPicker.this.calendar.add(5, -n4);
                    DayPicker.this.updatePicker();
                    DayPicker.this.selectedDay.requestFocus();
                    DayPicker.this.refreshUI();
                }
            } else if (n == 40) {
                int n6 = DayPicker.this.calendar.getMinimum(5);
                int n7 = DayPicker.this.calendar.getMaximum(5);
                int n8 = DayPicker.this.calendar.getMaximum(7);
                int n9 = DayPicker.this.calendar.get(5);
                if (n9 + n8 <= n7) {
                    DayPicker.this.calendar.add(5, n8);
                    DayPicker.this.updatePicker();
                    DayPicker.this.selectedDay.requestFocus();
                    DayPicker.this.refreshUI();
                }
            } else if (n == 37) {
                DayPicker.this.calendar.roll(5, false);
                DayPicker.this.updatePicker();
                DayPicker.this.selectedDay.requestFocus();
                DayPicker.this.refreshUI();
            } else if (n == 39) {
                DayPicker.this.calendar.roll(5, true);
                DayPicker.this.updatePicker();
                DayPicker.this.selectedDay.requestFocus();
                DayPicker.this.refreshUI();
            }
        }
    }

    class DayFocusListener
    implements FocusListener {
        DottedBorder dottedBorder = new DottedBorder();

        DayFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            DayLabel dayLabel = (DayLabel)focusEvent.getComponent();
            String string = dayLabel.getText();
            if (string.equals(" ")) {
                DayPicker.this.selectedDay.requestFocus();
            } else {
                DayPicker.this.selectedDay.setSelected(false);
                DayPicker.this.selectedDay = dayLabel;
                DayPicker.this.selectedDay.setSelected(true);
                DayPicker.this.calendar.set(5, DayPicker.this.getIntFromString(dayLabel.getText()));
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            DayLabel dayLabel = (DayLabel)focusEvent.getComponent();
            dayLabel.setText(dayLabel.getText());
        }
    }

    class DayLabel
    extends JLabel {
        public DayLabel() {
            this.addFocusListener(DayPicker.this.dayFocusListener);
            this.addMouseListener(DayPicker.this.dayMouseListener);
            this.setBackground(Color.white);
            this.setForeground(Color.black);
            this.setBorder(DayPicker.this.emptyBorder);
            this.setOpaque(true);
        }

        public boolean isFocusable() {
            return true;
        }

        public void setSelected(boolean bl) {
            if (!bl) {
                this.setForeground(UIManager.getColor("controlText"));
                this.setBackground(UIManager.getColor("window"));
            } else {
                this.setForeground(UIManager.getColor("textHighlightText"));
                this.setBackground(UIManager.getColor("textHighlight"));
            }
            this.setText(this.getText());
        }
    }
}

