/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ens.test;

import com.iplanet.ens.test.EnsRigException;
import java.util.StringTokenizer;

public class EnsRigCommand {
    static final int LOGIN = 1;
    static final int SUBSCRIBE = 2;
    static final int UNSUBSCRIBE = 3;
    static final int PUBLISH = 4;
    static final int LOGOUT = 5;
    static final int EXIT = 6;
    static final int HELP = 7;
    static final int SUBSCRIBE_R = 8;
    static final int PUBLISH_R = 9;
    public int type;
    public String sid;
    public String rid;
    public String eventRef;
    public String payload;
    public String renlId;

    static EnsRigCommand parse(String string) throws EnsRigException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        EnsRigCommand ensRigCommand = new EnsRigCommand();
        try {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("logi")) {
                ensRigCommand.type = 1;
            } else if (string2.startsWith("logo")) {
                ensRigCommand.type = 5;
            } else if (string2.startsWith("subs")) {
                ensRigCommand.type = 2;
            } else if (string2.startsWith("rsub")) {
                ensRigCommand.type = 8;
            } else if (string2.startsWith("ntfy") || string2.startsWith("publ")) {
                ensRigCommand.type = 4;
            } else if (string2.startsWith("unsu")) {
                ensRigCommand.type = 3;
            } else {
                if (string2.startsWith("help")) {
                    ensRigCommand.type = 7;
                    return ensRigCommand;
                }
                if (string2.equals("exit")) {
                    ensRigCommand.type = 6;
                    return ensRigCommand;
                }
                throw new EnsRigException("unrecognized command name : " + string2);
            }
            ensRigCommand.sid = stringTokenizer.nextToken();
            if (ensRigCommand.type == 1 || ensRigCommand.type == 5) {
                return ensRigCommand;
            }
            ensRigCommand.rid = stringTokenizer.nextToken();
            ensRigCommand.eventRef = stringTokenizer.nextToken();
            if (ensRigCommand.type == 2 || ensRigCommand.type == 3) {
                return ensRigCommand;
            }
            if (ensRigCommand.type == 8) {
                ensRigCommand.renlId = stringTokenizer.nextToken();
            } else {
                ensRigCommand.payload = stringTokenizer.nextToken("&*#@@#W#&*^#");
            }
            return ensRigCommand;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EnsRigException("invalid command line : " + string);
        }
    }
}

