
/*
 * Event Notification Client API 
 */

#ifndef _INCLUDED_pasdisp
#define _INCLUDED_pasdisp

#ifdef _WIN32
#define __export __declspec(dllexport)
#else /* #ifdef _WIN32 */
#define __export
#endif /* #ifdef _WIN32 */

#ifdef __cplusplus
extern "C" {
#endif

/**
 * pas_dispatcher_t : Publish and subscribe dispatcher
 *
 * Unless a synchronous publisher is used, the library needs 
 * borrow threads form a thread pool in order to invoke callbacks
 * 
 * The application can either choose to create its own thread
 * pool and pass it to the library, provided that it knows how 
 * to use it.  Or it can let the library create and manage its
 * own thread pool.  In either case, the library creates and
 * uses a dispatcher object materializing the dispatcher used
 * (pas_dispatcher_t).
 */
typedef struct pas_dispatcher_struct pas_dispatcher_t;

/**
 * create or advertize dispatcher.
 *
 * @param	dispcx	dispatcher context.  If NULL the application 
 *			will have to call pas_dispatch in order to start
 *			dispatching notifications.
 *			If not NULL, the dispatcher is assumed to be a 
 *			libasync dispatcher
 *
 * @return	dispatcher to use when creating publisher or subscriber
 *
 * Note: GDisp (libasync) is currently the only dispatcher supported.  In 
 * the future, there will be a more generic interface allowing applications
 * to make the library use their thread dispatcher format.
 */ 
__export pas_dispatcher_t *pas_dispatcher_new(void *disp);
    
/**
 * destroys a dispatcher created with pas_dispatcher_new.
 *
 * @param	disp	EN client enviroment
 */
__export void pas_dispatcher_delete(pas_dispatcher_t *disp);

/**
 * start a dispatch loop.  This call does nothing if the application
 * chooses to have the library use the application's own thread pool.
 * In that case, 
 *
 * @param	disp	dispatcher
 */
__export void pas_dispatch(pas_dispatcher_t *disp);

/**
 * stops the dispatch loop of an EN client enviroment, started with 
 * pas_dispatch.  No effect if an application-provided dispatcher
 * was passed to pas_new
 *
 * @param	disp	dispatcher
 */
__export void pas_shutdown(pas_dispatcher_t *disp);


#ifdef __cplusplus
}
#endif

#endif /* _INCLUDED_pasdisp */

