/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.page;

import com.netscape.page.Debug;
import com.netscape.page.DeserializationException;
import com.netscape.page.TokenGenerator;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;

public class Deserializer
extends FilterInputStream {
    private TokenGenerator tokenGenerator;

    public static Object readObject(InputStream inputStream) {
        Object object;
        try {
            Deserializer deserializer = new Deserializer(inputStream);
            object = deserializer.readObject();
        }
        catch (IOException iOException) {
            object = null;
        }
        catch (DeserializationException deserializationException) {
            Debug.println("" + deserializationException);
            object = null;
        }
        return object;
    }

    public Deserializer(InputStream inputStream) {
        super(inputStream);
        this.tokenGenerator = new TokenGenerator(inputStream);
    }

    public static Object deserializeObject(String string) {
        if (string == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return Deserializer.readObject(byteArrayInputStream);
    }

    public Object readObject() throws IOException, DeserializationException {
        Object object = this.readObjectInternal();
        return object;
    }

    private final Object readObjectInternal() throws IOException, DeserializationException {
        if (!this.tokenGenerator.hasMoreTokens()) {
            return null;
        }
        int n = this.tokenGenerator.nextToken();
        switch (n) {
            case 1: {
                return this.stringForToken();
            }
            case 2: {
                Object[] objectArray = this.readArray();
                return objectArray;
            }
            case 4: {
                return this.readVector();
            }
            case 6: {
                Hashtable hashtable = this.readHashtable();
                return hashtable;
            }
        }
        this.syntaxError();
        return null;
    }

    private final void readKeyValuePair(Hashtable hashtable) throws IOException, DeserializationException {
        Object object;
        int n;
        Object object2 = this.readObjectInternal();
        if (object2 == null) {
            this.unterminatedExpression();
        }
        if (!this.tokenGenerator.hasMoreTokens()) {
            this.unterminatedExpression();
        }
        if ((n = this.tokenGenerator.nextToken()) != 7) {
            this.syntaxError();
        }
        if (!this.tokenGenerator.hasMoreTokens()) {
            this.unterminatedExpression();
        }
        if ((object = this.readObjectInternal()) == null) {
            this.unterminatedExpression();
        }
        hashtable.put(object2, object);
        if (!this.tokenGenerator.hasMoreTokens()) {
            this.unterminatedExpression();
        }
        if ((n = this.tokenGenerator.peekNextToken()) == 8 || n == 10) {
            this.tokenGenerator.nextToken();
        }
    }

    private final Hashtable readHashtable() throws IOException, DeserializationException {
        Hashtable hashtable = new Hashtable();
        while (true) {
            int n;
            if (!this.tokenGenerator.hasMoreTokens()) {
                this.unterminatedExpression();
            }
            if ((n = this.tokenGenerator.peekNextToken()) == 9) {
                this.tokenGenerator.nextToken();
                return hashtable;
            }
            this.readKeyValuePair(hashtable);
        }
    }

    private final Vector readVector() throws IOException, DeserializationException {
        Vector<Object> vector = new Vector<Object>();
        boolean bl = false;
        while (true) {
            Object object;
            int n;
            if (!this.tokenGenerator.hasMoreTokens()) {
                this.unterminatedExpression();
            }
            if ((n = this.tokenGenerator.peekNextToken()) == 5) {
                this.tokenGenerator.nextToken();
                return vector;
            }
            if (n == 10) {
                this.tokenGenerator.nextToken();
                if (bl) {
                    bl = false;
                } else {
                    this.syntaxError();
                }
            } else if (bl) {
                this.syntaxError();
            }
            if ((object = this.readObjectInternal()) == null) continue;
            vector.addElement(object);
            bl = true;
        }
    }

    private final Object[] readArray() throws IOException, DeserializationException {
        Object[] objectArray = new Object[16];
        int n = 0;
        boolean bl = false;
        while (true) {
            Object object;
            Object[] objectArray2;
            int n2;
            if (!this.tokenGenerator.hasMoreTokens()) {
                this.unterminatedExpression();
            }
            if ((n2 = this.tokenGenerator.peekNextToken()) == 3) {
                this.tokenGenerator.nextToken();
                objectArray2 = new Object[n];
                System.arraycopy(objectArray, 0, objectArray2, 0, n);
                return objectArray2;
            }
            if (n2 == 10) {
                this.tokenGenerator.nextToken();
                if (bl) {
                    bl = false;
                } else {
                    this.syntaxError();
                }
            } else if (bl) {
                this.syntaxError();
            }
            n2 = this.tokenGenerator.peekNextToken();
            if (n2 == 11) {
                this.tokenGenerator.nextToken();
                object = null;
            } else {
                object = this.readObjectInternal();
            }
            objectArray[n++] = object;
            if (n == objectArray.length) {
                objectArray2 = new Object[objectArray.length * 2];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray = objectArray2;
            }
            bl = true;
        }
    }

    private final String stringForToken() throws DeserializationException {
        byte[] byArray = this.tokenGenerator.bytesForLastToken();
        if (byArray == null || byArray.length == 0) {
            this.internalInconsistency("empty string");
        }
        if (byArray[0] == 34) {
            char[] cArray = new char[32];
            int n = 0;
            int n2 = byArray.length - 1;
            for (int i = 1; i < n2; ++i) {
                byte by = byArray[i];
                if (by == 92) {
                    byte by2 = 0;
                    int n3 = 0;
                    if (++i < n2) {
                        by2 = byArray[i];
                    } else {
                        this.malformedString();
                    }
                    switch (by2) {
                        case 34: {
                            n3 = (char)by2;
                            break;
                        }
                        case 116: {
                            n3 = 9;
                            break;
                        }
                        case 110: {
                            n3 = 10;
                            break;
                        }
                        case 114: {
                            n3 = 13;
                            break;
                        }
                        case 92: {
                            n3 = 92;
                            break;
                        }
                        case 117: {
                            byte by3 = 0;
                            byte by4 = 0;
                            byte by5 = 0;
                            byte by6 = 0;
                            if (++i < n2) {
                                by3 = byArray[i];
                            } else {
                                this.malformedString();
                            }
                            if (++i < n2) {
                                by4 = byArray[i];
                            } else {
                                this.malformedString();
                            }
                            if (++i < n2) {
                                by5 = byArray[i];
                            } else {
                                this.malformedString();
                            }
                            if (++i < n2) {
                                by6 = byArray[i];
                            } else {
                                this.malformedString();
                            }
                            if (this.isHexa(by3) && this.isHexa(by4) && this.isHexa(by5) && this.isHexa(by6)) {
                                n3 = (char)(this.asciiToFourBits(by3) << 12 | this.asciiToFourBits(by4) << 8 | this.asciiToFourBits(by5) << 4 | this.asciiToFourBits(by6));
                                break;
                            }
                            this.malformedString();
                            break;
                        }
                        default: {
                            byte by7 = 0;
                            byte by8 = 0;
                            byte by9 = 0;
                            by7 = by2;
                            if (++i < n2) {
                                by8 = byArray[i];
                            } else {
                                --i;
                            }
                            if (++i < n2) {
                                by9 = byArray[i];
                            } else {
                                --i;
                            }
                            if (by7 >= 48 && by7 <= 55 && by8 >= 48 && by8 <= 55 && by9 >= 48 && by9 <= 55) {
                                n3 = (char)(by7 - 48 << 6 | by8 - 48 << 3 | by9 - 48);
                                break;
                            }
                            this.malformedString();
                        }
                    }
                    cArray[n++] = n3;
                    if (n != cArray.length) continue;
                    char[] cArray2 = new char[cArray.length * 2];
                    System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                    cArray = cArray2;
                    continue;
                }
                cArray[n++] = (char)by;
                if (n != cArray.length) continue;
                char[] cArray3 = new char[cArray.length * 2];
                System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
                cArray = cArray3;
            }
            return new String(cArray, 0, n);
        }
        return new String(byArray);
    }

    private final boolean isHexa(byte by) {
        return by >= 48 && by <= 57 || by >= 97 && by <= 102 || by >= 65 && by <= 70;
    }

    private final byte asciiToFourBits(byte by) {
        if (by >= 48 && by <= 57) {
            return (byte)(by - 48);
        }
        if (by >= 97 && by <= 102) {
            return (byte)(by - 97 + 10);
        }
        return (byte)(by - 65 + 10);
    }

    private void malformedString() throws DeserializationException {
        int n = this.tokenGenerator.lineForLastToken();
        throw new DeserializationException("Malformed string at line " + n + ":" + new String(this.tokenGenerator.bytesForLastToken()), n);
    }

    private void syntaxError() throws DeserializationException {
        int n = this.tokenGenerator.lineForLastToken();
        throw new DeserializationException("Syntax error at line " + n, n);
    }

    private void internalInconsistency(String string) throws DeserializationException {
        int n = this.tokenGenerator.lineForLastToken();
        throw new DeserializationException("Internal inconsistency exception. Please report this problem. " + string + " " + n, n);
    }

    private void unterminatedExpression() throws DeserializationException {
        int n = this.tokenGenerator.lineForLastToken();
        throw new DeserializationException("Unterminated expression at line " + n, n);
    }
}

