/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.msgserv;

import com.netscape.management.client.Framework;
import com.netscape.management.msgserv.MsgPageControl;
import com.netscape.management.msgserv.MsgResource;
import com.netscape.management.msgserv.util.Debug;
import com.netscape.management.msgserv.util.HashTableModel;
import com.netscape.management.msgserv.util.MsgUtil;
import com.netscape.management.msgserv.util.ReadFileTask;
import com.netscape.management.msgserv.util.ServerErrorException;
import com.netscape.page.AbstractCtrl;
import com.netscape.page.AbstractEditor;
import com.netscape.page.BUTTONeditor;
import com.netscape.page.CtrlModifiedEvent;
import com.netscape.page.Deserializer;
import com.netscape.page.LABELeditor;
import com.netscape.page.ModelModifiedEvent;
import com.netscape.page.PageModel;
import com.netscape.page.PageUI;
import com.netscape.page.PageUtil;
import com.netscape.page.PropDialog;
import com.netscape.page.TABLEeditor;
import com.netscape.page.TEXTAREAeditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class LogfileListControl
extends MsgPageControl {
    static final int PAGE_SIZE = 40;
    TABLEeditor _tableCtrl;
    JTable _table;
    PageModel _currentModel;
    MsgResource _node;
    LogListModel _tableModel;
    Framework _framework;
    int _currentSelection;
    static String[] key = new String[]{"name", "filetype", "size", "modtime", "linecount"};

    public final void init(PageUI pageUI) {
        super.init(pageUI);
        this._tableCtrl = (TABLEeditor)pageUI.getCtrlByName("logfiletable");
        Object[] objectArray = this._tableCtrl.getComponents();
        Component component = (Component)objectArray[0];
        this._table = (JTable)component;
        ListSelectionModel listSelectionModel = this._table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectListener());
    }

    public final void modelModified(ModelModifiedEvent modelModifiedEvent) {
        String string;
        if (this._framework == null) {
            this._framework = MsgUtil.getFramework(this.getPageUI());
        }
        if ("list".equals(string = modelModifiedEvent.getBlockID())) {
            this._currentModel = modelModifiedEvent.getModel();
            Object object = this._currentModel.getClientData();
            if (object instanceof MsgResource && !this._tableCtrl.isModified()) {
                this._node = (MsgResource)object;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this._node.getConfigURL());
                stringBuffer.append("?cmd=listfiles&object=");
                stringBuffer.append(this._node.getFullName());
                String string2 = stringBuffer.toString();
                if (this._framework != null) {
                    this._framework.changeStatusItemState("StatusItemText", (Object)MsgUtil.getReadDataString());
                }
                try {
                    Hashtable hashtable = MsgUtil.sendQuery(string2);
                    Object[] objectArray = (Object[])hashtable.get("files");
                    Vector<Object> vector = new Vector<Object>();
                    String string3 = "";
                    int n = -1;
                    if (objectArray != null) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            String string4 = (String)((Hashtable)objectArray[i]).get("modtime");
                            if (string3.compareTo(string4) < 0) {
                                string3 = string4;
                                n = i;
                            }
                            ((Hashtable)objectArray[i]).put(key[3], PageUtil.internalToLocale(string4));
                            vector.addElement(objectArray[i]);
                        }
                    }
                    this._tableModel = new LogListModel(vector);
                    if (this._table != null) {
                        this._table.setModel(this._tableModel);
                    }
                    if (n >= 0) {
                        this._table.setRowSelectionInterval(n, n);
                    }
                }
                catch (ServerErrorException serverErrorException) {
                    Debug.println("LogfileListControl: error listing log files");
                }
                if (this._framework != null) {
                    this._framework.changeStatusItemState("StatusItemText", (Object)"");
                }
            }
        }
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (".table.edit".equals(string)) {
            PageUI pageUI = this.getPageUI();
            Frame frame = PageUtil.getRootFrame(pageUI);
            if (frame != null) {
                frame.setCursor(new Cursor(3));
            }
            PageModel pageModel = pageUI.getPageModel();
            Hashtable hashtable = pageModel.getUITable();
            Hashtable hashtable2 = (Hashtable)hashtable.get("viewer:file");
            PageUI pageUI2 = new PageUI(hashtable2);
            hashtable2 = (Hashtable)hashtable.get("filter:file");
            PageUI pageUI3 = new PageUI(hashtable2);
            ContentModel contentModel = new ContentModel((String)this._tableModel.getValueAt(this._currentSelection, 0), (String)this._tableModel.getValueAt(this._currentSelection, 1));
            TABLEeditor tABLEeditor = (TABLEeditor)pageUI2.getCtrlByName("contenttable");
            Object[] objectArray = tABLEeditor.getComponents();
            Component component = (Component)objectArray[0];
            JTable jTable = (JTable)component;
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            TEXTAREAeditor tEXTAREAeditor = (TEXTAREAeditor)pageUI2.getCtrlByName("detailtext");
            JTextArea jTextArea = (JTextArea)tEXTAREAeditor.getComponents()[0];
            jTextArea.setLineWrap(true);
            ContentSelectListener contentSelectListener = new ContentSelectListener(jTable, jTextArea, contentModel);
            listSelectionModel.addListSelectionListener(contentSelectListener);
            contentModel.addTableModelListener(contentSelectListener);
            Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
            hashtable3.put(".filter.value", "");
            ViewerModel viewerModel = new ViewerModel(hashtable3);
            LogViewerControl logViewerControl = new LogViewerControl(pageUI3, pageUI2, viewerModel, contentModel);
            pageUI2.setPageModel(viewerModel);
            pageUI2.addIPageUIListener(logViewerControl);
            pageUI2.initAll();
            pageUI3.setPageModel(viewerModel);
            pageUI3.addIPageUIListener(logViewerControl);
            pageUI3.initAll();
            String string2 = (String)pageUI2.getLayoutAttr(".viewerheader.text");
            string2 = string2 + " [" + (String)this._tableModel.getValueAt(this._currentSelection, 0) + "]";
            if (logViewerControl._viewerCModel.isExceptionOccured) {
                return;
            }
            JDialog jDialog = new JDialog(PageUtil.getRootFrame(pageUI2), string2, true);
            jDialog.getContentPane().setLayout(new BorderLayout());
            ((JComponent)jDialog.getContentPane()).setBorder(PageUtil.windowInsets());
            contentModel.setDisplayDialog(jDialog);
            jDialog.getContentPane().add((Component)pageUI3, "North");
            jDialog.getContentPane().add((Component)pageUI2, "Center");
            jDialog.pack();
            PageUtil.placeWindow(pageUI, jDialog);
            jDialog.show();
            if (frame != null) {
                frame.setCursor(new Cursor(0));
            }
        } else if (".page.init".equals(string)) {
            PageUI pageUI = (PageUI)actionEvent.getSource();
            String string3 = (String)pageUI.getLayoutAttr(".header.text");
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    class ContentModel
    extends AbstractTableModel {
        String _fileName;
        String _fileType;
        int _rc;
        boolean isExceptionOccured;
        Vector _pageV;
        String _filter = "";
        JDialog _dialog;
        LogPage _currentPage;
        int _currentPageN;

        public ContentModel(String string, String string2) {
            this._fileName = string;
            this._fileType = string2;
            this.clear();
        }

        public void clear() {
            this._rc = -1;
            this.isExceptionOccured = false;
            this._pageV = new Vector();
            this.fireTableDataChanged();
        }

        public void setFilter(String string) {
            this._filter = !PageUtil.emptyString(string) ? URLEncoder.encode(string) : "";
        }

        void setDisplayDialog(JDialog jDialog) {
            this._dialog = jDialog;
        }

        JDialog getDisplayDialog() {
            return this._dialog;
        }

        public String getColumnName(int n) {
            return " ";
        }

        void setRowCount(int n) {
            this._rc = n;
        }

        public int getRowCount() {
            if (this._rc == -1) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(LogfileListControl.this._node.getConfigURL());
                stringBuffer.append("?cmd=countlines&object=");
                stringBuffer.append(LogfileListControl.this._node.getFullName());
                stringBuffer.append("&filename=");
                stringBuffer.append(this._fileName);
                stringBuffer.append("&filetype=");
                stringBuffer.append(this._fileType);
                if (!PageUtil.emptyString(this._filter)) {
                    stringBuffer.append("&filter=");
                    stringBuffer.append(this._filter);
                }
                String string = stringBuffer.toString();
                try {
                    this._rc = -2;
                    Hashtable hashtable = MsgUtil.sendQuery(string);
                    String string2 = (String)hashtable.get("count");
                    if (!PageUtil.emptyString(string2)) {
                        this._rc = Integer.parseInt(string2);
                        for (int i = 0; i < this._rc / 40 + 1; ++i) {
                            this._pageV.addElement(null);
                        }
                    }
                }
                catch (ServerErrorException serverErrorException) {
                    this.isExceptionOccured = true;
                    Debug.println("LogfileListControl: error getting line count");
                }
            }
            return this._rc;
        }

        public int getColumnCount() {
            return 1;
        }

        void pageArrived(int n) {
            int n2 = n * 40;
            this.fireTableRowsUpdated(n2, n2 + 40);
        }

        public Object getValueAt(int n, int n2) {
            this._currentPageN = n / 40;
            int n3 = n % 40;
            if (this._currentPageN >= this._pageV.size()) {
                this._currentPageN = this._pageV.size() - 1;
            }
            if (this._currentPageN >= 0) {
                this._currentPage = (LogPage)this._pageV.elementAt(this._currentPageN);
                if (this._currentPage == null) {
                    this._pageV.setElementAt(new LogPage(this, this._currentPageN), this._currentPageN);
                    return "";
                }
                return this._currentPage.getLineAt(n3);
            }
            return "";
        }

        void invalidatePage(LogPage logPage) {
            int n = this._pageV.indexOf(logPage);
            if (n >= 0) {
                this._pageV.setElementAt(null, n);
            }
        }

        class LogPage {
            ContentModel _cm;
            Vector _content;
            int _pageN;

            LogPage(ContentModel contentModel2, int n) {
                this._cm = contentModel2;
                this._content = null;
                this._pageN = n;
                new Thread(new Helper()).start();
            }

            String getLineAt(int n) {
                if (this._content != null) {
                    return (String)this._content.elementAt(n + 2);
                }
                return null;
            }

            class Helper
            implements Runnable {
                Helper() {
                }

                public void run() {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(((ContentModel)((LogPage)LogPage.this).ContentModel.this).LogfileListControl.this._node.getConfigURL());
                    stringBuffer.append("?cmd=read&object=");
                    stringBuffer.append(((ContentModel)((LogPage)LogPage.this).ContentModel.this).LogfileListControl.this._node.getFullName());
                    stringBuffer.append("&filename=");
                    stringBuffer.append(((LogPage)LogPage.this).ContentModel.this._fileName);
                    stringBuffer.append("&filetype=");
                    stringBuffer.append(((LogPage)LogPage.this).ContentModel.this._fileType);
                    stringBuffer.append("&start=");
                    stringBuffer.append(String.valueOf(LogPage.this._pageN * 40 + 1));
                    stringBuffer.append("&count=");
                    stringBuffer.append(String.valueOf(40));
                    if (!PageUtil.emptyString(((LogPage)LogPage.this).ContentModel.this._filter)) {
                        stringBuffer.append("&filter=");
                        stringBuffer.append(((LogPage)LogPage.this).ContentModel.this._filter);
                    }
                    String string = stringBuffer.toString();
                    ReadFileTask readFileTask = null;
                    Vector vector = null;
                    try {
                        readFileTask = new ReadFileTask(new URL(string), MsgUtil.getAuthID(), MsgUtil.getAuthPasswd());
                        if (readFileTask != null) {
                            readFileTask.exec();
                            vector = readFileTask.getResults();
                        }
                        if (vector != null && vector.size() > 0) {
                            String string2;
                            String string3 = (String)vector.elementAt(0);
                            Hashtable hashtable = (Hashtable)Deserializer.deserializeObject(string3);
                            if (hashtable != null && (string2 = (String)hashtable.get("status")) != null && string2.startsWith("OK")) {
                                LogPage.this._content = vector;
                            }
                            ContentModel.this.pageArrived(LogPage.this._pageN);
                        } else {
                            ContentModel.this.invalidatePage(LogPage.this);
                        }
                    }
                    catch (Exception exception) {
                        LogPage.this._content = null;
                        JDialog jDialog = LogPage.this._cm.getDisplayDialog();
                        Window window = PageUtil.getTopLevelWindow(jDialog);
                        window.setVisible(false);
                        window.dispose();
                        JOptionPane.showMessageDialog(PageUtil.getRootFrame(LogfileListControl.this.getPageUI()), MsgUtil.getString("error", "readlog"), MsgUtil.getString("error", "title"), 0);
                        Debug.println("LogfileListControl: error reading log");
                    }
                }
            }
        }
    }

    class ContentSelectListener
    implements ListSelectionListener,
    TableModelListener {
        JTable table;
        JTextArea textarea;
        ContentModel contentModel;

        ContentSelectListener(JTable jTable, JTextArea jTextArea, ContentModel contentModel) {
            this.table = jTable;
            this.textarea = jTextArea;
            this.contentModel = contentModel;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.updateDetail();
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateDetail();
        }

        final void updateDetail() {
            int n = this.table.getSelectedRow();
            if (n < 0) {
                return;
            }
            int n2 = this.contentModel.getRowCount();
            if (n2 == 0) {
                return;
            }
            this.textarea.setText((String)this.contentModel.getValueAt(n, 0));
            this.textarea.repaint();
        }
    }

    class SelectListener
    implements ListSelectionListener {
        SelectListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                LogfileListControl.this._currentSelection = LogfileListControl.this._table.getSelectedRow();
                if (LogfileListControl.this._currentSelection < 0) {
                    return;
                }
                int n = LogfileListControl.this._tableModel.getRowCount();
                if (n == 0) {
                    return;
                }
                PageUI pageUI = LogfileListControl.this.getPageUI();
                Hashtable hashtable = pageUI.getLayoutAttrs();
                if (hashtable != null) {
                    hashtable.put(".filetype.value", LogfileListControl.this._tableModel.getValueAt(LogfileListControl.this._currentSelection, 1));
                    hashtable.put(".size.value", LogfileListControl.this._tableModel.getValueAt(LogfileListControl.this._currentSelection, 2));
                    hashtable.put(".modtime.value", LogfileListControl.this._tableModel.getValueAt(LogfileListControl.this._currentSelection, 3));
                }
                pageUI.initAll();
            }
        }
    }

    class LogListModel
    extends HashTableModel {
        public int getColumnCount() {
            return 1;
        }

        public LogListModel(Vector vector) {
            super(vector);
            this.setVarNames(key);
            this.setColumnNames(key);
        }
    }

    class LogViewerControl
    extends MsgPageControl {
        PageUI _filterUI;
        PageUI _viewerUI;
        ViewerModel _viewerPModel;
        ContentModel _viewerCModel;
        TABLEeditor _contentTable;
        JTable _viewer;
        LABELeditor _numlines;
        AbstractEditor _goto;
        AbstractEditor _regex;
        AbstractEditor _facility;
        AbstractEditor _level;
        AbstractEditor _absflag;
        AbstractEditor _pastflag;
        AbstractEditor _absfrom;
        AbstractEditor _absto;
        AbstractEditor _past;
        int _gotoLine = -1;

        public LogViewerControl(PageUI pageUI, PageUI pageUI2, ViewerModel viewerModel, ContentModel contentModel) {
            this._filterUI = pageUI;
            this._viewerUI = pageUI2;
            this._viewerPModel = viewerModel;
            this._viewerCModel = contentModel;
            this._viewerPModel.setLogViewerControl(this);
            this._contentTable = (TABLEeditor)this._viewerUI.getCtrlByName("contenttable");
            this._contentTable.setModel(this._viewerCModel);
            Object[] objectArray = this._contentTable.getComponents();
            Component component = (Component)objectArray[0];
            this._viewer = (JTable)component;
            this.showLine(-1);
            this._facility = (AbstractEditor)this._filterUI.getCtrlByName("facilityctrl");
            this._level = (AbstractEditor)this._filterUI.getCtrlByName("levelctrl");
            this._regex = (AbstractEditor)this._filterUI.getCtrlByName("regexctrl");
            this._absflag = (AbstractEditor)this._filterUI.getCtrlByName("absflag");
            this._pastflag = (AbstractEditor)this._filterUI.getCtrlByName("pastflag");
            this._absfrom = (AbstractEditor)this._filterUI.getCtrlByName("absfromctrl");
            this._absto = (AbstractEditor)this._filterUI.getCtrlByName("abstoctrl");
            this._past = (AbstractEditor)this._filterUI.getCtrlByName("pastctrl");
            this._goto = (AbstractEditor)this._viewerUI.getCtrlByName("goto");
            this._numlines = (LABELeditor)this._viewerUI.getCtrlByName("numlineslabel");
        }

        private final void update() {
            Object object;
            Boolean bl = (Boolean)this._absflag.getValue();
            if (bl.booleanValue()) {
                object = (String)this._absfrom.getValue();
                String string = (String)this._absto.getValue();
                if (((String)object).indexOf("Z") != -1) {
                    object = ((String)object).substring(0, ((String)object).indexOf(90) - 1);
                }
                if (string.indexOf("Z") != -1) {
                    string = string.substring(0, string.indexOf(90) - 1);
                }
                float f = new Float((String)object).floatValue();
                float f2 = new Float(string).floatValue();
                if (f2 < f) {
                    JOptionPane.showMessageDialog(PageUtil.getRootFrame(this._filterUI), MsgUtil.getString("error", "timeinterval"), MsgUtil.getString("error", "title"), 0);
                    return;
                }
            }
            this._viewerCModel.setFilter(this.constructFilter());
            this._viewerCModel.clear();
            object = (JTable)this._contentTable.getComponents()[0];
            ((JTable)object).tableChanged(null);
        }

        private final void showLine(int n) {
            if (this._viewer != null) {
                int n2;
                int n3 = n;
                if (n < 0 && (n2 = this._viewerCModel.getRowCount() - 1) >= 0) {
                    n3 = n2;
                }
                if (n3 > 0 || n3 == 0) {
                    this._viewer.setRowSelectionInterval(n3, n3);
                    this._viewer.scrollRectToVisible(this._viewer.getCellRect(n3, 0, true));
                }
            }
        }

        public void ctrlModified(CtrlModifiedEvent ctrlModifiedEvent) {
            AbstractCtrl abstractCtrl = ctrlModifiedEvent.getCtrl();
            if (abstractCtrl == this._absflag) {
                if (((Boolean)this._absflag.getValue()).booleanValue() && ((Boolean)this._pastflag.getValue()).booleanValue()) {
                    this._pastflag.setValue(new Boolean(false));
                }
            } else if (abstractCtrl == this._pastflag && ((Boolean)this._pastflag.getValue()).booleanValue() && ((Boolean)this._absflag.getValue()).booleanValue()) {
                this._absflag.setValue(new Boolean(false));
            }
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (".log.update".equals(string)) {
                this.update();
                this.showLine(this._gotoLine);
                if (this._viewerCModel.isExceptionOccured) {
                    Component component = (Component)((BUTTONeditor)actionEvent.getSource()).getComponents()[0];
                    Window window = PageUtil.getTopLevelWindow(component);
                    window.setVisible(false);
                    window.dispose();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {}
                }
            } else if (".log.filter".equals(string)) {
                String string2 = (String)this._filterUI.getLayoutAttr(".filterheader.text");
                PropDialog propDialog = new PropDialog(PageUtil.getRootFrame(this.getPageUI()), this._filterUI, this._viewerPModel);
                propDialog.setTitle(string2);
                propDialog.pack();
                PageUtil.placeWindow(propDialog);
                propDialog.show();
            } else if (".log.goto".equals(string)) {
                try {
                    this._gotoLine = new Integer((String)this._goto.getValue());
                    this.showLine(this._gotoLine);
                }
                catch (Exception exception) {}
            } else if (".log.done".equals(string)) {
                Component component = (Component)((BUTTONeditor)actionEvent.getSource()).getComponents()[0];
                Window window = PageUtil.getTopLevelWindow(component);
                window.setVisible(false);
                window.dispose();
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
            } else if (".log.help".equals(string)) {
                MsgUtil.help(this._filterUI.getHelpToken());
            }
        }

        String constructFilter() {
            Boolean bl;
            StringBuffer stringBuffer = new StringBuffer();
            String string = (String)this._facility.getValue();
            if (!PageUtil.emptyString(string)) {
                stringBuffer.append("(FACILITY STR_EQ ");
                stringBuffer.append(string);
                stringBuffer.append(")");
            }
            if (!PageUtil.emptyString(string = (String)this._level.getValue())) {
                stringBuffer.append("(LEVEL STR_SUBSTR ");
                stringBuffer.append(string);
                stringBuffer.append(")");
            }
            if (!PageUtil.emptyString(string = (String)this._regex.getValue())) {
                if (!string.startsWith("*")) {
                    string = "*" + string;
                }
                if (!string.endsWith("*")) {
                    string = string + "*";
                }
                stringBuffer.append("(TEXT STR_REGEX ");
                stringBuffer.append(string);
                stringBuffer.append(")");
            }
            if ((bl = (Boolean)this._absflag.getValue()).booleanValue()) {
                string = (String)this._absfrom.getValue();
                String string2 = (String)this._absto.getValue();
                if (!PageUtil.emptyString(string) && !PageUtil.emptyString(string2)) {
                    this._absfrom.setValue(string);
                    this._absto.setValue(string2);
                    stringBuffer.append("(DATE GE ");
                    stringBuffer.append(string);
                    stringBuffer.append(")(DATE LE ");
                    stringBuffer.append(string2);
                    stringBuffer.append(")");
                }
            }
            if ((bl = (Boolean)this._pastflag.getValue()).booleanValue()) {
                string = (String)this._past.getValue();
                if (PageUtil.emptyString(string)) {
                    string = "360";
                    this._past.setValue(string);
                }
                stringBuffer.append("(-DATE GE 00/00/");
                stringBuffer.append(string);
                stringBuffer.append(" 0:0:0");
                stringBuffer.append(")");
            }
            if (!PageUtil.emptyString(string = stringBuffer.toString())) {
                return "(" + string + ")";
            }
            return "";
        }
    }

    class ViewerModel
    extends PageModel {
        LogViewerControl _lvc;

        public ViewerModel(Hashtable hashtable) {
            super(hashtable);
        }

        public void setLogViewerControl(LogViewerControl logViewerControl) {
            this._lvc = logViewerControl;
        }

        public Object[] saveAttributes() {
            if (this._lvc != null) {
                this._lvc.update();
            }
            return null;
        }
    }
}

