/*      focal ... the text control that last had focus
 *  focalLock ... a text control which is blocking other elments from request-
 *                ing focus - usually after bad data has been entered and the
 *                the element must be refocused. A focal element is so locked 
 *                only while the element is being validated.
 */
var focal, focalLock;

/* checkValue() calls the validating function associated with a specific form 
 * element (fe). The validating function is required to ensure that the data is
 * properly formed by the user and correctly changed in the current object. It
 * can return a non-empty string when data is not properly formed, which will
 * displayed to the user in the form of an alert. If the q argument is present
 * and true, the error string will not be alerted.
 */
function checkValue(fe, q) {
  var f = eval('window.' + fe.name + 'Check');
  var err;


if(fe.name=="givenname")
 if(fe.value==current_givenname) return "";
if(fe.name=="sn")
 if(fe.value==current_sn) return "";

  if (f) {
    err = f(fe, q);
    if (err) {
      if (!q) {
        alert(err);
        lockFocal(fe);
      }
    } else
      err = '';
    unlockFocal();
  }
  return err;
}

function unlockFocal() {
  focalLock = null;
}

function lockFocal(fe) {
  focalLock = fe;
  fe.focus();
  if ((IE >= 4 || NN > 0) && (fe.type == 'password' || fe.type == 'text' || fe.type == 'textarea'))
    fe.select();
  fe.onblur = unlockFocal;
}

function requestFocus(fe) {
  if (!fe)
    return false;
  if (focalLock) {
    return false;
  }
  if (!focal || fe.name != focal.name) {
    focal = fe;
    if ((IE >= 4 || NN > 0) && (fe.type == 'password' || fe.type == 'text' || fe.type == 'textarea'))
      focal.select();
  }
  return true;
}

/* IE does not always fire an onChange event for a text control. No onChange 
 * event is fired, for example, if the user clicks on a button (i.e., the OK
 * button) after entering data in a text control. In the iCS HTML UI, data from
 * a text control only makes its way into the current object if the onChange
 * event is fired. forceCheck() makes sure that the value from the last-focused
 * text control makes it into the current object by simulating an onChange
 * event for the focal element. It returns an empty string if the value was 
 * inserted into the object as expected and a non-empty string (i.e., the error
 * message that would have been displayed to the user) if the data from the
 * control was improperly formed. forceCheck() can be used as follows:
 * 
 *     if (forceCheck())
 *       return;
 *      
 * to guarantee that the last-focused text control is properly validated and
 * any changes are correctly made to the current object. If forceCheck() re-
 * turns an empty string, the interpreter will pass over the check and exe-
 * cute the remainder of the ok() or other containing function. Otherwise,
 * checkValue() will alert the user to the malformed data and halt execution.
 */
function forceCheck(force) { return ((IE > 0 || force) && focal ? checkValue(focal) : ''); }

function handleResize() {
  forceCheck(true);

  if(NN >= 4.0 && NN < 5)
  {
    for(i=0; i<window.frames.length; i++)
      reload(window.frames[i])
  }
}

// Do we need to handle NN 3.x?
window.onresize = NN >= 4 ? handleResize : null;
