
#ifndef _INCLUDED_ens_util
#define _INCLUDED_ens_util

#ifdef _WIN32
#define __export __declspec(dllexport)
#else /* #ifdef _WIN32 */
#define __export
#endif /* #ifdef _WIN32 */

#ifdef __cplusplus
extern "C" {
#endif


struct in_addr;
__export char *ens_inet_ntoa(struct in_addr ina, char *psz);


/*
 * logging tools and definitions
 */
#include "nslogger.h"

/* modules */
#define ENSLOG_CLIENT_API      	0x0001
#define ENSLOG_SERVER      	0x0002
#define ENSLOG_UPUB		0x0004
#define ENSLOG_RENL     	0x0008
#define ENSLOG_STORE		0x0010

/* additional NSLOG category */
#define NSLOG_DEBUG_0 100
#define NSLOG_DEBUG_1 101
#define NSLOG_DEBUG_2 102
#define NSLOG_DEBUG_3 103
#define NSLOG_DEBUG_4 104

/* number of modules - keep it up-to-date ! */
#define ENSLOG_MODULES		5

__export void gaplog(unsigned int level,
		     unsigned int module,
		     const char * format, ...);

__export void gaplog_init(unsigned int modules,
			  unsigned int level);



#include "dbgalloc.h"

#ifdef __cplusplus
}
#endif

#endif /* _INCLUDED_ens_util */
