/*       g ... the group object instance
 *     tfr ... a string containing the url or form to transact with the server
 *      un ... universal name - null if this is a new group
 *   state ... {init, group, POST, delete, conflict}
 *     inc ... an array of entry objects included in this group
 *     exc ... an array of entry objects not included in this group
 * members ... an array of entry uns originally included in this group
 *     add ... an array of entry uns to add to this group
 *     rem ... an array of entry uns to remove from this group
 *    dups ... an array of objects with the same cn as g
 */
var g, tfr, un, state = 'init', inc = new Array(), exc = new Array(), members = new Array(), add = new Array(), rem = new Array(), PAB_GRP_ALL = 1, PAB_GRP_UNFILED = 2, curPabGrp = PAB_GRP_ALL, MAXLEN = 128,modifiedvalues;
var PAB_ONLY_GRP = 3
var stateFocal = new Array(2);
stateFocal['group'] = null;
stateFocal['notes'] = null;
stateFocal['conflict'] = null;
var lookupWindow

function P(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10) {
  this.cn = a0
  this.sn = a1
  this.givenname = a2
  this.mail = a3
  this.description = a4
  this.telephonenumber = a5
  this.homephone = a6
  this.memberofpab = a7
  this.memberofpabgroup = a8
  this.un = a9
  this.objectclass = a10
}

function setFrames() {
  tab = window.frames[0];
  data = window.frames[1];
  idx = window.frames[2];
  btn = window.frames[3];
}

function setUp() {
  var s = window.location.search;
  un = getArg('un', s);
  if (un) {
    tfr = main.msgHREF + 'ldap.msc?sid=' + main.sid + '&security=' + main.security + '&ldapurl=pab&filter=' + encode('cmd=PAB_CMD_GET_ENTRY|old=' + main.pabAttrs['un'].name + ':' + un + '\n\n|') + main.get_charset();
  } else {
    g = new Object();
    modifiedvalues = new Object();
    g.cn = i18n_pg['no cn'];
    g.objectclass = 'pabgroup';
    g.memberofpab = main.curPab;
    state = 'group';
    modifiedvalues.cn = 1;
    modifiedvalues.objectclass = 1;
    modifiedvalues.memberofpab  = 1;
    setUpMembers();
  }
}

function setUpMembers() {
  var a = main.pabFrame.people, mog = false;
  // Iterate over the entries array in pabFrame
  for (var i = 0; i < a.length; i++) {
    // If g.un is not null, then g is an old group with possible members.
    // Iterate over the memberofpabgroup array for the current entry.
    for (var j = 0; g.un && j < a[i].memberofpabgroup.length; j++) {
      // This entry is a member of the current group.
      if (a[i].memberofpabgroup[j] == g.un) {
        mog = true;
        inc[inc.length] = a[i];
        inc[inc.length - 1].whereAmI = 'i';
        inc[inc.length - 1].ptr = inc.length - 1;
        members[members.length] = a[i].un;
        break;
      }
    }
    // Add entry to exc array if it is not a member of the current group.
    if (!mog) {
      exc[exc.length] = a[i];
      exc[exc.length - 1].whereAmI = 'e';
      exc[exc.length - 1].ptr = exc.length - 1;
    }
    // Reset mog, if necessary.
    else{
      mog = false;
      exc[exc.length] = a[i];
      exc[exc.length - 1].whereAmI = 'i';
      exc[exc.length - 1].ptr = exc.length - 1;
    }
  }

  a= main.pabFrame.groups;
  for (var i = 0; i < a.length; i++) {
      exc[exc.length] = a[i];
      exc[exc.length - 1].whereAmI = 'e';
      exc[exc.length - 1].ptr = exc.length - 1;
  }
}


function lookup() {

  var s = '?'+main.clientargs()+'&action=forGroups'
  lookupWindow = new Window(main.srcHREF + main.lang + '/lookup_fs.html'+s,
      'lookupWindow' + main.unique++, 'resizable,' +
      (mac ? 'width=540,height=280' : 'width=620,height=370'))
}

function fromLookup(t,what)
{
  var tempMail
  if(isArray(what.mail)) tempMail = what.mail[0]
  else tempMail = what.mail

  for (var i = 0; i < inc.length; i++) {
    if (what.un == inc[i].un)
      return;
  }

  inc[inc.length] =  new P(what.cn,what.sn,what.givenname,new Array(tempMail),'','','',new Array(what.memberofpab),
       new Array(what.memberofpabgroup),what.un,what.objectclass);

  for (var i = 0; i < exc.length; i++) {
    if (inc[inc.length-1].un == exc[i].un) {
      exc[i].whereAmI = 'i';
      inc[inc.length-1].whereAmI = 'i';
      inc[inc.length-1].ptr = exc[i].ptr;
      break;
    }
  }
}

function reloadIdx()
{
  reload(idx);
}


function tabHTML() {
  if (state == 'init')
    return '';
  var s = '<TABLE border=0 cellspacing=0 cellpadding=0 width=100%>' +
    '<TR bgcolor=' + main.chrome0 + '><TD>' + 
    '<TABLE border=0 cellspacing=1 cellpadding=1 width=100%>' +
    '<TR align="center" bgcolor="' + main.chrome1 + '">' +
    (state != 'conflict'
      ?
      main.tab(
        i18n_pg['group members'],
        state == 'group',
        'javascript:parent.displayPanel(\'group\')',
        window.name) +
      main.tab(
        i18n_pg['notes'],
        state == 'notes',
        'javascript:parent.displayPanel(\'notes\')',
        window.name)
      :
      main.tab(
        i18n_pg['conflict'],
        state == 'conflict',
        '',
        window.name)
      ) +
        '<TD>' + main.font() + nbsp + '</FONT></TD></TR></TABLE></TD></TR></TABLE>';

  return main.getBody(main.chrome2, true, false, false, false, main.black) + s;
}

function dataHTML() {
  return main.getBody(main.chrome2, true) + (tfr && state == 'POST' ? tfr : '');
}

function dataInit() {
  if (state == 'POST' && data.form)
    data.form.submit();
}

function idxHTML() {
  if (state == 'init')
    return '';
  if (state == 'group')
    return groupHTML();
  if (state == 'notes')
    return notesHTML();
  if (state == 'conflict') {
     if( !un )
      i18n_pg['conflicttext'] = 'Create a new group.';
     else
      i18n_pg['conflicttext'] = 'Rename the group.';

    return conflictHTML();
  }
}

function groupHTML() {
  var s = '<CENTER><TABLE border=0 cellpadding=3 cellspacing=1 width=100%>';
  // display name
  s += '<TR><TD colspan=3>' + main.font() + i18n_pg['cn'] + '</FONT>' +
    '&nbsp;<INPUT type=text name=cn size=28 maxlength=' + MAXLEN + ' value="' + (g.cn ? html(g.cn) : '') + '" onFocus="parent.requestFocus(this);" onChange="parent.checkValue(this);"></TD></TR>';
  // sep
  s += '<TR><TD colspan=3><hr size=1></TD></TR>';
  s += '<TR><TD colspan=3>' + main.font() + i18n_pg['mini help'] + '</FONT></TD></TR>'
  //s += '<TR><TD colspan=3>' + main.font() + i18n_pg['personal address book entries'] + '</FONT></TD></TR>'
  s += '<TR><TD colspan=2>' + main.font() + i18n_pg['view 2'] + nbsp + emitGroupList() + '</FONT></TD><TD nowrap width=1% nowrap>' + main.font() + i18n_pg['inc'] +':</FONT></TD></TR>';
  //s += '<TR><TD colspan=2 width=1% nowrap>' + main.font() + i18n_pg['exc'].bold() +
   // '</FONT></TD><TD nowrap>' + main.font() + i18n_pg['inc'].bold() + '</FONT></TD></TR>';
  s += '<TR>' + swapEntriesCtrl() + '</TR>';
  
  s += '</TABLE></CENTER>';
  return main.getBody(main.chrome2, true, false, false, false, false, 9, 12) +
    '<FORM name=form action="javascript:parent.noop()">' + s + '</FORM>';
}

function notesHTML() {
  var s = '<CENTER><TABLE border=0 cellpadding=3 cellspacing=1>';
  // notes
  s += '<TR><TD><TEXTAREA name=description cols=50 rows=15 onFocus="parent.requestFocus(this);" onChange="parent.checkValue(this);">' + (g.description ? g.description : '') + '</TEXTAREA></TD></TR>';
  s += '</TABLE></CENTER>';
  return main.getBody(main.chrome2, true, false, false, false, false, 9, 12) +
    '<FORM name=form>' + s + '</FORM>';
}

function swapEntriesCtrl() {
  var s
  var w = NN > 0 ? ' width=115' : '';

 
  s = '<TD valign=top nowrap>' + main.font() + '<SELECT size=11 multiple name=excludes>';
  for (var i = 0; i < exc.length; i++) {
    // If there is no current group, assume ALL
    // If the current group un (stored in curPabGrp) is 1, assume UNFILED
     if (curPabGrp == 1 || curPabGrp == 3 || 
      (curPabGrp == 2 && !exc[i].memberofpabgroup) ||
      ((isNaN(curPabGrp)? true : curPabGrp > 3) && indexOfGroup(exc[i], curPabGrp) > -1))
   
    {
       if(exc[i].objectclass=="pabperson" && curPabGrp != PAB_ONLY_GRP && exc[i].whereAmI == 'e' )
		s += '<OPTION value="' + exc[i].ptr + '">' + main.unescape_crlf(exc[i].cn) + '</OPTION>';
	    else if ( exc[i].objectclass=="pabgroup" && curPabGrp != 2 && exc[i].whereAmI == 'e')
 	  s += '<OPTION value="' + exc[i].ptr + '">' + main.unescape_crlf(exc[i].cn) + '</OPTION>';  // pramod    
    }
        
  }

  s += '<OPTION>' + i18n['scl sep'] + '</OPTION>';
  s += '</SELECT></FONT></TD>';

  s += '<TD width=1% nowrap align="center">'+'<font>'+ main.nbutton('inc', i18n_pg['add'], "parent.incE()") + '<BR><BR>' +
    main.nbutton('exc', i18n_pg['remove'], "parent.excE()") + '<BR><BR><BR>' +
    main.nbutton('search', i18n_pg['search'], "parent.lookup()") + '</FONT></TD>';

  s += '<TD width=1% valign=top nowrap>' + main.font() + '<SELECT size=11 multiple name=includes>';
  for (var i = 0; i < inc.length; i++)
    s += '<OPTION value="' + inc[i].ptr + '">' + main.unescape_crlf(inc[i].cn) + '</OPTION>';
  s += '<OPTION>' + i18n['scl sep'] + '</OPTION>';
  s += '</SELECT></FONT></TD>';

  return s;
}

function indexOfGroup(e, n) {
  if (!e.memberofpabgroup)
    return -1;
  for (var i = 0; i < e.memberofpabgroup.length; i++) {
    if (e.memberofpabgroup[i] == n)
      return i;
  }
  return -1;
}

function emitGroupList() {
  var g = main.pabFrame.groups;
  var s = '<SELECT name=groupSel onChange="if(!this.options[this.selectedIndex].value){for (var i=0;i<this.options.length;i++){if(this.options[i].value==parent.curPabGrp)this.options[i].selected=true;}}else{parent.selExc(this.options[this.selectedIndex].value);}">';

  s += '<OPTION>' + i18n_pg['View'] + '</option><option value="' + PAB_GRP_ALL + '"' + (curPabGrp == PAB_GRP_ALL ? ' selected' : '') + '>' + i18n['list indent'] + i18n_pg['all group'] + '</OPTION>';
  s += '<OPTION value="' + PAB_ONLY_GRP + '"' + (curPabGrp == PAB_ONLY_GRP ? ' selected' : '') + '>' + i18n['list indent'] + i18n_pg['groups only'] + '</option>'
  if (g) {
    for (var i = 0; i < g.length; i++) {
      if(g[i].un != un)
      		s += '<OPTION value="' + g[i].un + '"' + (curPabGrp == g[i].un ? ' selected' : '') + '>' + i18n['list indent'] + main.unescape_crlf(g[i].cn) + '</OPTION>';
    }
  }
  return s + '<OPTION value="' + PAB_GRP_UNFILED + '"' + (curPabGrp == PAB_GRP_UNFILED ? ' selected' : '') + '>' + i18n['list indent'] + i18n_pg['unfiled group'] + '</OPTION></SELECT>';
}

function idxInit() {
  idx.focus();
if(!mac && IE>0){
  if (focal) {
    if (IE > 0)
      focal = idx.form[focal.name];
    focal.focus();
    requestFocus(focal);
  } else if (idx.form && idx.form.elements[0]) {
    idx.form.elements[0].focus();
    requestFocus(idx.form.elements[0]);
  }
}
}

function btnHTML() {
  if (state == 'init')
    return '';
  var s = '<TABLE border=0 cellpadding=2 cellspacing=0 width=100% height=100%><TR bgcolor=' + main.chrome0 + '>';
  var w = NN > 0 ? ' width=72' : '';

  if (un && state != 'conflict')
    s += '<TD height=100%>' + '<font>' + nbsp + nbsp + nbsp +
    main.nbutton('delete', i18n_pg['delete'], "parent.delGroup()") + '</FONT></TD>';
  s += '<TD height=100% align=right>' + '<font>' + nbsp + nbsp + nbsp +
    main.nbutton('ok', (state != 'conflict' ? i18n_pg['ok'] : i18n_pg['continue']), "parent.ok()") + nbsp +
    main.nbutton('esc', i18n_pg['cancel'], "parent.cancel()") + nbsp +
    main.nbutton('help', i18n_pg['help'], "main.help()") +
    nbsp + nbsp + nbsp + '</FONT></TD></TR></TABLE>';
  
  return main.getBody(main.chrome0, true, main.white, false, false, false, 1, 1) +
    '<FORM name=FORM>' + s + '</FORM>';
}

function delGroup() {
  if (delGroupConfirm()) {
    state = 'delete';
    load(data, tfr = main.msgHREF + 'ldap.msc?sid=' + main.sid + '&ldapurl=pab&filter=' +
         encode('cmd=PAB_CMD_DEL_ENTRY|old=' + main.pabAttrs['un'].name + ':' + g.un + '\n' +
         main.pabAttrs['objectclass'].name + ':' + g.objectclass + '\n\n|'));
  }
}

function getDuplicates() {
  var i, a = new Array();
  for (i = 0; i < main.pabFrame.groups.length; i++) {
    if (main.pabFrame.groups[i].cn.toLowerCase() == g.cn.toLowerCase())
      a[a.length] = main.pabFrame.groups[i];
  }
  return a;
}

function quickCheck(fe) {
  /* if (trim(fe.value).length > 0)
    g[fe.name] = fe.value;
  else
    g[fe.name] = ''; */

  trim(fe.value)
  if(fe.value != g[fe.name])
     modifiedvalues[fe.name] = 1
  if (fe.value.length > 0)
    g[fe.name] = fe.value;
  else
    g[fe.name] = '';

}

// Group validation routines
function cnCheck(fe) {
  var s = '';
  // make sure that this thing isn't blank
  if (trim(fe.value).length > 0) {
    if(g[fe.name] != fe.value)
        modifiedvalues[fe.name] = 1
    g[fe.name] = fe.value;
  } else {
    fe.value = g[fe.name];
    s = s_NonBlank(fe.name);
  }
  reload(tab);
  return s;
}

// Notes validation
var descriptionCheck = quickCheck;

function dupCheck(fe) {
  //un = g.un = fe.value;
  // &! IE thinks that focal is non-null when we get here, and I don't know why.
  // When forceCheck() fires in ok() it checks the value of focal, which in the
  // case of a conflict is empty, and so sets un to empty even when it contains
  // a value. This forces IE to behave and provide the correct value for e.un.
  focal = null;
}

function isInc(n) {
  for (var i = 0; i < inc.length; i++) {
    if (n == inc[i].ptr)
      return i;
  }
  return -1;
}

function isExc(n) {
  for (var i = 0; i < exc.length; i++) {
    if (n == exc[i].un)
      return i;
  }
  return -1;
}

function isMember(n) {
  for (var i = 0; i < members.length; i++) {
    if (n == members[i])
      return i;
  }
  return -1;
}

function sortByName(a, b) {
  var s1 = a.cn.toLowerCase();
  var s2 = b.cn.toLowerCase();

  if (s1 < s2)
    return -1;
  else if (s1 > s2)
    return 1;
  return 0;
}

function incE() {
  var i, j, e = idx.form.excludes.options;
  var a,g,k;

  for (i = 0; i < e.length; i++) {
   var sel = parseInt(e[i].value,10); 
    if (e[i].selected && e[i].value) {
      if(  exc[sel].un == un ) {
       alert(i18n_pg['no self add']);
       return;
      }
      if (exc[sel].whereAmI != 'i') {
        exc[sel].whereAmI = 'i';
        inc[inc.length] = exc[sel];
      }
    }
  }
  
  reload(idx);
}

function excE() {
  var i, j, e = idx.form.includes.options;

  for (i = 0; i < e.length; i++) {
    if (e[i].selected && e[i].value) {
      if((j = isInc(parseInt(e[i].value,10))) != -1) {
        if( isExc(inc[j].un) == -1 ) {
          exc[exc.length] = inc[j];
          exc[exc.length - 1].whereAmI = 'e';
          exc[exc.length - 1].ptr = exc.length - 1;
        }
        else
          exc[inc[j].ptr].whereAmI = 'e';
        inc[j] = '';
      }
    }
  }

  inc = compressArray(inc);
  reload(idx);
}

function selExc(g) {
  curPabGrp = g;
  reload(idx);
}

function displayPanel(s) {
  if (forceCheck())
    return;
  stateFocal[state] = focal;
  state = s;
  focal = stateFocal[state];
  // requestFocus(stateFocal[state]);
  reload(idx);
  reload(tab);
}

function ok() {
  if (forceCheck())
    return;
  if ( state != 'conflict') {
    dups = getDuplicates();
    if ((!un && dups.length) || (un && modifiedvalues.cn && dups.length)) {
      alert(i18n_pg['group exists']);
      return;
    }
  }
  var i,j,k;
  var a = main.pabFrame.people;
  var mg

  // Set up members array if conflict occurs
  if ( state == 'conflict' && g) 
    setUpMembers();
  
  // Walk the include array. If an entry's un is not in the original members
  // array, and is not the group itself, then place the un in the add array.
  for (i = 0; i < inc.length; i++) {

	if(inc[i].objectclass=="pabgroup") {
		mg = inc[i]
		for (var j = 0; j < a.length; j++) {
			for (var k = 0; mg.un && k < a[j].memberofpabgroup.length; k++) {
				if (a[j].memberofpabgroup[k] == mg.un) {
					if (isMember(a[j].un) == -1) add[add.length] = a[j].un;
					break;
				}
			}
		}
	}
	else {
	    if (isMember(inc[i].un) == -1 && inc[i].un != g.un)
		  add[add.length] = inc[i].un;
	}
  }    



  // Walk the exclude array. If an entry's un is part of the original members
  // array, and is not the group itself, then place the un in the rem array.
  for (i = 0; i < exc.length; i++) {
    if (exc[i].whereAmI == 'e' && isMember(exc[i].un) != -1 && exc[i].un != g.un)
      rem[rem.length] = exc[i].un;
  }
  // Both add and rem arrays will be used by pabCB() to add and remove uns as
  // appropriate from the current group.

/*  var criteria = un
    ? 'cmd=PAB_CMD_MOD_ENTRY|old=' + main.pabAttrs['un'].name + ':' + g.un + '\n\n|new='
    : 'cmd=PAB_CMD_ADD_ENTRY|new=';

  for (p in g) {
    if (g[p]) {
      if ((main.pabAttrs[p].type & 8) && isArray(g[p])) {
        for (i = 0; i < g[p].length; i++)
          criteria += main.pabAttrs[p].name + ':' + main.escape_crlf(g[p][i]) + '\n';
      } else
        criteria += main.pabAttrs[p].name + ':' + main.escape_crlf(g[p]) + '\n';
    } 
  }
  criteria += '\n|'; */
  var modify =0
  if(un) {
        for(p in modifiedvalues )
        {
                if(modifiedvalues[p] == 1)
                        {
                           modify = 1
                           break;
                        }
        }
  }
  else
     modify = 1
  if(modify == 1)
  {
   var criteria = un
    ? 'cmd=PAB_CMD_MOD_ATTRIBUTES|old=' + main.pabAttrs['un'].name + ':' + g.un + '\n\n|new='
    : 'cmd=PAB_CMD_ADD_ENTRY|new=';

  for (p in g) {
    if (g[p]) {
      if ((main.pabAttrs[p].type & 8) && isArray(g[p])) {
        if(modifiedvalues[p] == 1)
          for (i = 0; i < g[p].length; i++)
             criteria += main.pabAttrs[p].name + ':' + main.escape_crlf(g[p][i]) + '\n';
      } else if( modifiedvalues[p] == 1)
             criteria += main.pabAttrs[p].name + ':' + main.escape_crlf(g[p]) + '\n';
    }
  }
  criteria += '\n|';
  tfr = '<FORM name=form method=post action="' + main.msgHREF + 'ldap.msc">' +
    '<INPUT type=hidden name=sid value="' + main.sid + '">' +
    '<INPUT type=hidden name=security value="' + main.security + '">' +
    '<INPUT type=hidden name=ldapurl value="pab">' +
    main.get_form_charset() + 
    '<INPUT type=hidden name=filter value="' + criteria + '"></FORM>';
  state = 'POST';
  reload(data);
  }
 else
 {
   un = g.un;
   if (add.length) {
      tfr = 'cmd=PAB_CMD_ADD_MEMBER|old=' + main.pabAttrs['un'].name + ':' + un + '\n' +
        main.pabAttrs['objectclass'].name + ':pabgroup\n\n|new='
      for (var i = 0; i < add.length; i++)
        tfr += main.pabAttrs['un'].name + ':' + add[i] + '\n';
      tfr += '\n|';
      tfr = main.msgHREF + 'ldap.msc?sid=' + main.sid +
        '&security=' + main.security + '&ldapurl=pab&filter=' + encode(tfr);
      add = new Array();
      state = 'POST';
      load(data, tfr);
      tfr = '';
   }
   else if(rem.length) {
      tfr = 'cmd=PAB_CMD_DEL_MEMBER|old=' + main.pabAttrs['un'].name + ':' + un + '\n' +
        main.pabAttrs['objectclass'].name + ':pabgroup\n\n|new='
        for (var i = 0; i < rem.length; i++)
          tfr += main.pabAttrs['un'].name + ':' + rem[i] + '\n';
      tfr += '\n|';
      tfr = main.msgHREF + 'ldap.msc?sid=' + main.sid +
        '&security=' + main.security + '&ldapurl=pab&filter=' + encode(tfr);
      rem = new Array();
      state = 'POST';
      load(data, tfr);
      tfr = '';
   }
   else alert(i18n_pg['group not altered'])
 }

}

function cancel() {
  window.close();
  if(lookupWindow) lookupWindow.close()
}

function pabCB() {
  tfr = '';
  if (data.color)
    data.color(main.chrome2);
  if (data.errno != 0) {
    alert(data.errstr);
    state = 'group';
    return;
  }
  if (state == 'init') {
    if (data.groups.length) {
      g = data.groups[0];
      modifiedvalues = cloneObject(data.groups[0]);
      for (p in g) {
        modifiedvalues[p] = 0
        if ((main.pabAttrs[p].type & 8) && isArray(g[p])) {
          for (var i = 0; i < g[p].length; i++)
            g[p][i] = main.unescape_crlf(g[p][i]);
        } else
          g[p] = main.unescape_crlf(g[p]);
      }
    }
    setUpMembers();
    state = 'group';
    reload(idx);
    reload(tab);
    reload(btn);
  } else if (state == 'POST' || state == 'delete') {
    if (data.groups && data.groups.length)
      un = data.groups[0].un;
    if (add.length) {
      tfr = 'cmd=PAB_CMD_ADD_MEMBER|old=' + main.pabAttrs['un'].name + ':' + un + '\n' +
        main.pabAttrs['objectclass'].name + ':pabgroup\n\n|new='
      for (var i = 0; i < add.length; i++)
        tfr += main.pabAttrs['un'].name + ':' + add[i] + '\n';
      tfr += '\n|';
//      if (!confirm(tfr))
//        return;
      tfr = main.msgHREF + 'ldap.msc?sid=' + main.sid +
        '&security=' + main.security + '&ldapurl=pab&filter=' + encode(tfr);
//      if (!confirm(tfr))
//        return;
      add = new Array();
      load(data, tfr);
      tfr = '';
    } else if (rem.length) {
      tfr = 'cmd=PAB_CMD_DEL_MEMBER|old=' + main.pabAttrs['un'].name + ':' + un + '\n' +
        main.pabAttrs['objectclass'].name + ':pabgroup\n\n|new='
        for (var i = 0; i < rem.length; i++)
          tfr += main.pabAttrs['un'].name + ':' + rem[i] + '\n';
      tfr += '\n|';
//      if (!confirm(tfr))
//        return;
      tfr = main.msgHREF + 'ldap.msc?sid=' + main.sid +
        '&security=' + main.security + '&ldapurl=pab&filter=' + encode(tfr);
//      if (!confirm(tfr))
//        return;
      rem = new Array();
      load(data, tfr);
      tfr = '';
    } else {
      if (state != 'delete' && main.curPabGrp == 1)
        main.lastModUn = un;
      if (main.state == 'pab')
        main.state = 'pabinit';
      if (un && main.curPabGrp == un && state == 'delete')
        main.curPabGrp = 1;
	  else if (main.curPabGrp == 3 ) main.curPabGrp = 3 // retain state
      else if (isNaN(main.curPabGrp)? true : main.curPabGrp > 1)
        main.curPabGrp = un;
	  main.fetchPab();
      window.close();
      if(lookupWindow) lookupWindow.close()
    }
  }
}

function noop()
{
}

