/*
** NETSCAPE COMMUNICATIONS CORPORATION 
** 
** Copyright (c) 1998 Netscape Communications Corporation. All Rights
** Reserved. 
** 
** Use of this Source Code is subject to the terms of the applicable license
** agreement from Netscape Communications Corporation. 
** 
** The copyright notice(s) in this Source Code does not indicate actual or
** intended publication of this Source Code. 
**
**  Filename 
**  --------
**  nsapipauth.c
**
**  Description
**  -----------
**  source file for messenger express sample proxy auth sample NSAPI plugin
**  
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "expapi.h"
#include "base/pblock.h"
#include "base/session.h"
#include "frame/req.h"

#ifndef XP_WIN32
#define NSAPI_PUBLIC
#else /* XP_WIN32 */
#define NSAPI_PUBLIC __declspec(dllexport)
#endif /* XP_WIN32 */


/* 
 * It would probably be better for to decompose this from
 * the path value of the request, but this is just a sample
 * so we'll hardcode it.
 */
#define HTML_SOURCE_FILE "/usr/netscape/suitespot/docs/login.html"
#define BUFFER_SIZE 1024
#define MAIL_SERVER "mail.yourdomain.com"


/* Assuming the obj.conf has:
** Init fn=load-modules shlib="/l1/install/me352/plugins/test/authplugin.so" 
**   funcs="handle_get,handle_post"
**
** <Object ppath=/l1/install/me352/docs/webmail/login>
** Service method=GET fn=handle_get
** Service method=POST fn=handle_post
** </Object>
*/



NSAPI_PUBLIC int handle_get(pblock *pb, Session *sn, Request *rq) {
    FILE	*hHtmlFile;
    char	buffer[BUFFER_SIZE];

    pblock_nvinsert("content-type", "text/html", rq->srvhdrs);

    if ((hHtmlFile = fopen(HTML_SOURCE_FILE, "r")) == NULL) {
	/* print something */
	log_error(0, "handle-post", sn, rq, "could not read input");
	net_write(sn->csd, "<HTML><BR><CENTER><B>\r\n", 23);
	net_write(sn->csd, "Unable to read login source file\r\n", 34);
	net_write(sn->csd, "</B></CENTER></HTML>\r\n", 22);
	return;
    }

    while (fgets(buffer, BUFFER_SIZE, hHtmlFile) != NULL) {
	net_write(sn->csd, buffer, strlen(buffer));
    }

    return REQ_PROCEED;
}


NSAPI_PUBLIC int handle_post(pblock *pb, Session *sn, Request *rq) {
    char	buffer[BUFFER_SIZE];
    char	user[BUFFER_SIZE];
    char	password[BUFFER_SIZE];
    char	url[BUFFER_SIZE];
    char	*p, *q;
    char	*ipaddress;
    int i;


    /* 
     * note that in a real example you will probably
     * need to unescape the values from CGI post if
     * users have passwords with odd characters in them 
     * read http://hoohoo.ncsa.uiuc.edu/cgi/ for more info
     */

    log_error(0, "handle-post", sn, rq, "handling post");

    /* read in the input */
    while((i = net_read(sn->csd, buffer, BUFFER_SIZE, 3)) > 0) {

	buffer[i] = '\0';

	log_error(0, "handle-post", sn, rq, "read [%s]", buffer);

	if ((p = strchr(buffer, '\n')) != NULL)
	    *p = '\0';

	/* snag the user value */
	if ((p = strstr(buffer, "user=")) != NULL) {
	    p += 5;
	    if (p != '\0') {
		if ((q=strchr(p, '&')) == NULL) 
		    q=strchr(p, '\0');

		strncpy(user, p, q-p);
		user[q-p] = '\0';
	    }
	}

	/* snag the password value */
	if ((p = strstr(buffer, "password=")) != NULL) {
	    p += 9;
	    if (p != '\0') {
		if ((q=strchr(p, '&')) == NULL) 
		    q=strchr(p, '\0');

		strncpy(password, p, q-p);
		user[q-p] = '\0';
	    }
	}
	    
	/* parse for other stuff here */

    }
    
    /* 
     * now you call whatever your local authentication function is
     * to see if the password is correct. If it is, you get them a
     * session ID and send them the URL.
     */


    /*
     * you can get remote ip address (and lots of other stuff)
     * from the ENV vars 
     * http://docs.iplanet.com/docs/manuals/enterprise/50/nsapi/
     */

    ipaddress = pblock_findval("ip", sn->client);
    log_error(0, "handle-post", sn, rq, "calling mail server");

    EXP_GenerateLoginURL(user, 
			 ipaddress, 
			 MAIL_SERVER, 
			 url);

    sprintf(buffer, "<HTML><SCRIPT>\ntop.location='%s';\n</SCRIPT></HTML>\n",
	    url);
    net_write(sn->csd,  buffer, strlen(buffer));

    return REQ_PROCEED;
}






