/* CHANGES MADE TO THIS FILE SHOULD ALSO BE MADE TO pmdf_apikeyconst.inc */

/****************************************************************************/
/*                                                                          */
/*  APIKEYDEF.H - PMDF channel keyword declarations for the PMDF API        */
/*                                                                          */
/*  Author:   Dan Newman (dan@innosoft.com)                                 */
/*            Fall 1996                                                     */
/*            PMDF Project, Innosoft International, Inc.                    */
/*                                                                          */
/*  Copyright (c) 1996, The PMDF Project                                    */
/*                Innosoft International, Inc.                              */
/*                                                                          */
/*  All rights reserved.                                                    */
/*                                                                          */
/****************************************************************************/

/*  The values assigned to these constants should never be changed.
 *  When new channel keywords are added to PMDF, a corresponding constant
 *  should be added to the end of this list.
 */

#ifndef __PMDF_APIKEYDEF__
#define __PMDF_APIKEYDEF__

#define PMDF_CKEY_END_LIST                0
#define PMDF_CKEY_CHAIN                   1
#define PMDF_CKEY_2ND_CLASS_BLOCKLIMIT    2
#define PMDF_CKEY_ADDRSPERFILE            3
#define PMDF_CKEY_ADDRSPERJOB             4
#define PMDF_CKEY_ADD_LINE_ADDRS          5
#define PMDF_CKEY_ADDLINEADDRS            5
#define PMDF_CKEY_AFTER                   6
#define PMDF_CKEY_BANGOVERPERCENT         7
#define PMDF_CKEY_BLOCKLIMIT              8
#define PMDF_CKEY_CACHE                   9
#define PMDF_CKEY_CHANCODE               10
#define PMDF_CKEY_CHARSET7               11
#define PMDF_CKEY_CHARSET8               12
#define PMDF_CKEY_COMMENTINC             13
#define PMDF_CKEY_CONNECT_CANONICAL      14
#define PMDF_CKEY_CONNECTCANONICAL       14
#define PMDF_CKEY_CONTCHAR               15
#define PMDF_CKEY_CONTPOSITION           16
#define PMDF_CKEY_CONVERT_OCTET_STREAM   17
#define PMDF_CKEY_DAEMON                 18
#define PMDF_CKEY_DATEFOUR               19
#define PMDF_CKEY_DAYOFWEEK              20
#define PMDF_CKEY_DEFAULTDOMAIN          21
#define PMDF_CKEY_DEFERRED               22
#define PMDF_CKEY_DEFRAGMENT             23
#define PMDF_CKEY_DESCRIPTION            24
#define PMDF_CKEY_DIRECTION              25
#define PMDF_CKEY_DRECEIPTS              26
#define PMDF_CKEY_EHLO                   27
#define PMDF_CKEY_EIGHTBIT               28
#define PMDF_CKEY_ENVELOPE_ADDRESS_TYPE  29
#define PMDF_CKEY_EXPANDLIMIT            30
#define PMDF_CKEY_EXPROUTE               31
#define PMDF_CKEY_EXQUOTA                32
#define PMDF_CKEY_FILESPERJOB            33
#define PMDF_CKEY_FOREIGN                34
#define PMDF_CKEY_GREY                   35
#define PMDF_CKEY_HEADERINC              36
#define PMDF_CKEY_HEADERLABELALIGNMENT   37
#define PMDF_CKEY_HEADERLINEINCREMENT    38
#define PMDF_CKEY_HEADERLINELENGTH       39
#define PMDF_CKEY_HEADERREAD             40
#define PMDF_CKEY_HEADERSET7             41
#define PMDF_CKEY_HEADERSET8             42
#define PMDF_CKEY_HEADERTRIM             43
#define PMDF_CKEY_HEADER_ADDRESS_TYPE    44
#define PMDF_CKEY_IDENT                  45
#define PMDF_CKEY_IMMEDIATE              46
#define PMDF_CKEY_IMPROUTE               47
#define PMDF_CKEY_INNERTRIM              48
#define PMDF_CKEY_INTERPRET_ENCODING     49
#define PMDF_CKEY_LASTRESORT             50
#define PMDF_CKEY_LINELENGTH             51
#define PMDF_CKEY_LINELIMIT              52
#define PMDF_CKEY_LOCAL_ALIAS            53
#define PMDF_CKEY_LOGGING                54
#define PMDF_CKEY_LOGICALDISK            55
#define PMDF_CKEY_MASTER_DEBUG           56
#define PMDF_CKEY_MAXBLOCKS              57
#define PMDF_CKEY_MAXFILES               58
#define PMDF_CKEY_MAXHEADERADDRS         59
#define PMDF_CKEY_MAXHEADERCHARS         60
#define PMDF_CKEY_MAXJOBS                61
#define PMDF_CKEY_MAXLINES               62
#define PMDF_CKEY_MAXPROCCHARS           63
#define PMDF_CKEY_MSEXCHANGE             64
#define PMDF_CKEY_MULTIGATE              65
#define PMDF_CKEY_MULTIPLICITY           66
#define PMDF_CKEY_MX                     67
#define PMDF_CKEY_NOLOCALUSER            68
#define PMDF_CKEY_NON_URGENT_BLOCKLIMIT  69
#define PMDF_CKEY_NORMAL_BLOCKLIMIT      70
#define PMDF_CKEY_NOTICES                71
#define PMDF_CKEY_OFFICIAL_HOSTNAME      72
#define PMDF_CKEY_PENDINGIGNORE          73
#define PMDF_CKEY_PERIOD                 74
#define PMDF_CKEY_PERSONALINC            75
#define PMDF_CKEY_PORT                   76
#define PMDF_CKEY_QUEUE                  77
#define PMDF_CKEY_RECEIVEDFOR            78
#define PMDF_CKEY_RECEIVEDFROM           79
#define PMDF_CKEY_REMOTEHOST             80
#define PMDF_CKEY_RESTRICTED_ENCODING    81
#define PMDF_CKEY_RETURNENVELOPE         82
#define PMDF_CKEY_REVERSE                83
#define PMDF_CKEY_REWRITEINNER           84
#define PMDF_CKEY_RULES                  85
#define PMDF_CKEY_SEARCHQUEUES           86
#define PMDF_CKEY_SENDHEAD               87
#define PMDF_CKEY_SENDPOST               88
#define PMDF_CKEY_SERVICE_ACTIVATE       89
#define PMDF_CKEY_SERVICE_ALL            90
#define PMDF_CKEY_SIGACTIONS             91
#define PMDF_CKEY_SLAVE_DEBUG            92
#define PMDF_CKEY_SMTP                   93
#define PMDF_CKEY_STREAMING              94
#define PMDF_CKEY_SUBADDRESSTRANSFER     95
#define PMDF_CKEY_SUBDIRS                96
#define PMDF_CKEY_SWITCH                 97
#define PMDF_CKEY_THREADDEPTH            98
#define PMDF_CKEY_THURMAN                99
#define PMDF_CKEY_TICK                  100
#define PMDF_CKEY_TURN                  101
#define PMDF_CKEY_URGENT_BLOCKLIMIT     102
#define PMDF_CKEY_USER                  103
#define PMDF_CKEY_USEREPLYTO            104
#define PMDF_CKEY_USERESENT             105
#define PMDF_CKEY_VERB                  106
#define PMDF_CKEY_OVRFY                 107
#define PMDF_CKEY_VRFY                  107
#define PMDF_CKEY_WARNPOST              108
#define PMDF_CKEY_X_ENV_TO              109
#define PMDF_CKEY_SIEVE                 110
#define PMDF_CKEY_CHANNELSIEVE          111
#define PMDF_CKEY_DEFAULTHOST           112
#define PMDF_CKEY_EXPANDCHANNEL         113
#define PMDF_CKEY_FILEINTO              114
#define PMDF_CKEY_FORWARDCHECK          115
#define PMDF_CKEY_IVRFY                 116
#define PMDF_CKEY_LOCALPOST             117
#define PMDF_CKEY_MAXPERPRIO            118
#define PMDF_CKEY_MINPERPRIO            119
#define PMDF_CKEY_MISSINGPOLICY         120
#define PMDF_CKEY_OPERTYPE              121
#define PMDF_CKEY_SENDETRN              122
#define PMDF_CKEY_SORTDIRECTION         123
#define PMDF_CKEY_SUPPRESSFINAL         124
#define PMDF_CKEY_TLS                   125
#define PMDF_CKEY_SENSITIVITYLIMIT      126
#define PMDF_CKEY_VALIDATELOCAL         127
#define PMDF_CKEY_VIA_ALIAS             128

#define PMDF_CKEY_V_UNKNOWN               0

/*
 *  PMDF_CKEY_SENDPOST
 *  PMDF_CKEY_WARNPOST
 */
#define PMDF_CKEY_V_NEVER_SEND         1
#define PMDF_CKEY_V_ERROR_SEND         2
#define PMDF_CKEY_V_COPY_SEND          3
#define PMDF_CKEY_V_CONTROLLED_SEND    4
#define PMDF_CKEY_V_ALWAYS_SEND        5

/*
 *  PMDF_CKEY_RESTRICTED_ENCODING
 */
#define PMDF_CKEY_V_RESTRICTED         1
#define PMDF_CKEY_V_NORESTRICTED       2
#define PMDF_CKEY_V_UNRESTRICTED       3

/*
 *  PMDF_CKEY_SWITCH
 */
#define PMDF_CKEY_V_SWITCHCHANNEL      1
#define PMDF_CKEY_V_NOSWITCHCHANNEL    2
#define PMDF_CKEY_V_ALLOWSWITCHCHANNEL 3

/*
 *  PMDF_CKEY_ENVELOPE_ADDRESS_TYPE
 *  PMDF_CKEY_HEADER_ADDRESS_TYPE
 */
#define PMDF_CKEY_V_SOURCEROUTE        1
#define PMDF_CKEY_V_PERCENTS           2
#define PMDF_CKEY_V_BANGSTYLE          3

/*
 *  PMDF_CKEY_DIRECTION
 */
#define PMDF_CKEY_V_BIDIRECTIONAL      1
#define PMDF_CKEY_V_MASTER             2
#define PMDF_CKEY_V_SLAVE              3

/*
 *  PMDF_CKEY_IMMEDIATE
 */
#define PMDF_CKEY_V_THIRD_CLASS        1
#define PMDF_CKEY_V_SECOND_CLASS       2
#define PMDF_CKEY_V_NON_URGENT         3
#define PMDF_CKEY_V_NORMAL             4
#define PMDF_CKEY_V_URGENT             5

/*
 *  PMDF_CKEY_TICK
 */
#define PMDF_CKEY_V_DEFAULTTICK        1
#define PMDF_CKEY_V_NOTICK             2
#define PMDF_CKEY_V_TICK               3

/*
 *  PMDF_CKEY_VERB
 */
#define PMDF_CKEY_V_VERB_NEVER         1
#define PMDF_CKEY_V_VERB_OFF           2
#define PMDF_CKEY_V_VERB_ON            3
#define PMDF_CKEY_V_VERB_NONE          4

/*
 *  PMDF_CKEY_EHLO
 */
#define PMDF_CKEY_V_DEFAULTEHLO        1
#define PMDF_CKEY_V_EHLO               2
#define PMDF_CKEY_V_NOEHLO             3
#define PMDF_CKEY_V_CHECKEHLO          4
#define PMDF_CKEY_V_REFUSEEHLO         5

/*
 *  PMDF_CKEY_VRFY
 */
#define PMDF_CKEY_V_NOVRFY             1
#define PMDF_CKEY_V_DOMAINVRFY         2
#define PMDF_CKEY_V_LOCALVRFY          3
#define PMDF_CKEY_V_PROHIBITVRFY       4
#define PMDF_CKEY_V_DEFAULTVRFY        5
#define PMDF_CKEY_V_ALLOWVRFY          6

/*
 *  PMDF_CKEY_HEADERINC
 */
#define PMDF_CKEY_V_HEADERINC          1
#define PMDF_CKEY_V_HEADERBOTTOM       2
#define PMDF_CKEY_V_HEADEROMIT         3

/*
 *  PMDF_CKEY_COMMENTINC
 */
#define PMDF_CKEY_V_COMMENTINC         1
#define PMDF_CKEY_V_COMMENTOMIT        2
#define PMDF_CKEY_V_COMMENTSTRIP       3
#define PMDF_CKEY_V_COMMENTTOTAL       4

/*
 *  PMDF_CKEY_PERSONALINC
 */
#define PMDF_CKEY_V_PERSONALINC        1
#define PMDF_CKEY_V_PERSONALSTRIP      2
#define PMDF_CKEY_V_PERSONALOMIT       3

/*
 *  PMDF_CKEY_EXQUOTA
 */
#define PMDF_CKEY_V_NOEXQUOTA          1
#define PMDF_CKEY_V_HOLDEXQUOTA        2
#define PMDF_CKEY_V_EXQUOTA            3

/*
 *  PMDF_CKEY_EIGHTBIT
 */
#define PMDF_CKEY_V_SEVENBIT           1
#define PMDF_CKEY_V_EIGHTBIT           2
#define PMDF_CKEY_V_EIGHTNEGOTIATE     3
#define PMDF_CKEY_V_EIGHTSTRICT        4

/*
 *  PMDF_CKEY_MX
 */
#define PMDF_CKEY_V_DEFAULTMX          1
#define PMDF_CKEY_V_MX                 2
#define PMDF_CKEY_V_NOMX               3
#define PMDF_CKEY_V_RANDOMMX           4

/*
 *  PMDF_CKEY_IDENT
 */
#define PMDF_CKEY_V_IDENTNONE          1
#define PMDF_CKEY_V_IDENTCP            2
#define PMDF_CKEY_V_IDENTMIB           3
#define PMDF_CKEY_V_IDENTNONENUMERIC   4
#define PMDF_CKEY_V_IDENTTCPNUMERIC    5
#define PMDF_CKEY_V_IDENTMIBNUMERIC    6
#define PMDF_CKEY_V_IDENTNONESYMBOLIC  7
#define PMDF_CKEY_V_IDENTTCPSYMBOLIC   8
#define PMDF_CKEY_V_IDENTMIBSYMBOLIC   9

/*
 *  PMDF_CKEY_DRECEIPTS
 */
#define PMDF_CKEY_V_RECEIPTHEADER      1
#define PMDF_CKEY_V_RECEIPTNOTARY      2
#define PMDF_CKEY_V_RECEIPTSUPPRESS    3

/*
 *  PMDF_CKEY_MULTIPLICITY
 */
#define PMDF_CKEY_V_SINGLE             1
#define PMDF_CKEY_V_MULTIPLE           2
#define PMDF_CKEY_V_SINGLE_SYS         3

/*
 *  PMDF_CKEY_TURN
 */
#define PMDF_CKEY_V_NOTURN             1
#define PMDF_CKEY_V_TURN_IN            2
#define PMDF_CKEY_V_TURN_OUT           3
#define PMDF_CKEY_V_TURN               4

/*
 *  PMDF_CKEY_SMTP
 */
#define PMDF_CKEY_V_NOSMTP             1
#define PMDF_CKEY_V_SMTP_CRLF          2
#define PMDF_CKEY_V_SMTP_CR            3
#define PMDF_CKEY_V_SMTP               4
#define PMDF_CKEY_V_LMTP_CRLF          5
#define PMDF_CKEY_V_LMTP_CR            6
#define PMDF_CKEY_V_LMTP_LF            7
#define PMDF_CKEY_V_LMTP_CRORLF        8

/*
 *  PMDF_CKEY_CACHE
 */
#define PMDF_CKEY_V_NOCACHE            1
#define PMDF_CKEY_V_CACHESUCCESSES     2
#define PMDF_CKEY_V_CACHEFAILURES      3
#define PMDF_CKEY_V_CACHEEVERYTHING    4

/*
 *  PMDF_CKEY_SIGACTIONS
 */
#define PMDF_CKEY_V_SIGNATURETUNNEL    1
#define PMDF_CKEY_V_SIGNATUREREMOVE    2
#define PMDF_CKEY_V_SIGNATUREPROCESS   3
#define PMDF_CKEY_V_SIGNATUREVERIFY    4

/*
 *  PMDF_CKEY_FORWARDCHECK
 */
#define PMDF_CKEY_V_FORWARDCHECKNONE   1
#define PMDF_CKEY_V_FORWARDCHECKTAG    2
#define PMDF_CKEY_V_FORWARDCHECKDELETE 3

/*
 *  PMDF_CKEY_OPERTYPE
 */
#define PMDF_CKEY_V_OPERTYPE_DEFAULT     1
#define PMDF_CKEY_V_OPERTYPE_SUBMIT      2
#define PMDF_CKEY_V_OPERTYPE_RELAY       3

/*
 *  PMDF_CKEY_SENSITIVITYLIMIT
 */
/*
#define PMDF_CKEY_V_NORMAL               4
*/
#define PMDF_CKEY_V_PERSONAL             1
#define PMDF_CKEY_V_PRIVATE              2
#define PMDF_CKEY_V_COMPANYCONFIDENTIAL  3

/*
 *  PMDF_CKEY_VALIDATELOCAL
 */
#define PMDF_CKEY_V_LOCALEXTERNAL        1
#define PMDF_CKEY_V_LOCALMSGSTORE        2
#define PMDF_CKEY_V_LOCALNONE            3
#define PMDF_CKEY_V_LOCALPOPSTORE        4
#define PMDF_CKEY_V_LOCALPROFILE         5
#define PMDF_CKEY_V_LOCALSYSTEM          6

/*
 *  PMDF_CKEY_TLS
 */
#define PMDF_CKEY_V_TLS_NO             1
#define PMDF_CKEY_V_TLS_MAY            2
#define PMDF_CKEY_V_TLS_MUST           3

/*
 *  Data from the queue cache
 */
#define PMDF_QC_END_LIST              0
#define PMDF_QC_CHAIN                 1
#define PMDF_QC_CHANNEL               2
#define PMDF_QC_CREATION_DATE_BIN     3
#define PMDF_QC_CREATION_DATE_STR     4
#define PMDF_QC_DEFERRED_DATE_BIN     5
#define PMDF_QC_DEFERRED_DATE_STR     6
#define PMDF_QC_EXPIRY_DATE_BIN       7
#define PMDF_QC_EXPIRY_DATE_STR       8
#define PMDF_QC_FILENAME              9
#define PMDF_QC_LAST_TRY_DATE_BIN    10
#define PMDF_QC_LAST_TRY_DATE_STR    11
#define PMDF_QC_OWNER_USERNAME       12
#define PMDF_QC_PRIORITY             13
#define PMDF_QC_RECIPIENT_COUNT      14
#define PMDF_QC_RECIPIENT_SYSTEM     15
#define PMDF_QC_MSG_SIZE             16

#define PMDF_QC_FLAG_MORE    0x00000001

#endif  /* __PMDF_APIKEYDEF__ */
