/*
 *  send_multi.c
 *
 *    Use mtaSend() to send a message to multiple recipients.
 *
 *  Copyright (c) 2003, Sun Microsystems, Inc.  All Rights Reserved.
 */

#include <stdio.h>
#include <string.h>
#include "mtasdk.h"

/* Push an entry onto the item list */
#define ITEM(item,adr) item_list[index].item_code    = item;   \
                       item_list[index].item_address = adr;    \
                       item_list[index].item_length  = adr ? strlen(adr) : 0; \
                       item_list[index].item_status  = 0;      \
                       item_list[index++].item_smessage = NULL

int main()
{
     mta_item_list_t item_list[7];
     int i, istat, index = 0;

     /* Specify the Subject: header line and message input source */
     ITEM(MTA_SUBJECT, "send_multi.c");
     ITEM(MTA_MSG_FILE, __FILE__);

     /* Return per address status/error messages */
     ITEM(MTA_ADR_STATUS, 0);

     /* Specify regular To: and Cc: addresses */
     ITEM(MTA_BCC, "root");
     ITEM(MTA_TO,  "abuse@sample.com");
     ITEM(MTA_CC,  "postmaster@sample.com");

     /* Now terminate the item list */
     ITEM(MTA_END_LIST, 0);

     /* And send the message */
     istat = mtaSend(item_list);

     /*  Display the address status messages provided
      *  that no error other than MTA_HOST has occurred
      */
     for (i = 0; i < index; i++)
	  if (item_list[i].item_smessage)
	       printf ("%s: %s - %s\n",
		       (const char *)item_list[i].item_address,
		       item_list[i].item_status ? "Failed" : "Succeeded",
		       item_list[i].item_smessage);

     /* Dispose of status messages */
     mtaSendDispose(item_list);

     /* And exit */
     return(istat);
}
