/*
 *  send_multi.c
 *
 *    Demonstrate the use of an input procedure with mtaSend().
 *
 *  Copyright (c) 2003, Sun Microsystems, Inc.  All Rights Reserved.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mtasdk.h"

#if defined(_WIN32)
typedef long ssize_t;
#endif

/* Push an entry onto the item list */
#define ITEM(item,adr) item_list[index].item_code    = item; \
                       item_list[index].item_address = adr;  \
                       item_list[index].item_length  = 0;    \
                       item_list[index].item_status  = 0;    \
                       item_list[index++].item_smessage = NULL

ssize_t msg_proc(const char **bufadr)
{
    static char buf[1024];
    ssize_t buflen;

    if (!bufadr)
        return(-2); /* Call error; abort */

    printf("input: ");
    if (fgets(buf, sizeof(buf), stdin))
    {
        *bufadr = buf;
        buflen = strlen(buf);
        if (buf[buflen-1] == '\n')
            buflen -= 1;
        return(buflen);
    }
    else
        return(-1);  /* EOF */
}

int main()
{
    int istat, index = 0;
    mta_item_list_t item_list[4];

    ITEM(MTA_TO, "root");
    ITEM(MTA_SUBJECT, "send_input.c");
    ITEM(MTA_MSG_PROC, (void *)msg_proc);
    ITEM(MTA_END_LIST, 0);
    return(mtaSend(item_list));
}
