#
# debug message
#
debug_log() {
  if [ $DEBUG != 0 ]; then
    log_msg $*
  fi
}

#
# initialize LOGFILE
#
log_init() {
  touch $LOGFILE
  echo "============ LOGFILE started `date` ==========" >> $LOGFILE
}

#
# log a message to the screen and to the LOGFILE
#
log_msg() {
  echo $*
  echo $* >> $LOGFILE
}

#
# log a message to the LOGFILE only
#
log_only() {
  echo $* >> $LOGFILE
}

#
# initialize
#
#log_init

#
# i18n messages
# Stolen from David Lim's installer, can be removed if being called from that
#
DTDSPMSG=${DTDSPMSG:=/usr/dt/bin/dtdspmsg}
#
# L10N Message translation utility
#
Message()
{
  # Message() - display message from installer.cat
  #   $1 - message id
  #   $2 - fallback message text

  log_only $2
  if [ "$OS" = "SunOS" ]; then
    if [ -x $DTDSPMSG ]; then
      $DTDSPMSG -s 11 installer.cat $1 "$2" "$3"
    else
      echo "$2"|sed -e 's/\\n//g'
    fi
  elif [ "$OS" = "Linux" ]; then
    # i18n solution for Linux should use gettext
    echo "$2"|sed -e 's/\\n//g'
  elif [ "$OS" = "HP-UX" ]; then
    echo "$2"|sed -e 's/\\n//g'
  else
    log_msg "-- $OS unsupported for i18n Message $2, sorry"
  fi
}
#CPU=`/usr/bin/uname -p`
#NLSPATH=${NLSPATH:=`/usr/bin/pwd`/$install_dir/locale/$CPU/%L/%N:$NLSPATH}
NLSPATH=`/bin/pwd`:$NLSPATH
export NLSPATH

