/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.page;

import com.netscape.page.Debug;
import com.netscape.page.Deserializer;
import com.netscape.page.PageModel;
import com.netscape.page.PageUI;
import com.netscape.page.PageUtil;
import com.netscape.page.WindowCloser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class Verify {
    JFrame _frame;
    JTabbedPane _tabPane;
    int debugLevel = 0;
    PageModel _defaultModel = new PageModel();
    Vector _pageUI;
    Vector _rsFiles = new Vector();
    int _loop = 1;

    public Verify(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if ("-debug".equals(stringArray[i])) {
                this.debugLevel = new Integer(stringArray[++i]);
                Debug.setLevel(this.debugLevel);
                continue;
            }
            if ("-loop".equals(stringArray[i])) {
                this._loop = new Integer(stringArray[++i]);
                continue;
            }
            if ("-g".equals(stringArray[i])) {
                String string = stringArray[++i];
                try {
                    String string2;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("{");
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string2);
                    }
                    stringBuffer.append("}");
                    Hashtable hashtable = (Hashtable)Deserializer.deserializeObject(stringBuffer.toString());
                    PageUI.setGlobalAttrs(hashtable);
                }
                catch (Exception exception) {
                    Debug.println("Failed to read global attributes.");
                    System.exit(0);
                }
                continue;
            }
            this._rsFiles.addElement(stringArray[i]);
        }
        this._frame = new JFrame();
        this._tabPane = new JTabbedPane();
        this._frame.setBackground(new Color(SystemColor.control.getRGB()));
        this._frame.setJMenuBar(this.constructMenuBar());
        this._frame.getContentPane().add(this._tabPane);
        new WindowCloser(this._frame, true);
        this._frame.setGlassPane(new GridPane());
        this.reload();
        if (0 < this._tabPane.getTabCount()) {
            this._tabPane.setSelectedIndex(0);
        }
        this._frame.show();
    }

    void reload() {
        int n;
        long l = 0L;
        long l2 = 0L;
        for (n = 0; n < this._tabPane.getTabCount(); ++n) {
            this._tabPane.removeTabAt(n);
        }
        this._pageUI = new Vector();
        for (n = 0; n < this._rsFiles.size(); ++n) {
            String string = (String)this._rsFiles.elementAt(n);
            try {
                InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
                if (this._loop > 1) {
                    Debug.println("=== " + string + " ===");
                    l = System.currentTimeMillis();
                }
                Object[] objectArray = null;
                objectArray = (Object[])Deserializer.readObject(inputStream);
                if (this._loop > 1) {
                    l2 = System.currentTimeMillis();
                    System.out.println("#### readObject took " + (l2 - l) / (long)this._loop + " msec");
                    l = System.currentTimeMillis();
                }
                Hashtable hashtable = null;
                for (int i = 0; i < this._loop; ++i) {
                    hashtable = PageUtil.createUITable(objectArray);
                }
                if (this._loop > 1) {
                    l2 = System.currentTimeMillis();
                    System.out.println("#### createUITable took " + (l2 - l) / (long)this._loop + " msec\n");
                }
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    Object v = enumeration.nextElement();
                    if (!(v instanceof PageUI)) continue;
                    PageUI pageUI = (PageUI)v;
                    this._tabPane.addTab(pageUI.getBlockID(), new TabContent(pageUI));
                }
                continue;
            }
            catch (Exception exception) {
                Debug.println("Error parsing " + string + "; " + exception);
            }
        }
        this._frame.pack();
    }

    public void setGlassVisible(boolean bl) {
        this._frame.getGlassPane().setVisible(bl);
    }

    public static void main(String[] stringArray) {
        Verify verify = new Verify(stringArray);
    }

    private JMenuBar constructMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setVisible(true);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = jMenu.add(new JMenuItem("Export"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream("export.rs"));
                    dataOutputStream.writeBytes("[");
                    for (int i = 0; i < Verify.this._rsFiles.size(); ++i) {
                        String string;
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream((String)Verify.this._rsFiles.elementAt(i))));
                        while ((string = bufferedReader.readLine()) != null) {
                            string = string.trim();
                            dataOutputStream.writeBytes(string);
                        }
                        if (i + 1 == Verify.this._rsFiles.size()) {
                            dataOutputStream.writeBytes("]");
                            continue;
                        }
                        dataOutputStream.writeBytes(",");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        jMenu.addSeparator();
        jMenuItem = jMenu.add(new JMenuItem("Exit"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu = new JMenu("Edit");
        jMenuBar.add(jMenu);
        jMenuItem = jMenu.add(new JMenuItem("Reload"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Verify.this.reload();
            }
        });
        jMenuItem = jMenu.add(new JCheckBoxMenuItem("Debug"));
        if (Debug.getLevel() == 0) {
            ((JCheckBoxMenuItem)jMenuItem).setState(false);
        } else {
            ((JCheckBoxMenuItem)jMenuItem).setState(true);
        }
        jMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)itemEvent.getItem();
                if (jCheckBoxMenuItem.isSelected()) {
                    if (Debug.getLevel() == 0) {
                        Debug.setLevel(9);
                        Verify.this.reload();
                    }
                } else if (Debug.getLevel() != 0) {
                    Debug.setLevel(0);
                    Verify.this.reload();
                }
            }
        });
        jMenuItem = jMenu.add(new JCheckBoxMenuItem("Grid"));
        ((JCheckBoxMenuItem)jMenuItem).setState(false);
        jMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)itemEvent.getItem();
                Verify.this.setGlassVisible(jCheckBoxMenuItem.isSelected());
            }
        });
        return jMenuBar;
    }

    class TabContent
    extends JScrollPane {
        public TabContent(Component component) {
            super(20, 31);
            JPanel jPanel = new JPanel();
            jPanel.setBorder(PageUtil.windowInsets());
            jPanel.setLayout(new BorderLayout());
            jPanel.add(component);
            this.getViewport().add(jPanel);
        }
    }

    class UpdatePage
    implements Runnable {
        PageUI pageUI;

        public UpdatePage(PageUI pageUI) {
            this.pageUI = pageUI;
        }

        public void run() {
            this.pageUI.initAll();
        }
    }

    class GridPane
    extends JComponent {
        public GridPane() {
            this.setVisible(false);
        }

        public void paint(Graphics graphics) {
            int n;
            Dimension dimension = this.getSize();
            graphics.setColor(Color.gray);
            for (n = 0; n < dimension.width; n += 10) {
                graphics.drawLine(n, 0, n, dimension.height - 1);
            }
            for (n = 0; n < dimension.height; n += 10) {
                graphics.drawLine(0, n, dimension.width - 1, n);
            }
        }
    }
}

