/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.page;

import com.netscape.page.AbstractCtrl;
import com.netscape.page.AbstractEditor;
import com.netscape.page.AttrValue;
import com.netscape.page.Debug;
import com.netscape.page.Deserializer;
import com.netscape.page.EditorTable;
import com.netscape.page.IPageModelListener;
import com.netscape.page.IPageUIListener;
import com.netscape.page.Layout;
import com.netscape.page.MBox;
import com.netscape.page.PageControl;
import com.netscape.page.PageModel;
import com.netscape.page.PageUIChangeSupport;
import com.netscape.page.PageUtil;
import com.netscape.page.RemoteResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class PageUI
extends JPanel
implements IPageModelListener {
    public static final String TITLE_TAG = "title";
    public static final String INIT_CMD = ".page.init";
    public static final String SAVE_CMD = ".page.save";
    public static final String DEFAULT_CMD = ".page.default";
    private static final String BLOCKID_TAG = "blockid";
    private static final String HELP_TAG = "help";
    private static final String LAYOUT_TAG = "layout";
    private static final String VERSION_TAG = "version";
    private static final String CUSTOM_TAG = "custom";
    private static final String LOCALVAR_TAG = "localvar";
    private static final String CONTENT_TAG = "content";
    private static final int DEFAULT_PAD_SIZE = 6;
    private static final Integer DEFAULT_STRUT_SIZE = new Integer(6);
    private static final Dimension DEFAULT_RIGID_SIZE = new Dimension(6, 6);
    private static final Color DEBUG_COLOR = Color.red;
    protected static Hashtable _classTable = new Hashtable();
    protected Hashtable _nameTable;
    protected EditorTable _editorTable;
    protected Hashtable _buttonGroup;
    protected Vector _modifiedCtrls;
    protected Vector _validateCtrls;
    protected Rectangle _focusedRect;
    protected Component _focusComponent;
    protected Hashtable _layoutAttrs;
    protected String _name = "";
    protected String _title = "";
    protected PageControl _control;
    protected static Hashtable _globalAttrs;
    PageModel owner;
    Hashtable _pageLayout;
    String _helpToken;
    private static final String GLOBAL = "com/netscape/page/global";
    private PageUIChangeSupport _changeSupport;

    public PageUI(Hashtable hashtable) {
        this._pageLayout = hashtable;
        this._editorTable = new EditorTable(this);
        this._nameTable = new Hashtable();
        this._buttonGroup = new Hashtable();
        this._modifiedCtrls = new Vector();
        this._validateCtrls = new Vector();
        if (hashtable.containsKey(CONTENT_TAG)) {
            String string = (String)hashtable.get(VERSION_TAG);
            this._helpToken = (String)hashtable.get(HELP_TAG);
            this._name = (String)hashtable.get(BLOCKID_TAG);
            this._title = (String)hashtable.get(TITLE_TAG);
            this._layoutAttrs = (Hashtable)hashtable.get(LOCALVAR_TAG);
            Object[] objectArray = (Object[])hashtable.get(LAYOUT_TAG);
            Layout.setLayoutManager(this, objectArray);
            Object[] objectArray2 = (Object[])hashtable.get(CONTENT_TAG);
            this.addContent(this, objectArray2);
            String string2 = (String)hashtable.get(CUSTOM_TAG);
            if (!PageUtil.emptyString(string2)) {
                ClassLoader classLoader = new StackLookup().getLoader();
                try {
                    Class<?> clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
                    this._control = (PageControl)clazz.newInstance();
                    this.addIPageUIListener(this._control);
                    this._control.init(this);
                }
                catch (Exception exception) {
                    Debug.println("PageUI.PageUI(): failed to load custom class. " + exception);
                }
            }
        } else {
            Debug.println("PageUI::PageUI: input missing required field");
        }
    }

    public Object clone() {
        return new PageUI(this.getPageLayout());
    }

    public Hashtable getPageLayout() {
        return this._pageLayout;
    }

    public void setPageModel(PageModel pageModel) {
        if (pageModel == null) {
            return;
        }
        if (this.owner != null) {
            this.owner.removeIPageModelListener(this);
        }
        this.fireModelModified(this.getBlockID(), pageModel);
        this.owner = pageModel;
        this.owner.addIPageModelListener(this);
    }

    public PageModel getPageModel() {
        return this.owner;
    }

    public Hashtable getLayoutAttrs() {
        return this._layoutAttrs;
    }

    public void setLayoutAttr(String string, Object object) {
        if (this._layoutAttrs == null) {
            this._layoutAttrs = new Hashtable();
        }
        this._layoutAttrs.put(string, object);
    }

    public Object getLayoutAttr(String string) {
        if (this._layoutAttrs != null) {
            return this._layoutAttrs.get(string);
        }
        return null;
    }

    public static Hashtable getGlobalAttrs() {
        return _globalAttrs;
    }

    public static Object getGlobalAttr(String string) {
        if (_globalAttrs != null) {
            return _globalAttrs.get(string);
        }
        return null;
    }

    public static void setGlobalAttrs(Hashtable hashtable) {
        if (_globalAttrs != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = hashtable.get(k);
                _globalAttrs.put(k, v);
            }
        } else {
            _globalAttrs = hashtable;
        }
    }

    public final String getBlockID() {
        return this._name;
    }

    public final String getTitle() {
        return this._title;
    }

    public final String getHelpToken() {
        return this._helpToken;
    }

    public EditorTable getEditorTable() {
        return this._editorTable;
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this._editorTable != null) {
            this._editorTable.updateVar(string, propertyChangeEvent.getNewValue());
        }
    }

    protected void fireActionPerformed(String string, ActionEvent actionEvent) {
        if (this._changeSupport == null) {
            return;
        }
        this._changeSupport.fireActionPerformed(string, actionEvent);
    }

    protected void fireCtrlModified(String string, AbstractCtrl abstractCtrl) {
        if (this._changeSupport == null) {
            return;
        }
        this._changeSupport.fireCtrlModified(string, abstractCtrl);
    }

    protected void fireModelModified(String string, PageModel pageModel) {
        if (this._changeSupport == null) {
            return;
        }
        this._changeSupport.fireModelModified(string, pageModel);
    }

    public synchronized void addIPageUIListener(IPageUIListener iPageUIListener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PageUIChangeSupport(this);
        }
        this._changeSupport.addPageUIChangeListener(iPageUIListener);
    }

    public synchronized void removeIPageUIListener(IPageUIListener iPageUIListener) {
        if (this._changeSupport == null) {
            return;
        }
        this._changeSupport.removePageUIChangeListener(iPageUIListener);
    }

    public final Vector getWriters(String string) {
        if (this._editorTable != null) {
            return this._editorTable.getWriters(string);
        }
        return null;
    }

    public final Vector getReaders(String string) {
        if (this._editorTable != null) {
            return this._editorTable.getReaders(string);
        }
        return null;
    }

    public final Vector getTriggers(String string) {
        if (this._editorTable != null) {
            return this._editorTable.getTriggers(string);
        }
        return null;
    }

    public void initAll() {
        if (this.owner != null && this._editorTable != null) {
            this._editorTable.updateAll();
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, INIT_CMD);
        this.fireActionPerformed(this.getBlockID(), actionEvent);
    }

    public void saveAll() {
        Object object;
        if (this.owner != null) {
            object = this._modifiedCtrls.elements();
            while (object.hasMoreElements()) {
                Object e = object.nextElement();
                if (!(e instanceof AbstractEditor)) continue;
                AbstractEditor abstractEditor = (AbstractEditor)e;
                String string = abstractEditor.getID();
                Object object2 = abstractEditor.getValue();
                if (!PageUtil.emptyString(string) && object2 != null) {
                    this.owner.setAttribute(string, object2);
                }
                abstractEditor.setModified(false);
            }
        }
        this._modifiedCtrls = new Vector();
        object = new ActionEvent(this, 1001, SAVE_CMD);
        this.fireActionPerformed(this.getBlockID(), (ActionEvent)object);
    }

    public String validateAll() {
        if (this._validateCtrls.size() > 0) {
            Enumeration enumeration = this._validateCtrls.elements();
            while (enumeration.hasMoreElements()) {
                String string;
                Object e = enumeration.nextElement();
                if (!(e instanceof AbstractEditor) || PageUtil.emptyString(string = ((AbstractEditor)e).validate())) continue;
                Component component = ((AbstractEditor)e).getFocusComponent();
                if (component != null) {
                    component.requestFocus();
                }
                return ((AbstractEditor)e).getErrHint() + "\n" + string;
            }
        }
        return "";
    }

    public final void performCommand(Object object, String string) {
        ActionEvent actionEvent = new ActionEvent(object, 1001, string);
        this.fireActionPerformed(this.getBlockID(), actionEvent);
        if (this.owner != null) {
            this.owner.actionPerformed(actionEvent);
        }
    }

    public final AbstractCtrl getCtrlByName(String string) {
        return (AbstractCtrl)this._nameTable.get(string);
    }

    public void registerShortCut(ActionListener actionListener, KeyStroke keyStroke, int n) {
        this.registerKeyboardAction(actionListener, keyStroke, n);
    }

    public void unregisterShortCut(KeyStroke keyStroke) {
        this.unregisterKeyboardAction(keyStroke);
    }

    public void addModifiedCtrl(AbstractCtrl abstractCtrl) {
        if (!this._modifiedCtrls.contains(abstractCtrl)) {
            this._modifiedCtrls.addElement(abstractCtrl);
        }
        this.fireCtrlModified(this.getBlockID(), abstractCtrl);
    }

    public void addValidateCtrl(AbstractCtrl abstractCtrl) {
        if (!this._validateCtrls.contains(abstractCtrl)) {
            this._validateCtrls.addElement(abstractCtrl);
        }
    }

    public void clearValidateCtrls() {
        this._validateCtrls.removeAllElements();
    }

    public Vector getModifiedCtrls() {
        return this._modifiedCtrls;
    }

    public void setFocusedRect(Rectangle rectangle) {
        this._focusedRect = rectangle;
    }

    public Rectangle getFocusedRect() {
        return this._focusedRect;
    }

    public final ButtonGroup getGroup(String string) {
        if (PageUtil.emptyString(string)) {
            return null;
        }
        ButtonGroup buttonGroup = (ButtonGroup)this._buttonGroup.get(string);
        if (buttonGroup == null) {
            buttonGroup = new ButtonGroup();
            this._buttonGroup.put(string, buttonGroup);
        }
        return buttonGroup;
    }

    public final String getGroupSelection(String string) {
        ButtonGroup buttonGroup = this.getGroup(string);
        ButtonModel buttonModel = buttonGroup.getSelection();
        if (buttonModel != null) {
            return buttonModel.getActionCommand();
        }
        return "";
    }

    public final void setFocusComponent(Component component) {
        this._focusComponent = component;
    }

    public final Component getFocusComponent() {
        return this._focusComponent;
    }

    public Vector addContent(Container container, Object[] objectArray) {
        Vector<AbstractCtrl> vector = new Vector<AbstractCtrl>();
        LayoutManager layoutManager = container.getLayout();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            String string;
            AttrValue attrValue;
            if (objectArray[i] == null || !(objectArray[i] instanceof Hashtable)) continue;
            Layout layout = new Layout(this, (Hashtable)objectArray[i]);
            AttrValue attrValue2 = layout.getStringTag("ctrl");
            String string2 = (String)attrValue2.getValue();
            attrValue2 = layout.getStringTag("id");
            String string3 = (String)attrValue2.getValue();
            Object object2 = null;
            if (layoutManager instanceof BorderLayout) {
                attrValue = layout.getStringTag("constraint", null);
                string = (String)attrValue.getValue();
                if (!PageUtil.emptyString(string)) {
                    object = string.toCharArray();
                    object[0] = Character.toUpperCase(object[0]);
                    object2 = PageUtil.upperCaseAt(string, 0);
                }
            } else if (layoutManager instanceof GridBagLayout) {
                attrValue = layout.getHashtableTag("constraint");
                Hashtable hashtable = (Hashtable)attrValue.getValue();
                if (hashtable != null) {
                    object2 = new GridBagConstraints();
                    String string4 = (String)hashtable.get("anchor");
                    if (string4 != null) {
                        if ("center".equals(string4)) {
                            ((GridBagConstraints)object2).anchor = 10;
                        } else if ("east".equals(string4)) {
                            ((GridBagConstraints)object2).anchor = 13;
                        } else if ("northeast".equals(string4)) {
                            ((GridBagConstraints)object2).anchor = 12;
                        } else if ("southeast".equals(string4)) {
                            ((GridBagConstraints)object2).anchor = 14;
                        } else if ("west".equals(string4)) {
                            ((GridBagConstraints)object2).anchor = 17;
                        } else if ("northwest".equals(string4)) {
                            ((GridBagConstraints)object2).anchor = 18;
                        } else if ("southwest".equals(string4)) {
                            ((GridBagConstraints)object2).anchor = 16;
                        } else if ("north".equals(string4)) {
                            ((GridBagConstraints)object2).anchor = 11;
                        } else if ("south".equals(string4)) {
                            ((GridBagConstraints)object2).anchor = 15;
                        }
                    }
                    if ((string4 = (String)hashtable.get("fill")) != null) {
                        if ("none".equals(string4)) {
                            ((GridBagConstraints)object2).fill = 0;
                        } else if (string4.startsWith("h")) {
                            ((GridBagConstraints)object2).fill = 2;
                        } else if (string4.startsWith("v")) {
                            ((GridBagConstraints)object2).fill = 3;
                        } else if ("both".equals(string4)) {
                            ((GridBagConstraints)object2).fill = 1;
                        }
                    }
                    if ((string4 = (String)hashtable.get("gridheight")) != null) {
                        ((GridBagConstraints)object2).gridheight = new Integer(string4);
                    }
                    if ((string4 = (String)hashtable.get("gridwidth")) != null) {
                        ((GridBagConstraints)object2).gridwidth = new Integer(string4);
                    }
                    if ((string4 = (String)hashtable.get("gridx")) != null) {
                        ((GridBagConstraints)object2).gridx = new Integer(string4);
                    }
                    if ((string4 = (String)hashtable.get("gridy")) != null) {
                        ((GridBagConstraints)object2).gridy = new Integer(string4);
                    }
                    if ((string = hashtable.get("insets")) != null) {
                        ((GridBagConstraints)object2).insets = layout.getInsets(string);
                    }
                    if ((string4 = (String)hashtable.get("ipadx")) != null) {
                        ((GridBagConstraints)object2).ipadx = new Integer(string4);
                    }
                    if ((string4 = (String)hashtable.get("ipady")) != null) {
                        ((GridBagConstraints)object2).ipady = new Integer(string4);
                    }
                    if ((string4 = (String)hashtable.get("weightx")) != null) {
                        ((GridBagConstraints)object2).weightx = new Double(string4);
                    }
                    if ((string4 = (String)hashtable.get("weighty")) != null) {
                        ((GridBagConstraints)object2).weighty = new Double(string4);
                    }
                }
            }
            if (string2 == null) continue;
            string = null;
            if (string2.indexOf(".") >= 0) {
                string = string2;
            } else {
                if ("VSTRUT".equals(string2 = string2.toUpperCase())) {
                    container.add(PageUI.getVSTRUT(this, layout));
                    continue;
                }
                if ("HSTRUT".equals(string2)) {
                    container.add(PageUI.getHSTRUT(this, layout));
                    continue;
                }
                if ("VGLUE".equals(string2)) {
                    container.add(PageUI.getVGLUE(this, layout));
                    continue;
                }
                if ("HGLUE".equals(string2)) {
                    container.add(PageUI.getHGLUE(this, layout));
                    continue;
                }
                if ("RIGID".equals(string2)) {
                    container.add(PageUI.getRIGID(this, layout));
                    continue;
                }
                if ("SEPARATOR".equals(string2)) {
                    container.add(PageUI.getSEPARATOR(this, layout), object2);
                    continue;
                }
                string = "com.netscape.page." + string2 + "editor";
            }
            try {
                Class<?> clazz = (Class<?>)_classTable.get(string);
                if (clazz == null) {
                    clazz = Class.forName(string);
                    _classTable.put(string, clazz);
                }
                AbstractCtrl abstractCtrl = (AbstractCtrl)clazz.newInstance();
                if (string3 != null) {
                    abstractCtrl.setID(string3);
                }
                if ((object = (Object)abstractCtrl.getEditor(this, layout)) != null) {
                    Component component;
                    container.add((Component)object, object2);
                    if (abstractCtrl.getRequestFocus() && (component = abstractCtrl.getFocusComponent()) != null) {
                        this.setFocusComponent(component);
                    }
                }
                abstractCtrl.register(this._editorTable);
                if (string3 == null) continue;
                this._nameTable.put(string3, abstractCtrl);
                vector.addElement(abstractCtrl);
                continue;
            }
            catch (Exception exception) {
                Debug.println("PageUI exception: " + exception);
            }
        }
        return vector;
    }

    public static Component getHSTRUT(PageUI pageUI, Layout layout) {
        Integer n;
        String string = (String)PageUI.getGlobalAttr("g.comp.space");
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            n = DEFAULT_STRUT_SIZE;
        }
        AttrValue attrValue = layout.getIntTag("size", n);
        int n2 = (Integer)attrValue.getValue();
        JComponent jComponent = (JComponent)MBox.createHorizontalStrut(n2);
        return jComponent;
    }

    public static Component getVSTRUT(PageUI pageUI, Layout layout) {
        Integer n;
        String string = (String)PageUI.getGlobalAttr("g.comp.space");
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            n = DEFAULT_STRUT_SIZE;
        }
        AttrValue attrValue = layout.getIntTag("size", n);
        int n2 = (Integer)attrValue.getValue();
        JComponent jComponent = (JComponent)MBox.createVerticalStrut(n2);
        return jComponent;
    }

    public static Component getHGLUE(PageUI pageUI, Layout layout) {
        JComponent jComponent = (JComponent)MBox.createHorizontalGlue();
        return jComponent;
    }

    public static Component getVGLUE(PageUI pageUI, Layout layout) {
        JComponent jComponent = (JComponent)MBox.createVerticalGlue();
        return jComponent;
    }

    public static Component getRIGID(PageUI pageUI, Layout layout) {
        Object[] objectArray = (Object[])PageUI.getGlobalAttr("g.comp.area");
        Dimension dimension = objectArray != null ? layout.getDimension((Object[])PageUI.getGlobalAttr("g.comp.area")) : DEFAULT_RIGID_SIZE;
        AttrValue attrValue = layout.getDimensionTag("dimension", dimension);
        Dimension dimension2 = (Dimension)attrValue.getValue();
        JComponent jComponent = (JComponent)MBox.createRigidArea(dimension2);
        jComponent.setAlignmentY(0.0f);
        return jComponent;
    }

    public static Component getSEPARATOR(PageUI pageUI, Layout layout) {
        return new JSeparator(){

            public Dimension getMinimumSize() {
                return new Dimension(0, 2);
            }

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, 2);
            }
        };
    }

    static Border emptyBorder(int n) {
        EmptyBorder emptyBorder = new EmptyBorder(n, n, n, n);
        return PageUI.debugBorder(emptyBorder);
    }

    static Border emptyBorder(int n, int n2, int n3, int n4) {
        EmptyBorder emptyBorder = new EmptyBorder(n, n2, n3, n4);
        return PageUI.debugBorder(emptyBorder);
    }

    static Border lineBorder(Color color) {
        LineBorder lineBorder = new LineBorder(color);
        return PageUI.debugBorder(lineBorder);
    }

    static Border titledBorder(String string) {
        CompoundBorder compoundBorder = new CompoundBorder(new TitledBorder(string), PageUI.emptyBorder(6));
        return PageUI.debugBorder(compoundBorder);
    }

    static Border etchedBorder() {
        CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), PageUI.emptyBorder(6));
        return PageUI.debugBorder(compoundBorder);
    }

    static Border debugBorder(Border border) {
        if (Debug.getLevel() > 0) {
            return new CompoundBorder(border, new LineBorder(DEBUG_COLOR));
        }
        return border;
    }

    static {
        String string = Locale.getDefault().getLanguage();
        String string2 = Locale.getDefault().getCountry();
        try {
            _globalAttrs = (Hashtable)Deserializer.readObject(new RemoteResource("com/netscape/page/global_" + string + "_" + string2 + ".properties").getAsStream());
        }
        catch (Exception exception) {
            try {
                _globalAttrs = (Hashtable)Deserializer.readObject(new RemoteResource("com/netscape/page/global_" + string + ".properties").getAsStream());
            }
            catch (Exception exception2) {
                try {
                    _globalAttrs = (Hashtable)Deserializer.readObject(new RemoteResource("com/netscape/page/global.properties").getAsStream());
                }
                catch (Exception exception3) {
                    Debug.println("PageUI failed to load global settings: " + exception3);
                }
            }
        }
        Font font = UIManager.getFont("Label.font");
        if (font == null) {
            font = new Font("Dialog", 0, 10);
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = fontMetrics.charWidth('N');
        Enumeration enumeration = _globalAttrs.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith("g.label.size")) continue;
            int n2 = new Integer((String)_globalAttrs.get(string3));
            _globalAttrs.put(string3, new Integer(n2 *= n).toString());
        }
    }

    static class StackLookup
    extends SecurityManager {
        StackLookup() {
        }

        public ClassLoader getLoader() {
            int n;
            Class<?>[] classArray = this.getClassContext();
            for (n = 0; n < classArray.length && classArray[n].getName().startsWith("com.netscape.page"); ++n) {
            }
            Class<?> clazz = n < classArray.length ? classArray[n] : null;
            return clazz == null ? null : clazz.getClassLoader();
        }
    }
}

