/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.msgserv.util;

import com.netscape.management.client.Framework;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Browser;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.msgserv.util.BrowserFilter;
import com.netscape.management.msgserv.util.Debug;
import com.netscape.management.msgserv.util.ExploreTask;
import com.netscape.management.msgserv.util.ServerErrorException;
import com.netscape.page.Deserializer;
import com.netscape.page.PageUtil;
import com.netscape.page.RemoteResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class MsgUtil {
    public static final String DATASOURCE = "Sun ONE Messaging Server 6.0 Admin Console";
    public static final String RSPATH = "com/netscape/management/msgserv/panel/";
    public static final String RESTART_IMAP = "imap";
    public static final String RESTART_POP = "pop";
    public static final String RESTART_SMTP = "smtp";
    public static final String RESTART_HTTP = "http";
    public static final String RESTART_NNTP = "nntp";
    public static final String RESTART_ALL = "all";
    public static final String RESTART_REBOOT = "reboot";
    public static final String[] SET_FLAGS = new String[]{"imap", "pop", "smtp", "http", "nntp", "all", "reboot"};
    public static final String NO_RESPONSE_ERROR = "ERROR did not receive status from server";
    static ResourceSet _resource = new ResourceSet("com.netscape.management.msgserv.panel.console");
    static Help _help;
    public static final String CMDSTRING = "cmd";
    public static final String OBJSTRING = "object";
    public static final String COUNTSTRING = "count";
    public static final ImageIcon SERVERICON;
    public static final ImageIcon ENTRYICON;
    public static final ImageIcon LDAPICON;
    public static final ImageIcon FOLDERICON;
    public static final ImageIcon DOCICON;
    public static final ImageIcon WIZARDIMAGE;
    private static String _serverRoot;
    private static String _authID;
    private static String _authPasswd;
    private static String _readData;
    private static ConsoleInfo _ci;
    private static ImageIcon _minizedIcon;

    public static Hashtable sendQuery(String string) throws ServerErrorException {
        Hashtable hashtable;
        Vector vector = ExploreTask.explore(string);
        if (vector != null && vector.size() != 0 && (hashtable = (Hashtable)vector.elementAt(0)) != null) {
            String string2 = (String)hashtable.get("status");
            if (string2 != null && string2.startsWith("OK")) {
                return hashtable;
            }
            JOptionPane.showMessageDialog(PageUtil.getRootFrame(null), string2, "", 0);
            throw new ServerErrorException("status: " + string2);
        }
        throw new ServerErrorException("empty reply");
    }

    public static Hashtable sendQuery(String string, String[] stringArray, String[] stringArray2) throws ServerErrorException {
        Hashtable hashtable;
        Vector vector = ExploreTask.explore(string, stringArray, stringArray2);
        if (vector != null && (hashtable = (Hashtable)vector.elementAt(0)) != null) {
            String string2 = (String)hashtable.get("status");
            if (string2 != null && string2.startsWith("OK")) {
                return hashtable;
            }
            JOptionPane.showMessageDialog(PageUtil.getRootFrame(null), string2, "", 0);
            throw new ServerErrorException(string2);
        }
        throw new ServerErrorException();
    }

    public static String replyStatus(Vector vector) {
        Hashtable hashtable;
        String string;
        Object e;
        if (vector != null && (e = vector.elementAt(0)) instanceof Hashtable && (string = (String)(hashtable = (Hashtable)e).get("status")) != null) {
            return string;
        }
        return null;
    }

    public static void openBrowser(Frame frame, String string) {
        Browser browser = new Browser();
        boolean bl = browser.open(string);
        if (!bl) {
            FileDialog fileDialog = new FileDialog(frame, MsgUtil.getString("browser", "locate"), 0);
            BrowserFilter browserFilter = new BrowserFilter();
            fileDialog.setFilenameFilter(browserFilter);
            fileDialog.pack();
            PageUtil.placeWindow(fileDialog);
            fileDialog.show();
            String string2 = "\"" + fileDialog.getDirectory() + File.separator + fileDialog.getFile() + "\"";
            browser.setBrowser(string2);
            browser.open(string);
        }
    }

    public static final Framework getFramework(Component component) {
        if (component != null) {
            Container container = component.getParent();
            if (container instanceof Framework) {
                return (Framework)container;
            }
            while ((container = container.getParent()) != null) {
                if (!(container instanceof Framework)) continue;
                return (Framework)container;
            }
            return null;
        }
        return null;
    }

    public static final void setServerRoot(String string) {
        _serverRoot = string;
    }

    public static final String getServerRoot() {
        return _serverRoot;
    }

    public static final void setAuthID(String string) {
        _authID = string;
    }

    public static final String getAuthID() {
        return _authID;
    }

    public static final void setAuthPasswd(String string) {
        _authPasswd = string;
    }

    public static final String getAuthPasswd() {
        return _authPasswd;
    }

    public static final void setConsoleInfo(ConsoleInfo consoleInfo) {
        _ci = consoleInfo;
    }

    public static final ConsoleInfo getConsoleInfo() {
        return _ci;
    }

    public static final Object[] getLayout(String string) {
        String string2 = Locale.getDefault().getLanguage();
        String string3 = Locale.getDefault().getCountry();
        String string4 = RSPATH + string2 + "_" + string3 + "/" + string + ".rs";
        Object[] objectArray = null;
        try {
            objectArray = (Object[])Deserializer.readObject(new RemoteResource(string4).getAsStream());
        }
        catch (Exception exception) {
            string4 = RSPATH + string2 + "/" + string + ".rs";
            try {
                objectArray = (Object[])Deserializer.readObject(new RemoteResource(string4).getAsStream());
            }
            catch (Exception exception2) {
                string4 = RSPATH + string + ".rs";
                try {
                    objectArray = (Object[])Deserializer.readObject(new RemoteResource(string4).getAsStream());
                }
                catch (Exception exception3) {
                    Debug.println("Failed to read " + string4 + ". " + exception3);
                }
            }
        }
        return objectArray;
    }

    public static String getReadDataString() {
        if (_readData == null) {
            _readData = MsgUtil.getString("status", "readdata");
        }
        return _readData;
    }

    public static String getString(String string, String string2) {
        return _resource.getString(string, string2);
    }

    public static String[] getLangFriendlyNames(Object[] objectArray) {
        String[] stringArray = null;
        if (objectArray != null) {
            stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = MsgUtil.getString("label", (String)objectArray[i]);
                if (stringArray[i] != null) continue;
                stringArray[i] = " ";
            }
        }
        return stringArray;
    }

    public static ImageIcon getMinimizedIcon() {
        if (_minizedIcon == null) {
            _minizedIcon = new RemoteImage(MsgUtil.getString("icon", "minimize"));
        }
        return _minizedIcon;
    }

    public static void help(String string) {
        if (_help == null) {
            _help = new Help(new ResourceSet("com.netscape.management.msgserv.panel.help"));
        }
        _help.help(string, "help");
    }

    public static final String decodeMultiLine(String string) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '$') {
                    stringBuffer.append('\n');
                    continue;
                }
                if (c == '\\') {
                    if (i + 1 >= string.length() || i + 2 >= string.length()) continue;
                    if (string.charAt(i + 1) == '2' && string.charAt(i + 2) == '4') {
                        stringBuffer.append('$');
                        i += 2;
                        continue;
                    }
                    if (string.charAt(i + 1) == '5' && (string.charAt(i + 2) == 'c' || string.charAt(i + 2) == 'C')) {
                        stringBuffer.append('\\');
                        i += 2;
                        continue;
                    }
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static final String encodeMultiLine(String string) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    stringBuffer.append('$');
                    continue;
                }
                if (c == '$') {
                    stringBuffer.append("\\24");
                    continue;
                }
                if (c == '\\') {
                    stringBuffer.append("\\5C");
                    continue;
                }
                if (c == '\r') continue;
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static final int inTheMiddle(String string, String string2) {
        int n = string.indexOf(string2);
        int n2 = string.indexOf(string2 + string2);
        if (n > 0 && n < string.length() - 1 && n2 == -1) {
            return n;
        }
        return -1;
    }

    public static final int oneInTheMiddle(String string, String string2) {
        int n = string.indexOf(string2);
        if (n > 0 && n < string.length() - 1 && n == string.lastIndexOf(string2)) {
            return n;
        }
        return -1;
    }

    public static void dspMsg(String string, String string2, String string3, String string4, int n) {
        String string5 = MsgUtil.getString(string, string2);
        if (string5 == null) {
            string5 = string3;
        }
        JOptionPane.showMessageDialog(PageUtil.getRootFrame(null), string5, string4, n);
    }

    static {
        SERVERICON = new ImageIcon("com/netscape/management/client/topology/images/messaging16.gif");
        ENTRYICON = new ImageIcon("com/netscape/management/client/topology/images/admin16.gif");
        LDAPICON = new ImageIcon("com/netscape/management/client/topology/images/directory16.gif");
        FOLDERICON = new ImageIcon("com/netscape/management/client/topology/images/folder16.gif");
        DOCICON = new ImageIcon("com/netscape/management/client/topology/images/red-ball-small.gif");
        WIZARDIMAGE = new ImageIcon("com/netscape/management/msgserv/images/wizard.gif");
    }
}

