/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ens.test;

import com.iplanet.ens.test.EnsRigListener;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

class EnsRigSession {
    private TopicConnection _topicConnection;
    private TopicSession _topicSession;
    private EnsRigListener _listener;
    private Hashtable _subscribers;
    private TopicPublisher _topicPublisher;
    private String _sid;
    static Hashtable __topics = new Hashtable();

    public EnsRigSession(String string, TopicConnection topicConnection, TopicSession topicSession) throws JMSException {
        this._topicConnection = topicConnection;
        this._topicSession = topicSession;
        this._topicPublisher = topicSession.createPublisher(null);
        this._subscribers = new Hashtable();
        this._sid = string;
    }

    private static Topic getTopic(TopicSession topicSession, String string) throws JMSException {
        Topic topic = (Topic)__topics.get(string);
        if (topic == null) {
            topic = topicSession.createTopic(string);
        }
        return topic;
    }

    public TopicSession getTopicSession() {
        return this._topicSession;
    }

    public TopicConnection getTopicConnection() {
        return this._topicConnection;
    }

    public void close() throws JMSException {
        this._topicPublisher.close();
        this._topicSession.close();
        this._topicConnection.close();
    }

    public void addSubscriber(String string) throws JMSException {
        Topic topic = EnsRigSession.getTopic(this._topicSession, string);
        TopicSubscriber topicSubscriber = this._topicSession.createSubscriber(topic);
        EnsRigListener ensRigListener = new EnsRigListener(System.out, this._sid, string);
        topicSubscriber.setMessageListener((MessageListener)ensRigListener);
        __topics.put(string, topic);
    }

    public void addSubscriber(String string, String string2) throws JMSException {
        Topic topic = EnsRigSession.getTopic(this._topicSession, string);
        TopicSubscriber topicSubscriber = this._topicSession.createDurableSubscriber(topic, string2);
        EnsRigListener ensRigListener = new EnsRigListener(System.out, this._sid, string);
        topicSubscriber.setMessageListener((MessageListener)ensRigListener);
        __topics.put(string, topic);
    }

    public void removeSubscriber(String string) throws JMSException {
        TopicSubscriber topicSubscriber = (TopicSubscriber)this._subscribers.get(string);
        if (topicSubscriber != null) {
            this._subscribers.remove(string);
            topicSubscriber.close();
        }
    }

    public void publish(String string, String string2) throws JMSException {
        Topic topic = EnsRigSession.getTopic(this._topicSession, string);
        TextMessage textMessage = this._topicSession.createTextMessage(string2);
        textMessage.setText(string2);
        this._topicPublisher.publish(topic, (Message)textMessage);
    }
}

