#
# Copyright C 2002-2003 Sun Microsystems, Inc.
# All rights reserved. Use is subject to license terms.
#
# 
# Sun, Sun Microsystems, and the Sun logo are trademarks or registered
# trademarks of Sun Microsystems, Inc. in the United States and other
# countries.
# 
# Federal Acquisitions: Commercial Software--Government Users Subject to
# Standard License Terms and Conditions
#

#
# $Revision: 1.20.2.2 $ $Date: 2004/02/13 16:51:37 $
#

namespace eval dps52insUninstall {
    
    proc main { xName } {
	upvar $xName x
	
	set rc [expr 0]

	set baseFiles [list \
		etc/dpsBase.ldif \
		etc/dpsDefaultConfiguration.ldif \
		etc/dpsISIE.ldif \
		etc/dpsTopologyPlugin.ldif \
		etc/dpsNickname.ldif \
		etc/dpsTask.ldif \
		etc/tailor.txt \
		tmp/DPS.pid \
		tmp/adminport.txt \
		uninstallContext.tcl \
		upgrade/versions.conf \
		]

	set cwd [pwd]
	
	cd $x(root)
	
	if [catch {glob $x(instance)} instances] {
	} else {
	    if [catch {restartAdmin x} result] {
		error $result
	    }
	    foreach i $instances {
		set j [file join $x(root) $i]
		if [file isdirectory $j] {
		    execProgram x [list \
			    $x(tclsh) \
			    [file join $x(root) bin dps install script dpsClean.tcl] \
			    -host $x(cdsHost)\
			    -port $x(cdsPort)\
			    -passwd $x(password)\
			    -uid $x(userID) \
			    -user $x(user) \
			    -root $x(root) \
			    -serverid $i \
			    -delete \
			    -v \
			    ]
		    cd $j
		    
		    set scratchList [list]
		    
		    foreach k $baseFiles {
			lappend scratchList [file join $j $k]
		    }
		    
		    if [catch {glob dpsAsks*.txt} askList] {
		    } else {
			foreach k $askList {
			    lappend scratchList [file join $j $k]
			}
		    }
		    
		    cd logs
		    
		    if [catch {glob fwd.log*} logList] {
		    } else {
			foreach k $logList {
			    lappend scratchList [file join $x(root) $j logs $k]
			}
		    }
		    
		    cd [file join $x(root) alias]
		    
		    # Remove certx and key3 of this instance ONLY
		    if [catch {glob $i-*.db} aliasList] {
		    } else {
			foreach k $aliasList {
			    lappend scratchList [file join $x(root) alias $k]
			}
		    }
		    
		    foreach k $scratchList {
			if [file exists $k] {
			    if [file isfile $k] {
				if [catch {file delete -- $k} result] {
				    puts stderr "Problem removing $k"
				    puts stderr $result
				} else {
				    puts stdout "Removed $k"
				}
			    }
			}
		    }
		    
		    rmdir $j
		}
	    }
	    execProgram x [list \
		    [file join $x(java.home) bin [cmd java]] \
		    -cp [file join $x(root) setup dps dps52Setup.jar][javaSeperator][file join $x(root) java ldapjdk.jar][javaSeperator]. \
		    com.sun.dps.ldapUtil \
		    -cdshost $x(cdsHost)\
		    -cdsport $x(cdsPort) \
		    -config $x(suffix) \
		    -domain $x(domain) \
		    -fullhostname $x(fullHostname) \
		    -password $x(password) \
		    -user $x(user) \
		    ]
	    execProgram x [list \
		    [file join $x(java.home) bin [cmd java]] \
		    -cp [file join $x(root) setup dps dps52Setup.jar][javaSeperator][file join $x(root) java ldapjdk.jar][javaSeperator]. \
		    com.sun.dps.ldapUtil \
		    -cdshost $x(cdsHost) \
		    -cdsport $x(cdsPort) \
		    -domain $x(domain) \
		    -scrubdps \
		    -password $x(password) \
		    -user $x(user) \
		    ]
	}

	cd $cwd
	
	return $rc
    }
}
