/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.util;

import com.iplanet.idar.objectmodel.bean.CipherSetup;
import com.iplanet.idar.objectmodel.bean.EncryptionConfigData;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;

class MigrateConfig2 {
    static final int TLS = 4;
    static final int SSLv3 = 2;
    static final int SSLv2 = 1;
    static final String DEVICE = "internal (software)";
    static final String CERTNAME = "server-cert";
    private static final String ROOT = "o=NetscapeRoot";
    private static final String NEW_CONFIG_BASE = "ou=dar-config,o=NetscapeRoot";
    private static final String NEW_SYSTEM_ROOT = "ou=system,ou=dar-config,o=netscaperoot";
    private static final String NEW_LOG_ROOT = "ou=properties,ou=system,ou=dar-config,o=netscaperoot";
    String _host = null;
    int _port = 389;
    String _userDn = null;
    String _password = null;
    boolean _verbose = false;
    LDAPConnection _ld = null;
    String _sie = null;
    String _ldapcmddir = null;
    String _ldifdir = null;
    String _backup_file = null;
    String _n_sie = null;
    String _n_server_name = null;
    String _n_sys = null;
    String _n_prop_base = null;
    String _n_grp_base = null;
    String _n_action_base = null;
    String _n_rule_base = null;
    String _o_server_name = null;
    String _o_sys = null;
    String _o_prop_base = null;
    String _o_grp_base = null;
    String _o_action_base = null;
    String _o_rule_base = null;

    public MigrateConfig2(String string, int n, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        this._host = string;
        this._port = n;
        this._userDn = string2;
        this._password = string3;
        this._sie = string4;
        this._ldapcmddir = string5;
        this._ldifdir = string6;
        this._backup_file = string7;
        this._verbose = bl;
    }

    public void setHost(String string) {
        this._host = string;
    }

    public void setPort(int n) {
        this._port = n;
    }

    public void setUserDn(String string) {
        this._userDn = string;
    }

    public void setPassword(String string) {
        this._password = string;
    }

    boolean configUpgradedBefore() throws LDAPException {
        LDAPSearchResults lDAPSearchResults = null;
        lDAPSearchResults = this._ld.search(ROOT, 2, "(&(objectclass=nstopologyplugin)(cn=dpsconfigplugin))", null, false);
        return lDAPSearchResults != null && lDAPSearchResults.getCount() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean backupiDARConfig(String string) throws IOException, LDAPException {
        FileWriter fileWriter = null;
        LDAPSearchResults lDAPSearchResults = null;
        if (this._verbose) {
            System.out.println("Backing up configuration");
        }
        try {
            fileWriter = new FileWriter(string);
            if (this.configUpgradedBefore()) {
                fileWriter.write("Backup done by an earlier upgrade\n");
            } else {
                LDAPEntry lDAPEntry;
                if (this._verbose) {
                    System.out.println("Retrieving configuration entries");
                }
                lDAPSearchResults = this._ld.search(NEW_CONFIG_BASE, 2, "objectclass=*", null, false);
                if (this._verbose) {
                    System.out.println("Retrieved " + lDAPSearchResults.getCount() + " entries");
                }
                if (lDAPSearchResults != null) {
                    while (lDAPSearchResults.hasMoreElements()) {
                        lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                        this.write_ldif_entry(fileWriter, lDAPEntry);
                    }
                }
                if (this._verbose) {
                    System.out.println("Retriving topology entries");
                }
                lDAPSearchResults = this._ld.search(ROOT, 2, "(&(objectclass=nstopologyplugin)(cn=idarconfigplugin))", null, false);
                if (this._verbose) {
                    System.out.println("Retrieved " + lDAPSearchResults.getCount() + " entries");
                }
                if (lDAPSearchResults == null) {
                    boolean bl = false;
                    return bl;
                }
                while (lDAPSearchResults.hasMoreElements()) {
                    lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    this.write_ldif_entry(fileWriter, lDAPEntry);
                }
                if (!this.saveiDARInstances(fileWriter)) {
                    System.out.println("Failed to locate iDAR instances");
                    boolean bl = false;
                    return bl;
                }
            }
            if (this._verbose) {
                System.out.println("Backup complete");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (fileWriter != null) {
                ((Writer)fileWriter).close();
            }
        }
    }

    boolean saveiDARInstances(Writer writer) throws LDAPException, IOException {
        LDAPEntry lDAPEntry;
        int n;
        LDAPSearchResults lDAPSearchResults = null;
        LDAPSearchResults lDAPSearchResults2 = null;
        if (this._verbose) {
            System.out.println("Retriving all entries under netscapeRoot");
        }
        lDAPSearchResults = this._ld.search(ROOT, 2, "objectclass=*", null, false);
        if (this._verbose) {
            System.out.println("Retrieved " + lDAPSearchResults.getCount() + " entries");
        }
        if (this._verbose) {
            System.out.println("Retriving idar instance entries");
        }
        lDAPSearchResults2 = this._ld.search(ROOT, 2, "objectclass=nsdarserver", null, false);
        if (this._verbose) {
            System.out.println("Retrieved " + lDAPSearchResults2.getCount() + " entries");
        }
        LDAPEntry[] lDAPEntryArray = null;
        if (lDAPSearchResults2 != null) {
            lDAPEntryArray = new LDAPEntry[lDAPSearchResults2.getCount()];
            n = 0;
            while (lDAPSearchResults2.hasMoreElements()) {
                lDAPEntryArray[n] = (LDAPEntry)lDAPSearchResults2.nextElement();
                ++n;
            }
        }
        if (lDAPSearchResults != null && lDAPSearchResults2 != null) {
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry2 = (LDAPEntry)lDAPSearchResults.nextElement();
                for (int i = 0; i < lDAPEntryArray.length; ++i) {
                    lDAPEntry = null;
                    lDAPEntry = lDAPEntryArray[i];
                    if (LDAPDN.equals((String)lDAPEntry2.getDN(), (String)ROOT) || !MigrateConfig2.a_subordinate_to_b(lDAPEntry2.getDN(), lDAPEntry.getDN()) && !MigrateConfig2.a_superior_to_b(lDAPEntry2.getDN(), lDAPEntry.getDN())) continue;
                    if (this._verbose) {
                        System.out.println("Writing " + lDAPEntry2.getDN() + "to backup");
                    }
                    this.write_ldif_entry(writer, lDAPEntry2);
                }
            }
        }
        if (lDAPEntryArray != null) {
            for (n = 0; n < lDAPEntryArray.length; ++n) {
                String string = new String("cn=Netscape Administration Server");
                lDAPEntry = LDAPDN.explodeDN((String)lDAPEntryArray[n].getDN(), (boolean)false);
                for (int i = 2; i < ((LDAPEntry)lDAPEntry).length; ++i) {
                    string = string.concat(",");
                    string = string.concat((String)lDAPEntry[i]);
                }
                LDAPSearchResults lDAPSearchResults3 = null;
                if (this._verbose) {
                    System.out.println("Trying to get admin server results for sie " + lDAPEntryArray[n].getDN());
                }
                if (this._verbose) {
                    System.out.println("Searching at base " + string);
                }
                try {
                    lDAPSearchResults3 = this._ld.search(string, 2, "objectclass=*", null, false);
                    if (this._verbose) {
                        System.out.println("Retrieved " + lDAPSearchResults3.getCount() + " entries");
                    }
                    while (lDAPSearchResults3.hasMoreElements()) {
                        LDAPEntry lDAPEntry3 = (LDAPEntry)lDAPSearchResults3.nextElement();
                        this.write_ldif_entry(writer, lDAPEntry3);
                    }
                    continue;
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() != 32) {
                        throw lDAPException;
                    }
                    if (!this._verbose) continue;
                    System.out.println("No system entries found");
                }
            }
        }
        return true;
    }

    public boolean deleteSubtree(String string) throws LDAPException {
        LDAPSearchResults lDAPSearchResults = null;
        lDAPSearchResults = this._ld.search(string, 1, "objectclass=*", null, false);
        if (lDAPSearchResults != null) {
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string2 = lDAPEntry.getDN();
                this.deleteSubtree(string2);
            }
        }
        if (this._verbose) {
            System.out.println("Deleting " + string);
        }
        this._ld.delete(string);
        return true;
    }

    boolean putServerGroupSubtree() throws IOException, InterruptedException {
        Process process;
        int n;
        String string = new String(this._ldapcmddir + "/ldapadd" + " -h " + this._host + " -p " + this._port + " -D " + this._userDn + " -w " + this._password + " -f " + this._ldifdir + "/dpsBase.ldif");
        if (this._verbose) {
            System.out.println(string);
        }
        if ((n = (process = Runtime.getRuntime().exec(string)).waitFor()) != 0) {
            System.out.println("Failed with code " + n);
            return false;
        }
        string = new String(this._ldapcmddir + "/ldapadd" + " -h " + this._host + " -p " + this._port + " -D " + this._userDn + " -w " + this._password + " -f " + this._ldifdir + "/dpsTask.ldif");
        if (this._verbose) {
            System.out.println(string);
        }
        if ((n = (process = Runtime.getRuntime().exec(string)).waitFor()) != 0) {
            System.out.println("Failed with code " + n);
            return false;
        }
        return true;
    }

    boolean updatePluginEntry() throws IOException, InterruptedException, LDAPException {
        Process process;
        int n;
        Object object;
        String[] stringArray = LDAPDN.explodeDN((String)this._n_sie, (boolean)false);
        String string = new String(stringArray[4]);
        for (int i = 5; i < stringArray.length; ++i) {
            string = string.concat(",");
            string = string.concat(stringArray[i]);
        }
        LDAPSearchResults lDAPSearchResults = this._ld.search(string, 2, "(&(objectclass=nstopologyplugin)(cn=dpsconfigplugin))", null, false);
        if (lDAPSearchResults != null && lDAPSearchResults.getCount() == 1) {
            object = lDAPSearchResults.next();
            if (this._verbose) {
                System.out.println("Deleting dpsconfigplugin entry " + object.getDN());
            }
            this._ld.delete(object.getDN());
        }
        if (this._verbose) {
            System.out.println("Searching for the idarconfigplugin entry");
        }
        if ((lDAPSearchResults = this._ld.search(string, 2, "(&(objectclass=nstopologyplugin)(cn=idarconfigplugin))", null, false)) != null && lDAPSearchResults.getCount() == 1) {
            object = lDAPSearchResults.next();
            if (this._verbose) {
                System.out.println("Deleting idarconfigplugin entry " + object.getDN());
            }
            this._ld.delete(object.getDN());
        }
        if (this._verbose) {
            System.out.println("Adding the plugin entry.");
        }
        object = new String(this._ldapcmddir + "/ldapadd" + " -h " + this._host + " -p " + this._port + " -D " + this._userDn + " -w " + this._password + " -f " + this._ldifdir + "/dpsTopologyPlugin.ldif");
        if (this._verbose) {
            System.out.println((String)object);
        }
        return (n = (process = Runtime.getRuntime().exec((String)object)).waitFor()) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean convertiDARToDps() throws LDAPException, IOException {
        boolean bl;
        block24: {
            block23: {
                block21: {
                    block20: {
                        boolean bl2;
                        block18: {
                            boolean bl3;
                            block17: {
                                Object var1_1 = null;
                                if (this._verbose) {
                                    System.out.println("Converting configuration");
                                }
                                try {
                                    block22: {
                                        block19: {
                                            this._ld = new LDAPConnection();
                                            this._ld.connect(this._host, this._port);
                                            if (this._verbose) {
                                                System.out.println("Connected to " + this._host + ":" + this._port);
                                            }
                                            this._ld.setOption(20, (Object)new Integer(0));
                                            this._ld.authenticate(3, this._userDn, this._password);
                                            if (this._verbose) {
                                                System.out.println("Authenticated to " + this._host + ":" + this._port);
                                            }
                                            if (!this.backupiDARConfig(this._backup_file)) {
                                                System.out.println("Could not backup configuration");
                                                bl3 = false;
                                                Object var7_5 = null;
                                                if (this._ld == null) return bl3;
                                                break block17;
                                            }
                                            this.create52Structure();
                                            if (!this.set_old_variables()) {
                                                bl2 = false;
                                                break block18;
                                            }
                                            String[] stringArray = LDAPDN.explodeDN((String)this._sie, (boolean)false);
                                            String string = new String(stringArray[1]);
                                            for (bl = 2 != 0; bl < stringArray.length; string = string.concat(stringArray[bl]), bl += 1) {
                                                string = string.concat(", ");
                                            }
                                            if (this._verbose) {
                                                System.out.println("Deleting subtree ... " + string);
                                            }
                                            this.deleteSubtree(string);
                                            if (this._verbose) {
                                                System.out.println("Deleted");
                                            }
                                            try {
                                                if (this.putServerGroupSubtree()) break block19;
                                                System.out.println("Could not update server group subtree");
                                                bl = false;
                                                break block20;
                                            }
                                            catch (Exception exception) {
                                                System.out.println("Could not update server group subtree");
                                                System.out.println(exception.getMessage());
                                                exception.printStackTrace();
                                                boolean bl4 = false;
                                                Object var7_8 = null;
                                                if (this._ld == null) return bl4;
                                                this._ld.disconnect();
                                                return bl4;
                                            }
                                        }
                                        if (!this.set_new_variables()) {
                                            bl = false;
                                            break block21;
                                        }
                                        this.moveConfiguration();
                                        try {
                                            if (this.updatePluginEntry()) break block22;
                                            System.out.println("Could not update plugin entry");
                                            bl = false;
                                            break block23;
                                        }
                                        catch (Exception exception) {
                                            System.out.println("Could not update plugin entry");
                                            System.out.println(exception.getMessage());
                                            exception.printStackTrace();
                                            boolean bl5 = false;
                                            Object var7_11 = null;
                                            if (this._ld == null) return bl5;
                                            this._ld.disconnect();
                                            return bl5;
                                        }
                                    }
                                    bl = true;
                                    break block24;
                                }
                                catch (Throwable throwable) {
                                    Object var7_13 = null;
                                    if (this._ld == null) throw throwable;
                                    this._ld.disconnect();
                                    throw throwable;
                                }
                            }
                            this._ld.disconnect();
                            return bl3;
                        }
                        Object var7_6 = null;
                        if (this._ld == null) return bl2;
                        this._ld.disconnect();
                        return bl2;
                    }
                    Object var7_7 = null;
                    if (this._ld == null) return bl;
                    this._ld.disconnect();
                    return bl;
                }
                Object var7_9 = null;
                if (this._ld == null) return bl;
                this._ld.disconnect();
                return bl;
            }
            Object var7_10 = null;
            if (this._ld == null) return bl;
            this._ld.disconnect();
            return bl;
        }
        Object var7_12 = null;
        if (this._ld == null) return bl;
        this._ld.disconnect();
        return bl;
    }

    static String get_new_ssl_version(String string) {
        if (string == null) {
            return null;
        }
        try {
            int n = Integer.parseInt(string);
            switch (n) {
                case 20: {
                    return String.valueOf(1);
                }
                case 30: {
                    return String.valueOf(2);
                }
                case 23: {
                    return String.valueOf(3);
                }
                case 31: {
                    return String.valueOf(4);
                }
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return null;
        }
    }

    boolean moveGlobalConfiguration() throws LDAPException {
        if (this._verbose) {
            System.out.println("Reading system entry " + this._o_sys);
        }
        LDAPEntry lDAPEntry = this._ld.read(this._o_sys);
        if (this._verbose) {
            System.out.println("Removing ssl parameters...");
        }
        String string = this.get_attr_val(lDAPEntry, "ids-proxy-con-ssl-cert");
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        lDAPAttributeSet.remove("ids-proxy-con-ssl-cert");
        lDAPAttributeSet.remove("ids-proxy-con-ssl-key");
        lDAPAttributeSet.remove("ids-proxy-con-ssl-cafile");
        String string2 = MigrateConfig2.get_new_ssl_version(this.get_attr_val(lDAPEntry, "ids-proxy-con-server-ssl-version"));
        if (string2 != null) {
            lDAPAttributeSet.remove("ids-proxy-con-server-ssl-version");
            lDAPAttributeSet.add(new LDAPAttribute("ids-proxy-con-server-ssl-version", string2));
        }
        if ((string2 = MigrateConfig2.get_new_ssl_version(this.get_attr_val(lDAPEntry, "ids-proxy-con-client-ssl-version"))) != null) {
            lDAPAttributeSet.remove("ids-proxy-con-client-ssl-version");
            lDAPAttributeSet.add(new LDAPAttribute("ids-proxy-con-client-ssl-version", string2));
        }
        String string3 = new String(NEW_LOG_ROOT);
        if (this._verbose) {
            System.out.println("Setting global-base attribute to " + string3);
        }
        lDAPAttributeSet.add(new LDAPAttribute("ids-proxy-sch-global-base", string3));
        String[] stringArray = LDAPDN.explodeDN((String)this._n_sys, (boolean)false);
        String string4 = stringArray[0];
        int n = string4.indexOf(61);
        string4 = string4.substring(n + 1);
        if (this._verbose) {
            System.out.println("Setting config-name to be " + string4);
        }
        lDAPAttributeSet.remove("ids-proxy-con-Config-Name");
        lDAPAttributeSet.add(new LDAPAttribute("ids-proxy-con-Config-Name", string4));
        LDAPEntry lDAPEntry2 = new LDAPEntry(this._n_sys, lDAPAttributeSet);
        try {
            if (this._verbose) {
                System.out.println("Adding system entry at " + this._n_sys);
            }
            this._ld.add(lDAPEntry2);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 68) {
                throw lDAPException;
            }
            if (this._verbose) {
                System.out.println("Entry already exists");
            }
            return true;
        }
        if (string != null) {
            this.write_ssl_configuration();
        }
        return true;
    }

    void write_ssl_configuration() throws LDAPException {
        EncryptionConfigData encryptionConfigData = new EncryptionConfigData();
        encryptionConfigData.setSslServerOn(true);
        encryptionConfigData.setSsl3On(true);
        encryptionConfigData.setSsl2On(true);
        encryptionConfigData.setCipherPrefs("+fortezza,+fortezza_null,+fortezza_rc4_128_sha,+rsa_3des_sha,+rsa_des_sha,+rsa_fips_3des_sha,+rsa_fips_des_sha,-rsa_null_md5,+rsa_rc2_40_md5,+rsa_rc4_128_md5,+rsa_rc4_40_md5,+rsa_rc4_des40_sha,+rsa_rc4_128_sha");
        encryptionConfigData.setCipherPrefsTLS("+tls_rsa_export1024_with_des_cbc_sha,+tls_rsa_export1024_with_rc4_56_sha");
        encryptionConfigData.setCipherPrefsSslV2("+rc4,+rc4export,+rc2,+rc2export,+des,+desede3");
        CipherSetup cipherSetup = encryptionConfigData.findOrCreateCipherSetup("RSA");
        cipherSetup.setEnabled(true);
        cipherSetup.setSelectedDevice(DEVICE);
        cipherSetup.setSelectedCertificate(CERTNAME);
        encryptionConfigData.writeToDirectory(this._ld, this._n_sie);
    }

    LDAPSearchResults get_objects(String string, String string2) throws LDAPException {
        return this._ld.search(string, 1, string2, null, false);
    }

    boolean addBelongsTo(LDAPEntry lDAPEntry) throws LDAPException {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-sch-belongs-to");
        String[] stringArray = lDAPAttribute.getStringValueArray();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(this._n_server_name)) continue;
            bl = true;
        }
        if (!bl) {
            this._ld.modify(lDAPEntry.getDN(), new LDAPModification(0, new LDAPAttribute("ids-proxy-sch-belongs-to", this._n_server_name)));
        }
        return true;
    }

    boolean moveObjects(LDAPSearchResults lDAPSearchResults, LDAPSearchResults lDAPSearchResults2, String string) throws LDAPException {
        LDAPEntry[] lDAPEntryArray = null;
        if (lDAPSearchResults2 != null) {
            lDAPEntryArray = new LDAPEntry[lDAPSearchResults2.getCount()];
            for (int i = 0; i < lDAPSearchResults2.getCount(); ++i) {
                lDAPEntryArray[i] = lDAPSearchResults2.next();
            }
        }
        while (lDAPSearchResults.hasMoreElements()) {
            LDAPEntry lDAPEntry;
            Object object;
            LDAPEntry lDAPEntry2 = lDAPSearchResults.next();
            if (this._verbose) {
                System.out.println("Moving entry " + lDAPEntry2.getDN());
            }
            LDAPAttribute lDAPAttribute = lDAPEntry2.getAttribute("ids-proxy-con-name");
            String[] stringArray = lDAPAttribute.getStringValueArray();
            String string2 = stringArray[0];
            LDAPEntry lDAPEntry3 = null;
            for (int i = 0; i < lDAPEntryArray.length; ++i) {
                object = lDAPEntryArray[i].getAttribute("ids-proxy-con-Name");
                lDAPEntry = object.getStringValueArray();
                for (int j = 0; j < ((String[])lDAPEntry).length; ++j) {
                    if (!lDAPEntry[j].equals(string2)) continue;
                    if (this._verbose) {
                        System.out.println("Found matching entry " + lDAPEntryArray[i].getDN());
                    }
                    lDAPEntry3 = lDAPEntryArray[i];
                }
            }
            if (lDAPEntry3 != null) {
                this.addBelongsTo(lDAPEntry3);
                continue;
            }
            LDAPAttributeSet lDAPAttributeSet = lDAPEntry2.getAttributeSet();
            object = new String("ids-proxy-con-Name=" + string2 + "," + string);
            lDAPEntry = new LDAPEntry((String)object, lDAPAttributeSet);
            if (this._verbose) {
                System.out.println("Adding entry " + (String)object);
            }
            this._ld.add(lDAPEntry);
            lDAPAttribute = lDAPEntry2.getAttribute("ids-proxy-sch-belongs-to");
            stringArray = lDAPAttribute.getStringValueArray();
            if (stringArray.length == 1) {
                if (this._verbose) {
                    System.out.println("Deleting entry " + lDAPEntry2.getDN());
                }
                this._ld.delete(lDAPEntry2.getDN());
                continue;
            }
            if (this._verbose) {
                System.out.println("Modifying belongs-to of entry " + lDAPEntry2.getDN());
            }
            this._ld.modify(lDAPEntry2.getDN(), new LDAPModification(1, new LDAPAttribute("ids-proxy-sch-belongs-to", this._o_server_name)));
        }
        return true;
    }

    boolean fixObject(LDAPSearchResults lDAPSearchResults) throws LDAPException {
        if (this._verbose) {
            System.out.println("Fixing objects. Number of objects " + lDAPSearchResults.getCount());
        }
        while (lDAPSearchResults.hasMoreElements()) {
            LDAPEntry lDAPEntry = lDAPSearchResults.next();
            if (this._verbose) {
                System.out.println("Fixing " + lDAPEntry.getDN());
            }
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            lDAPModificationSet.add(1, new LDAPAttribute("ids-proxy-sch-belongs-to", this._o_server_name));
            lDAPModificationSet.add(0, new LDAPAttribute("ids-proxy-sch-belongs-to", this._n_server_name));
            this._ld.modify(lDAPEntry.getDN(), lDAPModificationSet);
        }
        return true;
    }

    boolean fixProperties() throws LDAPException {
        return this.fixObject(this.get_objects(this._n_prop_base, "(&(objectclass=ids-proxy-sch-Property)(ids-proxy-sch-belongs-to=" + this._o_server_name + "))"));
    }

    boolean fixRules() throws LDAPException {
        return this.fixObject(this.get_objects(this._n_rule_base, "(&(objectclass=ids-proxy-sch-Rule)(ids-proxy-sch-belongs-to=" + this._o_server_name + "))"));
    }

    boolean fixActions() throws LDAPException {
        return this.fixObject(this.get_objects(this._n_action_base, "(&(objectclass=ids-proxy-sch-Action)(ids-proxy-sch-belongs-to=" + this._o_server_name + "))"));
    }

    boolean fixGroups() throws LDAPException {
        return this.fixObject(this.get_objects(this._n_grp_base, "(&(objectclass=ids-proxy-sch-Group)(ids-proxy-sch-belongs-to=" + this._o_server_name + "))"));
    }

    boolean moveConfiguration() throws LDAPException {
        if (!this.moveGlobalConfiguration()) {
            return false;
        }
        if (this._verbose) {
            System.out.println("Fixing configuration entries belongs-to attribute");
        }
        if (!this.fixRules()) {
            return false;
        }
        if (!this.fixActions()) {
            return false;
        }
        if (!this.fixGroups()) {
            return false;
        }
        if (this._verbose) {
            System.out.println("Moving log property");
        }
        LDAPSearchResults lDAPSearchResults = this.get_objects(this._o_prop_base, "(&(objectclass=ids-proxy-sch-LogProperty)(ids-proxy-sch-belongs-to=" + this._o_server_name + "))");
        LDAPSearchResults lDAPSearchResults2 = this.get_objects(NEW_LOG_ROOT, "(objectclass=ids-proxy-sch-LogProperty)");
        this.moveObjects(lDAPSearchResults, lDAPSearchResults2, NEW_LOG_ROOT);
        return this.fixProperties();
    }

    boolean set_old_variables() throws LDAPException {
        LDAPEntry lDAPEntry = this._ld.read(this._sie);
        if (lDAPEntry == null) {
            return false;
        }
        this._o_server_name = this.get_attr_val(lDAPEntry, "ids-proxy-con-Server-Name");
        if (this._o_server_name == null) {
            return false;
        }
        this._o_grp_base = this.get_attr_val(lDAPEntry, "ids-proxy-sch-Group-Base");
        if (this._o_grp_base == null) {
            return false;
        }
        this._o_prop_base = this.get_attr_val(lDAPEntry, "ids-proxy-sch-Property-Base");
        this._o_action_base = this.get_attr_val(lDAPEntry, "ids-proxy-sch-Action-Base");
        this._o_rule_base = this.get_attr_val(lDAPEntry, "ids-proxy-sch-Rule-Base");
        this._o_sys = this.get_attr_val(lDAPEntry, "ids-proxy-sch-Global-Config-DN");
        if (this._o_sys == null) {
            return false;
        }
        if (this._verbose) {
            System.out.println("Old Sie " + this._sie);
            System.out.println("Old Server Name " + this._o_server_name);
            System.out.println("Old Group Base " + this._o_grp_base);
            System.out.println("Old Prop Base " + this._o_prop_base);
            System.out.println("Old Action Base " + this._o_action_base);
            System.out.println("Old Rule Base " + this._o_rule_base);
            System.out.println("Old System Entry " + this._o_sys);
        }
        return true;
    }

    boolean set_new_variables() throws LDAPException {
        LDAPSearchResults lDAPSearchResults;
        String[] stringArray = LDAPDN.explodeDN((String)this._sie, (boolean)false);
        String string = new String(stringArray[2]);
        for (int i = 3; i < stringArray.length; ++i) {
            string = string.concat(",");
            string = string.concat(stringArray[i]);
        }
        if (this._verbose) {
            System.out.println("Searching at base " + string);
        }
        if ((lDAPSearchResults = this._ld.search(string, 2, "objectclass=ids-proxy-sch-LDAPProxy", null, false)) == null || lDAPSearchResults.getCount() != 1) {
            return false;
        }
        LDAPEntry lDAPEntry = lDAPSearchResults.next();
        this._n_sie = lDAPEntry.getDN();
        LDAPEntry lDAPEntry2 = this._ld.read(this._n_sie);
        if (lDAPEntry2 == null) {
            return false;
        }
        this._n_server_name = this.get_attr_val(lDAPEntry2, "ids-proxy-con-Server-Name");
        if (this._n_server_name == null) {
            return false;
        }
        this._n_grp_base = this.get_attr_val(lDAPEntry2, "ids-proxy-sch-Group-Base");
        if (this._n_grp_base == null) {
            return false;
        }
        this._n_prop_base = this.get_attr_val(lDAPEntry2, "ids-proxy-sch-Property-Base");
        this._n_action_base = this.get_attr_val(lDAPEntry2, "ids-proxy-sch-Action-Base");
        this._n_rule_base = this.get_attr_val(lDAPEntry2, "ids-proxy-sch-Rule-Base");
        this._n_sys = this.get_attr_val(lDAPEntry2, "ids-proxy-sch-Global-Config-DN");
        if (this._n_sys == null) {
            return false;
        }
        if (this._verbose) {
            System.out.println("New Sie " + this._n_sie);
            System.out.println("New Server Name " + this._n_server_name);
            System.out.println("New Group Base " + this._n_grp_base);
            System.out.println("New Prop Base " + this._n_prop_base);
            System.out.println("New Action Base " + this._n_action_base);
            System.out.println("New Rule Base " + this._n_rule_base);
            System.out.println("New System Entry " + this._n_sys);
        }
        return true;
    }

    String get_attr_val(LDAPEntry lDAPEntry, String string) {
        String[] stringArray = null;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute != null && (stringArray = lDAPAttribute.getStringValueArray()).length > 0) {
            return stringArray[0];
        }
        return null;
    }

    void create_ou_entry(String string, String string2) throws LDAPException {
        block3: {
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            String[] stringArray = new String[]{"top", "ids-proxy-top", "organizationalUnit"};
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", stringArray));
            lDAPAttributeSet.add(new LDAPAttribute("ou", string2));
            try {
                this._ld.add(new LDAPEntry(string, lDAPAttributeSet));
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 68) {
                    System.out.println("Ou " + string + " already exists");
                    throw lDAPException;
                }
                if (!this._verbose) break block3;
                System.out.println("Added ou" + string);
            }
        }
    }

    private void create52Structure() throws LDAPException {
        this.create_ou_entry(NEW_SYSTEM_ROOT, "system");
        this.create_ou_entry(NEW_LOG_ROOT, "properties");
    }

    private void write_ldif_entry(Writer writer, LDAPEntry lDAPEntry) throws IOException {
        writer.write("dn: " + lDAPEntry.getDN());
        writer.write("\n");
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            Enumeration enumeration2 = lDAPAttribute.getStringValues();
            while (enumeration2.hasMoreElements()) {
                writer.write(lDAPAttribute.getName() + ": ");
                writer.write((String)enumeration2.nextElement());
                writer.write("\n");
            }
        }
        writer.write("\n");
    }

    private static boolean a_subordinate_to_b(String string, String string2) {
        String string3 = LDAPDN.normalize((String)string);
        String string4 = LDAPDN.normalize((String)string2);
        String[] stringArray = LDAPDN.explodeDN((String)string3, (boolean)false);
        String[] stringArray2 = LDAPDN.explodeDN((String)string4, (boolean)false);
        if (stringArray2.length > stringArray.length) {
            return false;
        }
        int n = stringArray.length - 1;
        for (int i = stringArray2.length - 1; i >= 0; --i) {
            if (!stringArray2[i].equals(stringArray[n])) {
                return false;
            }
            --n;
        }
        return true;
    }

    private static boolean a_superior_to_b(String string, String string2) {
        String[] stringArray;
        String string3 = LDAPDN.normalize((String)string);
        String string4 = LDAPDN.normalize((String)string2);
        String[] stringArray2 = LDAPDN.explodeDN((String)string3, (boolean)false);
        if (stringArray2.length > (stringArray = LDAPDN.explodeDN((String)string4, (boolean)false)).length) {
            return false;
        }
        int n = stringArray2.length - 1;
        int n2 = stringArray.length - 1;
        while (n >= 0) {
            if (!stringArray2[n].equals(stringArray[n2])) {
                return false;
            }
            --n;
            --n2;
        }
        return true;
    }

    private static void usage() {
        System.out.println("usage:  MigrateConfig2 <options>");
        System.out.println("options:");
        System.out.println("-C DN of the sie to migrate");
        System.out.println("-h directory host name (localhost if unspecified)");
        System.out.println("-p directory port number (389 if unspecified)");
        System.out.println("-D directory user dn (anonymous bind if unspecified)");
        System.out.println("-w directory user password (anonymous bind if unspecified)");
        System.out.println("-E directory where ldapadd can be found");
        System.out.println("-L directory where ldif files can be found");
        System.out.println("-B backup ldif file");
        System.out.println("-v");
    }

    private static MigrateConfig2 processArguements(String[] stringArray) {
        String string = null;
        int n = 389;
        String string2 = "";
        String string3 = "";
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        boolean bl = false;
        MigrateConfig2 migrateConfig2 = null;
        boolean bl2 = true;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            String string8 = stringArray[i];
            if (!string8.startsWith("-")) {
                bl2 = false;
                break;
            }
            String string9 = null;
            if (i < stringArray.length - 1) {
                string9 = stringArray[i + 1];
            }
            if (string8.trim().equals("-h")) {
                string = string9;
                continue;
            }
            if (string8.trim().equals("-p")) {
                try {
                    n = Integer.parseInt(string9);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("ERROR:  illegal port " + string9);
                    numberFormatException.printStackTrace();
                    return null;
                }
            }
            if (string8.trim().equals("-D")) {
                string2 = string9;
                continue;
            }
            if (string8.trim().equals("-w")) {
                string3 = string9;
                continue;
            }
            if (string8.trim().equals("-v")) {
                bl = true;
                --i;
                continue;
            }
            if (string8.trim().equals("-C")) {
                string4 = string9;
                continue;
            }
            if (string8.trim().equals("-E")) {
                string5 = string9;
                continue;
            }
            if (string8.trim().equals("-L")) {
                string6 = string9;
                continue;
            }
            if (string8.trim().equals("-B")) {
                string7 = string9;
                continue;
            }
            return null;
        }
        if (string == null || string4 == null || string5 == null || string6 == null || string7 == null) {
            return null;
        }
        migrateConfig2 = new MigrateConfig2(string, n, string2, string3, string4, string5, string6, string7, bl);
        return migrateConfig2;
    }

    public static void main(String[] stringArray) {
        MigrateConfig2 migrateConfig2 = MigrateConfig2.processArguements(stringArray);
        if (migrateConfig2 == null) {
            MigrateConfig2.usage();
            return;
        }
        try {
            if (!migrateConfig2.convertiDARToDps()) {
                System.out.println("Conversion failed");
            }
        }
        catch (Exception exception) {
            System.out.println("Caught exception. Message : " + exception.getMessage());
            System.out.println("Migration failed");
            exception.printStackTrace();
        }
    }
}

