/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.util;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import sun.misc.BASE64Decoder;

class IDARGetLDAPConfig {
    private static final int MAX_LINE_SZ = 1024;
    private String _tailorFileName = null;
    private Writer _ldif = null;
    private ConfAccessProp[] _access_props;

    public IDARGetLDAPConfig(String string, String string2) throws IOException {
        this._tailorFileName = string;
        this._ldif = new FileWriter(string2);
        this._access_props = new ConfAccessProp[32];
    }

    static String get_attr_val(LDAPEntry lDAPEntry, String string) {
        String[] stringArray = null;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute != null && (stringArray = lDAPAttribute.getStringValueArray()).length > 0) {
            return stringArray[0];
        }
        return null;
    }

    boolean read_ssl_configuration(LDAPConnection lDAPConnection, String string) throws IOException {
        String string2 = "cn=configuration," + string;
        try {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string2, 2, "objectclass=*", null, false);
            if (lDAPSearchResults != null) {
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    this.write_ldif_entry(lDAPEntry);
                }
            }
        }
        catch (LDAPException lDAPException) {
            return false;
        }
        return true;
    }

    public boolean writeconfig() throws IOException {
        if (!this.get_configuration()) {
            System.err.println("Unable to process startup configuration file.");
            return false;
        }
        int n = 0;
        while (this._access_props[n] != null) {
            ConfAccessProp confAccessProp = this._access_props[n];
            if (!confAccessProp._url.regionMatches(true, 0, "ldap", 0, 4)) {
                System.err.println("Not a ldap URL " + this._access_props[n]._url + " ignoring...");
                ++n;
            } else {
                Object object;
                String[] stringArray;
                LDAPAttribute lDAPAttribute;
                LDAPSearchResults lDAPSearchResults;
                LDAPConnection lDAPConnection;
                LDAPUrl lDAPUrl;
                block43: {
                    lDAPUrl = new LDAPUrl(confAccessProp._url);
                    lDAPConnection = new LDAPConnection();
                    try {
                        lDAPConnection.connect(lDAPUrl.getHost(), lDAPUrl.getPort());
                        lDAPConnection.setOption(20, (Object)new Integer(0));
                    }
                    catch (LDAPException lDAPException) {
                        System.err.println("Error connecting to host: " + lDAPUrl.getHost());
                        System.err.println(lDAPException.toString());
                        ++n;
                        continue;
                    }
                    if (confAccessProp._sasl_mechanism == 0) {
                        try {
                            lDAPConnection.authenticate(3, confAccessProp._bind_dn, confAccessProp._passwd);
                            break block43;
                        }
                        catch (LDAPException lDAPException) {
                            System.err.println("Error binding to host: " + lDAPUrl.getHost());
                            System.err.println(lDAPException.toString());
                            ++n;
                            try {
                                lDAPConnection.disconnect();
                            }
                            catch (LDAPException lDAPException2) {}
                            continue;
                        }
                    }
                    System.err.println("This utility does not support SASL at this time.");
                    ++n;
                    continue;
                }
                try {
                    lDAPSearchResults = lDAPConnection.search(lDAPUrl.getDN(), 0, "objectclass=ids-proxy-sch-LDAPProxy", null, false);
                }
                catch (LDAPException lDAPException) {
                    System.err.print("Error encountered while searching for ids-proxy-sch-LDAPProxy object.");
                    System.err.println("Base was: " + lDAPUrl.getDN());
                    System.err.println(lDAPException.toString());
                    ++n;
                    try {
                        lDAPConnection.disconnect();
                    }
                    catch (LDAPException lDAPException3) {}
                    continue;
                }
                if (lDAPSearchResults.getCount() != 1) {
                    System.err.println("Did not find ids-proxy-sch-LDAPProxy object. DN was: " + lDAPUrl.getDN());
                    ++n;
                    continue;
                }
                LDAPEntry lDAPEntry = null;
                try {
                    lDAPEntry = lDAPSearchResults.next();
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                this.write_ldif_entry(lDAPEntry);
                if (!this.read_ssl_configuration(lDAPConnection, lDAPUrl.getDN())) {
                    System.err.println("Error encountered while reading SSL parameters");
                    ++n;
                    try {
                        lDAPConnection.disconnect();
                    }
                    catch (LDAPException lDAPException) {}
                    continue;
                }
                String string = null;
                try {
                    lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-sch-Global-Config-DN");
                    stringArray = lDAPAttribute.getStringValueArray();
                    if (stringArray.length > 1) {
                        System.err.println("Invalid configuration: more than one value found for ids-proxy-sch-Global-Config-DN.");
                        ++n;
                        continue;
                    }
                    lDAPSearchResults = lDAPConnection.search(stringArray[0], 0, "objectclass=ids-proxy-sch-GlobalConfiguration", null, false);
                    if (lDAPSearchResults.getCount() != 1) {
                        System.err.println("Could not locate ids-proxy-sch-GlobalConfiguration object. DN was: " + stringArray[0]);
                        ++n;
                        continue;
                    }
                    object = lDAPSearchResults.next();
                    lDAPAttribute = object.getAttribute("ids-proxy-sch-global-base");
                    if (lDAPAttribute != null) {
                        stringArray = lDAPAttribute.getStringValueArray();
                        string = stringArray[0];
                    }
                    this.write_ldif_entry((LDAPEntry)object);
                }
                catch (LDAPException lDAPException) {
                    System.err.println("Error encountered while searching for ids-proxy-sch-GlobalConfiguration object.");
                    System.err.println(lDAPException.toString());
                    ++n;
                    try {
                        lDAPConnection.disconnect();
                    }
                    catch (LDAPException lDAPException4) {}
                    continue;
                }
                lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-con-Server-Name");
                stringArray = lDAPAttribute.getStringValueArray();
                if (stringArray.length > 1) {
                    System.err.println("Invalid configuration: more than one value found for ids-proxy-con-Server-Name.");
                    ++n;
                    continue;
                }
                object = stringArray[0];
                if (string != null && !this.write_gpra(lDAPConnection, string, "(&(objectclass=ids-proxy-sch-Property)(ids-proxy-sch-enable=TRUE)(ids-proxy-sch-belongs-to=" + (String)object + "))")) {
                    System.err.println("Could not write ids-proxy-sch-global-base entries.");
                    ++n;
                    continue;
                }
                lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-sch-Group-Base");
                stringArray = lDAPAttribute.getStringValueArray();
                if (stringArray.length > 1) {
                    System.err.println("Invalid configuration: more than one values for ids-proxy-sch-Group-Base.");
                    ++n;
                    continue;
                }
                String string2 = stringArray[0];
                String string3 = "(&(objectclass=ids-proxy-sch-Group)(ids-proxy-sch-enable=TRUE)(ids-proxy-sch-belongs-to=" + (String)object + "))";
                if (!this.write_gpra(lDAPConnection, string2, string3)) {
                    System.err.println("Could not write ids-proxy-sch-Group's entries.");
                    ++n;
                    continue;
                }
                lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-sch-Property-Base");
                if (lDAPAttribute != null) {
                    stringArray = lDAPAttribute.getStringValueArray();
                    if (stringArray.length > 1) {
                        System.err.println("Invalid configuration: more than one value found for ids-proxy-sch-Property-Base.");
                        ++n;
                        continue;
                    }
                    string2 = stringArray[0];
                    string3 = "(&(objectclass=ids-proxy-sch-Property)(ids-proxy-sch-enable=TRUE)(ids-proxy-sch-belongs-to=" + (String)object + "))";
                    if (!this.write_gpra(lDAPConnection, string2, string3)) {
                        System.err.println("Could not write ids-proxy-sch-Property's entries.");
                        ++n;
                        continue;
                    }
                }
                if ((lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-sch-Rule-Base")) != null) {
                    stringArray = lDAPAttribute.getStringValueArray();
                    if (stringArray.length > 1) {
                        System.err.println("Invalid configuration: more than one value found for ids-proxy-sch-Rule-Base.");
                        ++n;
                        continue;
                    }
                    string2 = stringArray[0];
                    string3 = "(&(objectclass=ids-proxy-sch-Rule)(ids-proxy-sch-enable=TRUE)(ids-proxy-sch-belongs-to=" + (String)object + "))";
                    if (!this.write_gpra(lDAPConnection, string2, string3)) {
                        System.err.println("Could not write ids-proxy-sch-Rule's entries.");
                        ++n;
                        continue;
                    }
                }
                if ((lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-sch-Action-Base")) != null) {
                    stringArray = lDAPAttribute.getStringValueArray();
                    if (stringArray.length > 1) {
                        System.err.println("Invalid configuration: more than one value found for ids-proxy-sch-Action-Base.");
                        ++n;
                        continue;
                    }
                    string2 = stringArray[0];
                    string3 = "(&(objectclass=ids-proxy-sch-Action)(ids-proxy-sch-enable=TRUE)(ids-proxy-sch-belongs-to=" + (String)object + "))";
                    if (!this.write_gpra(lDAPConnection, string2, string3)) {
                        System.err.println("Could not write ids-proxy-sch-Action's entries.");
                        ++n;
                        continue;
                    }
                }
                this._ldif.close();
                try {
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException) {
                    System.err.println(lDAPException.toString());
                }
                return true;
            }
            ++n;
        }
        this._ldif.close();
        return false;
    }

    private boolean write_gpra(LDAPConnection lDAPConnection, String string, String string2) throws IOException {
        try {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, string2, null, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry;
                try {
                    lDAPEntry = lDAPSearchResults.next();
                }
                catch (LDAPReferralException lDAPReferralException) {
                    System.err.println("Received referral. Ignoring...");
                    continue;
                }
                this.write_ldif_entry(lDAPEntry);
            }
        }
        catch (LDAPException lDAPException) {
            System.err.println("Error encountered while searching " + string + " with filter " + string2);
            System.err.println(lDAPException.toString());
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException2) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private void write_ldif_entry(LDAPEntry lDAPEntry) throws IOException {
        this._ldif.write("dn: " + lDAPEntry.getDN());
        this._ldif.write("\n");
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            Enumeration enumeration2 = lDAPAttribute.getStringValues();
            while (enumeration2.hasMoreElements()) {
                this._ldif.write(lDAPAttribute.getName() + ": ");
                this._ldif.write((String)enumeration2.nextElement());
                this._ldif.write("\n");
            }
        }
        this._ldif.write("\n");
    }

    private boolean get_configuration() throws IOException {
        int n;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        FileReader fileReader = new FileReader(this._tailorFileName);
        char[] cArray = new char[1024];
        while ((n = this.getline(fileReader, cArray)) != -1) {
            ++n2;
            if (n == -2) {
                System.err.println("Line too long " + n2);
                fileReader.close();
                return false;
            }
            String string = new String(cArray, 0, n);
            if ((string = string.trim()).length() == 0 || Character.isWhitespace(string.charAt(0)) || string.charAt(0) == '#' || string.charAt(0) == ';') continue;
            if (string.compareToIgnoreCase("begin") == 0) {
                if (bl) {
                    System.err.println("Mismatched begin, line number " + n2);
                    fileReader.close();
                    return false;
                }
                bl = true;
                this._access_props[n3] = new ConfAccessProp();
                this._access_props[n3 + 1] = null;
                continue;
            }
            if (string.equalsIgnoreCase("end")) {
                if (!bl) {
                    System.err.println("Mismatched end, line number " + n2);
                    fileReader.close();
                    return false;
                }
                bl = false;
                ++n3;
                continue;
            }
            if (!bl) {
                System.err.println("Options must be within begin and end");
                fileReader.close();
                return false;
            }
            int n4 = string.indexOf(58);
            if (n4 == -1) {
                System.err.println("Missing : in line " + n2);
                fileReader.close();
                return false;
            }
            String string2 = string.substring(0, n4);
            String string3 = string.substring(n4 + 1);
            string2 = string2.trim();
            string3 = string3.trim();
            if (string2.equalsIgnoreCase("configuration_url")) {
                this._access_props[n3]._url = string3;
                continue;
            }
            if (string2.equalsIgnoreCase("configuration_bind_dn")) {
                this._access_props[n3]._bind_dn = string3;
                continue;
            }
            if (string2.equalsIgnoreCase("configuration_bind_pw")) {
                if (string3.startsWith("{}")) {
                    try {
                        this._access_props[n3]._passwd = new String(new BASE64Decoder().decodeBuffer(string3.substring(2)));
                    }
                    catch (IOException iOException) {
                        this._access_props[n3]._passwd = string3.substring(2);
                    }
                    continue;
                }
                this._access_props[n3]._passwd = string3;
                continue;
            }
            if (string2.equalsIgnoreCase("configuration_username")) {
                this._access_props[n3]._username = string3;
                continue;
            }
            if (string2.equalsIgnoreCase("sasl_bind_mechanism")) {
                if (string3.equalsIgnoreCase("DIGEST-MD5")) {
                    this._access_props[n3]._sasl_mechanism = 1;
                    continue;
                }
                if (string3.equalsIgnoreCase("CRAM-MD5")) {
                    this._access_props[n3]._sasl_mechanism = 1;
                    continue;
                }
                System.err.println("The only supported sasl_bind_mechanisms are DIGEST-MD5 and CRAM-MD5. " + string3 + " is not recognized.");
                fileReader.close();
                return false;
            }
            System.err.println("Unrecognized keyword (" + string2 + ") in line " + n2);
            fileReader.close();
            return false;
        }
        fileReader.close();
        return true;
    }

    private int getline(FileReader fileReader, char[] cArray) throws IOException {
        int n;
        int n2 = fileReader.read();
        for (n = 0; (char)n2 != '\n' && n < cArray.length && n2 != -1; ++n) {
            cArray[n] = (char)n2;
            n2 = fileReader.read();
        }
        if (n2 == -1) {
            return n2;
        }
        if (n >= cArray.length) {
            return -2;
        }
        return n;
    }

    private class ConfAccessProp {
        private static final int no_sasl = 0;
        private static final int cram_md5 = 1;
        private static final int digest_md5 = 1;
        private String _url = null;
        private String _bind_dn = null;
        private String _passwd = null;
        private String _username = null;
        private int _sasl_mechanism = 0;

        private ConfAccessProp() {
        }
    }
}

