/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.task.configuration;

import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.task.AbstractTask;
import com.iplanet.idar.task.TaskDialogManager;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ViewMap;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.configurator.Editor;
import com.iplanet.idar.ui.task.IplanetTaskDialogManager;
import com.iplanet.idar.ui.task.IplanetTaskEventManager;
import com.iplanet.idar.ui.task.SwingTaskDialogManager;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;

public class IplanetEditObjectTask
extends AbstractTask {
    IDARReference objectRef = null;
    ConsoleInfo info = null;

    public IplanetEditObjectTask() {
        this(null);
    }

    public IplanetEditObjectTask(IDARReference iDARReference) {
        this.setObject(iDARReference);
    }

    public String getName() {
        return IDARResourceSet.getString("taskEditObject", "NAME_SHORT");
    }

    public String getDescription() {
        return IDARResourceSet.getString("taskEditObject", "DESCRIPTION");
    }

    public String getUnexecutableMessage() {
        String string = "";
        if (this.objectRef != null) {
            string = IDARResourceSet.getString("taskEditObject", "UNEXEC_MSG_MISSING_REF");
        }
        return string;
    }

    public void setObject(IDARReference iDARReference) {
        Debug.println((String)("EditObjectTask.setObject: ref=" + iDARReference));
        this.objectRef = iDARReference;
        this.setExecutableness();
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        this.info = consoleInfo;
    }

    public ConsoleInfo getConsoleInfo() {
        return this.info;
    }

    public int doExecute() {
        Debug.println((String)"EditObjectTask.doExecute");
        int n = -2;
        IDARReference iDARReference = this.objectRef;
        IplanetTaskDialogManager iplanetTaskDialogManager = (IplanetTaskDialogManager)this.getDialogManager();
        this.fireTaskStatusChanged(IDARResourceSet.getString("taskEditObject", "EDITING", new String[]{iDARReference.getId()}));
        try {
            IDARModelBean iDARModelBean = iDARReference.getBean();
            ConfigurationView configurationView = ViewMap.getInstance().obtainView(iDARModelBean.getDescriptor(), iDARModelBean.getParentConfiguration());
            if (configurationView != null) {
                configurationView.setConsoleInfo(this.info);
                configurationView.setDataModel(iDARModelBean);
                Editor editor = new Editor(iplanetTaskDialogManager.getParent(), configurationView);
                editor.pack();
                IplanetTaskEventManager iplanetTaskEventManager = (IplanetTaskEventManager)this.getEventManager();
                iplanetTaskEventManager.stopFramework();
                iplanetTaskDialogManager.showDialog(editor);
                ViewMap.getInstance().releaseView(configurationView, iDARModelBean.getParentConfiguration());
                n = 0;
            }
        }
        catch (IDARBeanException iDARBeanException) {
            iplanetTaskDialogManager.showMessage(iDARBeanException.getMessage(), IDARResourceSet.getString("taskEditObject", "EDIT_ERROR"), 0);
            n = -1;
        }
        return n;
    }

    protected void setExecutableness() {
        TaskDialogManager taskDialogManager = this.getDialogManager();
        Debug.println((int)7, (String)("IplanetEditObjectTask.checkExecutableness: dm=" + taskDialogManager + " dmiswing=" + (taskDialogManager instanceof SwingTaskDialogManager ? "true" : "false") + " object=" + this.objectRef + " info=" + this.info));
        boolean bl = taskDialogManager != null && taskDialogManager instanceof SwingTaskDialogManager && this.objectRef != null && this.info != null;
        this.setExecutable(bl);
    }
}

