/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.task;

import com.iplanet.idar.task.AbstractTask;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.task.SwingTaskEventManager;
import com.netscape.management.client.Framework;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.util.Hashtable;

public class IplanetTaskEventManager
extends SwingTaskEventManager {
    static Hashtable frameworks = new Hashtable();
    private IFramework framework;
    private Runnable startFramework = new Runnable(){

        public void run() {
            IFramework iFramework = IplanetTaskEventManager.this.getFramework();
            if (iFramework != null) {
                if (IplanetTaskEventManager.this.showProgress) {
                    Debug.println((int)7, (String)(IplanetTaskEventManager.this.getTask().getName() + " requests start progress"));
                    IplanetTaskEventManager.requestProgressBarStart(iFramework, IplanetTaskEventManager.this.getTask());
                }
                if (IplanetTaskEventManager.this.showMessages) {
                    AbstractTask abstractTask = IplanetTaskEventManager.this.getTask();
                    String string = abstractTask.getStatusMessage();
                    iFramework.changeStatusItemState("StatusItemText", (Object)string);
                }
            }
        }
    };
    private Runnable stopFramework = new Runnable(){

        public void run() {
            AbstractTask abstractTask;
            IFramework iFramework = IplanetTaskEventManager.this.getFramework();
            if (iFramework != null && (abstractTask = IplanetTaskEventManager.this.getTask()) != null) {
                Debug.println((int)7, (String)(abstractTask.getName() + " requests stop progress"));
                IplanetTaskEventManager.requestProgressBarStop(iFramework, abstractTask);
                if (IplanetTaskEventManager.this.showMessages) {
                    String string = "";
                    int n = abstractTask.getExecutionStatus();
                    if (n == 0) {
                        string = IDARResourceSet.getString("task", "success", abstractTask.getDescription());
                    } else if (n == -3) {
                        string = IDARResourceSet.getString("task", "canceled", abstractTask.getDescription());
                    } else if (n == -1) {
                        string = IDARResourceSet.getString("task", "failure", abstractTask.getDescription());
                    }
                    iFramework.changeStatusItemState("StatusItemText", (Object)string);
                }
            }
        }
    };
    private Runnable statusFramework = new Runnable(){

        public void run() {
            IFramework iFramework = IplanetTaskEventManager.this.getFramework();
            if (iFramework != null && IplanetTaskEventManager.this.showMessages) {
                AbstractTask abstractTask = IplanetTaskEventManager.this.getTask();
                String string = abstractTask.getStatusMessage();
                iFramework.changeStatusItemState("StatusItemText", (Object)string);
            }
        }
    };
    private boolean showProgress = true;
    private boolean showMessages = true;

    public IplanetTaskEventManager() {
    }

    public IplanetTaskEventManager(AbstractTask abstractTask) {
        super(abstractTask);
    }

    public void setFramework(IFramework iFramework) {
        this.framework = iFramework;
    }

    public IFramework getFramework() {
        if (this.framework == null) {
            this.framework = (Framework)UtilConsoleGlobals.getActivatedFrame();
        }
        return this.framework;
    }

    public void showProgressOnFramework(boolean bl) {
        this.showProgress = bl;
    }

    public void showStatusMessagesOnFramework(boolean bl) {
        this.showMessages = bl;
    }

    public void fireTaskStarted() {
        this.runIt(this.startFramework);
        super.fireTaskStarted();
    }

    public void fireTaskStopped() {
        this.stopFramework();
        super.fireTaskStopped();
    }

    public void stopFramework() {
        Debug.println((int)6, (String)"IplanetTaskEventManager.stopFramework");
        this.runIt(this.stopFramework);
    }

    public void fireTaskStatusChanged(String string) {
        this.runIt(this.statusFramework);
        super.fireTaskStatusChanged(string);
    }

    private static synchronized void requestProgressBarStart(IFramework iFramework, AbstractTask abstractTask) {
        Debug.println((int)7, (String)("IplanetTaskEventManager.requestProgressBarStart: fw=" + iFramework));
        IplanetTaskEventManager.incrementProgressBarStarts(iFramework);
        iFramework.changeStatusItemState("StatusItemProgress", (Object)new Integer(-1));
    }

    private static synchronized void requestProgressBarStop(IFramework iFramework, AbstractTask abstractTask) {
        int n = IplanetTaskEventManager.decrementProgressBarStarts(iFramework);
        if (n <= 0) {
            iFramework.changeStatusItemState("StatusItemProgress", (Object)new Integer(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized int incrementProgressBarStarts(IFramework iFramework) {
        int n = -1;
        if (iFramework != null) {
            Hashtable hashtable = frameworks;
            synchronized (hashtable) {
                ProgressBarStatusRecord progressBarStatusRecord = (ProgressBarStatusRecord)frameworks.get(iFramework);
                if (progressBarStatusRecord == null) {
                    progressBarStatusRecord = new ProgressBarStatusRecord();
                    frameworks.put(iFramework, progressBarStatusRecord);
                }
                ++progressBarStatusRecord.starts;
                n = progressBarStatusRecord.starts;
            }
        }
        Debug.println((int)7, (String)("IplanetTaskEventManager.incrementProgressBarStarts: fw=" + iFramework + " starts=" + n));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized int decrementProgressBarStarts(IFramework iFramework) {
        int n = -1;
        Hashtable hashtable = frameworks;
        synchronized (hashtable) {
            ProgressBarStatusRecord progressBarStatusRecord = (ProgressBarStatusRecord)frameworks.get(iFramework);
            Debug.println((int)7, (String)("IplanetTaskEventManager.decrementProgressBarStarts: fw=" + iFramework + " starts=" + n));
            if (progressBarStatusRecord != null) {
                if (progressBarStatusRecord.starts > 0) {
                    --progressBarStatusRecord.starts;
                }
                n = progressBarStatusRecord.starts;
            }
        }
        Debug.println((int)7, (String)("IplanetTaskEventManager.decrementProgressBarStarts: fw=" + iFramework + " starts=" + n));
        return n;
    }

    static class ProgressBarStatusRecord {
        int starts = 0;

        ProgressBarStatusRecord() {
        }
    }
}

