/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.task;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.task.AbstractTask;
import com.iplanet.idar.task.TaskDialogManager;
import com.iplanet.idar.task.configuration.SaveObjectTask;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.enterprise.RestartIdarsPanel;
import com.iplanet.idar.ui.task.IplanetTaskDialogManager;
import com.iplanet.idar.ui.task.IplanetTaskEventManager;
import com.iplanet.idar.ui.task.SwingTaskDialogManager;
import com.netscape.management.client.util.Debug;
import java.awt.Window;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class IplanetSaveServerTask
extends AbstractTask {
    IDARReference idarRef = null;

    public IplanetSaveServerTask() {
        this(null);
    }

    public IplanetSaveServerTask(IDARReference iDARReference) {
        this.setObject(iDARReference);
    }

    public String getName() {
        return IDARResourceSet.getString("taskSaveServer", "NAME_SHORT");
    }

    public String getDescription() {
        return IDARResourceSet.getString("taskSaveServer", "DESCRIPTION");
    }

    public String getUnexecutableMessage() {
        String string = "";
        if (this.idarRef == null) {
            string = IDARResourceSet.getString("taskSaveServer", "UNEXEC_MSG_MISSING_REF");
        } else if (!this.idarRef.getDescriptor().equals("idar-server")) {
            string = IDARResourceSet.getString("taskSaveServer", "UNEXEC_MSG_WRONG_TYPE", new String[]{this.idarRef.getDescriptor()});
        }
        return string;
    }

    public void setObject(IDARReference iDARReference) {
        Debug.println((String)("IplanetSaveServerTask.setObject: ref=" + iDARReference));
        this.idarRef = iDARReference;
        this.setExecutableness();
    }

    public boolean isCancelable() {
        return true;
    }

    public int doExecute() {
        Debug.println((String)"IplanetSaveServerTask.doExecute");
        int n = -2;
        IplanetTaskDialogManager iplanetTaskDialogManager = (IplanetTaskDialogManager)this.getDialogManager();
        Vector vector = new Vector();
        try {
            Object object;
            Object object2;
            Object object3;
            this.fireTaskStatusChanged(IDARResourceSet.getString("taskSaveServer", "EXAMINING_OBJECTS"));
            if (this.canceled) {
                return -3;
            }
            IDARBeanCollection iDARBeanCollection = BeanSpace.getInstance().retrieveBeanCollection(IDARReference.NULL_REFERENCE, "system");
            IDARBeanCollection iDARBeanCollection2 = BeanSpace.getInstance().retrieveBeanCollection(IDARReference.NULL_REFERENCE, "log");
            if (this.canceled) {
                return -3;
            }
            this.fireTaskStatusChanged(IDARResourceSet.getString("taskSaveServer", "SAVING_SYSTEM_CONFIG"));
            vector.addAll(this.saveCollection(iDARBeanCollection));
            if (this.canceled) {
                return -3;
            }
            this.fireTaskStatusChanged(IDARResourceSet.getString("taskSaveServer", "SAVING_LOG_CONFIG"));
            vector.addAll(this.saveCollection(iDARBeanCollection2));
            if (this.canceled) {
                return -3;
            }
            HashSet<IDARReference> hashSet = new HashSet<IDARReference>();
            IDARBean iDARBean = (IDARBean)this.idarRef.getBean();
            if (iDARBean.isDirty()) {
                object3 = new SaveObjectTask(iDARBean);
                ((AbstractTask)object3).executeAndWait();
                hashSet.add(this.idarRef);
            }
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                object2 = (IDARModelBean)object3.nextElement();
                object = this.getIdarSubscribers((IDARModelBean)object2);
                hashSet.addAll((Collection<IDARReference>)object);
            }
            if (hashSet.size() > 0) {
                object3 = new RestartIdarsPanel(hashSet);
                object2 = new JOptionPane(object3, 1, 0, null, new Object[]{RestartIdarsPanel.DONE}).createDialog(iplanetTaskDialogManager.getParent(), IDARResourceSet.getString("notice", "NOTICE_TITLE"));
                ((Window)object2).pack();
                object = (IplanetTaskEventManager)this.getEventManager();
                ((IplanetTaskEventManager)object).stopFramework();
                iplanetTaskDialogManager.showDialog((JDialog)object2);
            } else {
                iplanetTaskDialogManager.showMessage(IDARResourceSet.getString("notice", "UNNECESSARY_SAVE"), IDARResourceSet.getString("notice", "NOTICE_TITLE"), 1);
            }
            n = 0;
        }
        catch (IDARBeanException iDARBeanException) {
            iplanetTaskDialogManager.showMessage(iDARBeanException.getMessage(), IDARResourceSet.getString("error", "TITLE"), 0);
            n = -1;
        }
        return n;
    }

    protected void setExecutableness() {
        TaskDialogManager taskDialogManager = this.getDialogManager();
        Debug.println((int)7, (String)("IplanetSaveServerTask.checkExecutableness: dm=" + taskDialogManager + " dmiswing=" + (taskDialogManager instanceof SwingTaskDialogManager ? "true" : "false") + " object=" + this.idarRef));
        boolean bl = taskDialogManager != null && taskDialogManager instanceof SwingTaskDialogManager && this.idarRef != null && this.idarRef.getDescriptor().equals("idar-server");
        this.setExecutable(bl);
    }

    private Set getIdarSubscribers(IDARModelBean iDARModelBean) {
        HashSet<IDARReference> hashSet = new HashSet<IDARReference>();
        IDARReference[] iDARReferenceArray = iDARModelBean.getSubscribers();
        if (iDARReferenceArray != null && iDARReferenceArray.length > 0) {
            for (int i = 0; i < iDARReferenceArray.length; ++i) {
                String string = iDARReferenceArray[0].getDescriptor();
                if (string.equals("idar-server")) {
                    hashSet.add(iDARReferenceArray[i]);
                    continue;
                }
                try {
                    IDARModelBean iDARModelBean2 = iDARReferenceArray[i].getBean();
                    Set set = this.getIdarSubscribers(iDARModelBean2);
                    hashSet.addAll(set);
                    continue;
                }
                catch (IDARBeanException iDARBeanException) {
                    iDARBeanException.printStackTrace();
                }
            }
        }
        Debug.println((String)("IplanetSaveServerTask.getIdarSubscribers: bean=" + iDARModelBean + " subs=" + hashSet));
        return hashSet;
    }

    private Vector saveCollection(IDARBeanCollection iDARBeanCollection) {
        Vector<IDARModelBean> vector = new Vector<IDARModelBean>();
        Vector vector2 = iDARBeanCollection.toReferenceVector();
        Iterator iterator = vector2.iterator();
        while (iterator.hasNext() && !this.canceled) {
            SaveObjectTask saveObjectTask = new SaveObjectTask();
            IDARReference iDARReference = (IDARReference)iterator.next();
            Debug.println((String)("MCV.saveCollection: ref = " + iDARReference));
            if (iDARReference.beanHasBeenLoaded()) {
                try {
                    IDARModelBean iDARModelBean = iDARReference.getBean();
                    if (iDARModelBean.isDirty()) {
                        Debug.println((String)("IplanetSaveServerTask.saveCollection: save dirty bean " + iDARModelBean));
                        saveObjectTask.setObject(iDARModelBean);
                        saveObjectTask.execute();
                        vector.add(iDARModelBean);
                        continue;
                    }
                    Debug.println((int)8, (String)("IplanetSaveServerTask.saveCollection: bean not dirty " + iDARReference));
                }
                catch (IDARBeanException iDARBeanException) {
                    iDARBeanException.printStackTrace();
                }
                continue;
            }
            Debug.println((int)8, (String)("IplanetSaveServerTask.saveCollection: bean not loaded " + iDARReference));
        }
        return vector;
    }
}

