/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.task;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.task.AbstractTask;
import com.iplanet.idar.task.TaskDialogManager;
import com.iplanet.idar.task.configuration.ResetObjectTask;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.task.IplanetTaskDialogManager;
import com.iplanet.idar.ui.task.SwingTaskDialogManager;
import com.netscape.management.client.util.Debug;
import java.util.Iterator;
import java.util.Vector;

public class IplanetResetServerTask
extends AbstractTask {
    IDARReference idarRef = null;

    public IplanetResetServerTask() {
        this(null);
    }

    public IplanetResetServerTask(IDARReference iDARReference) {
        this.setObject(iDARReference);
    }

    public String getName() {
        return IDARResourceSet.getString("taskResetServer", "NAME_SHORT");
    }

    public String getDescription() {
        return IDARResourceSet.getString("taskResetServer", "DESCRIPTION");
    }

    public String getUnexecutableMessage() {
        String string = "";
        if (this.idarRef == null) {
            string = IDARResourceSet.getString("taskResetServer", "UNEXEC_MSG_MISSING_REF");
        } else if (!this.idarRef.getDescriptor().equals("idar-server")) {
            string = IDARResourceSet.getString("taskResetServer", "UNEXEC_MSG_WRONG_TYPE", new String[]{this.idarRef.getDescriptor()});
        }
        return string;
    }

    public void setObject(IDARReference iDARReference) {
        Debug.println((String)("IplanetResetServerTask.setObject: ref=" + iDARReference));
        this.idarRef = iDARReference;
        this.setExecutableness();
    }

    public boolean isCancelable() {
        return true;
    }

    public int doExecute() {
        Debug.println((String)"IplanetResetServerTask.doExecute");
        int n = -2;
        IplanetTaskDialogManager iplanetTaskDialogManager = (IplanetTaskDialogManager)this.getDialogManager();
        try {
            if (this.canceled) {
                return -3;
            }
            this.fireTaskStatusChanged(IDARResourceSet.getString("taskResetServer", "RESETTING_CONFIG"));
            IDARBeanCollection iDARBeanCollection = BeanSpace.getInstance().retrieveBeanCollection(IDARReference.NULL_REFERENCE, "system");
            this.resetCollection(iDARBeanCollection);
            if (this.canceled) {
                return -3;
            }
            this.fireTaskStatusChanged(IDARResourceSet.getString("taskResetServer", "RESETTING_LOG"));
            IDARBeanCollection iDARBeanCollection2 = BeanSpace.getInstance().retrieveBeanCollection(IDARReference.NULL_REFERENCE, "log");
            this.resetCollection(iDARBeanCollection2);
            if (this.canceled) {
                return -3;
            }
            ResetObjectTask resetObjectTask = new ResetObjectTask(this.idarRef.getBean());
            resetObjectTask.executeAndWait();
            n = resetObjectTask.getExecutionStatus();
        }
        catch (IDARBeanException iDARBeanException) {
            iplanetTaskDialogManager.showMessage(iDARBeanException.getMessage(), IDARResourceSet.getString("taskResetServer", "UNEXEC_MSG_RESET_ERROR"), 0);
            n = -1;
        }
        return n;
    }

    protected void setExecutableness() {
        TaskDialogManager taskDialogManager = this.getDialogManager();
        Debug.println((int)7, (String)("IplanetResetServerTask.checkExecutableness: dm=" + taskDialogManager + " dmiswing=" + (taskDialogManager instanceof SwingTaskDialogManager ? "true" : "false") + " object=" + this.idarRef));
        boolean bl = taskDialogManager != null && taskDialogManager instanceof SwingTaskDialogManager && this.idarRef != null && this.idarRef.getDescriptor().equals("idar-server");
        this.setExecutable(bl);
    }

    private int resetCollection(IDARBeanCollection iDARBeanCollection) {
        int n = 0;
        Vector vector = iDARBeanCollection.toReferenceVector();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext() && !this.canceled) {
            ResetObjectTask resetObjectTask = new ResetObjectTask();
            IDARReference iDARReference = (IDARReference)iterator.next();
            Debug.println((String)("MCV.resetCollection: ref = " + iDARReference));
            if (iDARReference.beanHasBeenLoaded()) {
                try {
                    IDARModelBean iDARModelBean = iDARReference.getBean();
                    if (iDARModelBean.isDirty()) {
                        Debug.println((String)("IplanetResetServerTask.resetCollection: reset dirty bean " + iDARModelBean));
                        resetObjectTask.setObject(iDARModelBean);
                        resetObjectTask.executeAndWait();
                        if (resetObjectTask.getExecutionStatus() != -1) continue;
                        n = -1;
                        continue;
                    }
                    Debug.println((int)8, (String)("IplanetResetServerTask.resetCollection: bean not dirty " + iDARReference));
                }
                catch (IDARBeanException iDARBeanException) {
                    iDARBeanException.printStackTrace();
                }
                continue;
            }
            Debug.println((int)8, (String)("IplanetResetServerTask.resetCollection: bean not loaded " + iDARReference));
        }
        return n;
    }
}

