/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.server.configuration;

import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.task.TaskAdapter;
import com.iplanet.idar.task.TaskEvent;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.components.IDARJButtonFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationManager;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.common.configuration.DynamicConfigurationView;
import com.iplanet.idar.ui.common.configuration.IBlankPanelListener;
import com.iplanet.idar.ui.task.IplanetResetServerTask;
import com.iplanet.idar.ui.task.IplanetSaveServerTask;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ManagingConfigurationView
extends DynamicConfigurationView
implements IBlankPanelListener,
SuiConstants,
ConfigurationManager {
    IDARBeanCollection systemCollection;
    IDARBeanCollection logCollection;
    CardLayout clViews;
    CardLayout clMCV;
    JButton butSave;
    JButton butReset;
    BlankPanel pnlContent;
    BlankPanel pnlViews;
    private IplanetSaveServerTask saveTask = new IplanetSaveServerTask();
    private IplanetResetServerTask resetTask = new IplanetResetServerTask();
    private ConsoleInfo info = null;
    private static final String SAVING = "saving";
    private static final String RESETTING = "resetting";
    private static final String VIEWS = "views";
    private boolean busy = false;

    public ManagingConfigurationView(ConsoleInfo consoleInfo, ConfigurationView configurationView) {
        Debug.println((int)5);
        this.info = consoleInfo;
        this.initContents();
        this.addView(configurationView);
    }

    public void addView(ConfigurationView configurationView) {
        Debug.println((int)5, (String)("adding a view to manage..." + configurationView.getTitleText()));
        this.pnlViews.add(configurationView.getTitleText(), configurationView);
    }

    public void showView(String string) {
        Debug.println((String)("ManagingConfigurationView.showView: view=" + string));
        this.clViews.show(this.pnlViews, string);
    }

    public synchronized ConfigurationView getCurrentView() {
        ConfigurationView configurationView = null;
        int n = this.pnlViews.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.pnlViews.getComponent(i);
            if (!component.isVisible() || !(component instanceof ConfigurationView)) continue;
            configurationView = (ConfigurationView)component;
            break;
        }
        return configurationView;
    }

    public void setModelInfo(IDARReference iDARReference, String string, String string2) {
        super.setModelInfo(iDARReference, string, string2);
    }

    protected JPanel getContentPanel() {
        if (this.pnlContent == null) {
            this.initContents();
        }
        return this.pnlContent;
    }

    protected void initContents() {
        if (this.pnlContent == null) {
            this.pnlContent = new BlankPanel("ManagingConfigurationView.Content");
            this.clMCV = new CardLayout();
            this.pnlContent.setLayout(this.clMCV);
            this.pnlContent.add(SAVING, this.getWaitPanel(IDARResourceSet.getString("general", "SAVING")));
            this.pnlContent.add(RESETTING, this.getWaitPanel(IDARResourceSet.getString("general", "RESETTING")));
            this.pnlViews = new BlankPanel("ManagingConfigurationView.Views");
            this.clViews = new CardLayout();
            this.pnlViews.setLayout(this.clViews);
            BlankPanel blankPanel = new BlankPanel("ManagingConfigurationView.ButtonsAndViews");
            blankPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            blankPanel.add((Component)this.pnlViews, gridBagConstraints);
            gridBagConstraints.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 14;
            blankPanel.add((Component)this.getButtonPanel(), gridBagConstraints);
            this.pnlContent.add(VIEWS, blankPanel);
            this.clMCV.show(this.pnlContent, VIEWS);
        }
    }

    public void panelChanged(BlankPanelEvent blankPanelEvent) {
        IDARModelBean iDARModelBean;
        Debug.println((int)6, (String)("ManagingConfigurationView.panelChanged: e=" + blankPanelEvent));
        this.butSave.setEnabled(true);
        this.butReset.setEnabled(true);
        ConfigurationView configurationView = this.getCurrentView();
        if (configurationView != null && (iDARModelBean = configurationView.getDataModel()) != null) {
            iDARModelBean.setDirty(true);
        }
    }

    public void saveModel() {
        this.showWait(SAVING);
        try {
            this.applyChanges();
            if (this.saveTask.isExecutable()) {
                this.saveTask.execute(new TaskAdapter(){

                    public void taskStopped(TaskEvent taskEvent) {
                        int n = ManagingConfigurationView.this.saveTask.getExecutionStatus();
                        Debug.println((String)("ManagingConfigurationView.saveModel: saveTask.status = " + n));
                        ManagingConfigurationView.this.saveTask;
                        ManagingConfigurationView.this.restoreContent(n == 0);
                    }
                });
            } else {
                Debug.println((String)("ManagingConfigurationView.saveModel: ERROR cannot save: " + this.saveTask.getUnexecutableMessage()));
                this.restoreContent(false);
            }
        }
        catch (ConfigurationViewException configurationViewException) {
            JOptionPane.showMessageDialog(IDARUtilities.getParentFrame(this), configurationViewException.getMessage(), IDARResourceSet.getString("commonEditor", "ILLEGAL_DATA_TITLE"), 0);
            this.restoreContent(false);
        }
    }

    private JPanel getButtonPanel() {
        this.butSave = IDARJButtonFactory.create(IDARResourceSet.getString("button", "SAVE"));
        IDARJButtonFactory.resize((JButton)this.butSave);
        this.butSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ManagingConfigurationView.this.busy) {
                    ManagingConfigurationView.this.busy = true;
                    ManagingConfigurationView.this.saveModel();
                    ManagingConfigurationView.this.busy = false;
                }
            }
        });
        this.butReset = IDARJButtonFactory.create(IDARResourceSet.getString("button", "RESET"));
        IDARJButtonFactory.resize((JButton)this.butReset);
        this.butReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ManagingConfigurationView.this.busy) {
                    ManagingConfigurationView.this.busy = true;
                    ManagingConfigurationView.this.resetModel();
                    ManagingConfigurationView.this.busy = false;
                }
            }
        });
        JButton jButton = IDARJButtonFactory.create(IDARResourceSet.getString("button", "HELP"));
        IDARJButtonFactory.resize((JButton)jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = null;
                    if (ManagingConfigurationView.this.info != null) {
                        uRL = new URL(ManagingConfigurationView.this.info.getAdminURL());
                    } else {
                        Debug.println((int)0, (String)"ERROR: UNABLE TO FIND ADMIN-SERVER URL");
                    }
                    if (uRL != null) {
                        Help.showContextHelp((String)"dps", (String)ManagingConfigurationView.this.getHelpTopic(), (URL)uRL);
                    } else {
                        Debug.println((int)0, (String)"ERROR: UNABLE TO FIND ADMIN-SERVER URL");
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.println((int)0, (String)"ERROR: INVALID ADMIN-SERVER URL.");
                    Debug.println((int)0, (String)("ERROR MSG: " + malformedURLException.getLocalizedMessage()));
                }
            }
        });
        this.butSave.setEnabled(false);
        this.butReset.setEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.butSave);
        jPanel.add(Box.createHorizontalStrut(6));
        jPanel.add(this.butReset);
        jPanel.add(Box.createHorizontalStrut(12));
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel getWaitPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)new JLabel(string, 0), gridBagConstraints);
        JButton jButton = IDARJButtonFactory.create(IDARResourceSet.getString("button", "CANCEL"));
        IDARJButtonFactory.resize((JButton)jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManagingConfigurationView.this.cancelWait();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    private void resetModel() {
        this.showWait(RESETTING);
        if (this.resetTask.isExecutable()) {
            this.resetTask.execute(new TaskAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void taskStopped(TaskEvent taskEvent) {
                    int n = ManagingConfigurationView.this.resetTask.getExecutionStatus();
                    Debug.println((String)("ManagingConfigurationView.resetModel: resetTask.status = " + n));
                    try {
                        try {
                            ManagingConfigurationView.this.resetContentEventlessly();
                        }
                        catch (ConfigurationViewException configurationViewException) {
                            JOptionPane.showMessageDialog(IDARUtilities.getParentFrame(ManagingConfigurationView.this), configurationViewException.getMessage(), IDARResourceSet.getString("commonEditor", "ILLEGAL_DATA_TITLE"), 0);
                            Object var5_4 = null;
                            ManagingConfigurationView.this.resetTask;
                            ManagingConfigurationView.this.restoreContent(n == 0);
                            return;
                        }
                        Object var5_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        ManagingConfigurationView.this.resetTask;
                        ManagingConfigurationView.this.restoreContent(n == 0);
                        throw throwable;
                    }
                    ManagingConfigurationView.this.resetTask;
                    ManagingConfigurationView.this.restoreContent(n == 0);
                }
            });
        } else {
            Debug.println((String)("ManagingConfigurationView.resetModel: ERROR cannot reset: " + this.resetTask.getUnexecutableMessage()));
            this.restoreContent(false);
        }
    }

    public void setSaveAndResetButtonsEnabled(boolean bl) {
        this.setSaveButtonEnabled(bl);
        this.setResetButtonEnabled(bl);
    }

    public void setSaveButtonEnabled(boolean bl) {
        this.butSave.setEnabled(bl);
    }

    public void setResetButtonEnabled(boolean bl) {
        this.butReset.setEnabled(bl);
    }

    public String getHelpTopic() {
        String string = "";
        ConfigurationView configurationView = this.getCurrentView();
        if (configurationView != null) {
            string = configurationView.getHelpTopic();
        }
        return string;
    }

    public String getTitleText() {
        return "ManagingConfigurationView";
    }

    public void applyChanges() throws ConfigurationViewException {
        Debug.println((String)"ManagingConfigurationView.applyChanges");
        ConfigurationView configurationView = null;
        Component[] componentArray = this.pnlViews.getComponents();
        try {
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof ConfigurationView)) continue;
                configurationView = (ConfigurationView)componentArray[i];
                Debug.println((String)("ManagingConfigurationView.applyChanges: apply changes to " + configurationView));
                configurationView.applyChanges();
            }
        }
        catch (ConfigurationViewException configurationViewException) {
            this.showView(configurationView.getTitleText());
            throw configurationViewException;
        }
    }

    public void resetContent() throws ConfigurationViewException {
        ConfigurationView configurationView = null;
        Component[] componentArray = this.pnlViews.getComponents();
        try {
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof ConfigurationView)) continue;
                configurationView = (ConfigurationView)componentArray[i];
                configurationView.resetContentEventlessly();
            }
        }
        catch (ConfigurationViewException configurationViewException) {
            this.showView(configurationView.getTitleText());
            throw configurationViewException;
        }
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        Debug.println((String)("ManagingConfigurationView.setDataModel: model=" + iDARModelBean + " reset=" + bl));
        this.setEventFiringEnabled(false);
        Component[] componentArray = this.pnlViews.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof ConfigurationView)) continue;
            ConfigurationView configurationView = (ConfigurationView)componentArray[i];
            configurationView.setEventFiringEnabled(false);
            configurationView.setDataModel(iDARModelBean, false);
            configurationView.setEventFiringEnabled(true);
        }
        IDARReference iDARReference = null;
        if (iDARModelBean != null) {
            iDARReference = iDARModelBean.getSelfReference();
        }
        this.saveTask.setObject(iDARReference);
        this.resetTask.setObject(iDARReference);
        super.setDataModel(iDARModelBean, bl);
        this.setEventFiringEnabled(true);
    }

    private void showWait(String string) {
        Debug.println((int)6, (String)("ManagingConfigurationView.showWait: function=" + string));
        this.clMCV.show(this.pnlContent, string);
        this.setSaveAndResetButtonsEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.revalidate();
        this.repaint();
    }

    private void restoreContent(boolean bl) {
        Debug.println((int)6, (String)("ManagingConfigurationView.restoreContent: success=" + bl));
        this.setSaveAndResetButtonsEnabled(!bl);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.clMCV.show(this.pnlContent, VIEWS);
    }

    private void cancelWait() {
        if (this.saveTask.isExecuting()) {
            this.saveTask.cancel();
        }
        if (this.resetTask.isExecuting()) {
            this.resetTask.cancel();
        }
        this.restoreContent(false);
    }

    protected void finalize() throws Throwable {
        Debug.println((int)5, (String)"garbage collection running...");
        super.finalize();
    }
}

