/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.server.configuration;

import com.iplanet.idar.task.TaskAdapter;
import com.iplanet.idar.task.TaskEvent;
import com.iplanet.idar.task.idar.RetrieveLogRecordsTask;
import com.iplanet.idar.ui.common.FilteredInputDocument;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.components.IDARJButtonFactory;
import com.iplanet.idar.ui.server.configuration.DetailTable2;
import com.iplanet.idar.ui.server.configuration.LogRecord;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.components.DetailTable;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;

public class LogFileView
extends JPanel
implements SuiConstants {
    private static final String HELP_TOPIC = "Server-Configuration-LogFile";
    protected static final int DEFAULT_NUMBER_LINES_TO_RETRIEVE = 25;
    protected static final int DEFAULT_REFRESH_RATE = 5000;
    private RetrieveLogRecordsTask task;
    private int lines = 25;
    private Vector records;
    private JButton butRefresh;
    private JButton butHelp;
    private JCheckBox chkContinuous;
    private JTextField tfLogFileName;
    private JTextField tfLines;
    private DetailTable tblLogFile;
    private AbstractTableModel tableModel;
    private Refresher refresher = new Refresher();
    private ConsoleInfo info = null;

    public LogFileView(ConsoleInfo consoleInfo, RetrieveLogRecordsTask retrieveLogRecordsTask) {
        this.task = retrieveLogRecordsTask;
        this.info = consoleInfo;
        this.initComponents();
    }

    public void removeNotify() {
        Debug.println((int)6, (String)"LogFileView.removeNotify");
        super.removeNotify();
        this.refresher.stopRefreshing();
    }

    public void addNotify() {
        Debug.println((int)6, (String)"LogFileView.addNotify");
        super.addNotify();
        if (this.chkContinuous.isSelected()) {
            this.refresher.refreshContinuously();
        } else {
            this.refresher.refreshOnce();
        }
        Frame frame = IDARUtilities.getParentFrame(this);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                Debug.println((int)6, (String)"LogFileView:  stop refresher");
                LogFileView.this.refresher.stopRefreshing();
            }

            public void windowIconified(WindowEvent windowEvent) {
                Debug.println((int)6, (String)"LogFileView:  stop refresher");
                LogFileView.this.refresher.stopRefreshing();
            }

            public void windowOpened(WindowEvent windowEvent) {
                LogFileView.this.checkRefresher();
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                LogFileView.this.checkRefresher();
            }
        });
    }

    private void checkRefresher() {
        Debug.println((int)6, (String)("LogFileView.checkRefresher:  activate=" + this.chkContinuous.isSelected()));
        if (this.chkContinuous.isSelected()) {
            this.refresher.refreshContinuously();
        }
    }

    private void initComponents() {
        this.butRefresh = IDARJButtonFactory.create(IDARResourceSet.getString("serverLogView", "REFRESH"));
        ButtonFactory.resizeButton((JButton)this.butRefresh);
        this.butRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogFileView.this.refresher.refreshOnce();
            }
        });
        this.butHelp = IDARJButtonFactory.create(IDARResourceSet.getString("button", "HELP"));
        ButtonFactory.resizeButton((JButton)this.butHelp);
        this.butHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = null;
                    if (LogFileView.this.info != null) {
                        uRL = new URL(LogFileView.this.info.getAdminURL());
                    } else {
                        Debug.println((int)0, (String)"ERROR: UNABLE TO FIND ADMIN-SERVER URL");
                    }
                    if (uRL != null) {
                        Help.showContextHelp((String)"dps", (String)LogFileView.HELP_TOPIC, (URL)uRL);
                    } else {
                        Debug.println((int)0, (String)"ERROR: UNABLE TO FIND ADMIN-SERVER URL");
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.println((int)0, (String)"ERROR: INVALID ADMIN-SERVER URL.");
                    Debug.println((int)0, (String)("ERROR MSG: " + malformedURLException.getLocalizedMessage()));
                }
            }
        });
        this.chkContinuous = new JCheckBox(IDARResourceSet.getString("serverLogView", "CONTINUOUS"));
        this.chkContinuous.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LogFileView.this.chkContinuous.isSelected()) {
                    LogFileView.this.refresher.refreshContinuously();
                } else {
                    LogFileView.this.refresher.stopRefreshing();
                }
            }
        });
        this.tfLogFileName = new JTextField();
        if (this.task != null) {
            this.tfLogFileName.setText(this.task.getLogFileName());
        }
        this.tfLogFileName.setEditable(false);
        JLabel jLabel = new JLabel(IDARResourceSet.getString("serverLogView", "LOG_FILE") + ":");
        jLabel.setLabelFor(this.tfLogFileName);
        this.tfLines = new JTextField(6);
        this.tfLines.setMinimumSize(this.tfLines.getPreferredSize());
        this.tfLines.setText(Integer.toString(25));
        this.tfLines.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.tfLines.setText(Integer.toString(this.lines));
        JLabel jLabel2 = new JLabel(IDARResourceSet.getString("serverLogView", "LINES") + ":");
        jLabel2.setLabelFor(this.tfLines);
        this.tableModel = new AbstractTableModel(){

            public int getRowCount() {
                return LogFileView.this.records == null ? 0 : LogFileView.this.records.size();
            }

            public int getColumnCount() {
                return LogRecord.FIELD_NAMES.length;
            }

            public String getColumnName(int n) {
                return LogRecord.FIELD_NAMES[n];
            }

            public Object getValueAt(int n, int n2) {
                LogRecord logRecord;
                String string = null;
                if (LogFileView.this.records != null && n2 < LogRecord.FIELD_NAMES.length && (logRecord = (LogRecord)LogFileView.this.records.elementAt(n)) != null) {
                    string = logRecord.getFieldValue(n2);
                }
                return string;
            }
        };
        this.tblLogFile = new DetailTable2(this.tableModel);
        this.tblLogFile.setMinimumSize(new Dimension(600, 600));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        int n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.butRefresh, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.chkContinuous, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.tfLogFileName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tfLines, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.tblLogFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 6, 6);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 14;
        this.add((Component)this.butHelp, gridBagConstraints);
    }

    public void loadLogRecords() {
        if (this.task != null) {
            int n = 25;
            try {
                n = Integer.parseInt(this.tfLines.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.tfLines.setText(Integer.toString(25));
            }
            this.task.setNumberOfLinesToRetrieve(n);
            this.task.execute(new TaskAdapter(){

                public void taskStopped(TaskEvent taskEvent) {
                    RetrieveLogRecordsTask retrieveLogRecordsTask = (RetrieveLogRecordsTask)taskEvent.getTask();
                    if (retrieveLogRecordsTask.getExecutionStatus() != 0) {
                        String string = null;
                        switch (retrieveLogRecordsTask.getStatus()) {
                            case 3: {
                                string = IDARResourceSet.getString("error", "LOG_FILE_NOT_FOUND");
                                break;
                            }
                            case 4: {
                                string = IDARResourceSet.getString("error", "LOG_FILE_ACCESS_DENIED");
                                break;
                            }
                            case 2: {
                                string = IDARResourceSet.getString("error", "LOG_FILE_IO_ERROR");
                                break;
                            }
                            default: {
                                string = IDARResourceSet.getString("error", "LOG_FILE_ERROR");
                            }
                        }
                        if (string != null) {
                            JOptionPane.showMessageDialog(IDARUtilities.getParentFrame(LogFileView.this), string, IDARResourceSet.getString("error", "TASK_ERROR_TITLE"), 0);
                        }
                    } else {
                        if (LogFileView.this.records == null) {
                            LogFileView.this.records = new Vector();
                        }
                        LogFileView.this.records.removeAllElements();
                        LogFileView.this.records.addAll(retrieveLogRecordsTask.getRecords());
                        LogFileView.this.tableModel.fireTableDataChanged();
                    }
                    LogFileView.this.refresher.logLoadingFinished();
                }
            });
        }
    }

    private class Refresher {
        private int refreshRate = 5000;
        private boolean continuous = false;
        private boolean once = false;
        private boolean isLoading = false;
        private Thread refresher;
        private boolean refresh;

        private Refresher() {
        }

        public Thread getRefresher() {
            if (this.refresher == null) {
                this.refresh = true;
                this.refresher = new Thread(this){
                    private final /* synthetic */ Refresher this$1;
                    {
                        this.this$1 = refresher;
                    }

                    public synchronized void run() {
                        while (Refresher.access$700(this.this$1)) {
                            if (Refresher.access$800(this.this$1) || Refresher.access$900(this.this$1)) {
                                Refresher.access$1002(this.this$1, true);
                                Refresher.access$1100(this.this$1).loadLogRecords();
                                try {
                                    Debug.println((int)7, (String)"Refresher: waiting for log load");
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                Refresher.access$902(this.this$1, false);
                                Refresher.access$1002(this.this$1, false);
                            }
                            try {
                                Debug.println((int)7, (String)"Refresher: sleeping...");
                                this.wait(Refresher.access$1200(this.this$1));
                                Debug.println((int)7, (String)"Refresher: awake!");
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                };
                this.refresher.start();
            }
            return this.refresher;
        }

        public void setRefreshRate(int n) {
            this.refreshRate = n;
        }

        public int getRefreshRate() {
            return this.refreshRate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshContinuously() {
            Debug.println((String)"LogFileView.refresher.refreshContinuously");
            this.continuous = true;
            Thread thread = this.getRefresher();
            if (!this.isLoading) {
                Thread thread2 = thread;
                synchronized (thread2) {
                    thread.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshOnce() {
            Debug.println((String)"LogFileView.refresher.refreshOnce");
            Thread thread = this.getRefresher();
            if (!this.isLoading) {
                this.once = true;
                Thread thread2 = thread;
                synchronized (thread2) {
                    thread.notify();
                }
            }
        }

        public void stopRefreshing() {
            Debug.println((String)"LogFileView.refresher.stopRefreshing");
            this.continuous = false;
            this.refresh = false;
            this.refresher = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logLoadingFinished() {
            Debug.println((int)7, (String)"LogFileView.refresher.logLoadingFinished");
            if (this.refresher != null && this.isLoading) {
                Thread thread = this.refresher;
                synchronized (thread) {
                    this.refresher.notify();
                }
            }
        }

        static /* synthetic */ boolean access$700(Refresher refresher) {
            return refresher.refresh;
        }

        static /* synthetic */ boolean access$800(Refresher refresher) {
            return refresher.continuous;
        }

        static /* synthetic */ boolean access$900(Refresher refresher) {
            return refresher.once;
        }

        static /* synthetic */ boolean access$1002(Refresher refresher, boolean bl) {
            refresher.isLoading = bl;
            return refresher.isLoading;
        }

        static /* synthetic */ LogFileView access$1100(Refresher refresher) {
            return refresher.LogFileView.this;
        }

        static /* synthetic */ boolean access$902(Refresher refresher, boolean bl) {
            refresher.once = bl;
            return refresher.once;
        }

        static /* synthetic */ int access$1200(Refresher refresher) {
            return refresher.refreshRate;
        }
    }
}

