/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.server.configuration;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.ConfigurationBean;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.ui.common.DynamicComboBoxModel;
import com.iplanet.idar.ui.common.DynamicListModel;
import com.iplanet.idar.ui.common.IDARFramework;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.ConfigurationResource;
import com.iplanet.idar.ui.configurator.ConfiguratorFrameworkInitializer;
import com.iplanet.idar.ui.task.TaskButton;
import com.iplanet.idar.ui.task.configuration.IplanetEditObjectTask;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class IDARLogicView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "Server-Configuration-Main";
    private IDARBeanCollection configs;
    protected final IplanetEditObjectTask editTask = new IplanetEditObjectTask();
    private JLabel lblSharedConfig;
    private JButton butEditSharedConfig;
    private JComboBox cboSharedConfig;

    public IDARLogicView() {
        this.initComponents();
    }

    public IDARLogicView(ConsoleInfo consoleInfo, IDARBean iDARBean) {
        this.setConsoleInfo(consoleInfo);
        this.initComponents();
        this.setDataModel(iDARBean);
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        this.editTask.setConsoleInfo(consoleInfo);
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        Debug.println((String)("IDARLogicView.setDataModel: model=" + iDARModelBean + " reset=" + bl));
        if (this.cboSharedConfig != null && iDARModelBean != null) {
            String string = ((IDARBean)iDARModelBean).getSharedConfigurationName();
            this.cboSharedConfig.setSelectedItem(string);
        }
        super.setDataModel(iDARModelBean, bl);
    }

    public void resetContent() throws ConfigurationViewException {
        Debug.println((int)7, (String)"IDARLogicView.resetContent");
        IDARBean iDARBean = (IDARBean)super.getDataModel();
        if (iDARBean != null) {
            String string = iDARBean.getSharedConfigurationName();
            this.cboSharedConfig.setSelectedItem(string);
        }
        this.setEnablement();
    }

    public void applyChanges() throws ConfigurationViewException {
        block7: {
            Debug.println((int)7, (String)"IDARLogicView.applyChanges");
            try {
                final IDARBean iDARBean = (IDARBean)super.getDataModel();
                Debug.println((String)("model=" + iDARBean));
                if (iDARBean == null) break block7;
                Object object = this.cboSharedConfig.getSelectedItem();
                Debug.println((String)("o=" + object));
                if (object != null && !object.equals(DynamicListModel.NONE)) {
                    final ConfigurationBean configurationBean = iDARBean.getConfigurationBean();
                    Debug.println((String)("oldconfig=" + configurationBean.getDn()));
                    final ConfigurationBean configurationBean2 = (ConfigurationBean)this.configs.getBean(object.toString());
                    Debug.println((String)("newconfig=" + configurationBean2.getDn()));
                    if (configurationBean2 != null && configurationBean != configurationBean2) {
                        new Thread(new Runnable(){

                            public void run() {
                                configurationBean2.addBelongsTo(iDARBean.getServerName());
                                if (configurationBean != null) {
                                    configurationBean.removeBelongsTo(iDARBean.getServerName());
                                }
                            }
                        }).start();
                    } else {
                        if (configurationBean2 == null) {
                            Debug.println((int)5, (String)"WARNING - can't get new config bean");
                        }
                        if (configurationBean == configurationBean2) {
                            Debug.println((int)5, (String)"WARNING - Old config and new config are the same.");
                        }
                    }
                    iDARBean.setSharedConfiguration(configurationBean2);
                    break block7;
                }
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_CONFIGURATION"));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("serverLogicConfiguration", "TITLE");
    }

    protected void initComponents() {
        Serializable serializable;
        this.lblSharedConfig = new JLabel(IDARResourceSet.getString("serverLogicConfiguration", "LOGIC_CONFIG") + ":");
        this.lblSharedConfig.setIcon((Icon)ImageFactory.getImage("CONFIGURATION"));
        this.cboSharedConfig = new JComboBox();
        try {
            this.configs = BeanSpace.getInstance().retrieveBeanCollection(IDARReference.NULL_REFERENCE, "configuration");
            serializable = new DynamicComboBoxModel(this.configs, false);
            this.cboSharedConfig.setModel(serializable);
            IDARBean iDARBean = (IDARBean)this.getDataModel();
            if (iDARBean != null) {
                String string = ((IDARBean)this.model).getSharedConfigurationName();
                this.cboSharedConfig.setSelectedItem(string);
            }
        }
        catch (IDARBeanException iDARBeanException) {
            iDARBeanException.printStackTrace();
        }
        this.cboSharedConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IDARLogicView.this.setEnablement();
            }
        });
        this.butEditSharedConfig = new TaskButton(this.editTask);
        ButtonFactory.resizeButton((JButton)this.butEditSharedConfig);
        this.butEditSharedConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    IDARBean iDARBean = (IDARBean)IDARLogicView.this.getDataModel();
                    if (iDARBean != null) {
                        Object object = IDARLogicView.this.cboSharedConfig.getSelectedItem();
                        String string = "";
                        if (object != null) {
                            string = object.toString();
                        }
                        if (!string.trim().equals("")) {
                            ConfigurationResource configurationResource = IDARUtilities.getConfigurationResource(string);
                            if (configurationResource == null) {
                                JOptionPane.showMessageDialog(IDARLogicView.this, IDARResourceSet.getString("error", "UNKNOWN_CONFIG_MESSAGE") + " " + string, IDARResourceSet.getString("error", "UNKNOWN_CONFIG_TITLE"), 0);
                            } else {
                                IDARFramework iDARFramework = IDARFramework.getInstance(new ConfiguratorFrameworkInitializer(IDARLogicView.this.getConsoleInfo(), configurationResource));
                                iDARFramework.show();
                            }
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        });
        this.setLayout(new GridBagLayout());
        int n = 0;
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(29, 9, 9, 0);
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = n;
        ((GridBagConstraints)serializable).anchor = 12;
        this.add((Component)this.lblSharedConfig, serializable);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(29, 9, 0, 0);
        ((GridBagConstraints)serializable).gridx = 1;
        ((GridBagConstraints)serializable).gridy = n;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridwidth = -1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        this.add((Component)this.cboSharedConfig, serializable);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(29, 9, 0, 9);
        ((GridBagConstraints)serializable).gridx = 2;
        ((GridBagConstraints)serializable).gridy = n++;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        this.add((Component)this.butEditSharedConfig, serializable);
    }

    private void setEnablement() {
        Object object = this.cboSharedConfig.getSelectedItem();
        if (object == null) {
            this.cboSharedConfig.setSelectedItem(DynamicComboBoxModel.NONE);
            this.butEditSharedConfig.setEnabled(false);
        } else if (DynamicComboBoxModel.NONE.equals(object.toString())) {
            this.butEditSharedConfig.setEnabled(false);
        } else {
            this.butEditSharedConfig.setEnabled(true);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new IDARLogicView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

