/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.system;

import com.iplanet.idar.objectmodel.bean.SystemBean;
import com.iplanet.idar.ui.common.FilteredInputDocument;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ToggleBorder;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class ConnectionsView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "System-Settings-Connections";
    private JCheckBox chkMaxConns;
    private JTextField tfMaxConns;
    private JLabel lblBacklog;
    private JTextField tfConnectionBacklog;
    private BlankPanel pnlConnectionPool;
    private JCheckBox chkEnableConnectionPool;
    private JCheckBox chkTimeout;
    private JLabel lblInterval;
    private JTextField tfInterval;
    private JTextField tfTimeout;

    public ConnectionsView() {
        this((ConsoleInfo)null);
    }

    public ConnectionsView(ConsoleInfo consoleInfo) {
        this.setConsoleInfo(consoleInfo);
        this.initComponents();
    }

    public ConnectionsView(ConsoleInfo consoleInfo, SystemBean systemBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(systemBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    public Integer getMaximumConnections() {
        return this.getNumberValueFromTextField(this.tfMaxConns);
    }

    public Integer getBacklog() {
        return this.getNumberValueFromTextField(this.tfConnectionBacklog);
    }

    public Integer getInterval() {
        return this.getNumberValueFromTextField(this.tfInterval);
    }

    public Integer getTimeout() {
        return this.getNumberValueFromTextField(this.tfTimeout);
    }

    public void resetContent() throws ConfigurationViewException {
        Debug.println((String)"ConnectionsView.resetContent");
        SystemBean systemBean = (SystemBean)this.getDataModel();
        if (systemBean != null) {
            this.setViewEnabled(true);
            Integer n = systemBean.getMaximumConnections();
            this.chkMaxConns.setSelected(true);
            if (n != null) {
                this.tfMaxConns.setText(n.toString());
                this.chkMaxConns.setSelected(true);
            } else {
                this.chkMaxConns.setSelected(false);
            }
            this.setMaxConnectionsEnabled(this.chkMaxConns.isSelected());
            this.tfConnectionBacklog.setText(systemBean.getListenBacklog().toString());
            boolean bl = systemBean.isConnectionPoolEnabled();
            this.chkEnableConnectionPool.setSelected(bl);
            this.setConnectionPoolComponentsEnabled(bl);
            n = systemBean.getConnectionPoolTimeout();
            if (n != null && n != 0) {
                this.chkTimeout.setSelected(true);
                this.tfTimeout.setText(n.toString());
            } else {
                this.chkTimeout.setSelected(false);
                this.tfTimeout.setText(Integer.toString(30));
            }
            this.setTimeoutEnablement();
            n = systemBean.getConnectionPoolInterval();
            if (n != null) {
                this.tfInterval.setText(n.toString());
            }
        } else {
            this.setViewEnabled(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyChanges() throws ConfigurationViewException {
        Object object;
        SystemBean systemBean = (SystemBean)this.getDataModel();
        if (systemBean == null) return;
        Debug.println((int)7, (String)("ConnectionsView.applyChanges: model=" + systemBean + " dirty=" + systemBean.isDirty()));
        if (this.chkMaxConns.isSelected()) {
            object = this.tfMaxConns.getText().trim();
            if (((String)object).equals("")) throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_MAX_CONNECTIONS"));
            Integer n = null;
            try {
                n = new Integer(((String)object).toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "NUMBER_FORMAT") + ": " + (String)object);
            }
            if (n == 0) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ZERO_SYS_MAX_CONNECTIONS"));
            }
            systemBean.setMaximumConnections(n);
        } else {
            systemBean.setMaximumConnections(null);
        }
        if (this.tfConnectionBacklog.getText().trim().equals("")) {
            throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_BACKLOG"));
        }
        object = null;
        try {
            object = new Integer(this.tfConnectionBacklog.getText());
            if ((Integer)object == 0) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ZERO_BACKLOG"));
            }
            systemBean.setListenBacklog((Integer)object);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationViewException(IDARResourceSet.getString("error", "NUMBER_FORMAT") + ": " + this.tfConnectionBacklog.getText());
        }
        systemBean.setConnectionPoolEnabled(this.chkEnableConnectionPool.isSelected());
        if (this.chkTimeout.isSelected()) {
            if (this.tfTimeout.getText().trim().equals("")) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_TIMEOUT"));
            }
            object = null;
            try {
                object = new Integer(this.tfTimeout.getText());
                systemBean.setConnectionPoolTimeout((Integer)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "NUMBER_FORMAT") + ": " + this.tfTimeout.getText());
            }
        } else {
            systemBean.setConnectionPoolTimeout(new Integer(0));
        }
        object = null;
        try {
            object = new Integer(this.tfInterval.getText());
            if ((Integer)object == 0) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ZERO_INTERVAL"));
            }
            systemBean.setConnectionPoolInterval((Integer)object);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationViewException(IDARResourceSet.getString("error", "NUMBER_FORMAT") + ": " + this.tfInterval.getText());
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("systemConnections", "TITLE");
    }

    public String getHelpTopic() {
        Debug.println((String)"ConnectionsView.getHelpTopic");
        return HELP_TOPIC;
    }

    protected void initComponents() {
        this.chkMaxConns = new JCheckBox(IDARResourceSet.getString("systemConnections", "MAX_CONNS") + ":");
        this.chkMaxConns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionsView.this.setMaxConnectionsEnabled(ConnectionsView.this.chkMaxConns.isSelected());
            }
        });
        this.tfMaxConns = new JTextField(6);
        this.tfMaxConns.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.tfMaxConns.setMinimumSize(this.tfMaxConns.getPreferredSize());
        this.tfMaxConns.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("systemConnections", "MAX_CONNS"));
        this.tfConnectionBacklog = new JTextField(6);
        this.tfConnectionBacklog.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.tfConnectionBacklog.setMinimumSize(this.tfConnectionBacklog.getPreferredSize());
        this.lblBacklog = new JLabel(IDARResourceSet.getString("systemConnections", "CONN_BACKLOG") + ":");
        this.lblBacklog.setLabelFor(this.tfConnectionBacklog);
        this.setLayout(new GridBagLayout());
        this.pnlConnectionPool = new BlankPanel();
        this.pnlConnectionPool.addBlankPanelListener(this);
        this.chkTimeout = new JCheckBox(IDARResourceSet.getString("systemConnections", "TIMEOUT") + ":");
        this.chkTimeout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionsView.this.setTimeoutEnablement();
            }
        });
        this.tfInterval = new JTextField(6);
        this.tfInterval.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.lblInterval = new JLabel();
        this.lblInterval.setLabelFor(this.tfInterval);
        this.tfTimeout = new JTextField(6);
        this.tfTimeout.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.tfTimeout.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("systemConnections", "TIMEOUT"));
        this.chkEnableConnectionPool = new JCheckBox(IDARResourceSet.getString("systemConnections", "CONN_POOL"));
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 12;
        this.add((Component)this.lblBacklog, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.tfConnectionBacklog, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this.add((Component)this.chkMaxConns, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 9, 0, 9);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.tfMaxConns, gridBagConstraints);
        BlankPanel blankPanel = new BlankPanel();
        blankPanel.setAlignmentX(5.0f);
        blankPanel.setLayout(new BoxLayout(blankPanel, 0));
        blankPanel.add(this.chkEnableConnectionPool);
        this.pnlConnectionPool.setBorder(new CompoundBorder(new ToggleBorder(blankPanel, 1), new EmptyBorder(0, 6, 6, 0)));
        this.pnlConnectionPool.setLayout(new GridBagLayout());
        this.chkEnableConnectionPool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionsView.this.setConnectionPoolComponentsEnabled(ConnectionsView.this.chkEnableConnectionPool.isSelected());
                ConnectionsView.this.fireBlankPanelEvent(new BlankPanelEvent(null));
            }
        });
        this.setConnectionPoolComponentsEnabled(this.chkEnableConnectionPool.isSelected());
        int n2 = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.anchor = 18;
        this.pnlConnectionPool.add((Component)blankPanel, gridBagConstraints);
        this.lblInterval.setText(IDARResourceSet.getString("systemConnections", "INTERVAL") + ":");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = n2;
        gridBagConstraints2.anchor = 18;
        this.pnlConnectionPool.add((Component)this.lblInterval, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = n2++;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 18;
        this.pnlConnectionPool.add((Component)this.tfInterval, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = n2;
        gridBagConstraints2.anchor = 18;
        this.pnlConnectionPool.add((Component)this.chkTimeout, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = n2++;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 18;
        this.pnlConnectionPool.add((Component)this.tfTimeout, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(14, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlConnectionPool, gridBagConstraints);
    }

    private void setViewEnabled(boolean bl) {
        this.setEnabled(bl);
        this.lblBacklog.setEnabled(bl);
        this.lblInterval.setEnabled(bl);
        this.chkMaxConns.setEnabled(bl);
        this.tfMaxConns.setEnabled(bl);
        this.tfConnectionBacklog.setEnabled(bl);
        this.chkEnableConnectionPool.setEnabled(bl);
        this.chkTimeout.setEnabled(bl);
        this.tfInterval.setEnabled(bl);
        this.tfTimeout.setEnabled(bl);
        if (bl) {
            this.tfMaxConns.setBackground(Color.white);
            this.tfConnectionBacklog.setBackground(Color.white);
            this.tfInterval.setBackground(Color.white);
            this.tfTimeout.setBackground(Color.white);
        } else {
            this.tfMaxConns.setBackground(null);
            this.tfConnectionBacklog.setBackground(null);
            this.tfInterval.setBackground(null);
            this.tfTimeout.setBackground(null);
        }
    }

    private void setMaxConnectionsEnabled(boolean bl) {
        if (bl) {
            this.tfMaxConns.setEnabled(true);
            this.tfMaxConns.setBackground(Color.white);
        } else {
            this.tfMaxConns.setEnabled(false);
            this.tfMaxConns.setBackground(null);
        }
    }

    private void setTimeoutEnablement() {
        if (this.chkEnableConnectionPool.isSelected() && this.chkTimeout.isSelected()) {
            this.tfTimeout.setEnabled(true);
            this.tfTimeout.setBackground(Color.white);
        } else {
            this.tfTimeout.setEnabled(false);
            this.tfTimeout.setBackground(null);
        }
    }

    private void setConnectionPoolComponentsEnabled(boolean bl) {
        if (bl) {
            this.tfInterval.setEnabled(true);
            this.tfInterval.setBackground(Color.white);
            this.chkTimeout.setEnabled(true);
            this.lblInterval.setEnabled(true);
        } else {
            this.tfInterval.setEnabled(false);
            this.tfInterval.setBackground(null);
            this.chkTimeout.setEnabled(false);
            this.lblInterval.setEnabled(false);
        }
        this.setTimeoutEnablement();
    }

    private Integer getNumberValueFromTextField(JTextField jTextField) {
        Integer n = null;
        try {
            n = new Integer(jTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new ConnectionsView(null, null));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

