/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.rule;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.OnBindRuleBean;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.RuleBean;
import com.iplanet.idar.objectmodel.bean.RuleData;
import com.iplanet.idar.ui.common.DynamicComboBoxModel;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.NewItemListener;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.task.TaskButton;
import com.iplanet.idar.ui.task.configuration.IplanetCreateAndEditObjectTask;
import com.iplanet.idar.ui.task.configuration.IplanetEditObjectTask;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ActionToExecuteView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "Event-OnBind-Event";
    private JTextArea txtAction;
    private JComboBox cboAction;
    private DynamicComboBoxModel cbModel;
    private JButton butNewAction;
    private JButton butEditAction;
    private NewItemListener newItemListener;
    private RuleBean model;
    protected final IplanetEditObjectTask editTask = new IplanetEditObjectTask();
    protected final IplanetCreateAndEditObjectTask createTask = new IplanetCreateAndEditObjectTask("change-group");

    public ActionToExecuteView() {
        this.initComponents();
    }

    public ActionToExecuteView(ConsoleInfo consoleInfo, OnBindRuleBean onBindRuleBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(onBindRuleBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            configurationViewException.printStackTrace();
        }
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        Debug.println((int)6, (String)("ActionToExecuteView.setConsoleInfo: info=" + consoleInfo));
        super.setConsoleInfo(consoleInfo);
        this.createTask.setConsoleInfo(consoleInfo);
        this.editTask.setConsoleInfo(consoleInfo);
    }

    public void setNote(String string) {
        this.txtAction.setText(string);
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        Debug.println((int)6, (String)("ActionToExecuteView.setDataModel: model=" + iDARModelBean + " reset=" + bl));
        if (iDARModelBean != null) {
            this.createTask.setParentConfiguration(iDARModelBean.getParentConfiguration());
            IDARBeanCollection iDARBeanCollection = null;
            try {
                iDARBeanCollection = BeanSpace.getInstance().retrieveBeanCollection(iDARModelBean.getParentConfiguration(), "action");
            }
            catch (RetrievalException retrievalException) {
                retrievalException.printStackTrace();
            }
            catch (NoSuchBeanException noSuchBeanException) {
                noSuchBeanException.printStackTrace();
            }
            Object object = null;
            if (this.cbModel != null) {
                object = this.cbModel.getSelectedItem();
            }
            this.cbModel = new DynamicComboBoxModel(iDARBeanCollection);
            this.newItemListener.setModel(this.cbModel);
            this.cbModel.setSelectedItem(object);
            if (this.cboAction != null) {
                this.setEventFiringEnabled(false);
                this.cboAction.setModel(this.cbModel);
                this.setEventFiringEnabled(true);
            }
        }
        super.setDataModel(iDARModelBean, bl);
    }

    protected void initComponents() {
        this.txtAction = new JTextArea();
        this.txtAction.setText(IDARResourceSet.getString("eventAction", "NOTE"));
        this.txtAction.setEditable(false);
        this.txtAction.setBackground(this.getBackground());
        this.txtAction.setLineWrap(true);
        this.txtAction.setWrapStyleWord(true);
        this.cboAction = new JComboBox();
        this.cboAction.setToolTipText(IDARResourceSet.getString("tooltip", "action_to_execute"));
        if (this.cbModel != null) {
            this.cboAction.setModel(this.cbModel);
        }
        this.cboAction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionToExecuteView.this.setEditEnabled();
            }
        });
        this.butNewAction = new TaskButton(this.createTask);
        ButtonFactory.resizeButton((JButton)this.butNewAction);
        this.newItemListener = new NewItemListener(this.butNewAction);
        this.butEditAction = new TaskButton(this.editTask);
        ButtonFactory.resizeButton((JButton)this.butEditAction);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.setLayout(new GridBagLayout());
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        this.add((Component)this.txtAction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.cboAction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.butNewAction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 6, 9, 9);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.butEditAction, gridBagConstraints);
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("eventAction", "TITLE");
    }

    public void applyChanges() throws ConfigurationViewException {
        RuleBean ruleBean = (RuleBean)super.getDataModel();
        if (ruleBean != null) {
            ruleBean.removeAllRuleData();
            Object object = this.cboAction.getSelectedItem();
            if (object != null && !DynamicComboBoxModel.NONE.equals(object.toString())) {
                RuleData ruleData = new RuleData(ruleBean.getParentConfiguration(), object.toString(), new Integer(0));
                ruleBean.addRuleData(ruleData);
            }
        }
    }

    public void resetContent() throws ConfigurationViewException {
        RuleBean ruleBean = (RuleBean)super.getDataModel();
        Debug.println((String)("ActionToExecuteView.resetContent: model=" + ruleBean));
        if (ruleBean != null) {
            RuleData[] ruleDataArray = ruleBean.getRuleData();
            String string = null;
            if (ruleDataArray != null && ruleDataArray.length > 0 && ruleDataArray[0] != null) {
                RuleData ruleData = ruleDataArray[0];
                string = ruleData.getActionId();
            }
            if (string == null || string.trim().equals("")) {
                this.cboAction.setSelectedItem(DynamicComboBoxModel.NONE);
            } else {
                this.cboAction.setSelectedItem(string);
            }
            this.setEditEnabled();
        }
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    private void setEditEnabled() {
        this.editTask.setObject(((DynamicComboBoxModel)this.cboAction.getModel()).getSelectedReference());
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new ActionToExecuteView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

