/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.property;

import com.iplanet.idar.objectmodel.bean.LogPropertyBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatisticsView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "Server-Configuration-Logs";
    private JLabel lblLogLevel;
    private BlankPanel pnlStatistics;
    private JCheckBox chkMods;
    private JCheckBox chkOps;
    private JCheckBox chkConns;
    private JCheckBox chkStats;
    private JCheckBox chkAudits;
    private JCheckBox chkAcls;
    private JPanel _pnlLogLevel;

    public StatisticsView() {
        this.initComponents(true);
    }

    public StatisticsView(boolean bl) {
        if (bl) {
            this.initComponents(true);
        } else {
            this.initComponents(false);
        }
    }

    public StatisticsView(boolean bl, ConsoleInfo consoleInfo) {
        this.setConsoleInfo(consoleInfo);
        if (bl) {
            this.initComponents(true);
        } else {
            this.initComponents(false);
        }
    }

    public void resetContent() throws ConfigurationViewException {
        LogPropertyBean logPropertyBean = (LogPropertyBean)this.getDataModel();
        Debug.println((int)7, (String)("StatisticsView.resetContent: model=" + logPropertyBean));
        if (logPropertyBean != null) {
            this.setViewEnabled(true);
            this.chkMods.setSelected(logPropertyBean.isModificationStatisticsEnabled());
            this.chkOps.setSelected(logPropertyBean.isOperationStatisticsEnabled());
            this.chkConns.setSelected(logPropertyBean.isConnectionStatisticsEnabled());
            this.chkStats.setSelected(logPropertyBean.isGeneralStatisticsEnabled());
            this.chkAudits.setSelected(logPropertyBean.isAuditStatisticsEnabled());
            this.chkAcls.setSelected(logPropertyBean.isAclStatisticsEnabled());
        } else {
            this.setViewDefaults();
            this.setViewEnabled(false);
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        LogPropertyBean logPropertyBean = (LogPropertyBean)this.getDataModel();
        Debug.println((String)("StatisticsView.applyChanges: model=" + logPropertyBean));
        if (logPropertyBean != null) {
            logPropertyBean.setModificationStatisticsEnabled(this.chkMods.isSelected());
            logPropertyBean.setOperationStatisticsEnabled(this.chkOps.isSelected());
            logPropertyBean.setConnectionStatisticsEnabled(this.chkConns.isSelected());
            logPropertyBean.setGeneralStatisticsEnabled(this.chkStats.isSelected());
            logPropertyBean.setAuditStatisticsEnabled(this.chkAudits.isSelected());
            logPropertyBean.setAclStatisticsEnabled(this.chkAcls.isSelected());
        }
    }

    protected void initComponents() {
        this.initComponents(true);
    }

    protected void initComponents(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.chkMods = new JCheckBox(IDARResourceSet.getString("propertyLogLevel", "MODS"));
        this.chkOps = new JCheckBox(IDARResourceSet.getString("propertyLogLevel", "OPS"));
        this.chkConns = new JCheckBox(IDARResourceSet.getString("propertyLogLevel", "CONNS"));
        this.chkStats = new JCheckBox(IDARResourceSet.getString("propertyLogLevel", "STATS"));
        this.chkAudits = new JCheckBox(IDARResourceSet.getString("propertyLogLevel", "AUDITS"));
        this.chkAcls = new JCheckBox(IDARResourceSet.getString("propertyLogLevel", "ACLS"));
        int n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.chkMods, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.chkOps, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.chkConns, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.chkStats, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.chkAudits, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.chkAcls, gridBagConstraints);
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("propertyLogLevel", "TITLE");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    private void setViewEnabled(boolean bl) {
        this.chkMods.setEnabled(bl);
        this.chkOps.setEnabled(bl);
        this.chkConns.setEnabled(bl);
        this.chkStats.setEnabled(bl);
        this.chkAudits.setEnabled(bl);
        this.chkAcls.setEnabled(bl);
    }

    private void setViewDefaults() {
        this.chkMods.setSelected(false);
        this.chkOps.setSelected(false);
        this.chkConns.setSelected(false);
        this.chkStats.setSelected(false);
        this.chkAudits.setSelected(false);
        this.chkAcls.setSelected(false);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new StatisticsView(false));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

