/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.property;

import com.iplanet.idar.objectmodel.bean.LogPropertyBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class LogLevelView
extends ConfigurationView
implements SuiConstants {
    protected static final String[] LOG_LEVELS = new String[]{IDARResourceSet.getString("propertyLogLevel", "CRITICAL"), IDARResourceSet.getString("propertyLogLevel", "EXCEPTION"), IDARResourceSet.getString("propertyLogLevel", "WARNING"), IDARResourceSet.getString("propertyLogLevel", "NOTICE"), IDARResourceSet.getString("propertyLogLevel", "TRACE"), IDARResourceSet.getString("propertyLogLevel", "DETAILED")};
    protected static final Hashtable hashLogLevels = new Hashtable(LOG_LEVELS.length);
    private static final String HELP_TOPIC = "Server-Configuration-Logs-Detail";
    private JLabel lblLogLevel;
    private JTextArea taNote;
    private JComboBox cbLogLevel;
    private BlankPanel pnlLogLevel;

    public LogLevelView() {
        this.initComponents(true);
    }

    public LogLevelView(boolean bl) {
        if (bl) {
            this.initComponents(true);
        } else {
            this.initComponents(false);
        }
    }

    public LogLevelView(boolean bl, ConsoleInfo consoleInfo) {
        this.setConsoleInfo(consoleInfo);
        if (bl) {
            this.initComponents(true);
        } else {
            this.initComponents(false);
        }
    }

    public void resetContent() throws ConfigurationViewException {
        LogPropertyBean logPropertyBean = (LogPropertyBean)this.getDataModel();
        if (logPropertyBean != null) {
            this.setViewEnabled(true);
            String string = logPropertyBean.getLogLevel();
            int n = 0;
            if (string.equals("critical")) {
                n = 0;
            }
            if (string.equals("exception")) {
                n = 1;
            }
            if (string.equals("warning")) {
                n = 2;
            }
            if (string.equals("notice")) {
                n = 3;
            }
            if (string.equals("trace")) {
                n = 4;
            }
            if (string.equals("detail_trace")) {
                n = 5;
            }
            this.cbLogLevel.setSelectedIndex(n);
        } else {
            this.setViewDefaults();
            this.setViewEnabled(false);
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        LogPropertyBean logPropertyBean = (LogPropertyBean)this.getDataModel();
        if (logPropertyBean != null) {
            int n = this.cbLogLevel.getSelectedIndex();
            if (n == 1) {
                logPropertyBean.setLogLevel("exception");
            } else if (n == 2) {
                logPropertyBean.setLogLevel("warning");
            } else if (n == 3) {
                logPropertyBean.setLogLevel("notice");
            } else if (n == 4) {
                logPropertyBean.setLogLevel("trace");
            } else if (n == 5) {
                logPropertyBean.setLogLevel("detail_trace");
            } else {
                logPropertyBean.setLogLevel("critical");
            }
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("propertyLogLevel", "DETAIL");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public void initLogLevelPanel(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.lblLogLevel = new JLabel(IDARResourceSet.getString("propertyLogLevel", "LOG_LEVEL") + ":");
        this.lblLogLevel.setEnabled(bl);
        this.taNote = new JTextArea(IDARResourceSet.getString("propertyLogLevel", "NOTE"));
        this.taNote.setLineWrap(true);
        this.taNote.setEditable(false);
        this.taNote.setBackground(this.getBackground());
        this.taNote.setWrapStyleWord(true);
        this.pnlLogLevel = new BlankPanel();
        this.pnlLogLevel.addBlankPanelListener(this);
        this.pnlLogLevel.setLayout(new GridBagLayout());
        this.cbLogLevel = new JComboBox<String>(LOG_LEVELS);
        int n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        this.pnlLogLevel.add((Component)this.taNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.pnlLogLevel.add((Component)this.lblLogLevel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlLogLevel.add((Component)this.cbLogLevel, gridBagConstraints);
        JTextArea jTextArea = new JTextArea("               ");
        jTextArea.setBackground(this.getBackground());
        jTextArea.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlLogLevel.add((Component)jTextArea, gridBagConstraints);
    }

    protected void initComponents() {
        this.initComponents(true);
    }

    protected void initComponents(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.initLogLevelPanel(bl);
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlLogLevel, gridBagConstraints);
    }

    private void setViewEnabled(boolean bl) {
        this.lblLogLevel.setEnabled(bl);
        this.taNote.setEnabled(bl);
        this.cbLogLevel.setEnabled(bl);
        this.pnlLogLevel.setEnabled(bl);
    }

    private void setViewDefaults() {
        this.cbLogLevel.setSelectedIndex(2);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new LogLevelView(true));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static {
        for (int i = 0; i < LOG_LEVELS.length; ++i) {
            hashLogLevels.put(new Integer(i), new JLabel(LOG_LEVELS[i]));
        }
    }
}

