/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.property;

import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.LoadBalanceData;
import com.iplanet.idar.objectmodel.bean.LoadBalancePropertyBean;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.task.TaskAdapter;
import com.iplanet.idar.task.TaskEvent;
import com.iplanet.idar.ui.common.AbstractChooserDialog;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.components.IDARJButtonFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.property.LoadBalanceTableModel;
import com.iplanet.idar.ui.task.TaskButton;
import com.iplanet.idar.ui.task.configuration.IplanetEditObjectTask;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.TitlePanel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import com.netscape.management.nmclf.SuiTableHeaderBorder;
import com.netscape.management.nmclf.SuiTableHeaderRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LoadBalancePropertyView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "Property-LoadBalancing";
    private JLabel lblName;
    private JTextField tfName;
    private TitlePanel pnlTitle;
    private JTextArea txtNote;
    private JButton butAddServer;
    private JButton butRemoveServer;
    private JButton butEditServer;
    private JButton butDistribute;
    private JTable tblServers;
    private LoadBalanceTableModel tableModel;
    private PercentageEditor percentageEditor = new PercentageEditor();
    protected final IplanetEditObjectTask editTask = new IplanetEditObjectTask();
    private static final int PERC_COLUMN = 1;
    private static final String TOTAL = IDARResourceSet.getString("propertyLoadBalance", "TOTAL");

    public LoadBalancePropertyView() {
        this.initComponents();
    }

    public LoadBalancePropertyView(ConsoleInfo consoleInfo, LoadBalancePropertyBean loadBalancePropertyBean) {
        this.setConsoleInfo(consoleInfo);
        this.initComponents();
        super.setDataModel(loadBalancePropertyBean);
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        this.editTask.setConsoleInfo(consoleInfo);
    }

    protected void initComponents() {
        this.pnlTitle = new TitlePanel();
        this.pnlTitle.setIcon((Icon)ImageFactory.getImage("PROPERTY"));
        this.pnlTitle.setText(IDARResourceSet.getString("propertyLoadBalance", "TITLE"));
        this.tfName = new JTextField();
        this.lblName = new JLabel(IDARResourceSet.getString("propertyLoadBalance", "PROPERTY_NAME"));
        this.lblName.setLabelFor(this.tfName);
        this.txtNote = new JTextArea();
        this.txtNote.setText(IDARResourceSet.getString("propertyLoadBalance", "NOTE"));
        this.txtNote.setEditable(false);
        this.txtNote.setBackground(this.getBackground());
        this.txtNote.setLineWrap(true);
        this.txtNote.setWrapStyleWord(true);
        this.butAddServer = IDARJButtonFactory.create(IDARResourceSet.getString("button", "ADD"));
        this.butAddServer.setToolTipText(IDARResourceSet.getString("tooltip", "add_ldap_server"));
        this.butAddServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoadBalancePropertyBean loadBalancePropertyBean = (LoadBalancePropertyBean)LoadBalancePropertyView.this.getDataModel();
                if (loadBalancePropertyBean != null) {
                    AbstractChooserDialog abstractChooserDialog = new AbstractChooserDialog(IDARUtilities.getParentFrame(LoadBalancePropertyView.this), IDARResourceSet.getString("dialogLDAPServerChooser", "TITLE"), IDARResourceSet.getString("dialogLDAPServerChooser", "NOTE"), LoadBalancePropertyView.this.getDataModel().getParentConfiguration(), "ldap-server", LoadBalancePropertyView.super.getConsoleInfo(), true);
                    abstractChooserDialog.show();
                    if (!abstractChooserDialog.isCancel()) {
                        BeanListenable beanListenable = abstractChooserDialog.getSelectedBean();
                        if (!LoadBalancePropertyView.this.tableModel.contains(beanListenable.getId())) {
                            Integer n = LoadBalancePropertyView.this.tableModel.getRowCount() == 0 ? new Integer(100) : new Integer(0);
                            LoadBalancePropertyView.this.tableModel.addRow(new LoadBalanceData(beanListenable.getSelfReference(), n));
                            LoadBalancePropertyView.this.tblServers.getTableHeader().repaint();
                            LoadBalancePropertyView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(LoadBalancePropertyView.this.tableModel)));
                        } else {
                            JOptionPane.showMessageDialog(IDARUtilities.getParentFrame(LoadBalancePropertyView.this), IDARResourceSet.getString("error", "DUPLICATE"), IDARResourceSet.getString("error", "TITLE"), 0);
                        }
                    }
                }
            }
        });
        this.butEditServer = new TaskButton(this.editTask);
        ButtonFactory.resizeButton((JButton)this.butEditServer);
        this.editTask.addTaskListener(new TaskAdapter(){

            public void taskStarted(TaskEvent taskEvent) {
                LoadBalancePropertyView.this.percentageEditor.stopCellEditing();
            }
        });
        this.butRemoveServer = IDARJButtonFactory.create(IDARResourceSet.getString("button", "REMOVE"));
        this.butRemoveServer.setToolTipText(IDARResourceSet.getString("tooltip", "add_ldap_server"));
        this.butRemoveServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = LoadBalancePropertyView.this.tblServers.getSelectedRow();
                if (n != -1) {
                    LoadBalancePropertyView.this.percentageEditor.stopCellEditing();
                    LoadBalancePropertyView.this.tableModel.removeRow(n);
                    int n2 = LoadBalancePropertyView.this.tblServers.getRowCount();
                    if (n >= n2) {
                        n = n2 - 1;
                    }
                    if (n > 0) {
                        LoadBalancePropertyView.this.tblServers.addRowSelectionInterval(n, n);
                    }
                    LoadBalancePropertyView.this.tblServers.getTableHeader().repaint();
                    LoadBalancePropertyView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(LoadBalancePropertyView.this.tableModel)));
                }
            }
        });
        this.butRemoveServer.setEnabled(false);
        this.butDistribute = IDARJButtonFactory.create(IDARResourceSet.getString("propertyLoadBalance", "DISTRIBUTE"));
        this.butDistribute.setToolTipText(IDARResourceSet.getString("tooltip", "distribute"));
        this.butDistribute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LoadBalancePropertyView.this.tableModel != null) {
                    int n = LoadBalancePropertyView.this.tableModel.getRowCount();
                    for (int i = 0; i < n - 1; ++i) {
                        LoadBalancePropertyView.this.tableModel.setValueAt(new Integer(100 / n), i, 1);
                    }
                    LoadBalancePropertyView.this.tableModel.setValueAt(new Integer(100 / n + 100 % n), n - 1, 1);
                    LoadBalancePropertyView.this.percentageEditor.loadValue();
                    LoadBalancePropertyView.this.tblServers.getTableHeader().repaint();
                    LoadBalancePropertyView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(LoadBalancePropertyView.this.tableModel)));
                }
            }
        });
        this.butDistribute.setEnabled(false);
        this.tblServers = new JTable(this.getServerTableModel());
        this.tblServers.setToolTipText(IDARResourceSet.getString("tooltip", "TITLE"));
        this.tblServers.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this.tblServers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LoadBalancePropertyView.this.setEnablement();
            }
        });
        this.tblServers.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    LoadBalancePropertyView.this.butEditServer.doClick();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.pnlTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.tfName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        this.add((Component)this.txtNote, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.butAddServer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 9, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.butEditServer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 9, 0, 0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.butRemoveServer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 9, 0, 0);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 9, 0, 0);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.butDistribute, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.add((Component)new JScrollPane(this.tblServers), gridBagConstraints);
    }

    private void setEnablement() {
        boolean bl = this.tblServers.getRowCount() != 0 && this.tblServers.getSelectedRow() != -1 && this.tblServers.getRowCount() > this.tblServers.getSelectedRow();
        this.butRemoveServer.setEnabled(bl);
        this.butDistribute.setEnabled(this.tblServers.getRowCount() > 1);
        this.editTask.setObject(this.getSelectedReference());
    }

    private LoadBalanceTableModel getServerTableModel() {
        LoadBalancePropertyBean loadBalancePropertyBean;
        if (this.tableModel == null && (loadBalancePropertyBean = (LoadBalancePropertyBean)this.getDataModel()) != null) {
            LoadBalanceData[] loadBalanceDataArray = loadBalancePropertyBean.getLoadBalanceData();
            this.tableModel = new LoadBalanceTableModel(loadBalancePropertyBean.getParentConfiguration(), loadBalanceDataArray);
            this.tableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    LoadBalancePropertyView.this.setEnablement();
                }
            });
            this.tblServers.setModel(this.tableModel);
            this.tblServers.getColumnModel().getColumn(1).setCellEditor(this.percentageEditor);
            Debug.println((String)"LoadBalancePropertyView.getServerTableModel: setting table headers ...");
            this.tblServers.getColumnModel().getColumn(0).setHeaderRenderer((TableCellRenderer)new SuiTableHeaderRenderer());
            PercentageColumnHeaderRenderer percentageColumnHeaderRenderer = new PercentageColumnHeaderRenderer();
            this.tblServers.getColumnModel().getColumn(1).setHeaderRenderer(percentageColumnHeaderRenderer);
        }
        return this.tableModel;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("propertyLoadBalance", "TITLE");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public void resetContent() throws ConfigurationViewException {
        Debug.println((String)"LoadBalancePropertyView.resetContent");
        this.percentageEditor.stopCellEditing();
        try {
            LoadBalancePropertyBean loadBalancePropertyBean = (LoadBalancePropertyBean)super.getDataModel();
            if (loadBalancePropertyBean != null) {
                this.tfName.setText(loadBalancePropertyBean.getName());
                LoadBalanceTableModel loadBalanceTableModel = this.getServerTableModel();
                if (loadBalanceTableModel != null) {
                    loadBalanceTableModel.setLoadBalanceData(loadBalancePropertyBean.getLoadBalanceData());
                }
            }
            this.tblServers.getTableHeader().repaint();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        block10: {
            this.percentageEditor.stopCellEditing();
            try {
                LoadBalanceTableModel loadBalanceTableModel;
                LoadBalancePropertyBean loadBalancePropertyBean = (LoadBalancePropertyBean)super.getDataModel();
                if (loadBalancePropertyBean == null) break block10;
                if (this.tfName.getText().trim().equals("")) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_ID"));
                }
                if (!loadBalancePropertyBean.getName().equals(this.tfName.getText())) {
                    try {
                        loadBalancePropertyBean.setName(this.tfName.getText());
                    }
                    catch (UniqueNameException uniqueNameException) {
                        throw new ConfigurationViewException(IDARResourceSet.getString("error", "UNIQUE_NAME", this.tfName.getText()));
                    }
                }
                if ((loadBalanceTableModel = this.getServerTableModel()) != null) {
                    if (loadBalanceTableModel.getRowCount() == 0) {
                        throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_SERVERS"));
                    }
                    if (loadBalanceTableModel.getPercentageTotal() != 100) {
                        throw new ConfigurationViewException(IDARResourceSet.getString("error", "LOAD_BALANCE_PERCENTAGE"));
                    }
                    loadBalancePropertyBean.setLoadBalanceData(loadBalanceTableModel.getLoadBalanceData());
                } else {
                    Debug.println((String)"LoadBalancePropertyView.applyChanges: ERROR: null table model");
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private IDARReference getSelectedReference() {
        IDARReference iDARReference = null;
        Object object = this.tableModel.getValueAt(this.tblServers.getSelectedRow(), 0);
        if (object != null) {
            try {
                iDARReference = BeanSpace.getInstance().getBeanReference(object.toString(), "ldap-server", this.getDataModel().getParentConfiguration());
            }
            catch (IDARBeanException iDARBeanException) {
                iDARBeanException.printStackTrace();
            }
        }
        return iDARReference;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new LoadBalancePropertyView(null, null));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public class PercentageColumnHeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        JLabel lblTitle = new JLabel(IDARResourceSet.getString("propertyLoadBalance", "PERCENT_LOAD"));
        JLabel lblPerc = new JLabel();

        PercentageColumnHeaderRenderer() {
            this.setBorder((Border)new SuiTableHeaderBorder(0));
            this.setForeground(UIManager.getColor("textText"));
            this.setBackground(UIManager.getColor("control"));
            this.setOpaque(true);
            this.setLayout(new FlowLayout(1));
            this.add((Component)this.lblTitle, "West");
            this.add((Component)this.lblPerc, "East");
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            LoadBalanceTableModel loadBalanceTableModel = (LoadBalanceTableModel)jTable.getModel();
            StringBuffer stringBuffer = new StringBuffer("(" + TOTAL + "=");
            int n3 = loadBalanceTableModel.getPercentageTotal();
            stringBuffer.append(Integer.toString(n3));
            stringBuffer.append(")");
            if (n3 != 100) {
                this.lblPerc.setForeground(Color.red);
            } else {
                this.lblPerc.setForeground(Color.black);
            }
            this.lblPerc.setText(stringBuffer.toString());
            return this;
        }
    }

    class PercentageEditor
    extends JPanel
    implements TableCellEditor {
        JTextField tfPercentage;
        JButton butFit;
        Vector listeners = new Vector();
        String originalValue;
        LoadBalanceTableModel dataModel;
        JTable table;
        int row;
        int col;
        boolean isEditing;
        DocumentListener docListener = new DocumentListener(this){
            private final /* synthetic */ PercentageEditor this$1;
            {
                this.this$1 = percentageEditor;
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.fire();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.fire();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.fire();
            }

            private void fire() {
                PercentageEditor.access$600(this.this$1).fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(LoadBalancePropertyView.access$100(PercentageEditor.access$600(this.this$1)))));
            }
        };

        public PercentageEditor() {
            this.setLayout(new BorderLayout());
            this.tfPercentage = new JTextField();
            this.tfPercentage.setDocument(new PlainDocument(this){
                private final /* synthetic */ PercentageEditor this$1;
                {
                    this.this$1 = percentageEditor;
                }

                public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                    Integer n2 = null;
                    try {
                        n2 = new Integer(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n2 != null && Integer.parseInt(this.this$1.getPercentage().toString() + n2.toString()) <= 100) {
                        super.insertString(n, string, attributeSet);
                        LoadBalancePropertyView.access$100(PercentageEditor.access$600(this.this$1)).setValueAt(new Integer(this.this$1.tfPercentage.getText()), this.this$1.row, 1);
                        LoadBalancePropertyView.access$200(PercentageEditor.access$600(this.this$1)).getTableHeader().repaint();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }

                public void postRemoveUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
                    super.removeUpdate(defaultDocumentEvent);
                    Integer n = null;
                    try {
                        n = new Integer(this.this$1.tfPercentage.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = new Integer(0);
                    }
                    LoadBalancePropertyView.access$100(PercentageEditor.access$600(this.this$1)).setValueAt(n, this.this$1.row, 1);
                    LoadBalancePropertyView.access$200(PercentageEditor.access$600(this.this$1)).getTableHeader().repaint();
                }
            });
            this.tfPercentage.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke('\n'), new AbstractAction(this){
                private final /* synthetic */ PercentageEditor this$1;
                {
                    this.this$1 = percentageEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.stopCellEditing();
                }
            });
            this.tfPercentage.addFocusListener(new FocusAdapter(this, LoadBalancePropertyView.this){
                private final /* synthetic */ LoadBalancePropertyView val$this$0;
                private final /* synthetic */ PercentageEditor this$1;
                {
                    this.this$1 = percentageEditor;
                    this.val$this$0 = loadBalancePropertyView;
                }

                public void focusGained(FocusEvent focusEvent) {
                    this.this$1.isEditing = true;
                }

                public void focusLost(FocusEvent focusEvent) {
                    this.this$1.isEditing = false;
                }
            });
            JButton jButton = IDARJButtonFactory.create(IDARResourceSet.getString("propertyLoadBalance", "FIT"));
            jButton.setToolTipText(IDARResourceSet.getString("tooltip", "fit"));
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PercentageEditor this$1;
                {
                    this.this$1 = percentageEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    int n2 = this.this$1.dataModel.getPercentageTotal();
                    int n3 = 100 - (n2 - (n = ((Integer)this.this$1.dataModel.getValueAt(this.this$1.row, 1)).intValue()));
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    this.this$1.setValue(Integer.toString(n3));
                }
            });
            jButton.addFocusListener(new FocusAdapter(this, LoadBalancePropertyView.this){
                private final /* synthetic */ LoadBalancePropertyView val$this$0;
                private final /* synthetic */ PercentageEditor this$1;
                {
                    this.this$1 = percentageEditor;
                    this.val$this$0 = loadBalancePropertyView;
                }

                public void focusGained(FocusEvent focusEvent) {
                    this.this$1.isEditing = true;
                }

                public void focusLost(FocusEvent focusEvent) {
                    this.this$1.isEditing = false;
                }
            });
            this.add((Component)this.tfPercentage, "Center");
            this.add((Component)jButton, "East");
        }

        public boolean isEditing() {
            return this.isEditing;
        }

        public void loadValue() {
            Object object;
            if (this.dataModel != null && (object = this.dataModel.getValueAt(this.row, this.col)) != null) {
                this.tfPercentage.setText(object.toString());
            }
        }

        public Integer getPercentage() {
            return (Integer)this.getCellEditorValue();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.table = jTable;
            this.row = n;
            this.col = n2;
            this.dataModel = (LoadBalanceTableModel)jTable.getModel();
            this.originalValue = object.toString();
            this.tfPercentage.setText(this.originalValue);
            this.tfPercentage.getDocument().addDocumentListener(this.docListener);
            return this;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.add(cellEditorListener);
        }

        public void cancelCellEditing() {
            this.tfPercentage.getDocument().removeDocumentListener(this.docListener);
            this.fireEditingCanceled();
        }

        public Object getCellEditorValue() {
            Integer n;
            try {
                n = new Integer(this.tfPercentage.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = new Integer(0);
            }
            return n;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.remove(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.tfPercentage.getDocument().removeDocumentListener(this.docListener);
            this.fireEditingStopped();
            return true;
        }

        protected void fireEditingCanceled() {
            this.setValue(this.originalValue);
            ChangeEvent changeEvent = new ChangeEvent(this);
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                CellEditorListener cellEditorListener = (CellEditorListener)enumeration.nextElement();
                cellEditorListener.editingCanceled(changeEvent);
            }
        }

        protected void fireEditingStopped() {
            this.setValue(this.tfPercentage.getText());
            ChangeEvent changeEvent = new ChangeEvent(this);
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                CellEditorListener cellEditorListener = (CellEditorListener)enumeration.nextElement();
                cellEditorListener.editingStopped(changeEvent);
            }
        }

        protected void setValue(String string) {
            if (LoadBalancePropertyView.this.tableModel != null && this.isEditing) {
                this.tfPercentage.setText(string);
                Integer n = new Integer(0);
                try {
                    n = new Integer(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                LoadBalancePropertyView.this.tableModel.setValueAt(n, this.row, 1);
                LoadBalancePropertyView.this.tblServers.getTableHeader().repaint();
            }
        }

        public String toString() {
            return "PercentageEditor[value=" + this.tfPercentage.getText() + "]";
        }

        static /* synthetic */ LoadBalancePropertyView access$600(PercentageEditor percentageEditor) {
            return percentageEditor.LoadBalancePropertyView.this;
        }
    }
}

