/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.property;

import com.iplanet.idar.common.IDARConstants;
import com.iplanet.idar.objectmodel.bean.LDAPServerPropertyBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class LDAPVersionView
extends ConfigurationView
implements SuiConstants,
IDARConstants {
    private static final String HELP_TOPIC = "Property-LDAPServer-LDAPVersion";
    private ConsoleInfo info;
    private JTextArea txtNote;
    private BlankPanel pnlSupport;
    private JRadioButton radSupportLDAPv2;
    private JRadioButton radSupportLDAPv2and3;
    private BlankPanel pnlUse;
    private JRadioButton radUseLDAPv2;
    private JRadioButton radUseLDAPv3;
    private JRadioButton radUseWhatever;

    public LDAPVersionView(ConsoleInfo consoleInfo) {
        this.info = consoleInfo;
        this.initComponents();
    }

    public LDAPVersionView(ConsoleInfo consoleInfo, LDAPServerPropertyBean lDAPServerPropertyBean) {
        this.info = consoleInfo;
        this.setDataModel(lDAPServerPropertyBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    public void resetContent() throws ConfigurationViewException {
        LDAPServerPropertyBean lDAPServerPropertyBean = (LDAPServerPropertyBean)this.getDataModel();
        Debug.println((int)7, (String)("LDAPVersionView.resetContent: model=" + lDAPServerPropertyBean));
        if (lDAPServerPropertyBean != null) {
            if (lDAPServerPropertyBean.getSupportedVersion().equals("2")) {
                this.radSupportLDAPv2.setSelected(true);
                this.radUseLDAPv3.setEnabled(false);
                this.radUseWhatever.setEnabled(false);
            } else {
                this.radSupportLDAPv2and3.setSelected(true);
                this.radUseLDAPv3.setEnabled(true);
                this.radUseWhatever.setEnabled(true);
            }
            String string = lDAPServerPropertyBean.getUseVersion();
            if (string.equals("2")) {
                this.radUseLDAPv2.setSelected(true);
            } else if (string.equals("3")) {
                this.radUseLDAPv3.setSelected(true);
            } else {
                this.radUseWhatever.setSelected(true);
            }
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        LDAPServerPropertyBean lDAPServerPropertyBean = (LDAPServerPropertyBean)this.getDataModel();
        Debug.println((int)7, (String)("LDAPVersionView.applyChanges: model=" + lDAPServerPropertyBean));
        if (lDAPServerPropertyBean != null) {
            if (this.radSupportLDAPv2.isSelected()) {
                lDAPServerPropertyBean.setSupportedVersion("2");
            } else if (this.radSupportLDAPv2and3.isSelected()) {
                lDAPServerPropertyBean.setSupportedVersion("23");
            }
            if (this.radUseLDAPv2.isSelected()) {
                lDAPServerPropertyBean.setUseVersion("2");
            } else if (this.radUseLDAPv3.isSelected()) {
                lDAPServerPropertyBean.setUseVersion("3");
            } else if (this.radUseWhatever.isSelected()) {
                lDAPServerPropertyBean.setUseVersion("23");
            }
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("propertyLDAPServerLDAP", "TITLE");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    protected void initComponents() {
        this.txtNote = new JTextArea();
        this.txtNote.setText(IDARResourceSet.getString("propertyLDAPServerLDAP", "NOTE"));
        this.txtNote.setEditable(false);
        this.txtNote.setBackground(this.getBackground());
        this.txtNote.setLineWrap(true);
        this.txtNote.setWrapStyleWord(true);
        this.pnlSupport = new BlankPanel();
        this.pnlSupport.addBlankPanelListener(this);
        this.pnlSupport.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("propertyLDAPServerLDAP", "LDAP_VERSION")));
        this.radSupportLDAPv2and3 = new JRadioButton(IDARResourceSet.getString("propertyLDAPServerLDAP", "LDAP_V3"));
        this.radSupportLDAPv2and3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LDAPVersionView.this.radUseLDAPv3.setEnabled(true);
                LDAPVersionView.this.radUseWhatever.setEnabled(true);
            }
        });
        this.radSupportLDAPv2 = new JRadioButton(IDARResourceSet.getString("propertyLDAPServerLDAP", "LDAP_V2"));
        this.radSupportLDAPv2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LDAPVersionView.this.radUseLDAPv2.setSelected(true);
                LDAPVersionView.this.radUseLDAPv3.setEnabled(false);
                LDAPVersionView.this.radUseWhatever.setEnabled(false);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radSupportLDAPv2and3);
        buttonGroup.add(this.radSupportLDAPv2);
        this.pnlUse = new BlankPanel();
        this.pnlUse.addBlankPanelListener(this);
        this.pnlUse.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("propertyLDAPServerLDAP", "LDAP_TO_USE")));
        this.radUseWhatever = new JRadioButton(IDARResourceSet.getString("propertyLDAPServerLDAP", "LDAP_CLIENT"));
        this.radUseLDAPv3 = new JRadioButton(IDARResourceSet.getString("propertyLDAPServerLDAP", "LDAP_V3_ONLY"));
        this.radUseLDAPv2 = new JRadioButton(IDARResourceSet.getString("propertyLDAPServerLDAP", "LDAP_V2_ONLY"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.radUseWhatever);
        buttonGroup2.add(this.radUseLDAPv3);
        buttonGroup2.add(this.radUseLDAPv2);
        this.pnlSupport.setLayout(new GridBagLayout());
        this.pnlUse.setLayout(new GridBagLayout());
        this.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.pnlSupport.add((Component)this.radSupportLDAPv2and3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.pnlSupport.add((Component)this.radSupportLDAPv2, gridBagConstraints);
        n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.pnlUse.add((Component)this.radUseWhatever, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.pnlUse.add((Component)this.radUseLDAPv3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.pnlUse.add((Component)this.radUseLDAPv2, gridBagConstraints);
        n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.add((Component)this.txtNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pnlSupport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pnlUse, gridBagConstraints);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new LDAPVersionView(null, new LDAPServerPropertyBean()));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

